/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.raid;

import com.bekvon.bukkit.residence.BossBar.BossBarInfo;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceRaidEndEvent;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.RaidAttacker;
import com.bekvon.bukkit.residence.raid.RaidDefender;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceRaid {
    private ClaimedResidence res;
    private Long startsAt = 0L;
    private Long endsAt = 0L;
    private Long immunityUntil = null;
    private HashMap<UUID, RaidAttacker> attackers = new HashMap();
    private HashMap<UUID, RaidDefender> defenders = new HashMap();
    private int schedId = -1;
    public static final String bossBarPreRaidIdent = "ResidencePreRaid";
    public static final String bossBarRaidIdent = "ResidenceRaid";

    public ResidenceRaid(ClaimedResidence claimedResidence) {
        this.res = claimedResidence;
    }

    public boolean onSameTeam(Player player, Player player2) {
        return this.attackers.containsKey(player.getUniqueId()) && this.attackers.containsKey(player2.getUniqueId()) || this.defenders.containsKey(player.getUniqueId()) && this.defenders.containsKey(player2.getUniqueId());
    }

    public Long getEndsAt() {
        return this.endsAt;
    }

    public Long getCooldownEnd() {
        return this.endsAt + (long)(ConfigManager.RaidCooldown * 1000);
    }

    public void setEndsAt(Long l) {
        this.endsAt = l;
    }

    public boolean isEnded() {
        return this.getEndsAt() < System.currentTimeMillis();
    }

    public ClaimedResidence getRes() {
        return this.res;
    }

    public HashMap<UUID, RaidDefender> getDefenders() {
        return this.defenders;
    }

    public void addDefender(Player player) {
        this.addDefender(Residence.getInstance().getPlayerManager().getResidencePlayer(player));
    }

    public void addDefender(ResidencePlayer residencePlayer) {
        this.attackers.remove(residencePlayer.getUniqueId());
        this.defenders.put(residencePlayer.getUniqueId(), new RaidDefender(residencePlayer));
        residencePlayer.setJoinedRaid(this);
    }

    public boolean isDefender(Player player) {
        return this.isDefender(player.getUniqueId());
    }

    public boolean isDefender(UUID uUID) {
        return this.defenders.containsKey(uUID);
    }

    public void removeDefender(Player player) {
        this.removeDefender(Residence.getInstance().getPlayerManager().getResidencePlayer(player));
    }

    public void removeDefender(ResidencePlayer residencePlayer) {
        this.defenders.remove(residencePlayer.getUniqueId());
        residencePlayer.setJoinedRaid(null);
    }

    public boolean isAttacker(Player player) {
        return this.isAttacker(player.getUniqueId());
    }

    public boolean isAttacker(UUID uUID) {
        return this.attackers.containsKey(uUID);
    }

    public HashMap<UUID, RaidAttacker> getAttackers() {
        return this.attackers;
    }

    public void clearAttackers() {
        for (Map.Entry<UUID, RaidAttacker> entry : this.attackers.entrySet()) {
            entry.getValue().getPlayer().setJoinedRaid(null);
        }
        this.attackers.clear();
    }

    public void clearDefenders() {
        for (Map.Entry<UUID, RaidDefender> entry : this.defenders.entrySet()) {
            entry.getValue().getPlayer().setJoinedRaid(null);
        }
        this.defenders.clear();
    }

    public void addAttacker(Player player) {
        this.addAttacker(Residence.getInstance().getPlayerManager().getResidencePlayer(player));
    }

    public void addAttacker(ResidencePlayer residencePlayer) {
        this.defenders.remove(residencePlayer.getUniqueId());
        this.attackers.put(residencePlayer.getUniqueId(), new RaidAttacker(residencePlayer));
        residencePlayer.setJoinedRaid(this);
    }

    public void removeAttacker(Player player) {
        this.attackers.remove(player.getUniqueId());
        this.removeAttacker(Residence.getInstance().getPlayerManager().getResidencePlayer(player));
    }

    public void removeAttacker(ResidencePlayer residencePlayer) {
        residencePlayer.setJoinedRaid(null);
        this.attackers.remove(residencePlayer.getUniqueId());
    }

    public Long getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(Long l) {
        this.startsAt = l;
    }

    public int getSchedId() {
        return this.schedId;
    }

    public void setSchedId(int n) {
        this.schedId = n;
    }

    public void showBossBar() {
        block5: {
            ResidencePlayer residencePlayer;
            block4: {
                ResidencePlayer residencePlayer2;
                if (!this.res.isUnderRaid()) break block4;
                for (Map.Entry<UUID, RaidAttacker> entry : this.res.getRaid().getAttackers().entrySet()) {
                    residencePlayer2 = entry.getValue().getPlayer();
                    if (!residencePlayer2.isOnline()) continue;
                    this.showBossbar(residencePlayer2, BarColor.BLUE, lm.Raid_EndsIn);
                }
                for (Map.Entry<UUID, Object> entry : this.res.getRaid().getDefenders().entrySet()) {
                    residencePlayer2 = ((RaidDefender)entry.getValue()).getPlayer();
                    if (!residencePlayer2.isOnline()) continue;
                    this.showBossbar(residencePlayer2, BarColor.BLUE, lm.Raid_EndsIn);
                }
                break block5;
            }
            if (!this.res.isInPreRaid()) break block5;
            for (Map.Entry<UUID, RaidAttacker> entry : this.res.getRaid().getAttackers().entrySet()) {
                residencePlayer = entry.getValue().getPlayer();
                if (!residencePlayer.isOnline()) continue;
                this.showBossbar(residencePlayer, BarColor.GREEN, lm.Raid_StartsIn);
            }
            for (Map.Entry<UUID, Object> entry : this.res.getRaid().getDefenders().entrySet()) {
                residencePlayer = ((RaidDefender)entry.getValue()).getPlayer();
                if (!residencePlayer.isOnline()) continue;
                this.showBossbar(residencePlayer, BarColor.GREEN, lm.Raid_StartsIn);
            }
        }
    }

    private void showBossbar(ResidencePlayer residencePlayer, BarColor barColor, final lm lm2) {
        BossBarInfo bossBarInfo = residencePlayer.getBossBar(this.res.isUnderRaid() ? bossBarRaidIdent : bossBarPreRaidIdent);
        if (bossBarInfo == null) {
            bossBarInfo = new BossBarInfo(residencePlayer, this.res.isUnderRaid() ? bossBarRaidIdent : bossBarPreRaidIdent){

                @Override
                public void updateCycle() {
                    this.setTitleOfBar(Residence.getInstance().msg(lm2, ResidenceRaid.this.getDefenders().size(), ResidenceRaid.this.getAttackers().size()));
                }
            };
            Double d = (double)((this.res.isUnderRaid() ? this.res.getRaid().getEndsAt() : this.res.getRaid().getStartsAt()) - System.currentTimeMillis()) / 1000.0;
            bossBarInfo.setKeepForTicks(22);
            bossBarInfo.setColor(barColor);
            bossBarInfo.setTitleOfBar(Residence.getInstance().msg(lm2, this.getDefenders().size(), this.getAttackers().size()));
            bossBarInfo.setAdjustPerc(-(1.0 / d));
            bossBarInfo.setPercentage(d, d);
            bossBarInfo.setStyle(BarStyle.SEGMENTED_20);
            bossBarInfo.setAuto(20);
            residencePlayer.addBossBar(bossBarInfo);
        }
    }

    public void endRaid() {
        BossBarInfo bossBarInfo;
        Object object;
        this.setEndsAt(System.currentTimeMillis());
        if (this.getSchedId() > 0) {
            ResidenceRaidEndEvent object2 = new ResidenceRaidEndEvent(this.res);
            Bukkit.getPluginManager().callEvent((Event)object2);
            Bukkit.getScheduler().cancelTask(this.getSchedId());
            this.setSchedId(-1);
        }
        this.setStartsAt(0L);
        for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
            object = Bukkit.getPlayer((UUID)entry.getKey());
            if (object == null) continue;
            Residence.getInstance().msg((CommandSender)object, lm.Raid_Ended, this.res.getName());
            bossBarInfo = this.res.getOutsideFreeLoc(object.getLocation(), (Player)object);
            if (bossBarInfo == null) continue;
            object.teleport((Location)bossBarInfo);
        }
        for (Map.Entry<UUID, RaidAttacker> entry : this.getAttackers().entrySet()) {
            object = entry.getValue().getPlayer();
            if (object == null) continue;
            ((ResidencePlayer)object).setLastRaidAttackTimer(System.currentTimeMillis());
            bossBarInfo = ((ResidencePlayer)object).getBossBar(bossBarRaidIdent);
            if (bossBarInfo == null) continue;
            ((ResidencePlayer)object).removeBossBar(bossBarInfo);
        }
        for (Map.Entry<UUID, Object> entry : this.getDefenders().entrySet()) {
            object = ((RaidDefender)entry.getValue()).getPlayer();
            if (object == null || (bossBarInfo = ((ResidencePlayer)object).getBossBar(bossBarRaidIdent)) == null) continue;
            ((ResidencePlayer)object).removeBossBar(bossBarInfo);
        }
        this.res.getRPlayer().setLastRaidDefendTimer(System.currentTimeMillis());
        this.clearAttackers();
        this.clearDefenders();
    }

    public boolean isImmune() {
        return this.immunityUntil == null ? false : this.immunityUntil > System.currentTimeMillis();
    }

    public Long getPlayerImmunityUntil() {
        ResidencePlayer residencePlayer = this.res.getRPlayer();
        if (residencePlayer == null) {
            return 0L;
        }
        return residencePlayer.getLastRaidDefendTimer() == null ? 0L : residencePlayer.getLastRaidDefendTimer() + (long)ConfigManager.RaidPlayerCooldown * 1000L;
    }

    public boolean isPlayerImmune() {
        return this.getPlayerImmunityUntil() > System.currentTimeMillis();
    }

    public Long getImmunityUntil() {
        return this.immunityUntil;
    }

    public void setImmunityUntil(Long l) {
        this.immunityUntil = l != null && l > System.currentTimeMillis() ? l : null;
    }
}

