/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WorldFlagManager {
    protected Map<String, Map<String, FlagPermissions>> groupperms;
    protected Map<String, FlagPermissions> worldperms;
    protected FlagPermissions globaldefaults;
    private Residence plugin;

    public WorldFlagManager(Residence residence) {
        this.plugin = residence;
        this.globaldefaults = new FlagPermissions();
        this.worldperms = new HashMap<String, FlagPermissions>();
        this.groupperms = new HashMap<String, Map<String, FlagPermissions>>();
        this.parsePerms();
    }

    public FlagPermissions getPerms(Player player) {
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        return this.getPerms(player.getWorld().getName(), residencePlayer.getGroup().getGroupName());
    }

    public FlagPermissions getPerms(String string, String string2) {
        string = string.toLowerCase();
        Map<String, FlagPermissions> map = this.groupperms.get(string2 = string2.toLowerCase());
        if (map == null) {
            return this.getPerms(string);
        }
        FlagPermissions flagPermissions = map.get(string);
        if (flagPermissions == null) {
            flagPermissions = map.get("global." + string);
            if (flagPermissions == null) {
                flagPermissions = map.get("global");
            }
            if (flagPermissions == null) {
                return this.getPerms(string);
            }
        }
        return flagPermissions;
    }

    public FlagPermissions getPerms(String string) {
        FlagPermissions flagPermissions = this.worldperms.get(string = string.toLowerCase());
        if (flagPermissions == null) {
            if (this.globaldefaults == null) {
                return new FlagPermissions();
            }
            return this.globaldefaults;
        }
        return flagPermissions;
    }

    public final void parsePerms() {
        block13: {
            try {
                Set set2;
                Set object22;
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
                YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
                if (yamlConfiguration.isConfigurationSection("Global.Flags") && (object22 = yamlConfiguration.getConfigurationSection("Global.Flags").getKeys(false)) != null) {
                    for (Object object : object22) {
                        if (((String)object).equalsIgnoreCase("Global")) {
                            this.globaldefaults = FlagPermissions.parseFromConfigNode((String)object, yamlConfiguration.getConfigurationSection("Global.Flags"));
                            continue;
                        }
                        this.worldperms.put(((String)object).toLowerCase(), FlagPermissions.parseFromConfigNode((String)object, yamlConfiguration.getConfigurationSection("Global.Flags")));
                    }
                }
                for (Map.Entry<String, FlagPermissions> entry : this.worldperms.entrySet()) {
                    entry.getValue().setParent(this.globaldefaults);
                }
                if (!yamlConfiguration2.isConfigurationSection("Groups")) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Your groups.yml file is incorrect!");
                    return;
                }
                if (!yamlConfiguration.isConfigurationSection("Groups") || (set2 = yamlConfiguration2.getConfigurationSection("Groups").getKeys(false)) == null) break block13;
                for (Object object : set2) {
                    Object object2;
                    Set set3;
                    if (!yamlConfiguration2.contains("Groups." + (String)object + ".Flags") || !yamlConfiguration2.contains("Groups." + (String)object + ".Flags.World") || object == null || (set3 = yamlConfiguration2.getConfigurationSection("Groups." + (String)object + ".Flags.World").getKeys(false)) == null) continue;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    for (String string : set3) {
                        object2 = FlagPermissions.parseFromConfigNode(string, yamlConfiguration2.getConfigurationSection("Groups." + (String)object + ".Flags.World"));
                        if (string.equalsIgnoreCase("global")) {
                            ((FlagPermissions)object2).setParent(this.globaldefaults);
                            hashMap.put(string.toLowerCase(), object2);
                            for (Map.Entry<String, FlagPermissions> entry : this.worldperms.entrySet()) {
                                object2 = FlagPermissions.parseFromConfigNode(string, yamlConfiguration2.getConfigurationSection("Groups." + (String)object + ".Flags.World"));
                                ((FlagPermissions)object2).setParent(entry.getValue());
                                hashMap.put("global." + entry.getKey().toLowerCase(), object2);
                            }
                            continue;
                        }
                        hashMap.put(string.toLowerCase(), object2);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object2 = (String)entry.getKey();
                        FlagPermissions flagPermissions = (FlagPermissions)entry.getValue();
                        if (((String)object2).startsWith("global.")) continue;
                        flagPermissions.setParent((FlagPermissions)hashMap.get("global." + (String)object2));
                        if (flagPermissions.getParent() == null) {
                            flagPermissions.setParent(this.worldperms.get(object2));
                        }
                        if (flagPermissions.getParent() != null) continue;
                        flagPermissions.setParent(this.globaldefaults);
                    }
                    this.groupperms.put(((String)object).toLowerCase(), hashMap);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(WorldFlagManager.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
    }
}

