/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagCheckEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidencePermissions
extends FlagPermissions {
    private UUID ownerUUID;
    private String ownerLastKnownName;
    private String world;
    private ClaimedResidence residence;

    private ResidencePermissions(ClaimedResidence claimedResidence) {
        this.residence = claimedResidence;
    }

    public ResidencePermissions(ClaimedResidence claimedResidence, String string, String string2) {
        this(claimedResidence);
        this.ownerUUID = Residence.getInstance().getPlayerUUID(string);
        if (this.ownerUUID == null) {
            this.ownerUUID = UUID.fromString(Residence.getInstance().getTempUserUUID());
        }
        this.ownerLastKnownName = string;
        this.world = string2;
    }

    public boolean playerHas(CommandSender commandSender, Flags flags2, boolean bl) {
        if (commandSender instanceof Player) {
            return this.playerHas((Player)commandSender, flags2, bl);
        }
        return true;
    }

    @Override
    public boolean playerHas(Player player, Flags flags2, boolean bl) {
        return this.playerHas(player, this.world, flags2, bl);
    }

    @Deprecated
    public boolean playerHas(Player player, String string, boolean bl) {
        return this.playerHas(player.getName(), this.world, string, bl);
    }

    public boolean playerHas(String string, Flags flags2, boolean bl) {
        return this.playerHas(string, flags2.toString(), bl);
    }

    @Deprecated
    public boolean playerHas(String string, String string2, boolean bl) {
        return this.playerHas(string, this.world, string2, bl);
    }

    public boolean playerHas(Player player, Flags flags2, FlagPermissions.FlagCombo flagCombo) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.playerHas(player, this.world, flags2, false);
            }
            case OnlyFalse: {
                return !this.playerHas(player, this.world, flags2, true);
            }
            case OnlyTrue: {
                return this.playerHas(player, this.world, flags2, false);
            }
            case TrueOrNone: {
                return this.playerHas(player, this.world, flags2, true);
            }
        }
        return false;
    }

    public boolean playerHas(ResidencePlayer residencePlayer, Flags flags2, FlagPermissions.FlagCombo flagCombo) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.playerHas(residencePlayer, flags2, false);
            }
            case OnlyFalse: {
                return !this.playerHas(residencePlayer, flags2, true);
            }
            case OnlyTrue: {
                return this.playerHas(residencePlayer, flags2, false);
            }
            case TrueOrNone: {
                return this.playerHas(residencePlayer, flags2, true);
            }
        }
        return false;
    }

    @Override
    public boolean playerHas(ResidencePlayer residencePlayer, Flags flags2, boolean bl) {
        if (residencePlayer == null) {
            return false;
        }
        ResidenceFlagCheckEvent residenceFlagCheckEvent = new ResidenceFlagCheckEvent(this.residence, flags2.toString(), ResidenceFlagEvent.FlagType.PLAYER, residencePlayer.getName(), bl);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagCheckEvent);
        if (residenceFlagCheckEvent.isOverriden()) {
            return residenceFlagCheckEvent.getOverrideValue();
        }
        return super.playerHas(residencePlayer, flags2, bl);
    }

    @Deprecated
    public boolean playerHas(String string, String string2, FlagPermissions.FlagCombo flagCombo) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.playerHas(string, this.world, string2, false);
            }
            case OnlyFalse: {
                return !this.playerHas(string, this.world, string2, true);
            }
            case OnlyTrue: {
                return this.playerHas(string, this.world, string2, false);
            }
            case TrueOrNone: {
                return this.playerHas(string, this.world, string2, true);
            }
        }
        return false;
    }

    @Override
    public boolean playerHas(Player player, String string, Flags flags2, boolean bl) {
        if (player == null) {
            return false;
        }
        ResidenceFlagCheckEvent residenceFlagCheckEvent = new ResidenceFlagCheckEvent(this.residence, flags2.toString(), ResidenceFlagEvent.FlagType.PLAYER, player.getName(), bl);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagCheckEvent);
        if (residenceFlagCheckEvent.isOverriden()) {
            return residenceFlagCheckEvent.getOverrideValue();
        }
        return super.playerHas(player, string, flags2, bl);
    }

    @Override
    @Deprecated
    public boolean playerHas(String string, String string2, String string3, boolean bl) {
        ResidenceFlagCheckEvent residenceFlagCheckEvent = new ResidenceFlagCheckEvent(this.residence, string3, ResidenceFlagEvent.FlagType.PLAYER, string, bl);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagCheckEvent);
        if (residenceFlagCheckEvent.isOverriden()) {
            return residenceFlagCheckEvent.getOverrideValue();
        }
        return super.playerHas(string, string2, string3, bl);
    }

    @Override
    public boolean groupHas(String string, String string2, boolean bl) {
        ResidenceFlagCheckEvent residenceFlagCheckEvent = new ResidenceFlagCheckEvent(this.residence, string2, ResidenceFlagEvent.FlagType.GROUP, string, bl);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagCheckEvent);
        if (residenceFlagCheckEvent.isOverriden()) {
            return residenceFlagCheckEvent.getOverrideValue();
        }
        return super.groupHas(string, string2, bl);
    }

    @Override
    public boolean has(Flags flags2, FlagPermissions.FlagCombo flagCombo) {
        return this.has(flags2, flagCombo, true);
    }

    public boolean has(Flags flags2, FlagPermissions.FlagCombo flagCombo, boolean bl) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.has(flags2, false, bl);
            }
            case OnlyFalse: {
                return !this.has(flags2, true, bl);
            }
            case OnlyTrue: {
                return this.has(flags2, false, bl);
            }
            case TrueOrNone: {
                return this.has(flags2, true, bl);
            }
        }
        return false;
    }

    @Deprecated
    public boolean has(String string, FlagPermissions.FlagCombo flagCombo) {
        return this.has(string, flagCombo, true);
    }

    @Deprecated
    public boolean has(String string, FlagPermissions.FlagCombo flagCombo, boolean bl) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.has(string, false, bl);
            }
            case OnlyFalse: {
                return !this.has(string, true, bl);
            }
            case OnlyTrue: {
                return this.has(string, false, bl);
            }
            case TrueOrNone: {
                return this.has(string, true, bl);
            }
        }
        return false;
    }

    @Override
    public boolean has(Flags flags2, boolean bl) {
        return this.has(flags2.toString(), bl, true);
    }

    @Override
    public boolean has(String string, boolean bl) {
        return this.has(string, bl, true);
    }

    @Override
    public boolean has(String string, boolean bl, boolean bl2) {
        ResidenceFlagCheckEvent residenceFlagCheckEvent = new ResidenceFlagCheckEvent(this.residence, string, ResidenceFlagEvent.FlagType.RESIDENCE, null, bl);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagCheckEvent);
        if (residenceFlagCheckEvent.isOverriden()) {
            return residenceFlagCheckEvent.getOverrideValue();
        }
        return super.has(string, bl, bl2);
    }

    public boolean hasApplicableFlag(String string, String string2) {
        return super.inheritanceIsPlayerSet(string, string2) || super.inheritanceIsGroupSet(Residence.getInstance().getPlayerManager().getResidencePlayer(string).getGroup(this.world).getGroupName(), string2) || super.inheritanceIsSet(string2);
    }

    public void applyTemplate(Player player, FlagPermissions flagPermissions, boolean bl) {
        if (player != null) {
            if (!bl) {
                if (!Residence.getInstance().getConfigManager().isOfflineMode() && !player.getUniqueId().toString().equals(this.ownerUUID.toString())) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return;
                }
                if (!player.getName().equals(this.ownerLastKnownName)) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return;
                }
            }
        } else {
            bl = true;
        }
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(this.getOwner());
        PermissionGroup permissionGroup = residencePlayer.getGroup(this.world);
        for (Map.Entry<String, Boolean> entry : flagPermissions.cuboidFlags.entrySet()) {
            if (permissionGroup.hasFlagAccess(entry.getKey()) || bl) {
                this.cuboidFlags.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (player == null) continue;
            Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : flagPermissions.playerFlags.entrySet()) {
            Map.Entry entry2 = this.getPlayerFlags(entry.getKey(), true);
            for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                if (permissionGroup.hasFlagAccess((String)entry3.getKey()) || bl) {
                    entry2.put((String)entry3.getKey(), (Boolean)entry3.getValue());
                    continue;
                }
                if (player == null) continue;
                Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, entry3.getKey());
            }
        }
        for (Map.Entry<String, Object> entry : flagPermissions.groupFlags.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (permissionGroup.hasFlagAccess((String)entry2.getKey()) || bl) {
                    if (!this.groupFlags.containsKey(entry.getKey())) {
                        this.groupFlags.put(entry.getKey(), Collections.synchronizedMap(new HashMap()));
                    }
                    ((Map)this.groupFlags.get(entry.getKey())).put((String)entry2.getKey(), (Boolean)entry2.getValue());
                    continue;
                }
                if (player == null) continue;
                Residence.getInstance().msg((CommandSender)player, lm.Flag_SetDeny, entry2.getKey());
            }
        }
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Residence_PermissionsApply, new Object[0]);
        }
    }

    public boolean hasResidencePermission(CommandSender commandSender, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return true;
        }
        ClaimedResidence claimedResidence = this.residence.getParent();
        Player player = (Player)commandSender;
        if (claimedResidence != null && claimedResidence.getPermissions().playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue)) {
            return true;
        }
        if (Residence.getInstance().getConfigManager().enabledRentSystem()) {
            String string = this.residence.getName();
            if (Residence.getInstance().getRentManager().isRented(string)) {
                if (bl) {
                    return false;
                }
                String string2 = Residence.getInstance().getRentManager().getRentingPlayer(string);
                if (commandSender.getName().equals(string2)) {
                    return true;
                }
                return this.playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue);
            }
        }
        if (bl) {
            return this.getOwner().equals(commandSender.getName());
        }
        return this.playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue) || this.getOwner().equals(commandSender.getName());
    }

    private boolean checkCanSetFlag(CommandSender commandSender, String string, FlagPermissions.FlagState flagState, boolean bl, boolean bl2) {
        Flags flags2 = Flags.getFlag(string);
        if (flags2 != null) {
            string = flags2.toString();
        }
        if (!this.checkValidFlag(string, bl)) {
            if (flags2 != null) {
                Residence.getInstance().msg(commandSender, lm.Invalid_FlagType_Fail, flags2.getFlagMode() == Flags.FlagMode.Residence ? Residence.getInstance().getLM().getMessage(lm.Invalid_FlagType_Residence, new Object[0]) : Residence.getInstance().getLM().getMessage(lm.Invalid_FlagType_Player, new Object[0]));
            } else {
                Residence.getInstance().msg(commandSender, lm.Invalid_Flag, new Object[0]);
            }
            return false;
        }
        if (flagState == FlagPermissions.FlagState.INVALID) {
            Residence.getInstance().msg(commandSender, lm.Invalid_FlagState, new Object[0]);
            return false;
        }
        if (!bl2) {
            if (!this.hasResidencePermission(commandSender, false)) {
                Residence.getInstance().msg(commandSender, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (!this.hasFlagAccess(this.getOwner(), string) && !PermissionManager.ResPerm.flag_$1.hasPermission(commandSender, 10000L, string.toLowerCase())) {
                Residence.getInstance().msg(commandSender, lm.Flag_SetFailed, string);
                return false;
            }
        }
        return true;
    }

    private boolean hasFlagAccess(String string, String string2) {
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(string);
        PermissionGroup permissionGroup = residencePlayer.getGroup(this.world);
        return permissionGroup.hasFlagAccess(string2);
    }

    public boolean setPlayerFlag(CommandSender commandSender, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (Residence.getInstance().getPlayerUUID(string) == null) {
            commandSender.sendMessage("No player by this name");
            return false;
        }
        if (this.residence.isRaidInitialized() && !bl) {
            Residence.getInstance().msg(commandSender, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        Flags flags2 = Flags.getFlag(string2);
        if (flags2 != null) {
            string2 = flags2.toString();
        }
        if (validFlagGroups.containsKey(string2)) {
            return this.setFlagGroupOnPlayer(commandSender, string, string2, string3, bl);
        }
        FlagPermissions.FlagState flagState = FlagPermissions.stringToFlagState(string3);
        if (this.checkCanSetFlag(commandSender, string2, flagState, false, bl)) {
            ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, commandSender instanceof Player ? (Player)commandSender : null, string2, ResidenceFlagEvent.FlagType.PLAYER, flagState, string);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
            if (residenceFlagChangeEvent.isCancelled()) {
                return false;
            }
            if (super.setPlayerFlag(string, string2, flagState)) {
                if (bl2) {
                    Residence.getInstance().msg(commandSender, lm.Flag_Set, string2, this.residence.getName(), string3);
                }
                return true;
            }
        }
        return false;
    }

    public boolean setGroupFlag(Player player, String string, String string2, String string3, boolean bl) {
        Flags flags2 = Flags.getFlag(string2);
        if (flags2 != null) {
            string2 = flags2.toString();
        }
        if (this.residence.isRaidInitialized() && !bl) {
            Residence.getInstance().msg((CommandSender)player, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        string = string.toLowerCase();
        if (validFlagGroups.containsKey(string2)) {
            return this.setFlagGroupOnGroup(player, string2, string, string3, bl);
        }
        FlagPermissions.FlagState flagState = FlagPermissions.stringToFlagState(string3);
        if (this.checkCanSetFlag((CommandSender)player, string2, flagState, false, bl)) {
            if (Residence.getInstance().getPermissionManager().hasGroup(string)) {
                ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, player, string2, ResidenceFlagEvent.FlagType.GROUP, flagState, string);
                Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
                if (residenceFlagChangeEvent.isCancelled()) {
                    return false;
                }
                if (super.setGroupFlag(string, string2, flagState)) {
                    Residence.getInstance().msg((CommandSender)player, lm.Flag_Set, string2, this.residence.getName(), string3);
                    return true;
                }
            } else {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_Group, new Object[0]);
                return false;
            }
        }
        return false;
    }

    @Deprecated
    public boolean setFlag(CommandSender commandSender, String string, String string2, boolean bl) {
        return this.setFlag(commandSender, string, FlagPermissions.stringToFlagState(string2), bl);
    }

    public boolean setFlag(CommandSender commandSender, String string, FlagPermissions.FlagState flagState, boolean bl) {
        return this.setFlag(commandSender, string, flagState, bl, true);
    }

    public boolean setFlag(CommandSender commandSender, String string, FlagPermissions.FlagState flagState, boolean bl, boolean bl2) {
        Flags flags2 = Flags.getFlag(string);
        if (flags2 != null) {
            string = flags2.toString();
        }
        if (this.residence.isRaidInitialized() && !bl) {
            Residence.getInstance().msg(commandSender, lm.Raid_noFlagChange, new Object[0]);
            return false;
        }
        if (validFlagGroups.containsKey(string)) {
            return this.setFlagGroup(commandSender, string, flagState, bl);
        }
        if (Residence.getInstance().getConfigManager().isPvPFlagPrevent()) {
            for (String object : Residence.getInstance().getConfigManager().getProtectedFlagsList()) {
                if (!string.equalsIgnoreCase(object)) continue;
                ArrayList<Player> arrayList = this.residence.getPlayersInResidence();
                if (bl || arrayList.size() <= 1 && (arrayList.size() != 1 || arrayList.get(0).getName().equals(this.getOwner()))) continue;
                int n = 0;
                for (Player player : arrayList) {
                    if (player.getName().equals(this.getOwner())) continue;
                    ++n;
                }
                if (bl2) {
                    Residence.getInstance().msg(commandSender, lm.Flag_ChangeDeny, string, n);
                }
                return false;
            }
        }
        if (this.checkCanSetFlag(commandSender, string, flagState, true, bl)) {
            ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, commandSender instanceof Player ? (Player)commandSender : null, string, ResidenceFlagEvent.FlagType.RESIDENCE, flagState, null);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
            if (residenceFlagChangeEvent.isCancelled()) {
                return false;
            }
            if (super.setFlag(string, flagState)) {
                if (bl2) {
                    Residence.getInstance().msg(commandSender, lm.Flag_Set, string, this.residence.getName(), flagState.name());
                }
                return true;
            }
        }
        return false;
    }

    public boolean removeAllPlayerFlags(CommandSender commandSender, String string, boolean bl) {
        if (this.hasResidencePermission(commandSender, false) || bl) {
            ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, commandSender instanceof Player ? (Player)commandSender : null, "ALL", ResidenceFlagEvent.FlagType.RESIDENCE, FlagPermissions.FlagState.NEITHER, null);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
            if (residenceFlagChangeEvent.isCancelled()) {
                return false;
            }
            super.removeAllPlayerFlags(string);
            Residence.getInstance().msg(commandSender, lm.Flag_RemovedAll, string, this.residence.getName());
            return true;
        }
        return false;
    }

    public boolean removeAllGroupFlags(Player player, String string, boolean bl) {
        if (this.hasResidencePermission((CommandSender)player, false) || bl) {
            ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, player, "ALL", ResidenceFlagEvent.FlagType.GROUP, FlagPermissions.FlagState.NEITHER, null);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
            if (residenceFlagChangeEvent.isCancelled()) {
                return false;
            }
            super.removeAllGroupFlags(string);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_RemovedGroup, string, this.residence.getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean setFlag(String string, FlagPermissions.FlagState flagState) {
        ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, null, string, ResidenceFlagEvent.FlagType.RESIDENCE, flagState, null);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
        if (residenceFlagChangeEvent.isCancelled()) {
            return false;
        }
        return super.setFlag(string, flagState);
    }

    @Override
    public boolean setGroupFlag(String string, String string2, FlagPermissions.FlagState flagState) {
        ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, null, string2, ResidenceFlagEvent.FlagType.GROUP, flagState, string);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
        if (residenceFlagChangeEvent.isCancelled()) {
            return false;
        }
        return super.setGroupFlag(string, string2, flagState);
    }

    @Override
    public boolean setPlayerFlag(String string, String string2, FlagPermissions.FlagState flagState) {
        ResidenceFlagChangeEvent residenceFlagChangeEvent = new ResidenceFlagChangeEvent(this.residence, null, string2, ResidenceFlagEvent.FlagType.PLAYER, flagState, string);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceFlagChangeEvent);
        if (residenceFlagChangeEvent.isCancelled()) {
            return false;
        }
        return super.setPlayerFlag(string, string2, flagState);
    }

    public void applyDefaultFlags(Player player, boolean bl) {
        if (this.hasResidencePermission((CommandSender)player, true) || bl) {
            this.applyDefaultFlags();
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Default, new Object[0]);
        } else {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    public void applyDefaultFlags() {
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(this.getOwner());
        PermissionGroup permissionGroup = residencePlayer.getGroup(this.world);
        Set<Map.Entry<String, Boolean>> set2 = permissionGroup.getDefaultResidenceFlags();
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = permissionGroup.getDefaultGroupFlags();
        this.applyGlobalDefaults();
        for (Map.Entry<String, Boolean> entry : set2) {
            if (!this.checkValidFlag(entry.getKey(), true)) continue;
            this.setFlag(entry.getKey(), entry.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Object> entry : set3) {
            Map map = (Map)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                this.setGroupFlag(entry.getKey(), (String)entry2.getKey(), (Boolean)entry2.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
            }
        }
    }

    public void applyDefaultRentedFlags() {
        if (!this.residence.isRented()) {
            return;
        }
        FlagPermissions flagPermissions = Residence.getInstance().getConfigManager().getGlobalRentedDefaultFlags();
        Map<String, Boolean> map = flagPermissions.getFlags();
        if (this.residence.rentedland == null || this.residence.rentedland.player == null) {
            return;
        }
        this.removeAllPlayerFlags(this.residence.rentedland.player);
        String string = this.residence.rentedland.player;
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            this.setPlayerFlag(string, entry.getKey(), entry.getValue() != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
        }
    }

    public boolean setOwner(Player player, boolean bl) {
        ResidenceOwnerChangeEvent residenceOwnerChangeEvent = new ResidenceOwnerChangeEvent(this.residence, player);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceOwnerChangeEvent);
        if (residenceOwnerChangeEvent.isCancelled()) {
            return false;
        }
        Residence.getInstance().getPlayerManager().removeResFromPlayer(this.residence.getOwnerUUID(), this.residence);
        Residence.getInstance().getPlayerManager().addResidence(player, this.residence);
        this.ownerLastKnownName = player.getName();
        this.ownerUUID = player.getUniqueId();
        if (bl) {
            this.applyDefaultFlags();
        }
        return true;
    }

    public void setOwner(String string, boolean bl) {
        UUID uUID;
        ResidenceOwnerChangeEvent residenceOwnerChangeEvent = new ResidenceOwnerChangeEvent(this.residence, string);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)residenceOwnerChangeEvent);
        if (residenceOwnerChangeEvent.isCancelled()) {
            return;
        }
        Residence.getInstance().getPlayerManager().removeResFromPlayer(this.residence.getOwnerUUID(), this.residence);
        this.ownerLastKnownName = string;
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(string);
        if (residencePlayer != null) {
            this.ownerUUID = residencePlayer.getUuid();
        }
        this.ownerUUID = string.equalsIgnoreCase("Server Land") || string.equalsIgnoreCase(Residence.getInstance().getServerLandName()) ? UUID.fromString(Residence.getInstance().getServerLandUUID()) : ((uUID = Residence.getInstance().getPlayerUUID(string)) != null ? uUID : UUID.fromString(Residence.getInstance().getTempUserUUID()));
        Residence.getInstance().getPlayerManager().addResidence(string, this.residence);
        if (bl) {
            this.applyDefaultFlags();
        }
    }

    public String getOwner() {
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            return this.ownerLastKnownName;
        }
        if (this.ownerUUID.toString().equals(Residence.getInstance().getServerLandUUID())) {
            return Residence.getInstance().getServerLandName();
        }
        String string = Residence.getInstance().getPlayerName(this.ownerUUID);
        if (string == null) {
            return this.ownerLastKnownName;
        }
        this.ownerLastKnownName = string;
        return string;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uUID) {
        this.ownerUUID = uUID;
    }

    public String getWorld() {
        return this.world;
    }

    @Override
    public Map<String, Object> save(String string) {
        Map<String, Object> map = super.save(this.world);
        if (!this.ownerUUID.toString().equals(Residence.getInstance().getTempUserUUID())) {
            map.put("OwnerUUID", this.ownerUUID.toString());
        }
        map.put("OwnerLastKnownName", this.ownerLastKnownName);
        return map;
    }

    public static ResidencePermissions load(String string, ClaimedResidence claimedResidence, Map<String, Object> map) {
        ResidencePermissions residencePermissions = new ResidencePermissions(claimedResidence);
        if (map.containsKey("OwnerUUID") || map.containsKey("OwnerLastKnownName")) {
            UUID uUID;
            residencePermissions.ownerUUID = !map.containsKey("OwnerUUID") ? UUID.fromString(Residence.getInstance().getTempUserUUID()) : UUID.fromString((String)map.get("OwnerUUID"));
            residencePermissions.ownerLastKnownName = (String)map.get("OwnerLastKnownName");
            OfflinePlayer offlinePlayer = null;
            if (residencePermissions.ownerLastKnownName == null) {
                offlinePlayer = Residence.getInstance().getOfflinePlayer(residencePermissions.ownerUUID);
            }
            if (offlinePlayer != null) {
                residencePermissions.ownerLastKnownName = offlinePlayer.getName();
            }
            if (residencePermissions.ownerLastKnownName == null) {
                return residencePermissions;
            }
            if (residencePermissions.ownerLastKnownName.equalsIgnoreCase("Server land") || residencePermissions.ownerLastKnownName.equalsIgnoreCase(Residence.getInstance().getServerLandName())) {
                residencePermissions.ownerUUID = UUID.fromString(Residence.getInstance().getServerLandUUID());
                residencePermissions.ownerLastKnownName = Residence.getInstance().getServerLandName();
            } else if (residencePermissions.ownerUUID.toString().equals(Residence.getInstance().getTempUserUUID()) && (uUID = Residence.getInstance().getPlayerUUID(residencePermissions.ownerLastKnownName)) != null) {
                residencePermissions.ownerUUID = uUID;
            }
        } else if (map.containsKey("Owner")) {
            String string2;
            residencePermissions.ownerLastKnownName = string2 = (String)map.get("Owner");
            residencePermissions.ownerUUID = Residence.getInstance().getPlayerUUID(string2);
            if (residencePermissions.ownerUUID == null) {
                residencePermissions.ownerUUID = UUID.fromString(Residence.getInstance().getTempUserUUID());
            }
        } else {
            residencePermissions.ownerUUID = UUID.fromString(Residence.getInstance().getServerLandUUID());
            residencePermissions.ownerLastKnownName = Residence.getInstance().getServerLandName();
        }
        residencePermissions.world = string;
        FlagPermissions.load(map, residencePermissions);
        if (residencePermissions.getOwner() == null || residencePermissions.world == null || residencePermissions.playerFlags == null || residencePermissions.groupFlags == null || residencePermissions.cuboidFlags == null) {
            throw new Exception("Invalid Residence Permissions...");
        }
        return residencePermissions;
    }

    public void applyGlobalDefaults() {
        this.clearFlags();
        FlagPermissions flagPermissions = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags();
        FlagPermissions flagPermissions2 = Residence.getInstance().getConfigManager().getGlobalCreatorDefaultFlags();
        Map<String, FlagPermissions> map = Residence.getInstance().getConfigManager().getGlobalGroupDefaultFlags();
        for (Map.Entry<String, Boolean> entry : flagPermissions.cuboidFlags.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.setFlag(entry.getKey(), FlagPermissions.FlagState.TRUE);
                continue;
            }
            this.setFlag(entry.getKey(), FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Boolean> entry : flagPermissions2.cuboidFlags.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.setPlayerFlag(this.getOwner(), entry.getKey(), FlagPermissions.FlagState.TRUE);
                continue;
            }
            this.setPlayerFlag(this.getOwner(), entry.getKey(), FlagPermissions.FlagState.FALSE);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            for (Map.Entry<String, Boolean> entry2 : ((FlagPermissions)entry.getValue()).cuboidFlags.entrySet()) {
                if (entry2.getValue().booleanValue()) {
                    this.setGroupFlag(entry.getKey(), entry2.getKey(), FlagPermissions.FlagState.TRUE);
                    continue;
                }
                this.setGroupFlag(entry.getKey(), entry2.getKey(), FlagPermissions.FlagState.FALSE);
            }
        }
    }

    @Deprecated
    public boolean setFlagGroup(CommandSender commandSender, String string, String string2, boolean bl) {
        return this.setFlagGroup(commandSender, string, FlagPermissions.stringToFlagState(string2), bl);
    }

    public boolean setFlagGroup(CommandSender commandSender, String string, FlagPermissions.FlagState flagState, boolean bl) {
        if (FlagPermissions.validFlagGroups.containsKey(string)) {
            ArrayList<String> arrayList = FlagPermissions.validFlagGroups.get(string);
            boolean bl2 = false;
            for (String string2 : arrayList) {
                if (!this.setFlag(commandSender, string2, flagState, bl)) continue;
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    public boolean setFlagGroupOnGroup(Player player, String string, String string2, String string3, boolean bl) {
        if (FlagPermissions.validFlagGroups.containsKey(string)) {
            ArrayList<String> arrayList = FlagPermissions.validFlagGroups.get(string);
            boolean bl2 = false;
            for (String string4 : arrayList) {
                if (!this.setGroupFlag(player, string2, string4, string3, bl)) continue;
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    public boolean setFlagGroupOnPlayer(CommandSender commandSender, String string, String string2, String string3, boolean bl) {
        if (FlagPermissions.validFlagGroups.containsKey(string2)) {
            ArrayList<String> arrayList = FlagPermissions.validFlagGroups.get(string2);
            boolean bl2 = false;
            String string4 = "";
            for (String string5 : arrayList) {
                if (!this.setPlayerFlag(commandSender, string, string5, string3, bl, false)) continue;
                bl2 = true;
                if (!string4.isEmpty()) {
                    string4 = String.valueOf(string4) + ", ";
                }
                string4 = String.valueOf(string4) + string5;
            }
            if (string4.length() > 0) {
                Residence.getInstance().msg(commandSender, lm.Flag_Set, string4, string, string3);
            }
            return bl2;
        }
        return false;
    }

    public String getOwnerLastKnownName() {
        return this.ownerLastKnownName;
    }

    public void setOwnerLastKnownName(String string) {
        this.ownerLastKnownName = string;
    }
}

