/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeFlags;
import com.bekvon.bukkit.residence.containers.MinimizeMessages;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.CancellableResidencePlayerEvent;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import com.griefcraft.cache.ProtectionCache;
import com.griefcraft.lwc.LWC;
import com.griefcraft.model.Protection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ResidenceManager
implements ResidenceInterface {
    protected SortedMap<String, ClaimedResidence> residences;
    protected Map<String, Map<ChunkRef, List<ClaimedResidence>>> chunkResidences;
    protected List<ClaimedResidence> shops = new ArrayList<ClaimedResidence>();
    private Residence plugin;
    HashMap<String, List<MinimizeMessages>> optimizeMessages = new HashMap();
    HashMap<String, List<MinimizeFlags>> optimizeFlags = new HashMap();
    HashMap<String, HashMap<Integer, MinimizeMessages>> cacheMessages = new HashMap();
    HashMap<String, HashMap<Integer, MinimizeFlags>> cacheFlags = new HashMap();

    public ResidenceManager(Residence residence) {
        this.residences = new TreeMap<String, ClaimedResidence>();
        this.chunkResidences = new HashMap<String, Map<ChunkRef, List<ClaimedResidence>>>();
        this.shops = new ArrayList<ClaimedResidence>();
        this.plugin = residence;
    }

    public boolean isOwnerOfLocation(Player player, Location location) {
        ClaimedResidence claimedResidence = this.getByLoc(location);
        return claimedResidence != null && claimedResidence.isOwner(player);
    }

    public ClaimedResidence getByLoc(Player player) {
        return this.getByLoc(player.getLocation());
    }

    @Override
    public ClaimedResidence getByLoc(Location location) {
        ClaimedResidence claimedResidence3;
        if (location == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        String string = world.getName();
        if (string == null) {
            return null;
        }
        if (!this.chunkResidences.containsKey(string)) {
            return null;
        }
        ClaimedResidence claimedResidence2 = null;
        ChunkRef chunkRef = new ChunkRef(location);
        Map<ChunkRef, List<ClaimedResidence>> map = this.chunkResidences.get(string);
        List<ClaimedResidence> list2 = map.get(chunkRef);
        if (list2 != null) {
            for (ClaimedResidence claimedResidence3 : list2) {
                if (claimedResidence3 == null || !claimedResidence3.containsLoc(location)) continue;
                claimedResidence2 = claimedResidence3;
                break;
            }
        }
        if (claimedResidence2 == null) {
            return null;
        }
        claimedResidence3 = claimedResidence2.getSubzoneByLoc(location);
        if (claimedResidence3 == null) {
            return claimedResidence2;
        }
        return claimedResidence3;
    }

    @Override
    public ClaimedResidence getByName(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return (ClaimedResidence)this.residences.get(string.toLowerCase());
        }
        ClaimedResidence claimedResidence = (ClaimedResidence)this.residences.get(stringArray[0].toLowerCase());
        int n = 1;
        while (n < stringArray.length) {
            if (claimedResidence == null) {
                return null;
            }
            claimedResidence = claimedResidence.getSubzone(stringArray[n].toLowerCase());
            ++n;
        }
        return claimedResidence;
    }

    @Override
    public String getSubzoneNameByRes(ClaimedResidence claimedResidence) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (entry.getValue() == claimedResidence) {
                return entry.getKey();
            }
            String string = entry.getValue().getSubzoneNameByRes(claimedResidence);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public void addShop(String string) {
        ClaimedResidence claimedResidence = this.getByName(string);
        if (claimedResidence != null) {
            this.shops.add(claimedResidence);
        }
    }

    @Override
    public void addShop(ClaimedResidence claimedResidence) {
        this.shops.add(claimedResidence);
    }

    @Override
    public void removeShop(ClaimedResidence claimedResidence) {
        this.shops.remove(claimedResidence);
    }

    @Override
    public void removeShop(String string) {
        for (ClaimedResidence claimedResidence : this.shops) {
            if (!claimedResidence.getName().equalsIgnoreCase(string)) continue;
            this.shops.remove(claimedResidence);
            break;
        }
    }

    @Override
    public List<ClaimedResidence> getShops() {
        return this.shops;
    }

    @Override
    public boolean addResidence(String string, Location location, Location location2) {
        return this.addResidence(string, this.plugin.getServerLandName(), location, location2);
    }

    @Override
    public boolean addResidence(String string, String string2, Location location, Location location2) {
        return this.addResidence(null, string2, string, location, location2, true);
    }

    @Override
    public boolean addResidence(Player player, String string, Location location, Location location2, boolean bl) {
        return this.addResidence(player, player.getName(), string, location, location2, bl);
    }

    public boolean addResidence(Player player, String string, String string2, Location location, Location location2, boolean bl) {
        if (!this.plugin.validName(string2)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (location == null || location2 == null || !location.getWorld().getName().equals(location2.getWorld().getName())) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return false;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (!(bl || permissionGroup.canCreateResidences() || PermissionManager.ResPerm.create.hasPermission((CommandSender)player, lm.General_NoPermission))) {
            return false;
        }
        if (!bl && !PermissionManager.ResPerm.create.hasPermission((CommandSender)player, true, new String[0])) {
            return false;
        }
        if (residencePlayer.getResAmount() >= residencePlayer.getMaxRes() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Residence_TooMany, new Object[0]);
            return false;
        }
        CuboidArea cuboidArea = new CuboidArea(location, location2);
        ClaimedResidence claimedResidence = new ClaimedResidence(string, location.getWorld().getName(), this.plugin);
        claimedResidence.getPermissions().applyDefaultFlags();
        claimedResidence.setEnterMessage(permissionGroup.getDefaultEnterMessage());
        claimedResidence.setLeaveMessage(permissionGroup.getDefaultLeaveMessage());
        claimedResidence.setName(string2);
        claimedResidence.setCreateTime();
        if (this.residences.containsKey(string2.toLowerCase())) {
            this.plugin.msg((CommandSender)player, lm.Residence_AlreadyExists, ((ClaimedResidence)this.residences.get(string2.toLowerCase())).getResidenceName());
            return false;
        }
        claimedResidence.BlockSellPrice = permissionGroup.getSellPerBlock();
        if (!claimedResidence.addArea(player, cuboidArea, "main", bl, false)) {
            return false;
        }
        ResidenceCreationEvent residenceCreationEvent = new ResidenceCreationEvent(player, string2, claimedResidence, cuboidArea);
        this.plugin.getServ().getPluginManager().callEvent((Event)residenceCreationEvent);
        if (residenceCreationEvent.isCancelled()) {
            return false;
        }
        if (!claimedResidence.isSubzone() && this.plugin.getConfigManager().enableEconomy() && !bl) {
            double d = cuboidArea.getCost(permissionGroup);
            if (!this.plugin.getTransactionManager().chargeEconomyMoney(player, d)) {
                claimedResidence.removeArea("main");
                return false;
            }
        }
        this.residences.put(string2.toLowerCase(), claimedResidence);
        this.calculateChunks(string2);
        this.plugin.getLeaseManager().removeExpireTime(claimedResidence);
        this.plugin.getPlayerManager().addResidence(claimedResidence.getOwner(), claimedResidence);
        if (player != null) {
            Visualizer visualizer = new Visualizer(player);
            visualizer.setAreas(cuboidArea);
            this.plugin.getSelectionManager().showBounds(player, visualizer);
            this.plugin.getAutoSelectionManager().getList().remove(player.getUniqueId());
            this.plugin.msg((CommandSender)player, lm.Area_Create, "main");
            this.plugin.msg((CommandSender)player, lm.Residence_Create, string2);
        }
        if (this.plugin.getConfigManager().useLeases()) {
            this.plugin.getLeaseManager().setExpireTime(player, claimedResidence, permissionGroup.getLeaseGiveTime());
        }
        return true;
    }

    public void listResidences(CommandSender commandSender) {
        this.listResidences(commandSender, commandSender.getName(), 1);
    }

    public void listResidences(CommandSender commandSender, boolean bl) {
        this.listResidences(commandSender, commandSender.getName(), 1, false, false, bl);
    }

    public void listResidences(CommandSender commandSender, String string, boolean bl) {
        this.listResidences(commandSender, string, 1, bl, false, bl);
    }

    public void listResidences(CommandSender commandSender, String string, int n) {
        this.listResidences(commandSender, string, n, false, false, false);
    }

    public void listResidences(CommandSender commandSender, int n, boolean bl) {
        this.listResidences(commandSender, commandSender.getName(), n, bl, false, bl);
    }

    public void listResidences(CommandSender commandSender, int n, boolean bl, boolean bl2) {
        this.listResidences(commandSender, commandSender.getName(), n, bl, bl2, bl);
    }

    public void listResidences(CommandSender commandSender, String string, int n, boolean bl) {
        this.listResidences(commandSender, string, n, bl, false, bl);
    }

    public void listResidences(CommandSender commandSender, String string, int n, boolean bl, boolean bl2, boolean bl3) {
        this.listResidences(commandSender, string, n, bl, bl2, bl3, null);
    }

    public void listResidences(CommandSender commandSender, String string, int n, boolean bl, boolean bl2, boolean bl3, World world) {
        if (string == null) {
            string = commandSender.getName();
        }
        if (bl && !this.plugin.isResAdminOn(commandSender) && !commandSender.getName().equalsIgnoreCase(string)) {
            bl = false;
        } else if (commandSender.getName().equalsIgnoreCase(string)) {
            bl = true;
        }
        boolean bl4 = bl;
        TreeMap<String, ClaimedResidence> treeMap = this.plugin.getPlayerManager().getResidencesMap(string, bl4, bl2, world);
        treeMap.putAll(this.plugin.getRentManager().getRentsMap(string, bl2, world));
        this.plugin.getInfoPageManager().printListInfo(commandSender, string, treeMap, n, bl3);
    }

    public void listAllResidences(CommandSender commandSender, int n) {
        this.listAllResidences(commandSender, n, false);
    }

    public void listAllResidences(CommandSender commandSender, int n, boolean bl, World world) {
        TreeMap<String, ClaimedResidence> treeMap = this.getFromAllResidencesMap(bl, false, world);
        this.plugin.getInfoPageManager().printListInfo(commandSender, null, treeMap, n, bl);
    }

    public void listAllResidences(CommandSender commandSender, int n, boolean bl) {
        this.listAllResidences(commandSender, n, bl, false);
    }

    public void listAllResidences(CommandSender commandSender, int n, boolean bl, boolean bl2) {
        TreeMap<String, ClaimedResidence> treeMap = this.getFromAllResidencesMap(bl, bl2, null);
        this.plugin.getInfoPageManager().printListInfo(commandSender, null, treeMap, n, bl);
    }

    public String[] getResidenceList() {
        return this.getResidenceList(true, true).toArray(new String[0]);
    }

    public Map<String, ClaimedResidence> getResidenceMapList(String string, boolean bl) {
        HashMap<String, ClaimedResidence> hashMap = new HashMap<String, ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> entry : this.residences.entrySet()) {
            if (!entry.getValue().isOwner(string)) continue;
            boolean bl2 = entry.getValue().getPermissions().has("hidden", false);
            if (!bl && (bl || bl2)) continue;
            hashMap.put(entry.getValue().getName().toLowerCase(), entry.getValue());
        }
        return hashMap;
    }

    public ArrayList<String> getResidenceList(boolean bl, boolean bl2) {
        return this.getResidenceList(null, bl, bl2, false);
    }

    public ArrayList<String> getResidenceList(String string, boolean bl, boolean bl2) {
        return this.getResidenceList(string, bl, bl2, false, false);
    }

    public ArrayList<String> getResidenceList(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.getResidenceList(string, bl, bl2, false, bl3);
    }

    public ArrayList<String> getResidenceList(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, ClaimedResidence> entry : this.residences.entrySet()) {
            this.getResidenceList(string, bl, bl2, "", entry.getKey(), entry.getValue(), arrayList, bl3, bl4);
        }
        return arrayList;
    }

    public ArrayList<ClaimedResidence> getFromAllResidences(boolean bl, boolean bl2, World world) {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> entry : this.residences.entrySet()) {
            boolean bl3 = entry.getValue().getPermissions().has("hidden", false);
            if (bl2 && !bl3 || world != null && !world.getName().equalsIgnoreCase(entry.getValue().getWorld()) || !bl && (bl || bl3)) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public TreeMap<String, ClaimedResidence> getFromAllResidencesMap(boolean bl, boolean bl2, World world) {
        TreeMap<String, ClaimedResidence> treeMap = new TreeMap<String, ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> entry : this.residences.entrySet()) {
            boolean bl3 = entry.getValue().getPermissions().has("hidden", false);
            if (bl2 && !bl3 || world != null && !world.getName().equalsIgnoreCase(entry.getValue().getWorld()) || !bl && (bl || bl3)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    private void getResidenceList(String string, boolean bl, boolean bl2, String string2, String string3, ClaimedResidence claimedResidence, ArrayList<String> arrayList, boolean bl3, boolean bl4) {
        boolean bl5 = claimedResidence.getPermissions().has("hidden", false);
        if (bl4 && !bl5) {
            return;
        }
        if (bl || !bl && !bl5) {
            if (string == null || claimedResidence.getPermissions().getOwner().equals(string)) {
                if (bl3) {
                    arrayList.add(String.valueOf(this.plugin.msg(lm.Residence_List, string2, string3, claimedResidence.getWorld())) + (bl5 ? this.plugin.msg(lm.Residence_Hidden, new Object[0]) : ""));
                } else {
                    arrayList.add(String.valueOf(string2) + string3);
                }
            }
            if (bl2) {
                for (Map.Entry<String, ClaimedResidence> entry : claimedResidence.subzones.entrySet()) {
                    this.getResidenceList(string, bl, bl2, String.valueOf(string2) + string3 + ".", entry.getKey(), entry.getValue(), arrayList, bl3, bl4);
                }
            }
        }
    }

    public String checkAreaCollision(CuboidArea cuboidArea, ClaimedResidence claimedResidence) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            ClaimedResidence claimedResidence2 = entry.getValue();
            if (claimedResidence2 == claimedResidence || !claimedResidence2.checkCollision(cuboidArea)) continue;
            return entry.getKey();
        }
        return null;
    }

    public ClaimedResidence collidesWithResidence(CuboidArea cuboidArea) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            ClaimedResidence claimedResidence = entry.getValue();
            if (!claimedResidence.checkCollision(cuboidArea)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void removeResidence(ClaimedResidence claimedResidence) {
        this.removeResidence((Player)null, claimedResidence.getName(), true);
    }

    public void removeResidence(String string) {
        this.removeResidence((Player)null, string, true);
    }

    public void removeResidence(CommandSender commandSender, String string, boolean bl) {
        if (commandSender instanceof Player) {
            this.removeResidence((Player)commandSender, string, bl);
        } else {
            this.removeResidence((Player)null, string, true);
        }
    }

    @Deprecated
    public void removeResidence(Player player, String string, boolean bl) {
        ClaimedResidence claimedResidence = this.getByName(string);
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        this.removeResidence(player, claimedResidence, bl);
    }

    @Deprecated
    public void removeResidence(Player player, ClaimedResidence claimedResidence, boolean bl) {
        this.removeResidence(this.plugin.getPlayerManager().getResidencePlayer(player), claimedResidence, bl);
    }

    public void removeResidence(ResidencePlayer residencePlayer, ClaimedResidence claimedResidence, boolean bl) {
        this.removeResidence(residencePlayer, claimedResidence, bl, false);
    }

    public void removeResidence(ResidencePlayer residencePlayer, ClaimedResidence claimedResidence, boolean bl, boolean bl2) {
        Object object2;
        Player player = null;
        if (residencePlayer != null) {
            player = residencePlayer.getPlayer();
        }
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        String string = claimedResidence.getName();
        if (this.plugin.getConfigManager().isRentPreventRemoval() && !bl) {
            object2 = claimedResidence.getRentedSubzone();
            if (object2 != null) {
                this.plugin.msg((CommandSender)player, lm.Residence_CantRemove, claimedResidence.getName(), ((ClaimedResidence)object2).getName(), ((ClaimedResidence)object2).getRentedLand().player);
                return;
            }
            if (player != null && claimedResidence.isRented() && !player.getName().equalsIgnoreCase(claimedResidence.getRentedLand().player)) {
                this.plugin.msg((CommandSender)player, lm.Residence_CantRemove, claimedResidence.getName(), claimedResidence.getName(), claimedResidence.getRentedLand().player);
                return;
            }
        }
        if (!(player == null || bl || claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) || bl || claimedResidence.getParent() == null || claimedResidence.getParent().isOwner(player))) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        object2 = new ResidenceDeleteEvent(player, claimedResidence, residencePlayer == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
        this.plugin.getServ().getPluginManager().callEvent((Event)object2);
        if (((CancellableResidencePlayerEvent)object2).isCancelled()) {
            return;
        }
        ClaimedResidence claimedResidence2 = claimedResidence.getParent();
        if (claimedResidence2 == null) {
            this.removeChunkList(string);
            this.residences.remove(string.toLowerCase());
            if (this.plugin.getConfigManager().isUseClean() && this.plugin.getConfigManager().getCleanWorlds().contains(claimedResidence.getWorld())) {
                final CuboidArea[] object3 = claimedResidence.getAreaArray();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        CuboidArea[] cuboidAreaArray = object3;
                        int n = object3.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CuboidArea cuboidArea = cuboidAreaArray[n2];
                            Location location = cuboidArea.getLowLoc().clone();
                            Location location2 = cuboidArea.getHighLoc().clone();
                            if (location2.getBlockY() > ResidenceManager.this.plugin.getConfigManager().getCleanLevel()) {
                                if (location.getBlockY() < ResidenceManager.this.plugin.getConfigManager().getCleanLevel()) {
                                    location.setY((double)ResidenceManager.this.plugin.getConfigManager().getCleanLevel());
                                }
                                World world = location.getWorld();
                                Location location3 = new Location(world, (double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
                                Bukkit.getScheduler().runTask((Plugin)ResidenceManager.this.plugin, () -> {
                                    Long l = 0L;
                                    int n = location.getBlockX();
                                    while (n <= location2.getBlockX()) {
                                        location3.setX((double)n);
                                        int n2 = location.getBlockZ();
                                        while (n2 <= location2.getBlockZ()) {
                                            location3.setZ((double)n2);
                                            int n3 = location.getBlockY();
                                            while (n3 <= world.getHighestBlockAt(n, n2).getY()) {
                                                location3.setY((double)n3);
                                                if (!location3.getChunk().isLoaded()) {
                                                    location3.getChunk().load();
                                                }
                                                if (ResidenceManager.this.plugin.getConfigManager().getCleanBlocks().contains(location3.getBlock().getType())) {
                                                    location3.getBlock().setType(Material.AIR);
                                                }
                                                l = l + 1L;
                                                ++n3;
                                            }
                                            ++n2;
                                        }
                                        ++n;
                                    }
                                });
                            }
                            ++n2;
                        }
                    }
                });
            }
            if (this.plugin.getConfigManager().isRemoveLwcOnDelete()) {
                this.removeLwcFromResidence(player, claimedResidence);
            }
            if (bl2) {
                CuboidArea[] cuboidAreaArray = claimedResidence.getAreaArray();
                int n = cuboidAreaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuboidArea cuboidArea = cuboidAreaArray[n2];
                    this.plugin.getSelectionManager().regenerate(cuboidArea);
                    ++n2;
                }
            }
            this.plugin.msg((CommandSender)player, lm.Residence_Remove, string);
        } else {
            String[] stringArray = string.split("\\.");
            if (player != null) {
                claimedResidence2.removeSubzone(player, stringArray[stringArray.length - 1], true);
            } else {
                claimedResidence2.removeSubzone(stringArray[stringArray.length - 1]);
            }
        }
        this.plugin.getLeaseManager().removeExpireTime(claimedResidence);
        for (ClaimedResidence claimedResidence3 : claimedResidence.getSubzones()) {
            this.plugin.getPlayerManager().removeResFromPlayer(claimedResidence.getOwnerUUID(), claimedResidence3);
            this.plugin.getRentManager().removeRentable(String.valueOf(string) + "." + claimedResidence3.getResidenceName());
            this.plugin.getTransactionManager().removeFromSale(String.valueOf(string) + "." + claimedResidence3.getResidenceName());
        }
        this.plugin.getPlayerManager().removeResFromPlayer(claimedResidence.getOwnerUUID(), claimedResidence);
        this.plugin.getRentManager().removeRentable(string);
        this.plugin.getTransactionManager().removeFromSale(string);
        if (!claimedResidence.isServerLand() && claimedResidence2 == null && this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().useResMoneyBack()) {
            double d = claimedResidence.getWorth();
            if (!claimedResidence.isOwner(player)) {
                this.plugin.getTransactionManager().giveEconomyMoney(claimedResidence.getOwner(), d);
            } else if (player != null) {
                this.plugin.getTransactionManager().giveEconomyMoney(player, d);
            } else if (residencePlayer != null) {
                this.plugin.getTransactionManager().giveEconomyMoney(residencePlayer.getPlayerName(), d);
            }
        }
    }

    public void removeLwcFromResidence(Player player, ClaimedResidence claimedResidence) {
        long l = System.currentTimeMillis();
        LWC lWC = this.plugin.getLwc();
        if (lWC == null) {
            return;
        }
        if (claimedResidence == null) {
            return;
        }
        int n = 0;
        ProtectionCache protectionCache = lWC.getProtectionCache();
        List<Material> list2 = this.plugin.getConfigManager().getLwcMatList();
        try {
            CuboidArea[] cuboidAreaArray = claimedResidence.getAreaArray();
            int n2 = cuboidAreaArray.length;
            int n3 = 0;
            while (n3 < n2) {
                CuboidArea cuboidArea = cuboidAreaArray[n3];
                Location location = cuboidArea.getLowLoc();
                Location location2 = cuboidArea.getHighLoc();
                World world = location.getWorld();
                int n4 = location.getBlockX();
                while (n4 <= location2.getBlockX()) {
                    int n5 = location.getBlockY();
                    while (n5 <= location2.getBlockY()) {
                        int n6 = location.getBlockZ();
                        while (n6 <= location2.getBlockZ()) {
                            Protection protection;
                            Block block = world.getBlockAt(n4, n5, n6);
                            if (!block.getChunk().isLoaded()) {
                                block.getChunk().load();
                            }
                            if (list2.contains(block.getType()) && (protection = protectionCache.getProtection(block)) != null) {
                                protection.remove();
                                ++n;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            this.plugin.msg((CommandSender)player, lm.Residence_LwcRemoved, n, System.currentTimeMillis() - l);
        }
    }

    public void removeAllByOwner(String string) {
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(string);
        for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
            this.removeResidence(residencePlayer, claimedResidence, true);
        }
    }

    public int getOwnedZoneCount(String string) {
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(string);
        return residencePlayer.getResAmount();
    }

    public boolean hasMaxZones(String string, int n) {
        return this.getOwnedZoneCount(string) < n;
    }

    public void printAreaInfo(String string, CommandSender commandSender) {
        this.printAreaInfo(string, commandSender, false);
    }

    public void printAreaInfo(String string, CommandSender commandSender, boolean bl) {
        String string2;
        Object object;
        String string3;
        Object object2;
        ClaimedResidence claimedResidence = this.getByName(string);
        if (claimedResidence == null) {
            this.plugin.msg(commandSender, lm.Invalid_Residence, new Object[0]);
            return;
        }
        string = claimedResidence.getName();
        this.plugin.msg(commandSender, lm.General_Separator, new Object[0]);
        ResidencePermissions residencePermissions = claimedResidence.getPermissions();
        String string4 = "&e" + this.plugin.msg(lm.Residence_Line, string);
        string4 = String.valueOf(string4) + this.plugin.msg(lm.General_Owner, residencePermissions.getOwner());
        if (this.plugin.getConfigManager().enableEconomy() && (claimedResidence.isOwner(commandSender) || !(commandSender instanceof Player) || bl)) {
            string4 = String.valueOf(string4) + this.plugin.msg(lm.Bank_Name, claimedResidence.getBank().getStoredMoneyFormated());
        }
        string4 = CMIChatColor.translate(string4);
        String string5 = this.plugin.msg(lm.General_World, residencePermissions.getWorld());
        if (claimedResidence.getAreaArray().length > 0 && (claimedResidence.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && claimedResidence.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || bl)) {
            object2 = claimedResidence.getAreaArray()[0];
            string3 = this.plugin.msg(lm.General_CoordsTop, ((CuboidArea)object2).getHighLoc().getBlockX(), ((CuboidArea)object2).getHighLoc().getBlockY(), ((CuboidArea)object2).getHighLoc().getBlockZ());
            object = this.plugin.msg(lm.General_CoordsBottom, ((CuboidArea)object2).getLowLoc().getBlockX(), ((CuboidArea)object2).getLowLoc().getBlockY(), ((CuboidArea)object2).getLowLoc().getBlockZ());
            string5 = String.valueOf(string5) + CMIChatColor.translate(this.plugin.msg(lm.General_CoordsLiner, string3, object));
        }
        string5 = String.valueOf(string5) + "\n" + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(claimedResidence.createTime));
        object2 = residencePermissions.listFlags(5);
        if (!(commandSender instanceof Player)) {
            object2 = residencePermissions.listFlags();
        }
        string3 = this.plugin.msg(lm.General_ResidenceFlags, object2);
        if (residencePermissions.getFlags().size() > 2 && commandSender instanceof Player) {
            string3 = String.valueOf(this.plugin.msg(lm.General_ResidenceFlags, residencePermissions.listFlags(5, 3))) + "...";
        }
        if (commandSender instanceof Player) {
            object = new RawMessage();
            ((RawMessage)object).addText(string4).addHover(string5);
            ((RawMessage)object).show(commandSender);
            ((RawMessage)object).clear();
            ((RawMessage)object).addText(string3).addHover((String)object2);
            ((RawMessage)object).show(commandSender);
        } else {
            this.plugin.msg(commandSender, string4);
            this.plugin.msg(commandSender, string5);
            this.plugin.msg(commandSender, string3);
        }
        if (!this.plugin.getConfigManager().isShortInfoUse() || !(commandSender instanceof Player)) {
            commandSender.sendMessage(this.plugin.msg(lm.General_PlayersFlags, residencePermissions.listPlayersFlags()));
        } else if (this.plugin.getConfigManager().isShortInfoUse() || commandSender instanceof Player) {
            object = residencePermissions.listPlayersFlagsRaw(commandSender.getName(), this.plugin.msg(lm.General_PlayersFlags, ""));
            ((RawMessage)object).show(commandSender);
        }
        object = residencePermissions.listGroupFlags();
        if (((String)object).length() > 0) {
            this.plugin.msg(commandSender, lm.General_GroupFlags, object);
        }
        String string6 = "";
        string6 = String.valueOf(string6) + this.plugin.msg(lm.General_TotalResSize, claimedResidence.getTotalSize(), claimedResidence.getXZSize());
        this.plugin.msg(commandSender, CMIChatColor.translate(string6));
        if (this.plugin.getEconomyManager() != null) {
            this.plugin.msg(commandSender, lm.General_TotalWorth, claimedResidence.getWorthByOwner(), claimedResidence.getWorth());
        }
        if (claimedResidence.getSubzonesAmount(false) > 0) {
            this.plugin.msg(commandSender, lm.General_TotalSubzones, claimedResidence.getSubzonesAmount(false), claimedResidence.getSubzonesAmount(true));
        }
        if (this.plugin.getConfigManager().useLeases() && this.plugin.getLeaseManager().isLeased(claimedResidence) && (string2 = this.plugin.getLeaseManager().getExpireTime(claimedResidence)) != null) {
            this.plugin.msg(commandSender, lm.Economy_LeaseExpire, string2);
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isForRent(string) && !this.plugin.getRentManager().isRented(string)) {
            string2 = this.plugin.msg(lm.Rent_isForRent, new Object[0]);
            RentableLand rentableLand = this.plugin.getRentManager().getRentableLand(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (rentableLand != null) {
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.General_Cost, rentableLand.cost, rentableLand.days)) + "\n");
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.Rentable_AllowRenewing, rentableLand.AllowRenewing)) + "\n");
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.Rentable_StayInMarket, rentableLand.StayInMarket)) + "\n");
                stringBuilder.append(this.plugin.msg(lm.Rentable_AllowAutoPay, rentableLand.AllowAutoPay));
            }
            if (commandSender instanceof Player) {
                RawMessage rawMessage = new RawMessage();
                rawMessage.add(string2, stringBuilder.toString());
                rawMessage.show(commandSender);
            } else {
                this.plugin.msg(commandSender, string2);
            }
        } else if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(string)) {
            string2 = this.plugin.msg(lm.Residence_RentedBy, this.plugin.getRentManager().getRentingPlayer(string));
            RentableLand rentableLand = this.plugin.getRentManager().getRentableLand(string);
            RentedLand rentedLand = this.plugin.getRentManager().getRentedLand(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (rentedLand != null) {
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.Rent_Expire, GetTime.getTime(rentedLand.endTime))) + "\n");
                if (rentedLand.player.equals(commandSender.getName()) || bl || claimedResidence.isOwner(commandSender)) {
                    stringBuilder.append(String.valueOf(rentedLand.AutoPay ? this.plugin.msg(lm.Rent_AutoPayTurnedOn, new Object[0]) : this.plugin.msg(lm.Rent_AutoPayTurnedOff, new Object[0])) + "\n");
                }
            }
            if (rentableLand != null) {
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.General_Cost, rentableLand.cost, rentableLand.days)) + "\n");
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.Rentable_AllowRenewing, rentableLand.AllowRenewing)) + "\n");
                stringBuilder.append(String.valueOf(this.plugin.msg(lm.Rentable_StayInMarket, rentableLand.StayInMarket)) + "\n");
                stringBuilder.append(this.plugin.msg(lm.Rentable_AllowAutoPay, rentableLand.AllowAutoPay));
            }
            if (commandSender instanceof Player) {
                RawMessage rawMessage = new RawMessage();
                rawMessage.addText(string2).addHover(stringBuilder.toString());
                rawMessage.show(commandSender);
            } else {
                this.plugin.msg(commandSender, string2);
            }
        } else if (this.plugin.getTransactionManager().isForSale(string)) {
            int n = this.plugin.getTransactionManager().getSaleAmount(string);
            String string7 = String.valueOf(this.plugin.msg(lm.Economy_LandForSale, new Object[0])) + " " + n;
            this.plugin.msg(commandSender, string7);
        }
        this.plugin.msg(commandSender, lm.General_Separator, new Object[0]);
    }

    public void mirrorPerms(Player player, String string, String string2, boolean bl) {
        ClaimedResidence claimedResidence = this.getByName(string);
        ClaimedResidence claimedResidence2 = this.getByName(string2);
        if (claimedResidence2 == null || claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (!(bl || claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) && claimedResidence2.getPermissions().hasResidencePermission((CommandSender)player, true))) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        claimedResidence.getPermissions().applyTemplate(player, claimedResidence2.getPermissions(), bl);
    }

    public Map<String, Object> save() {
        this.clearSaveChache();
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (World world : this.plugin.getServ().getWorlds()) {
            LinkedHashMap<String, Map<String, Object>> linkedHashMap2 = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, ClaimedResidence> entry : new TreeMap<String, ClaimedResidence>(this.residences).entrySet()) {
                if (!entry.getValue().getWorld().equals(world.getName())) continue;
                try {
                    linkedHashMap2.put(entry.getValue().getResidenceName(), entry.getValue().save());
                }
                catch (Throwable throwable) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + " Failed to save residence (" + entry.getKey() + ")!");
                    Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, throwable);
                }
            }
            linkedHashMap.put(world.getName(), linkedHashMap2);
        }
        return linkedHashMap;
    }

    private void clearSaveChache() {
        this.optimizeMessages.clear();
        this.optimizeFlags.clear();
    }

    public MinimizeMessages addMessageToTempCache(String string, String string2, String string3) {
        MinimizeMessages minimizeMessages2;
        List<MinimizeMessages> list2 = this.optimizeMessages.get(string);
        if (list2 == null) {
            list2 = new ArrayList<MinimizeMessages>();
        }
        for (MinimizeMessages minimizeMessages2 : list2) {
            if (!minimizeMessages2.add(string2, string3)) continue;
            return minimizeMessages2;
        }
        minimizeMessages2 = new MinimizeMessages(list2.size() + 1, string2, string3);
        list2.add(minimizeMessages2);
        this.optimizeMessages.put(string, list2);
        return minimizeMessages2;
    }

    public HashMap<Integer, Object> getMessageCatch(String string) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        List<MinimizeMessages> list2 = this.optimizeMessages.get(string);
        if (list2 == null) {
            return null;
        }
        for (MinimizeMessages minimizeMessages : list2) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("EnterMessage", minimizeMessages.getEnter());
            hashMap2.put("LeaveMessage", minimizeMessages.getLeave());
            hashMap.put(minimizeMessages.getId(), hashMap2);
        }
        return hashMap;
    }

    public MinimizeFlags addFlagsTempCache(String string, Map<String, Boolean> map) {
        MinimizeFlags minimizeFlags2;
        if (string == null) {
            return null;
        }
        List<MinimizeFlags> list2 = this.optimizeFlags.get(string);
        if (list2 == null) {
            list2 = new ArrayList<MinimizeFlags>();
        }
        for (MinimizeFlags minimizeFlags2 : list2) {
            if (!minimizeFlags2.add(map)) continue;
            return minimizeFlags2;
        }
        minimizeFlags2 = new MinimizeFlags(list2.size() + 1, map);
        list2.add(minimizeFlags2);
        this.optimizeFlags.put(string, list2);
        return minimizeFlags2;
    }

    public HashMap<Integer, Object> getFlagsCatch(String string) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        List<MinimizeFlags> list2 = this.optimizeFlags.get(string);
        if (list2 == null) {
            return null;
        }
        for (MinimizeFlags minimizeFlags : list2) {
            hashMap.put(minimizeFlags.getId(), minimizeFlags.getFlags());
        }
        return hashMap;
    }

    private void clearLoadChache() {
        this.cacheMessages.clear();
        this.cacheFlags.clear();
    }

    public HashMap<String, HashMap<Integer, MinimizeMessages>> getCacheMessages() {
        return this.cacheMessages;
    }

    public HashMap<String, HashMap<Integer, MinimizeFlags>> getCacheFlags() {
        return this.cacheFlags;
    }

    public String getChacheMessageEnter(String string, int n) {
        HashMap<Integer, MinimizeMessages> hashMap = this.cacheMessages.get(string);
        if (hashMap == null) {
            return null;
        }
        MinimizeMessages minimizeMessages = hashMap.get(n);
        if (minimizeMessages == null) {
            return null;
        }
        return minimizeMessages.getEnter();
    }

    public String getChacheMessageLeave(String string, int n) {
        HashMap<Integer, MinimizeMessages> hashMap = this.cacheMessages.get(string);
        if (hashMap == null) {
            return null;
        }
        MinimizeMessages minimizeMessages = hashMap.get(n);
        if (minimizeMessages == null) {
            return null;
        }
        return minimizeMessages.getLeave();
    }

    public Map<String, Boolean> getChacheFlags(String string, int n) {
        HashMap<Integer, MinimizeFlags> hashMap = this.cacheFlags.get(string);
        if (hashMap == null) {
            return null;
        }
        MinimizeFlags minimizeFlags = hashMap.get(n);
        if (minimizeFlags == null) {
            return null;
        }
        return minimizeFlags.getFlags();
    }

    public void load(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        this.residences.clear();
        for (World world : this.plugin.getServ().getWorlds()) {
            long l;
            String string;
            Map map2;
            long l2;
            block6: {
                l2 = System.currentTimeMillis();
                map2 = (Map)map.get(world.getName());
                if (!this.plugin.isDisabledWorld(world)) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Loading " + world.getName() + " data into memory...");
                }
                if (map2 != null) {
                    try {
                        this.chunkResidences.put(world.getName(), this.loadMap(world.getName(), map2));
                    }
                    catch (Exception exception) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + "Error in loading save file for world: " + world.getName());
                        if (!this.plugin.getConfigManager().stopOnSaveError()) break block6;
                        throw exception;
                    }
                }
            }
            String string2 = string = (l = System.currentTimeMillis() - l2) > 1000L ? String.valueOf(String.format("%.2f", Float.valueOf((float)l / 1000.0f))) + " sec" : String.valueOf(l) + " ms";
            if (this.plugin.isDisabledWorld(world)) continue;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Loaded " + world.getName() + " data into memory. (" + string + ") -> " + (map2 == null ? "0" : Integer.valueOf(map2.size())) + " residences");
        }
        this.clearLoadChache();
    }

    public Map<ChunkRef, List<ClaimedResidence>> loadMap(String string, Map<String, Object> map) {
        HashMap<ChunkRef, List<ClaimedResidence>> hashMap = new HashMap<ChunkRef, List<ClaimedResidence>>();
        if (map == null) {
            return hashMap;
        }
        int n = 0;
        int n2 = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (n == 100 & this.plugin.getConfigManager().isUUIDConvertion()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " " + string + " UUID conversion done: " + n2 + " of " + map.size());
            }
            if (n >= 100) {
                n = 0;
            }
            ++n;
            ++n2;
            try {
                ClaimedResidence claimedResidence = ClaimedResidence.load(string, (Map)entry.getValue(), null, this.plugin);
                if (claimedResidence == null || claimedResidence.getPermissions().getOwnerUUID().toString().equals(this.plugin.getServerLandUUID()) && !claimedResidence.getOwner().equalsIgnoreCase("Server land") && !claimedResidence.getOwner().equalsIgnoreCase(this.plugin.getServerLandName())) continue;
                if (claimedResidence.getOwner().equalsIgnoreCase("Server land")) {
                    claimedResidence.getPermissions().setOwner(this.plugin.getServerLandName(), false);
                }
                String string2 = entry.getKey().toLowerCase();
                int n3 = this.getNameIncrement(string2);
                if (claimedResidence.getResidenceName() == null) {
                    claimedResidence.setName(entry.getKey());
                }
                if (n3 > 0) {
                    claimedResidence.setName(String.valueOf(claimedResidence.getResidenceName()) + n3);
                    string2 = String.valueOf(string2) + n3;
                }
                for (ChunkRef chunkRef : ResidenceManager.getChunks(claimedResidence)) {
                    ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
                    if (hashMap.containsKey(chunkRef)) {
                        arrayList.addAll((Collection)hashMap.get(chunkRef));
                    }
                    arrayList.add(claimedResidence);
                    hashMap.put(chunkRef, arrayList);
                }
                this.plugin.getPlayerManager().addResidence(claimedResidence.getOwner(), claimedResidence);
                this.residences.put(string2.toLowerCase(), claimedResidence);
            }
            catch (Exception exception) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + " Failed to load residence (" + entry.getKey() + ")! Reason:" + exception.getMessage() + " Error Log:");
                Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, exception);
                if (!this.plugin.getConfigManager().stopOnSaveError()) continue;
                throw exception;
            }
        }
        return hashMap;
    }

    private int getNameIncrement(String string) {
        String string2 = string;
        int n = 0;
        while (n < 1000) {
            if (!this.residences.containsKey(string.toLowerCase())) break;
            string = String.valueOf(string2) + ++n;
        }
        return n;
    }

    private static List<ChunkRef> getChunks(ClaimedResidence claimedResidence) {
        ArrayList<ChunkRef> arrayList = new ArrayList<ChunkRef>();
        CuboidArea[] cuboidAreaArray = claimedResidence.getAreaArray();
        int n = cuboidAreaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuboidArea cuboidArea = cuboidAreaArray[n2];
            arrayList.addAll(cuboidArea.getChunks());
            ++n2;
        }
        return arrayList;
    }

    public boolean renameResidence(String string, String string2) {
        return this.renameResidence(null, string, string2, true);
    }

    public boolean renameResidence(Player player, String string, String string2, boolean bl) {
        if (!PermissionManager.ResPerm.rename.hasPermission((CommandSender)player, true, new String[0])) {
            return false;
        }
        if (!this.plugin.validName(string2)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        ClaimedResidence claimedResidence = this.getByName(string);
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return false;
        }
        if (claimedResidence.isRaidInitialized() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return false;
        }
        string = claimedResidence.getName();
        if (claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) || bl) {
            if (claimedResidence.getParent() == null) {
                if (this.residences.containsKey(string2.toLowerCase())) {
                    this.plugin.msg((CommandSender)player, lm.Residence_AlreadyExists, string2);
                    return false;
                }
                ResidenceRenameEvent residenceRenameEvent = new ResidenceRenameEvent(claimedResidence, string2, string);
                this.plugin.getServ().getPluginManager().callEvent((Event)residenceRenameEvent);
                this.removeChunkList(string);
                claimedResidence.setName(string2);
                this.residences.put(string2.toLowerCase(), claimedResidence);
                this.residences.remove(string.toLowerCase());
                this.calculateChunks(string2);
                this.plugin.getSignUtil().updateSignResName(claimedResidence);
                this.plugin.msg((CommandSender)player, lm.Residence_Rename, string, string2);
                return true;
            }
            String[] stringArray = string.split("\\.");
            ClaimedResidence claimedResidence2 = claimedResidence.getParent();
            boolean bl2 = claimedResidence2.renameSubzone(player, stringArray[stringArray.length - 1], string2, bl);
            this.plugin.getSignUtil().updateSignResName(claimedResidence);
            return bl2;
        }
        this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        return false;
    }

    public void giveResidence(Player player, String string, String string2, boolean bl) {
        this.giveResidence(player, string, string2, bl, false);
    }

    public void giveResidence(Player player, String string, String string2, boolean bl, boolean bl2) {
        this.giveResidence(player, string, this.getByName(string2), bl, bl2);
    }

    public void giveResidence(Player player, String string, ClaimedResidence claimedResidence, boolean bl, boolean bl2) {
        ResidencePlayer residencePlayer;
        PermissionGroup permissionGroup;
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        String string2 = claimedResidence.getName();
        if (!claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        Player player2 = this.plugin.getServ().getPlayer(string);
        if (player2 == null || !player2.isOnline()) {
            this.plugin.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
            return;
        }
        CuboidArea[] cuboidAreaArray = claimedResidence.getAreaArray();
        if (cuboidAreaArray.length > (permissionGroup = (residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player2)).getGroup()).getMaxPhysicalPerResidence() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Residence_GiveLimits, new Object[0]);
            return;
        }
        if (!this.hasMaxZones(player2.getName(), residencePlayer.getMaxRes()) && !bl) {
            this.plugin.msg((CommandSender)player, lm.Residence_GiveLimits, new Object[0]);
            return;
        }
        if (!bl) {
            CuboidArea[] cuboidAreaArray2 = cuboidAreaArray;
            int n = cuboidAreaArray.length;
            int n2 = 0;
            while (n2 < n) {
                CuboidArea object = cuboidAreaArray2[n2];
                if (!claimedResidence.isSubzone() && !claimedResidence.isSmallerThanMax(player2, object, bl) || claimedResidence.isSubzone() && !claimedResidence.isSmallerThanMaxSubzone(player2, object, bl)) {
                    this.plugin.msg((CommandSender)player, lm.Residence_GiveLimits, new Object[0]);
                    return;
                }
                ++n2;
            }
        }
        if (!claimedResidence.getPermissions().setOwner(player2, true)) {
            return;
        }
        this.plugin.msg((CommandSender)player, lm.Residence_Give, string2, player2.getName());
        this.plugin.msg((CommandSender)player2, lm.Residence_Recieve, string2, player.getName());
        this.plugin.getSignUtil().updateSignResName(claimedResidence);
        if (bl2) {
            for (ClaimedResidence claimedResidence2 : claimedResidence.getSubzones()) {
                this.giveResidence(player, string, claimedResidence2, bl, bl2);
            }
        }
    }

    public void removeAllFromWorld(CommandSender commandSender, String string) {
        int n = 0;
        Iterator<ClaimedResidence> iterator = this.residences.values().iterator();
        while (iterator.hasNext()) {
            ClaimedResidence claimedResidence = iterator.next();
            if (!claimedResidence.getWorld().equals(string)) continue;
            iterator.remove();
            ++n;
        }
        this.chunkResidences.remove(string);
        this.chunkResidences.put(string, new HashMap());
        if (n == 0) {
            commandSender.sendMessage(ChatColor.RED + "No residences found in world: " + ChatColor.YELLOW + string);
        } else {
            commandSender.sendMessage(ChatColor.RED + "Removed " + ChatColor.YELLOW + n + ChatColor.RED + " residences in world: " + ChatColor.YELLOW + string);
        }
    }

    public int getResidenceCount() {
        return this.residences.size();
    }

    public Map<String, ClaimedResidence> getResidences() {
        return this.residences;
    }

    public void removeChunkList(String string) {
        if (string == null) {
            return;
        }
        ClaimedResidence claimedResidence = (ClaimedResidence)this.residences.get(string = string.toLowerCase());
        if (claimedResidence == null) {
            return;
        }
        String string2 = claimedResidence.getWorld();
        if (this.chunkResidences.get(string2) == null) {
            return;
        }
        for (ChunkRef chunkRef : ResidenceManager.getChunks(claimedResidence)) {
            ArrayList arrayList = new ArrayList();
            if (this.chunkResidences.get(string2).containsKey(chunkRef)) {
                arrayList.addAll(this.chunkResidences.get(string2).get(chunkRef));
            }
            arrayList.remove(claimedResidence);
            this.chunkResidences.get(string2).put(chunkRef, arrayList);
        }
    }

    public void calculateChunks(String string) {
        if (string == null) {
            return;
        }
        ClaimedResidence claimedResidence = (ClaimedResidence)this.residences.get(string = string.toLowerCase());
        if (claimedResidence == null) {
            return;
        }
        String string2 = claimedResidence.getWorld();
        if (this.chunkResidences.get(string2) == null) {
            this.chunkResidences.put(string2, new HashMap());
        }
        for (ChunkRef chunkRef : ResidenceManager.getChunks(claimedResidence)) {
            ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
            if (this.chunkResidences.get(string2).containsKey(chunkRef)) {
                arrayList.addAll((Collection)this.chunkResidences.get(string2).get(chunkRef));
            }
            arrayList.add(claimedResidence);
            this.chunkResidences.get(string2).put(chunkRef, arrayList);
        }
    }

    public static final class ChunkRef {
        private final int z;
        private final int x;

        public static int getChunkCoord(int n) {
            return n >> 4;
        }

        public ChunkRef(Location location) {
            this.x = ChunkRef.getChunkCoord(location.getBlockX());
            this.z = ChunkRef.getChunkCoord(location.getBlockZ());
        }

        public ChunkRef(int n, int n2) {
            this.x = n;
            this.z = n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ChunkRef chunkRef = (ChunkRef)object;
            return this.x == chunkRef.x && this.z == chunkRef.z;
        }

        public int hashCode() {
            return this.x ^ this.z;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ x: ").append(this.x).append(", z: ").append(this.z).append(" }");
            return stringBuilder.toString();
        }

        public int getZ() {
            return this.z;
        }

        public int getX() {
            return this.x;
        }
    }
}

