/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidencePlayerInterface;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerManager
implements ResidencePlayerInterface {
    private ConcurrentHashMap<String, ResidencePlayer> players = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, ResidencePlayer> playersUuid = new ConcurrentHashMap();
    private Residence plugin;

    public PlayerManager(Residence residence) {
        this.plugin = residence;
    }

    public void addPlayer(ResidencePlayer residencePlayer) {
        if (residencePlayer == null) {
            return;
        }
        this.addPlayer(residencePlayer.getName(), residencePlayer.getUniqueId(), residencePlayer);
    }

    public void addPlayer(Player player, ResidencePlayer residencePlayer) {
        if (player == null) {
            return;
        }
        this.addPlayer(player.getName(), player.getUniqueId(), residencePlayer);
    }

    public void addPlayer(String string, UUID uUID, ResidencePlayer residencePlayer) {
        if (string != null) {
            this.players.put(string.toLowerCase(), residencePlayer);
        }
        if (uUID != null) {
            this.playersUuid.put(uUID, residencePlayer);
        }
    }

    public ResidencePlayer playerJoin(Player player) {
        ResidencePlayer residencePlayer = this.playersUuid.get(player.getUniqueId());
        if (residencePlayer == null) {
            residencePlayer = new ResidencePlayer(player);
            this.addPlayer(residencePlayer);
        } else {
            residencePlayer.updatePlayer(player);
        }
        return residencePlayer;
    }

    public ResidencePlayer playerJoin(UUID uUID) {
        OfflinePlayer offlinePlayer;
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer == null && (offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID)) != null) {
            residencePlayer = new ResidencePlayer(offlinePlayer);
            this.addPlayer(residencePlayer);
        }
        return residencePlayer;
    }

    public ResidencePlayer playerJoin(String string) {
        if (!this.players.containsKey(string.toLowerCase())) {
            ResidencePlayer residencePlayer = new ResidencePlayer(string);
            this.addPlayer(residencePlayer);
            return residencePlayer;
        }
        return null;
    }

    public ResidencePlayer playerJoin(String string, UUID uUID) {
        if (!this.players.containsKey(string.toLowerCase())) {
            ResidencePlayer residencePlayer = new ResidencePlayer(string, uUID);
            this.addPlayer(residencePlayer);
            return residencePlayer;
        }
        return null;
    }

    public int getResidenceCount(UUID uUID) {
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer != null) {
            return residencePlayer.getResList().size();
        }
        return 0;
    }

    @Override
    public ArrayList<String> getResidenceList(UUID uUID) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer != null) {
            for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
                arrayList.add(claimedResidence.getName());
            }
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getResidenceList(String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player != null) {
            return this.getResidenceList(player.getUniqueId());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ResidencePlayer residencePlayer = this.getResidencePlayer(string.toLowerCase());
        if (residencePlayer != null) {
            for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
                arrayList.add(claimedResidence.getName());
            }
            return arrayList;
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getResidenceList(String string, boolean bl) {
        return this.getResidenceList(string, bl, false);
    }

    public ArrayList<String> getResidenceList(String string, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResidencePlayer residencePlayer = this.getResidencePlayer(string.toLowerCase());
        if (residencePlayer == null) {
            return arrayList;
        }
        for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
            boolean bl3 = claimedResidence.getPermissions().has("hidden", false);
            if (!bl && bl3 || bl2 && !bl3) continue;
            arrayList.add(String.valueOf(this.plugin.msg(lm.Residence_List, "", claimedResidence.getName(), claimedResidence.getWorld())) + (bl3 ? this.plugin.msg(lm.Residence_Hidden, new Object[0]) : ""));
        }
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        return arrayList;
    }

    public ArrayList<ClaimedResidence> getResidences(String string, boolean bl) {
        return this.getResidences(string, bl, false);
    }

    public ArrayList<ClaimedResidence> getResidences(String string, boolean bl, boolean bl2) {
        return this.getResidences(string, bl, bl2, null);
    }

    public ArrayList<ClaimedResidence> getResidences(String string, boolean bl, boolean bl2, World world) {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        ResidencePlayer residencePlayer = this.getResidencePlayer(string.toLowerCase());
        if (residencePlayer == null) {
            return arrayList;
        }
        for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
            boolean bl3 = claimedResidence.getPermissions().has("hidden", false);
            if (!bl && bl3 || bl2 && !bl3 || world != null && !world.getName().equalsIgnoreCase(claimedResidence.getWorld())) continue;
            arrayList.add(claimedResidence);
        }
        return arrayList;
    }

    public TreeMap<String, ClaimedResidence> getResidencesMap(String string, boolean bl, boolean bl2, World world) {
        TreeMap<String, ClaimedResidence> treeMap = new TreeMap<String, ClaimedResidence>();
        ResidencePlayer residencePlayer = this.getResidencePlayer(string.toLowerCase());
        if (residencePlayer == null) {
            return treeMap;
        }
        for (ClaimedResidence claimedResidence : residencePlayer.getResList()) {
            boolean bl3 = claimedResidence.getPermissions().has(Flags.hidden, false);
            if (!bl && bl3 || bl2 && !bl3 || world != null && !world.getName().equalsIgnoreCase(claimedResidence.getWorld())) continue;
            treeMap.put(claimedResidence.getName(), claimedResidence);
        }
        return treeMap;
    }

    @Override
    public PermissionGroup getGroup(String string) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string);
        if (residencePlayer != null) {
            return residencePlayer.getGroup();
        }
        return null;
    }

    @Override
    public int getMaxResidences(String string) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string);
        if (residencePlayer != null) {
            return residencePlayer.getMaxRes();
        }
        return -1;
    }

    @Override
    public int getMaxSubzones(String string) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string);
        if (residencePlayer != null) {
            return residencePlayer.getMaxSubzones();
        }
        return -1;
    }

    @Override
    public int getMaxSubzoneDepth(String string) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string);
        if (residencePlayer != null) {
            return residencePlayer.getMaxSubzoneDepth();
        }
        return -1;
    }

    @Override
    public int getMaxRents(String string) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string);
        if (residencePlayer != null) {
            return residencePlayer.getMaxRents();
        }
        return -1;
    }

    public ResidencePlayer getResidencePlayer(Player player) {
        ResidencePlayer residencePlayer = null;
        if (player == null) {
            return null;
        }
        residencePlayer = this.playersUuid.get(player.getUniqueId());
        if (residencePlayer != null) {
            residencePlayer.updatePlayer(player);
        } else {
            residencePlayer = this.playerJoin(player);
        }
        return residencePlayer;
    }

    @Override
    public ResidencePlayer getResidencePlayer(String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player != null) {
            return this.getResidencePlayer(player);
        }
        ResidencePlayer residencePlayer = this.players.get(string.toLowerCase());
        if (residencePlayer != null) {
            return residencePlayer;
        }
        return this.playerJoin(string);
    }

    public ResidencePlayer getResidencePlayer(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player != null) {
            return this.getResidencePlayer(player);
        }
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer != null) {
            return residencePlayer;
        }
        return this.playerJoin(uUID);
    }

    public ResidencePlayer getResidencePlayer(String string, UUID uUID) {
        if (uUID.toString().equals(this.plugin.getServerLandUUID())) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player != null) {
            return this.getResidencePlayer(player);
        }
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer != null) {
            return residencePlayer;
        }
        if (string != null) {
            residencePlayer = this.players.get(string.toLowerCase());
        }
        if (residencePlayer != null) {
            return residencePlayer;
        }
        return this.playerJoin(string, uUID);
    }

    public void addResidence(UUID uUID, ClaimedResidence claimedResidence) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(uUID);
        if (residencePlayer != null) {
            residencePlayer.addResidence(claimedResidence);
        }
    }

    public void addResidence(Player player, ClaimedResidence claimedResidence) {
        this.addResidence(player.getUniqueId(), claimedResidence);
    }

    public void addResidence(String string, ClaimedResidence claimedResidence) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string, claimedResidence.getOwnerUUID());
        if (residencePlayer != null) {
            residencePlayer.addResidence(claimedResidence);
        }
    }

    public void removeResFromPlayer(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        this.removeResFromPlayer(claimedResidence.getOwnerUUID(), claimedResidence);
    }

    public void removeResFromPlayer(UUID uUID, ClaimedResidence claimedResidence) {
        ResidencePlayer residencePlayer = this.playersUuid.get(uUID);
        if (residencePlayer != null) {
            residencePlayer.removeResidence(claimedResidence);
        }
    }

    public void removeResFromPlayer(OfflinePlayer offlinePlayer, ClaimedResidence claimedResidence) {
        this.removeResFromPlayer(offlinePlayer.getUniqueId(), claimedResidence);
    }

    public void removeResFromPlayer(Player player, ClaimedResidence claimedResidence) {
        this.removeResFromPlayer(player.getUniqueId(), claimedResidence);
    }

    public void removeResFromPlayer(String string, ClaimedResidence claimedResidence) {
        ResidencePlayer residencePlayer = this.getResidencePlayer(string.toLowerCase());
        if (residencePlayer != null) {
            residencePlayer.removeResidence(claimedResidence);
        }
    }
}

