/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PermissionListManager {
    private final Map<String, Map<String, FlagPermissions>> lists;
    private Residence plugin;

    public PermissionListManager(Residence residence) {
        this.plugin = residence;
        this.lists = Collections.synchronizedMap(new HashMap());
    }

    public FlagPermissions getList(String string, String string2) {
        Map<String, FlagPermissions> map = this.lists.get(string);
        if (map == null) {
            return null;
        }
        return map.get(string2);
    }

    public void makeList(Player player, String string) {
        FlagPermissions flagPermissions;
        Map<String, FlagPermissions> map = this.lists.get(player.getName());
        if (map == null) {
            map = new HashMap<String, FlagPermissions>();
            this.lists.put(player.getName(), map);
        }
        if ((flagPermissions = map.get(string)) == null) {
            flagPermissions = new FlagPermissions();
            map.put(string, flagPermissions);
            this.plugin.msg((CommandSender)player, lm.General_ListCreate, string);
        } else {
            this.plugin.msg((CommandSender)player, lm.General_ListExists, new Object[0]);
        }
    }

    public void removeList(Player player, String string) {
        Map<String, FlagPermissions> map = this.lists.get(player.getName());
        if (map == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_List, new Object[0]);
            return;
        }
        FlagPermissions flagPermissions = map.get(string);
        if (flagPermissions == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_List, new Object[0]);
            return;
        }
        map.remove(string);
        this.plugin.msg((CommandSender)player, lm.General_ListRemoved, new Object[0]);
    }

    public void applyListToResidence(Player player, String string, String string2, boolean bl) {
        FlagPermissions flagPermissions = this.getList(player.getName(), string);
        if (flagPermissions == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_List, new Object[0]);
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string2);
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        claimedResidence.getPermissions().applyTemplate(player, flagPermissions, bl);
    }

    public void printList(Player player, String string) {
        FlagPermissions flagPermissions = this.getList(player.getName(), string);
        if (flagPermissions == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_List, new Object[0]);
            return;
        }
        player.sendMessage(ChatColor.LIGHT_PURPLE + "------Permission Template------");
        this.plugin.msg((CommandSender)player, lm.General_Name, string);
        flagPermissions.printFlags(player);
    }

    public Map<String, Object> save() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Map<String, FlagPermissions>> entry : this.lists.entrySet()) {
            LinkedHashMap<String, Map<String, Object>> linkedHashMap2 = new LinkedHashMap<String, Map<String, Object>>();
            Map<String, FlagPermissions> map = entry.getValue();
            for (Map.Entry<String, FlagPermissions> entry2 : map.entrySet()) {
                linkedHashMap2.put(entry2.getKey(), entry2.getValue().save(null));
            }
            linkedHashMap.put(entry.getKey(), linkedHashMap2);
        }
        return linkedHashMap;
    }

    public PermissionListManager load(Map<String, Object> map) {
        PermissionListManager permissionListManager = new PermissionListManager(this.plugin);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                try {
                    Map map2 = (Map)entry.getValue();
                    Map<String, FlagPermissions> map3 = Collections.synchronizedMap(new HashMap());
                    for (Map.Entry entry2 : map2.entrySet()) {
                        map3.put((String)entry2.getKey(), FlagPermissions.load((Map)entry2.getValue()));
                    }
                    permissionListManager.lists.put(entry.getKey(), map3);
                }
                catch (Exception exception) {
                    System.out.println("[Residence] - Failed to load permission lists for player: " + entry.getKey());
                }
            }
        }
        return permissionListManager;
    }

    public void printLists(Player player) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, FlagPermissions> map = this.lists.get(player.getName());
        stringBuilder.append(this.plugin.msg(lm.General_Lists, new Object[0]));
        if (map != null) {
            for (Map.Entry<String, FlagPermissions> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey()).append(" ");
            }
        }
        player.sendMessage(stringBuilder.toString());
    }
}

