/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class LeaseManager {
    private Set<ClaimedResidence> leaseExpireTime;
    ResidenceManager manager;
    private Residence plugin;

    public LeaseManager(Residence residence) {
        this.plugin = residence;
        this.manager = residence.getResidenceManager();
        this.leaseExpireTime = new HashSet<ClaimedResidence>();
    }

    @Deprecated
    public boolean leaseExpires(ClaimedResidence claimedResidence) {
        return this.isLeased(claimedResidence);
    }

    public boolean isLeased(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return claimedResidence.getLeaseExpireTime() != null;
    }

    @Deprecated
    public boolean leaseExpires(String string) {
        return this.isLeased(this.plugin.getResidenceManager().getByName(string));
    }

    public String getExpireTime(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return null;
        }
        Long l = claimedResidence.getLeaseExpireTime();
        if (l != null) {
            return GetTime.getTime(l);
        }
        return null;
    }

    @Deprecated
    public String getExpireTime(String string) {
        return this.getExpireTime(this.plugin.getResidenceManager().getByName(string));
    }

    public void removeExpireTime(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        this.leaseExpireTime.remove(claimedResidence);
    }

    @Deprecated
    public void removeExpireTime(String string) {
        this.removeExpireTime(this.plugin.getResidenceManager().getByName(string));
    }

    public void setExpireTime(Player player, ClaimedResidence claimedResidence, int n) {
        if (claimedResidence == null) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
            }
            return;
        }
        claimedResidence.setLeaseExpireTime(LeaseManager.daysToMs(n) + System.currentTimeMillis());
        this.leaseExpireTime.add(claimedResidence);
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(claimedResidence));
        }
    }

    @Deprecated
    public void setExpireTime(String string, int n) {
        this.setExpireTime(null, string, n);
    }

    @Deprecated
    public void setExpireTime(Player player, String string, int n) {
        this.setExpireTime(player, this.plugin.getResidenceManager().getByName(string), n);
    }

    @Deprecated
    public void renewArea(String string, Player player) {
        this.renewArea(this.plugin.getResidenceManager().getByName(string), player);
    }

    public void renewArea(ClaimedResidence claimedResidence, Player player) {
        if (claimedResidence == null) {
            return;
        }
        if (!this.isLeased(claimedResidence)) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
            return;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        int n = permissionGroup.getMaxLeaseTime();
        int n2 = permissionGroup.getLeaseGiveTime();
        int n3 = LeaseManager.daysRemaining(claimedResidence);
        if (n3 >= n) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(claimedResidence));
            return;
        }
        EconomyInterface economyInterface = this.plugin.getEconomyManager();
        if (economyInterface != null) {
            double d = permissionGroup.getLeaseRenewCost();
            int n4 = (int)Math.ceil((double)claimedResidence.getTotalSize() * d);
            if (d != 0.0) {
                if (economyInterface.canAfford(player.getName(), n4)) {
                    economyInterface.subtract(player.getName(), n4);
                    economyInterface.add("Lease Money", n4);
                    if ((double)n4 != 0.0) {
                        this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(n4), economyInterface.getName());
                    }
                } else {
                    this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
                    return;
                }
            }
        }
        if (n3 + n2 > n) {
            this.setExpireTime(player, claimedResidence, n);
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenewMax, new Object[0]);
            return;
        }
        Long l = claimedResidence.getLeaseExpireTime();
        if (l != null) {
            l = l + LeaseManager.daysToMs(n2);
            claimedResidence.setLeaseExpireTime(l);
            this.leaseExpireTime.add(claimedResidence);
        } else {
            claimedResidence.setLeaseExpireTime(LeaseManager.daysToMs(n2));
            this.leaseExpireTime.add(claimedResidence);
        }
        this.plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, this.getExpireTime(claimedResidence));
    }

    public double getRenewCostD(ClaimedResidence claimedResidence) {
        double d = claimedResidence.getOwnerGroup().getLeaseRenewCost();
        double d2 = (double)claimedResidence.getTotalSize() * d;
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        return d2;
    }

    private static long daysToMs(int n) {
        return (long)n * 24L * 60L * 60L * 1000L;
    }

    private static int msToDays(long l) {
        return (int)Math.ceil((double)l / 1000.0 / 60.0 / 60.0 / 24.0);
    }

    private static int daysRemaining(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return 999;
        }
        Long l = claimedResidence.getLeaseExpireTime();
        if (l <= System.currentTimeMillis()) {
            return 0;
        }
        return LeaseManager.msToDays((int)(l - System.currentTimeMillis()));
    }

    public void doExpirations() {
        HashSet<ClaimedResidence> hashSet = new HashSet<ClaimedResidence>(this.leaseExpireTime);
        for (ClaimedResidence claimedResidence : hashSet) {
            if (claimedResidence == null) {
                this.leaseExpireTime.remove(claimedResidence);
                continue;
            }
            if (claimedResidence.getLeaseExpireTime() > System.currentTimeMillis()) continue;
            String string = claimedResidence.getName();
            boolean bl = false;
            String string2 = claimedResidence.getPermissions().getOwner();
            PermissionGroup permissionGroup = claimedResidence.getOwnerGroup();
            double d = this.getRenewCostD(claimedResidence);
            if (this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().autoRenewLeases()) {
                if (d == 0.0) {
                    bl = true;
                } else if (claimedResidence.getBank().hasEnough(d)) {
                    claimedResidence.getBank().subtract(d);
                    bl = true;
                    if (this.plugin.getConfigManager().debugEnabled()) {
                        System.out.println("Lease Renewed From Residence Bank: " + string);
                    }
                } else if (this.plugin.getEconomyManager().canAfford(string2, d) && this.plugin.getEconomyManager().subtract(string2, d)) {
                    bl = true;
                    if (this.plugin.getConfigManager().debugEnabled()) {
                        System.out.println("Lease Renewed From Economy: " + string);
                    }
                }
            }
            if (!bl) {
                if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(string)) continue;
                ResidenceDeleteEvent residenceDeleteEvent = new ResidenceDeleteEvent(null, claimedResidence, ResidenceDeleteEvent.DeleteCause.LEASE_EXPIRE);
                this.plugin.getServ().getPluginManager().callEvent((Event)residenceDeleteEvent);
                if (residenceDeleteEvent.isCancelled()) continue;
                this.manager.removeResidence(claimedResidence);
                this.leaseExpireTime.remove(claimedResidence);
                if (!this.plugin.getConfigManager().debugEnabled()) continue;
                System.out.println("Lease NOT removed, Removing: " + string);
                continue;
            }
            if (this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().enableLeaseMoneyAccount()) {
                this.plugin.getEconomyManager().add("Lease Money", d);
            }
            if (this.plugin.getConfigManager().debugEnabled()) {
                System.out.println("Lease Renew Old: " + claimedResidence.getName());
            }
            claimedResidence.setLeaseExpireTime(System.currentTimeMillis() + LeaseManager.daysToMs(permissionGroup.getLeaseGiveTime()));
            if (!this.plugin.getConfigManager().debugEnabled()) continue;
            System.out.println("Lease Renew New: " + claimedResidence.getName());
        }
    }

    public void resetLeases() {
        String[] stringArray;
        this.leaseExpireTime.clear();
        String[] stringArray2 = stringArray = this.manager.getResidenceList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClaimedResidence claimedResidence;
            String string = stringArray2[n2];
            if (string != null && (claimedResidence = this.plugin.getResidenceManager().getByName(string)) != null) {
                this.setExpireTime(null, claimedResidence, claimedResidence.getOwnerGroup().getLeaseGiveTime());
            }
            ++n2;
        }
        System.out.println("[Residence] - Set default leases.");
    }

    public Map<String, Long> save() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (ClaimedResidence claimedResidence : this.leaseExpireTime) {
            hashMap.put(claimedResidence.getName(), claimedResidence.getLeaseExpireTime());
        }
        return hashMap;
    }

    public LeaseManager load(Map map) {
        Map map22;
        LeaseManager leaseManager = new LeaseManager(this.plugin);
        if (map == null) {
            return leaseManager;
        }
        for (Map map22 : map.values()) {
            if (map22 instanceof Long) continue;
            map.remove(map22);
        }
        map22 = map;
        for (Map.Entry entry : map22.entrySet()) {
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName((String)entry.getKey());
            if (claimedResidence == null) continue;
            claimedResidence.setLeaseExpireTime((Long)entry.getValue());
            leaseManager.leaseExpireTime.add(claimedResidence);
        }
        return leaseManager;
    }
}

