/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeFlags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class FlagPermissions {
    protected static ArrayList<String> validFlags = new ArrayList();
    protected static ArrayList<String> validPlayerFlags = new ArrayList();
    protected static ArrayList<String> validAreaFlags = new ArrayList();
    protected static HashMap<String, ArrayList<String>> validFlagGroups = new HashMap();
    static final Map<Material, Flags> matUseFlagList = new EnumMap<Material, Flags>(Material.class);
    protected Map<UUID, String> cachedPlayerNameUUIDs = new ConcurrentHashMap<UUID, String>();
    protected Map<String, Map<String, Boolean>> playerFlags = new ConcurrentHashMap<String, Map<String, Boolean>>();
    protected Map<String, Map<String, Boolean>> groupFlags = new ConcurrentHashMap<String, Map<String, Boolean>>();
    protected Map<String, Boolean> cuboidFlags = new ConcurrentHashMap<String, Boolean>();
    protected FlagPermissions parent;

    public FlagPermissions() {
        this.playerFlags = new ConcurrentHashMap<String, Map<String, Boolean>>();
        this.groupFlags = new ConcurrentHashMap<String, Map<String, Boolean>>();
        this.cachedPlayerNameUUIDs = new ConcurrentHashMap<UUID, String>();
    }

    public static void addMaterialToUseFlag(Material material2, Flags flags2) {
        if (material2 == null) {
            return;
        }
        matUseFlagList.put(material2, flags2);
    }

    public static void removeMaterialFromUseFlag(Material material2) {
        if (material2 == null) {
            return;
        }
        matUseFlagList.remove(material2);
    }

    public static EnumMap<Material, Flags> getMaterialUseFlagList() {
        return (EnumMap)matUseFlagList;
    }

    public static void addFlag(Flags flags2) {
        FlagPermissions.addFlag(flags2.name());
    }

    public static void addFlag(String string) {
        Flags flags2;
        if (!validFlags.contains(string = string.toLowerCase())) {
            validFlags.add(string);
        }
        if (validFlagGroups.containsKey(string)) {
            validFlagGroups.remove(string);
        }
        if ((flags2 = Flags.getFlag(string)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(string, FlagState.TRUE);
        }
    }

    public static void addPlayerOrGroupOnlyFlag(Flags flags2) {
        FlagPermissions.addPlayerOrGroupOnlyFlag(flags2.name());
    }

    public static void addPlayerOrGroupOnlyFlag(String string) {
        Flags flags2;
        if (!validPlayerFlags.contains(string = string.toLowerCase())) {
            validPlayerFlags.add(string);
        }
        if (validFlagGroups.containsKey(string)) {
            validFlagGroups.remove(string);
        }
        if ((flags2 = Flags.getFlag(string)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(string, FlagState.TRUE);
        }
    }

    public static void addResidenceOnlyFlag(Flags flags2) {
        FlagPermissions.addResidenceOnlyFlag(flags2.name());
    }

    public static void addResidenceOnlyFlag(String string) {
        Flags flags2;
        if (!validAreaFlags.contains(string = string.toLowerCase())) {
            validAreaFlags.add(string);
        }
        if (validFlagGroups.containsKey(string)) {
            validFlagGroups.remove(string);
        }
        if ((flags2 = Flags.getFlag(string)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(string, FlagState.TRUE);
        }
    }

    public static void addFlagToFlagGroup(String string, String string2) {
        if (!(validFlags.contains(string) || validAreaFlags.contains(string) || validPlayerFlags.contains(string))) {
            if (!validFlagGroups.containsKey(string)) {
                validFlagGroups.put(string, new ArrayList());
            }
            ArrayList<String> arrayList = validFlagGroups.get(string);
            arrayList.add(string2);
        }
    }

    public static void removeFlagFromFlagGroup(String string, String string2) {
        if (validFlagGroups.containsKey(string)) {
            ArrayList<String> arrayList = validFlagGroups.get(string);
            arrayList.remove(string2);
            if (arrayList.isEmpty()) {
                validFlagGroups.remove(string);
            }
        }
    }

    public static boolean flagGroupExists(String string) {
        return validFlagGroups.containsKey(string);
    }

    public static void initValidFlags() {
        Enum enum_;
        validAreaFlags.clear();
        validPlayerFlags.clear();
        validFlags.clear();
        validFlagGroups.clear();
        Enum[] enumArray = Flags.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            switch (((Flags)enum_).getFlagMode()) {
                case Both: {
                    FlagPermissions.addFlag((Flags)enum_);
                    break;
                }
                case Player: {
                    FlagPermissions.addPlayerOrGroupOnlyFlag((Flags)enum_);
                    break;
                }
                case Residence: {
                    FlagPermissions.addResidenceOnlyFlag((Flags)enum_);
                    break;
                }
            }
            ++n2;
        }
        Residence.getInstance().getConfigManager().UpdateGroupedFlagsFile();
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.REPEATER.getMaterial(), Flags.diode);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMPARATOR.getMaterial(), Flags.diode);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CRAFTING_TABLE.getMaterial(), Flags.table);
        enumArray = CMIMaterial.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            if (((CMIMaterial)enum_).getMaterial() != null) {
                if (((CMIMaterial)enum_).isDoor()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)enum_).isGate()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)enum_).isTrapDoor()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)enum_).isShulkerBox()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.container);
                }
                if (((CMIMaterial)enum_).isButton()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.button);
                }
                if (((CMIMaterial)enum_).isBed()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.bed);
                }
                if (((CMIMaterial)enum_).isPotted()) {
                    matUseFlagList.put(((CMIMaterial)enum_).getMaterial(), Flags.flowerpot);
                }
            }
            ++n2;
        }
        if (CMIMaterial.DAYLIGHT_DETECTOR.getMaterial() != null) {
            matUseFlagList.put(CMIMaterial.DAYLIGHT_DETECTOR.getMaterial(), Flags.diode);
        }
        if (CMIMaterial.ENCHANTING_TABLE.getMaterial() != null) {
            FlagPermissions.addMaterialToUseFlag(CMIMaterial.ENCHANTING_TABLE.getMaterial(), Flags.enchant);
        }
        FlagPermissions.addMaterialToUseFlag(Material.LEVER, Flags.lever);
        FlagPermissions.addMaterialToUseFlag(Material.BREWING_STAND, Flags.brew);
        FlagPermissions.addMaterialToUseFlag(Material.CAKE, Flags.cake);
        FlagPermissions.addMaterialToUseFlag(Material.NOTE_BLOCK, Flags.note);
        FlagPermissions.addMaterialToUseFlag(Material.DRAGON_EGG, Flags.egg);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMMAND_BLOCK.getMaterial(), Flags.commandblock);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.ANVIL.getMaterial(), Flags.anvil);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CHIPPED_ANVIL.getMaterial(), Flags.anvil);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.DAMAGED_ANVIL.getMaterial(), Flags.anvil);
        FlagPermissions.addMaterialToUseFlag(Material.FLOWER_POT, Flags.flowerpot);
        FlagPermissions.addMaterialToUseFlag(Material.BEACON, Flags.beacon);
        FlagPermissions.addMaterialToUseFlag(Material.JUKEBOX, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.CHEST, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.TRAPPED_CHEST, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.HOPPER, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.DROPPER, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.FURNACE, Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LEGACY_BURNING_FURNACE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.BARREL.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.BLAST_FURNACE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CARTOGRAPHY_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.FLETCHING_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.GRINDSTONE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LECTERN.getMaterial(), Flags.use);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LOOM.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.SMITHING_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.SMOKER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMPOSTER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.STONECUTTER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.DISPENSER, Flags.container);
    }

    public static FlagPermissions parseFromConfigNode(String string, ConfigurationSection configurationSection) {
        FlagPermissions flagPermissions = new FlagPermissions();
        if (!configurationSection.isConfigurationSection(string)) {
            return flagPermissions;
        }
        Set set2 = configurationSection.getConfigurationSection(string).getKeys(false);
        if (set2 == null) {
            return flagPermissions;
        }
        for (String string2 : set2) {
            boolean bl = configurationSection.getBoolean(String.valueOf(string) + "." + string2, false);
            Flags flags2 = Flags.getFlag(string2 = string2.toLowerCase());
            if (flags2 != null) {
                flags2.setEnabled(bl);
            }
            if (bl) {
                flagPermissions.setFlag(string2, FlagState.TRUE);
                continue;
            }
            flagPermissions.setFlag(string2, FlagState.FALSE);
        }
        return flagPermissions;
    }

    public static FlagPermissions parseFromConfigNodeAsList(String string, String string2) {
        FlagPermissions flagPermissions = new FlagPermissions();
        if (string.equalsIgnoreCase("true")) {
            flagPermissions.setFlag(string, FlagState.valueOf(string2));
        } else {
            flagPermissions.setFlag(string, FlagState.FALSE);
        }
        return flagPermissions;
    }

    protected Map<String, Boolean> getPlayerFlags(Player player, boolean bl) {
        Map<String, Boolean> map = null;
        if (!Residence.getInstance().getConfigManager().isOfflineMode()) {
            UUID uUID = player.getUniqueId();
            map = this.playerFlags.get(uUID.toString());
            if (map == null && bl) {
                map = Collections.synchronizedMap(new HashMap());
                this.playerFlags.put(uUID.toString(), map);
                this.cachedPlayerNameUUIDs.put(uUID, player.getName());
            }
        } else {
            for (Map.Entry<String, Map<String, Boolean>> entry : this.playerFlags.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(player.getName())) continue;
                if (!entry.getKey().equals(player.getName())) {
                    Map<String, Boolean> map2 = this.playerFlags.remove(entry.getKey());
                    this.playerFlags.put(player.getName(), map2);
                }
                map = entry.getValue();
                break;
            }
            if (map == null && bl) {
                map = Collections.synchronizedMap(new HashMap());
                this.playerFlags.put(player.getName(), map);
            }
        }
        return map;
    }

    protected Map<String, Boolean> getPlayerFlags(String string, boolean bl) {
        Map<Object, Object> map = null;
        if (!Residence.getInstance().getConfigManager().isOfflineMode()) {
            Object object;
            UUID uUID = null;
            if (string.length() == 36) {
                try {
                    uUID = UUID.fromString(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = Residence.getInstance().getPlayerName(uUID);
                if (object != null) {
                    string = object;
                } else if (this.cachedPlayerNameUUIDs.containsKey(uUID)) {
                    string = this.cachedPlayerNameUUIDs.get(uUID);
                }
            } else {
                uUID = Residence.getInstance().getPlayerUUID(string);
            }
            if (uUID == null) {
                object = this.cachedPlayerNameUUIDs.entrySet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!((String)entry.getValue()).equals(string)) continue;
                    uUID = (UUID)entry.getKey();
                    break;
                }
            }
            if (uUID != null) {
                map = this.playerFlags.get(uUID.toString());
            }
            if (map == null) {
                map = this.playerFlags.get(string);
                if (uUID != null && map != null) {
                    map = this.playerFlags.remove(string);
                    this.playerFlags.put(uUID.toString(), map);
                    this.cachedPlayerNameUUIDs.put(uUID, string);
                }
            } else {
                this.cachedPlayerNameUUIDs.put(uUID, string);
            }
            if (map == null && bl) {
                if (uUID != null) {
                    map = Collections.synchronizedMap(new HashMap());
                    this.playerFlags.put(uUID.toString(), map);
                    this.cachedPlayerNameUUIDs.put(uUID, string);
                } else {
                    map = Collections.synchronizedMap(new HashMap());
                    this.playerFlags.put(string, map);
                }
            }
        } else {
            for (Map.Entry<String, Map<String, Boolean>> entry : this.playerFlags.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(string)) continue;
                if (!entry.getKey().equals(string)) {
                    Map<String, Boolean> map2 = this.playerFlags.remove(entry.getKey());
                    this.playerFlags.put(string, map2);
                }
                map = entry.getValue();
                break;
            }
            if (map == null && bl) {
                map = Collections.synchronizedMap(new HashMap());
                this.playerFlags.put(string, map);
            }
        }
        return map;
    }

    public boolean setPlayerFlag(String string, String string2, FlagState flagState) {
        Map<String, Boolean> map = this.getPlayerFlags(string, flagState != FlagState.NEITHER);
        if (map == null) {
            return true;
        }
        if (flagState == FlagState.FALSE) {
            map.put(string2, false);
        } else if (flagState == FlagState.TRUE) {
            map.put(string2, true);
        } else if (flagState == FlagState.NEITHER) {
            map.remove(string2);
        }
        if (map.isEmpty()) {
            this.removeAllPlayerFlags(string);
        }
        return true;
    }

    public void removeAllPlayerFlags(String string) {
        if (!Residence.getInstance().getConfigManager().isOfflineMode()) {
            UUID uUID = Residence.getInstance().getPlayerUUID(string);
            if (uUID == null) {
                for (Map.Entry<UUID, String> entry : this.cachedPlayerNameUUIDs.entrySet()) {
                    if (!entry.getValue().equals(string)) continue;
                    uUID = entry.getKey();
                    break;
                }
            }
            if (uUID != null) {
                this.playerFlags.remove(uUID.toString());
                this.cachedPlayerNameUUIDs.remove(uUID);
            }
            return;
        }
        this.playerFlags.remove(string);
    }

    public void removeAllGroupFlags(String string) {
        this.groupFlags.remove(string);
    }

    public boolean setGroupFlag(String string, String string2, FlagState flagState) {
        if (!this.groupFlags.containsKey(string = string.toLowerCase())) {
            this.groupFlags.put(string, Collections.synchronizedMap(new HashMap()));
        }
        Map<String, Boolean> map = this.groupFlags.get(string);
        if (flagState == FlagState.FALSE) {
            map.put(string2, false);
        } else if (flagState == FlagState.TRUE) {
            map.put(string2, true);
        } else if (flagState == FlagState.NEITHER) {
            map.remove(string2);
        }
        if (map.isEmpty()) {
            this.groupFlags.remove(string);
        }
        return true;
    }

    public boolean setFlag(String string, FlagState flagState) {
        if (flagState == FlagState.FALSE) {
            this.cuboidFlags.put(string, false);
        } else if (flagState == FlagState.TRUE) {
            this.cuboidFlags.put(string, true);
        } else if (flagState == FlagState.NEITHER) {
            this.cuboidFlags.remove(string);
        }
        return true;
    }

    public static FlagState stringToFlagState(String string) {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
            return FlagState.TRUE;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f")) {
            return FlagState.FALSE;
        }
        if (string.equalsIgnoreCase("remove") || string.equalsIgnoreCase("r")) {
            return FlagState.NEITHER;
        }
        return FlagState.INVALID;
    }

    public boolean playerHas(ResidencePlayer residencePlayer, Flags flags2, boolean bl) {
        if (residencePlayer == null) {
            return false;
        }
        return this.playerCheck(residencePlayer.getPlayer(), flags2.toString(), this.groupCheck(residencePlayer.getGroup(), flags2.toString(), this.has(flags2, bl)));
    }

    public boolean playerHas(Player player, Flags flags2, boolean bl) {
        if (player == null) {
            return false;
        }
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        return this.playerCheck(player, flags2.toString(), this.groupCheck(permissionGroup, flags2.toString(), this.has(flags2, bl)));
    }

    public boolean playerHas(Player player, String string, Flags flags2, boolean bl) {
        if (player == null) {
            return false;
        }
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup(string);
        return this.playerCheck(player, flags2.toString(), this.groupCheck(permissionGroup, flags2.toString(), this.has(flags2, bl)));
    }

    @Deprecated
    public boolean playerHas(String string, String string2, String string3, boolean bl) {
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(string);
        PermissionGroup permissionGroup = residencePlayer.getGroup(string2);
        return this.playerCheck(string, string3, this.groupCheck(permissionGroup, string3, this.has(string3, bl)));
    }

    public boolean groupHas(String string, String string2, boolean bl) {
        return this.groupCheck(string, string2, this.has(string2, bl));
    }

    private boolean playerCheck(Player player, String string, boolean bl) {
        Map<String, Boolean> map = this.getPlayerFlags(player, false);
        if (map != null && map.containsKey(string)) {
            return map.get(string);
        }
        if (this.parent != null) {
            return this.parent.playerCheck(player, string, bl);
        }
        return bl;
    }

    @Deprecated
    private boolean playerCheck(String string, String string2, boolean bl) {
        Map<String, Boolean> map = this.getPlayerFlags(string, false);
        if (map != null && map.containsKey(string2)) {
            return map.get(string2);
        }
        if (this.parent != null) {
            return this.parent.playerCheck(string, string2, bl);
        }
        return bl;
    }

    private boolean groupCheck(PermissionGroup permissionGroup, String string, boolean bl) {
        if (permissionGroup == null) {
            return bl;
        }
        return this.groupCheck(permissionGroup.getGroupName(), string, bl);
    }

    private boolean groupCheck(String string, String string2, boolean bl) {
        Map<String, Boolean> map;
        if (this.groupFlags.containsKey(string) && (map = this.groupFlags.get(string)).containsKey(string2)) {
            return map.get(string2);
        }
        if (this.parent != null) {
            return this.parent.groupCheck(string, string2, bl);
        }
        return bl;
    }

    public boolean has(Flags flags2, FlagCombo flagCombo) {
        switch (flagCombo) {
            case FalseOrNone: {
                return !this.has(flags2, false);
            }
            case OnlyFalse: {
                return !this.has(flags2, true);
            }
            case OnlyTrue: {
                return this.has(flags2, false);
            }
            case TrueOrNone: {
                return this.has(flags2, true);
            }
        }
        return false;
    }

    public boolean has(Flags flags2, boolean bl) {
        return this.has(flags2, bl, true);
    }

    public boolean has(Flags flags2, boolean bl, boolean bl2) {
        if (this.cuboidFlags.containsKey(flags2.toString())) {
            return this.cuboidFlags.get(flags2.toString());
        }
        if (bl2 && this.parent != null) {
            return this.parent.has(flags2, bl);
        }
        return bl;
    }

    @Deprecated
    public boolean has(String string, boolean bl) {
        return this.has(string, bl, true);
    }

    @Deprecated
    public boolean has(String string, boolean bl, boolean bl2) {
        if (this.cuboidFlags.containsKey(string)) {
            return this.cuboidFlags.get(string);
        }
        if (bl2 && this.parent != null) {
            return this.parent.has(string, bl);
        }
        return bl;
    }

    public boolean isPlayerSet(String string, String string2) {
        Map<String, Boolean> map = this.getPlayerFlags(string, false);
        if (map == null) {
            return false;
        }
        return map.containsKey(string2);
    }

    public boolean inheritanceIsPlayerSet(String string, String string2) {
        Map<String, Boolean> map = this.getPlayerFlags(string, false);
        if (map == null) {
            return this.parent == null ? false : this.parent.inheritanceIsPlayerSet(string, string2);
        }
        return map.containsKey(string2) ? true : (this.parent == null ? false : this.parent.inheritanceIsPlayerSet(string, string2));
    }

    public boolean isGroupSet(String string, String string2) {
        Map<String, Boolean> map = this.groupFlags.get(string = string.toLowerCase());
        if (map == null) {
            return false;
        }
        return map.containsKey(string2);
    }

    public boolean inheritanceIsGroupSet(String string, String string2) {
        Map<String, Boolean> map = this.groupFlags.get(string = string.toLowerCase());
        if (map == null) {
            return this.parent == null ? false : this.parent.inheritanceIsGroupSet(string, string2);
        }
        return map.containsKey(string2) ? true : (this.parent == null ? false : this.parent.inheritanceIsGroupSet(string, string2));
    }

    public boolean isSet(String string) {
        return this.cuboidFlags.containsKey(string);
    }

    public boolean inheritanceIsSet(String string) {
        return this.cuboidFlags.containsKey(string) ? true : (this.parent == null ? false : this.parent.inheritanceIsSet(string));
    }

    public boolean checkValidFlag(String string, boolean bl) {
        if (validFlags.contains(string)) {
            return true;
        }
        return bl ? validAreaFlags.contains(string) : validPlayerFlags.contains(string);
    }

    public Map<String, Object> save(String string) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (Residence.getInstance().getConfigManager().isNewSaveMechanic()) {
            MinimizeFlags minimizeFlags;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (Map.Entry<String, Map<String, Boolean>> entry : this.playerFlags.entrySet()) {
                MinimizeFlags minimizeFlags2 = Residence.getInstance().getResidenceManager().addFlagsTempCache(string, entry.getValue());
                hashMap.put(entry.getKey(), minimizeFlags2.getId());
            }
            linkedHashMap.put("PlayerFlags", hashMap);
            if (!this.groupFlags.isEmpty()) {
                HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                for (Map.Entry entry : this.groupFlags.entrySet()) {
                    MinimizeFlags minimizeFlags3 = Residence.getInstance().getResidenceManager().addFlagsTempCache(string, (Map)entry.getValue());
                    hashMap2.put((String)entry.getKey(), minimizeFlags3.getId());
                }
                linkedHashMap.put("GroupFlags", hashMap2);
            }
            if ((minimizeFlags = Residence.getInstance().getResidenceManager().addFlagsTempCache(string, this.cuboidFlags)) == null) {
                linkedHashMap.put("AreaFlags", new HashMap<String, Boolean>(this.cuboidFlags));
            } else {
                linkedHashMap.put("AreaFlags", minimizeFlags.getId());
            }
        } else {
            linkedHashMap.put("PlayerFlags", FlagPermissions.clone(this.playerFlags));
            if (!this.groupFlags.isEmpty()) {
                linkedHashMap.put("GroupFlags", FlagPermissions.clone(this.groupFlags));
            }
            linkedHashMap.put("AreaFlags", new HashMap<String, Boolean>(this.cuboidFlags));
        }
        return linkedHashMap;
    }

    private static HashMap<String, Map<String, Boolean>> clone(Map<String, Map<String, Boolean>> map) {
        HashMap<String, Map<String, Boolean>> hashMap = new HashMap<String, Map<String, Boolean>>();
        for (Map.Entry<String, Map<String, Boolean>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashMap<String, Boolean>(entry.getValue()));
        }
        return hashMap;
    }

    public static FlagPermissions load(Map<String, Object> map) {
        FlagPermissions flagPermissions = new FlagPermissions();
        return FlagPermissions.load(map, flagPermissions);
    }

    protected static FlagPermissions load(Map<String, Object> map, FlagPermissions flagPermissions) {
        Map<String, Boolean> map2;
        Map<String, Boolean> map3;
        if (map.containsKey("LastKnownPlayerNames")) {
            flagPermissions.cachedPlayerNameUUIDs = (Map)map.get("LastKnownPlayerNames");
        }
        if (map.containsKey("PlayerFlags")) {
            boolean bl = true;
            map3 = ((HashMap)map.get("PlayerFlags")).entrySet().iterator();
            if (map3.hasNext() && (map2 = map3.next()).getValue() instanceof Integer) {
                bl = false;
            }
            if (bl) {
                flagPermissions.playerFlags = (Map)map.get("PlayerFlags");
            } else if (flagPermissions instanceof ResidencePermissions) {
                map2 = new HashMap();
                map3 = new HashMap();
                for (Map.Entry object : ((HashMap)map.get("PlayerFlags")).entrySet()) {
                    map3 = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)flagPermissions).getWorld(), (Integer)object.getValue());
                    if (map3 == null || map3.isEmpty()) continue;
                    if (Residence.getInstance().getConfigManager().isOfflineMode() && ((String)object.getKey()).length() == 36) {
                        String string = Residence.getInstance().getPlayerName(UUID.fromString((String)object.getKey()));
                        if (string != null) {
                            map2.put(string, (Boolean)((Object)new HashMap<Object, Object>(map3)));
                            continue;
                        }
                        map2.put((String)object.getKey(), (Boolean)((Object)new HashMap<Object, Object>(map3)));
                        continue;
                    }
                    map2.put((String)object.getKey(), (Boolean)((Object)new HashMap<Object, Object>(map3)));
                }
                if (!map2.isEmpty()) {
                    flagPermissions.playerFlags = map2;
                }
            }
        }
        map2 = flagPermissions.playerFlags.entrySet().iterator();
        while (map2.hasNext()) {
            Map.Entry<String, Map<String, Boolean>> entry = map2.next();
            if (entry.getKey().length() != 32) continue;
            try {
                map3 = UUID.fromString(entry.getKey());
                OfflinePlayer offlinePlayer = Residence.getInstance().getOfflinePlayer((UUID)((Object)map3));
                flagPermissions.cachedPlayerNameUUIDs.put((UUID)((Object)map3), offlinePlayer.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (map.containsKey("GroupFlags")) {
            boolean bl = true;
            map3 = ((HashMap)map.get("GroupFlags")).entrySet().iterator();
            if (map3.hasNext() && (map2 = (Map.Entry)map3.next()).getValue() instanceof Integer) {
                bl = false;
            }
            if (bl) {
                flagPermissions.groupFlags = (Map)map.get("GroupFlags");
            } else if (flagPermissions instanceof ResidencePermissions) {
                map2 = new HashMap();
                map3 = new HashMap();
                for (Map.Entry entry : ((HashMap)map.get("GroupFlags")).entrySet()) {
                    map3 = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)flagPermissions).getWorld(), (Integer)entry.getValue());
                    if (map3 == null || map3.isEmpty()) continue;
                    map2.put((String)entry.getKey(), (Boolean)((Object)new HashMap<Object, Object>(map3)));
                }
                if (!map2.isEmpty()) {
                    flagPermissions.groupFlags = map2;
                }
            }
        }
        if (map.containsKey("AreaFlags")) {
            boolean bl = true;
            if (map.get("AreaFlags") instanceof Integer) {
                bl = false;
            }
            if (bl) {
                flagPermissions.cuboidFlags = (Map)map.get("AreaFlags");
            } else if (flagPermissions instanceof ResidencePermissions) {
                map2 = new HashMap<String, Map<String, Boolean>>();
                map2 = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)flagPermissions).getWorld(), (Integer)map.get("AreaFlags"));
                if (map2 != null && !map2.isEmpty()) {
                    flagPermissions.cuboidFlags = new HashMap<String, Boolean>(map2);
                }
            }
        } else {
            flagPermissions.cuboidFlags = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags().getFlags();
        }
        String string = null;
        map2 = null;
        if (map.containsKey("OwnerLastKnownName")) {
            string = (String)map.get("OwnerLastKnownName");
            map2 = map.containsKey("OwnerUUID") ? (String)map.get("OwnerUUID") : Residence.getInstance().getTempUserUUID();
        }
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            flagPermissions.convertFlagsUUIDsToPlayerNames();
        } else {
            flagPermissions.convertPlayerNamesToUUIDs(string, (String)((Object)map2));
        }
        return flagPermissions;
    }

    private void convertFlagsUUIDsToPlayerNames() {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : this.playerFlags.keySet()) {
            if (object2.length() != 36) continue;
            object = object2;
            if (((String)object).equalsIgnoreCase(Residence.getInstance().getServerLandUUID())) {
                hashMap.put((String)object, Residence.getInstance().getServerLandName());
                continue;
            }
            String string = Residence.getInstance().getPlayerName((String)object);
            if (string == null) continue;
            hashMap.put((String)object, string);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!this.playerFlags.containsKey(entry.getKey())) continue;
            object = this.playerFlags.get(entry.getKey());
            this.playerFlags.remove(entry.getKey());
            this.playerFlags.put((String)entry.getValue(), (Map<String, Boolean>)object);
        }
    }

    private void convertPlayerNamesToUUIDs(String string, String string2) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : this.playerFlags.keySet()) {
            if (object2.length() != 36) {
                object = null;
                object = string != null && string.equals(object2) && !string2.equals(Residence.getInstance().getTempUserUUID()) ? string2 : Residence.getInstance().getPlayerUUIDString(object2);
                if (object != null) {
                    hashMap.put(object2, (String)object);
                    continue;
                }
                if (string == null || string.equals(object2)) continue;
                arrayList.add(object2);
                continue;
            }
            object = Residence.getInstance().getPlayerName(object2);
            if (object == null) continue;
            try {
                UUID uUID = UUID.fromString(object2);
                this.cachedPlayerNameUUIDs.put(uUID, (String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String string3 : arrayList) {
            this.playerFlags.remove(string3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.playerFlags.put((String)entry.getValue(), this.playerFlags.remove(entry.getKey()));
            try {
                object = UUID.fromString((String)entry.getValue());
                this.cachedPlayerNameUUIDs.put((UUID)object, (String)entry.getKey());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String listFlags() {
        return this.listFlags(0, 0);
    }

    public String listFlags(Integer n) {
        return this.listFlags(n, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listFlags(Integer n, Integer n2) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, Boolean>> set2 = this.cuboidFlags.entrySet();
        FlagPermissions flagPermissions = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags();
        Set<Map.Entry<String, Boolean>> set3 = set2;
        synchronized (set3) {
            Iterator<Map.Entry<String, Boolean>> iterator = set2.iterator();
            int n3 = -1;
            int n4 = 0;
            String string = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
            String string2 = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
            String string3 = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
            String string4 = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
            while (iterator.hasNext()) {
                String string5;
                Flags flags2;
                Map.Entry<String, Boolean> entry = iterator.next();
                if (Residence.getInstance().getConfigManager().isInfoExcludeDFlags() && flagPermissions.cuboidFlags.get(entry.getKey()) != null && flagPermissions.cuboidFlags.get(entry.getKey()) == entry.getValue() || (flags2 = Flags.getFlag(string5 = entry.getKey())) != null && !flags2.isGlobalyEnabled()) continue;
                if (flags2 != null) {
                    string5 = flags2.getName();
                }
                ++n3;
                if (n2 > 0 && ++n4 > n2) break;
                if (n > 0 && n3 >= n) {
                    n3 = 0;
                    stringBuilder.append("\n");
                }
                if (entry.getValue().booleanValue()) {
                    stringBuilder.append(string).append(string3).append(string5);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(" ");
                    continue;
                }
                stringBuilder.append(string2).append(string4).append(string5);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("none");
        }
        return CMIChatColor.translate(stringBuilder.toString());
    }

    public Map<String, Boolean> getFlags() {
        return this.cuboidFlags;
    }

    public Map<String, Boolean> getPlayerFlags(String string) {
        return this.getPlayerFlags(string, false);
    }

    @Deprecated
    public Set<String> getposibleFlags() {
        return FlagPermissions.getAllPosibleFlags();
    }

    public static Set<String> getAllPosibleFlags() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(validFlags);
        hashSet.addAll(validPlayerFlags);
        return hashSet;
    }

    public static ArrayList<String> getPosibleAreaFlags() {
        return validAreaFlags;
    }

    public List<String> getPosibleFlags(Player player, boolean bl, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : Residence.getInstance().getPermissionManager().getAllFlags().getFlags().entrySet()) {
            String string;
            Flags flags2;
            if (!entry.getValue().booleanValue() && !bl2 && !PermissionManager.ResPerm.flag_$1.hasSetPermission((CommandSender)player, entry.getKey().toLowerCase()) || !bl && !FlagPermissions.getAllPosibleFlags().contains(entry.getKey()) || (flags2 = Flags.getFlag(string = entry.getKey())) != null && !flags2.isGlobalyEnabled()) continue;
            hashSet.add(entry.getKey());
        }
        return new ArrayList<String>(hashSet);
    }

    public String listPlayerFlags(String string) {
        Map<String, Boolean> map = this.getPlayerFlags(string, false);
        if (map != null) {
            return this.printPlayerFlags(map);
        }
        return "none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printPlayerFlags(Map<String, Boolean> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map == null) {
            return "none";
        }
        Set<Map.Entry<String, Boolean>> set2 = map.entrySet();
        String string = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
        String string2 = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
        String string3 = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
        String string4 = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
        Map<String, Boolean> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<String, Boolean>> iterator = set2.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Boolean> entry = iterator.next();
                String string5 = entry.getKey();
                Flags flags2 = Flags.getFlag(entry.getKey());
                if (flags2 != null && !flags2.isGlobalyEnabled()) continue;
                if (flags2 != null) {
                    string5 = flags2.getName();
                }
                if (entry.getValue().booleanValue()) {
                    stringBuilder.append(string).append(string3).append(string5);
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(" ");
                    continue;
                }
                stringBuilder.append(string2).append(string4).append(string5);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("none");
        }
        return CMIChatColor.translate(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listOtherPlayersFlags(String string) {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        String string2 = Residence.getInstance().getPlayerUUIDString(string);
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            for (Map.Entry<String, Map<String, Boolean>> entry : set2) {
                String string3;
                String string4 = entry.getKey();
                if ((Residence.getInstance().getConfigManager().isOfflineMode() || string4.equals(string) || string4.equals(string2)) && (!Residence.getInstance().getConfigManager().isOfflineMode() || string4.equals(string))) continue;
                String string5 = this.printPlayerFlags(entry.getValue());
                if (string4.length() == 36 && (string3 = Residence.getInstance().getPlayerName(string4)) != null) {
                    try {
                        UUID uUID = UUID.fromString(string4);
                        this.cachedPlayerNameUUIDs.put(uUID, string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string4 = string3;
                }
                if (string5.equals("none")) continue;
                stringBuilder.append(string4).append(ChatColor.WHITE).append("[").append(string5).append(ChatColor.WHITE).append("] ");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPlayersFlags() {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            for (Map.Entry<String, Map<String, Boolean>> entry : set2) {
                String string;
                String string2 = entry.getKey();
                String string3 = this.printPlayerFlags(entry.getValue());
                if (string2.length() == 36 && (string = Residence.getInstance().getPlayerName(string2)) != null) {
                    try {
                        UUID uUID = UUID.fromString(string2);
                        this.cachedPlayerNameUUIDs.put(uUID, string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = string;
                }
                if (string2.equalsIgnoreCase(Residence.getInstance().getServerLandName()) || string3.equals("none")) continue;
                stringBuilder.append(string2).append(ChatColor.WHITE).append("[").append(string3).append(ChatColor.WHITE).append("] ");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawMessage listPlayersFlagsRaw(String string, String string2) {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        RawMessage rawMessage = new RawMessage();
        rawMessage.add(string2);
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            Iterator<Map.Entry<String, Map<String, Boolean>>> iterator = set2.iterator();
            boolean bl = true;
            String string3 = Residence.getInstance().getLM().getMessage(lm.Flag_ownColor, new Object[0]);
            String string4 = Residence.getInstance().getLM().getMessage(lm.Flag_p1Color, new Object[0]);
            String string5 = Residence.getInstance().getLM().getMessage(lm.Flag_p2Color, new Object[0]);
            while (iterator.hasNext()) {
                String string6;
                Map.Entry<String, Map<String, Boolean>> entry = iterator.next();
                String string7 = entry.getKey();
                String string8 = this.printPlayerFlags(entry.getValue());
                if (string7.length() == 36 && (string6 = Residence.getInstance().getPlayerName(string7)) != null) {
                    try {
                        UUID uUID = UUID.fromString(string7);
                        this.cachedPlayerNameUUIDs.put(uUID, string6);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string7 = string6;
                }
                if (string7.equalsIgnoreCase(Residence.getInstance().getServerLandName()) || string8.equals("none")) continue;
                if (bl) {
                    bl = false;
                    string7 = string.equals(string7) ? String.valueOf(string3) + string7 + "&r" : String.valueOf(string5) + string7 + "&r";
                } else {
                    bl = true;
                    string7 = string.equals(string7) ? String.valueOf(string3) + string7 + "&r" : String.valueOf(string4) + string7 + "&r";
                }
                rawMessage.add(string7, this.splitBy(5, string8));
                rawMessage.add(" ");
            }
        }
        return rawMessage;
    }

    protected String splitBy(int n, String string) {
        if (string.contains(" ")) {
            String[] stringArray = string.split(" ");
            int n2 = 0;
            string = "";
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray2[n4];
                string = String.valueOf(string) + string2 + " ";
                if (++n2 >= n) {
                    n2 = 0;
                    string = String.valueOf(string) + "\n";
                }
                ++n4;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listGroupFlags() {
        Set<String> set2;
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set3 = set2 = this.groupFlags.keySet();
        synchronized (set3) {
            for (String string : set2) {
                String string2 = this.listGroupFlags(string);
                if (string2.equals("none")) continue;
                stringBuilder.append(string).append("[").append(ChatColor.DARK_AQUA).append(string2).append(ChatColor.RED).append("] ");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listGroupFlags(String string) {
        if (this.groupFlags.containsKey(string = string.toLowerCase())) {
            StringBuilder stringBuilder = new StringBuilder();
            Map<String, Boolean> map = this.groupFlags.get(string);
            Set<Map.Entry<String, Boolean>> set2 = map.entrySet();
            String string2 = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
            String string3 = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
            String string4 = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
            String string5 = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
            Map<String, Boolean> map2 = map;
            synchronized (map2) {
                Iterator<Map.Entry<String, Boolean>> iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Boolean> entry = iterator.next();
                    if (entry.getValue().booleanValue()) {
                        stringBuilder.append(string2).append(string4).append(entry.getKey());
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(" ");
                        continue;
                    }
                    stringBuilder.append(string3).append(string5).append(entry.getKey());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(" ");
                }
            }
            if (stringBuilder.length() == 0) {
                this.groupFlags.remove(string);
                stringBuilder.append("none");
            }
            return CMIChatColor.translate(stringBuilder.toString());
        }
        return "none";
    }

    public void clearFlags() {
        this.groupFlags.clear();
        this.playerFlags.clear();
        this.cuboidFlags.clear();
    }

    public void printFlags(Player player) {
        Residence.getInstance().msg((CommandSender)player, lm.General_ResidenceFlags, this.listFlags());
        Residence.getInstance().msg((CommandSender)player, lm.General_PlayersFlags, this.listPlayerFlags(player.getName()));
        Residence.getInstance().msg((CommandSender)player, lm.General_GroupFlags, this.listGroupFlags());
        Residence.getInstance().msg((CommandSender)player, lm.General_OthersFlags, this.listOtherPlayersFlags(player.getName()));
    }

    public void copyUserPermissions(String string, String string2) {
        Map<String, Boolean> map = this.getPlayerFlags(string, false);
        if (map != null) {
            Map<String, Boolean> map2 = this.getPlayerFlags(string2, true);
            for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                map2.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Deprecated
    public void clearPlayersFlags(String string) {
        this.removeAllPlayerFlags(string);
    }

    public void setParent(FlagPermissions flagPermissions) {
        this.parent = flagPermissions;
    }

    public FlagPermissions getParent() {
        return this.parent;
    }

    public static enum FlagCombo {
        OnlyTrue,
        OnlyFalse,
        TrueOrNone,
        FalseOrNone;

    }

    public static enum FlagState {
        TRUE,
        FALSE,
        NEITHER,
        INVALID;


        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

