/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ResidenceManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;

public class CuboidArea {
    private Location highPoints;
    private Location lowPoints;
    protected String worldName;

    public CuboidArea(Location location, Location location2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (location.getBlockX() > location2.getBlockX()) {
            n6 = location.getBlockX();
            n5 = location2.getBlockX();
        } else {
            n6 = location2.getBlockX();
            n5 = location.getBlockX();
        }
        if (location.getBlockY() > location2.getBlockY()) {
            n4 = location.getBlockY();
            n3 = location2.getBlockY();
        } else {
            n4 = location2.getBlockY();
            n3 = location.getBlockY();
        }
        if (location.getBlockZ() > location2.getBlockZ()) {
            n2 = location.getBlockZ();
            n = location2.getBlockZ();
        } else {
            n2 = location2.getBlockZ();
            n = location.getBlockZ();
        }
        this.highPoints = new Location(location.getWorld(), (double)n6, (double)n4, (double)n2);
        this.lowPoints = new Location(location.getWorld(), (double)n5, (double)n3, (double)n);
        this.worldName = location.getWorld().getName();
    }

    public CuboidArea() {
    }

    public boolean isAreaWithinArea(CuboidArea cuboidArea) {
        return this.containsLoc(cuboidArea.highPoints) && this.containsLoc(cuboidArea.lowPoints);
    }

    public boolean containsLoc(Location location) {
        if (location == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        if (this.lowPoints.getBlockX() > location.getBlockX()) {
            return false;
        }
        if (this.highPoints.getBlockX() < location.getBlockX()) {
            return false;
        }
        if (this.lowPoints.getBlockZ() > location.getBlockZ()) {
            return false;
        }
        if (this.highPoints.getBlockZ() < location.getBlockZ()) {
            return false;
        }
        if (this.lowPoints.getBlockY() > location.getBlockY()) {
            return false;
        }
        return this.highPoints.getBlockY() >= location.getBlockY();
    }

    public boolean checkCollision(CuboidArea cuboidArea) {
        if (!cuboidArea.getWorld().equals(this.getWorld())) {
            return false;
        }
        if (cuboidArea.containsLoc(this.lowPoints) || cuboidArea.containsLoc(this.highPoints) || this.containsLoc(cuboidArea.highPoints) || this.containsLoc(cuboidArea.lowPoints)) {
            return true;
        }
        return CuboidArea.advCuboidCheckCollision(this.highPoints, this.lowPoints, cuboidArea.highPoints, cuboidArea.lowPoints);
    }

    private static boolean advCuboidCheckCollision(Location location, Location location2, Location location3, Location location4) {
        int n = location.getBlockX();
        int n2 = location2.getBlockX();
        int n3 = location.getBlockY();
        int n4 = location2.getBlockY();
        int n5 = location.getBlockZ();
        int n6 = location2.getBlockZ();
        int n7 = location3.getBlockX();
        int n8 = location4.getBlockX();
        int n9 = location3.getBlockY();
        int n10 = location4.getBlockY();
        int n11 = location3.getBlockZ();
        int n12 = location4.getBlockZ();
        return (n >= n8 && n <= n7 || n2 >= n8 && n2 <= n7 || n7 >= n2 && n7 <= n || n8 >= n2 && n8 <= n) && (n3 >= n10 && n3 <= n9 || n4 >= n10 && n4 <= n9 || n9 >= n4 && n9 <= n3 || n10 >= n4 && n10 <= n3) && (n5 >= n12 && n5 <= n11 || n6 >= n12 && n6 <= n11 || n11 >= n6 && n11 <= n5 || n12 >= n6 && n12 <= n5);
    }

    public long getSize() {
        int n = this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
        int n2 = this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
        if (!Residence.getInstance().getConfigManager().isNoCostForYBlocks()) {
            int n3 = this.highPoints.getBlockY() - this.lowPoints.getBlockY();
            return n * n3 * n2;
        }
        return n * n2;
    }

    public int getXSize() {
        return this.highPoints.getBlockX() - this.lowPoints.getBlockX() + 1;
    }

    public int getYSize() {
        return this.highPoints.getBlockY() - this.lowPoints.getBlockY() + 1;
    }

    public int getZSize() {
        return this.highPoints.getBlockZ() - this.lowPoints.getBlockZ() + 1;
    }

    public Location getHighLoc() {
        return this.highPoints;
    }

    public Location getLowLoc() {
        return this.lowPoints;
    }

    public World getWorld() {
        return this.highPoints.getWorld();
    }

    public void save(DataOutputStream dataOutputStream) {
        dataOutputStream.writeUTF(this.highPoints.getWorld().getName());
        dataOutputStream.writeInt(this.highPoints.getBlockX());
        dataOutputStream.writeInt(this.highPoints.getBlockY());
        dataOutputStream.writeInt(this.highPoints.getBlockZ());
        dataOutputStream.writeInt(this.lowPoints.getBlockX());
        dataOutputStream.writeInt(this.lowPoints.getBlockY());
        dataOutputStream.writeInt(this.lowPoints.getBlockZ());
    }

    public CuboidArea load(DataInputStream dataInputStream) {
        CuboidArea cuboidArea = new CuboidArea();
        Server server2 = Residence.getInstance().getServ();
        World world = server2.getWorld(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        cuboidArea.highPoints = new Location(world, (double)n, (double)n2, (double)n3);
        cuboidArea.lowPoints = new Location(world, (double)n4, (double)n5, (double)n6);
        cuboidArea.worldName = world.getName();
        return cuboidArea;
    }

    public Map<String, Object> save() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("X1", this.highPoints.getBlockX());
        linkedHashMap.put("Y1", this.highPoints.getBlockY());
        linkedHashMap.put("Z1", this.highPoints.getBlockZ());
        linkedHashMap.put("X2", this.lowPoints.getBlockX());
        linkedHashMap.put("Y2", this.lowPoints.getBlockY());
        linkedHashMap.put("Z2", this.lowPoints.getBlockZ());
        return linkedHashMap;
    }

    public String newSave() {
        return String.valueOf(this.lowPoints.getBlockX()) + ":" + this.lowPoints.getBlockY() + ":" + this.lowPoints.getBlockZ() + ":" + this.highPoints.getBlockX() + ":" + this.highPoints.getBlockY() + ":" + this.highPoints.getBlockZ();
    }

    public static CuboidArea newLoad(String string, World world) {
        if (string == null || !string.contains(":")) {
            throw new Exception("Invalid residence physical location...");
        }
        CuboidArea cuboidArea = new CuboidArea();
        String[] stringArray = string.split(":");
        try {
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            int n4 = Integer.parseInt(stringArray[3]);
            int n5 = Integer.parseInt(stringArray[4]);
            int n6 = Integer.parseInt(stringArray[5]);
            cuboidArea.lowPoints = new Location(world, (double)n, (double)n2, (double)n3);
            cuboidArea.highPoints = new Location(world, (double)n4, (double)n5, (double)n6);
            cuboidArea.worldName = world.getName();
        }
        catch (Exception exception) {
            throw new Exception("Invalid residence physical location...");
        }
        return cuboidArea;
    }

    public static CuboidArea load(Map<String, Object> map, World world) {
        if (map == null) {
            throw new Exception("Invalid residence physical location...");
        }
        CuboidArea cuboidArea = new CuboidArea();
        int n = (Integer)map.get("X1");
        int n2 = (Integer)map.get("Y1");
        int n3 = (Integer)map.get("Z1");
        int n4 = (Integer)map.get("X2");
        int n5 = (Integer)map.get("Y2");
        int n6 = (Integer)map.get("Z2");
        cuboidArea.highPoints = new Location(world, (double)n, (double)n2, (double)n3);
        cuboidArea.lowPoints = new Location(world, (double)n4, (double)n5, (double)n6);
        cuboidArea.worldName = world.getName();
        return cuboidArea;
    }

    public List<ResidenceManager.ChunkRef> getChunks() {
        ArrayList<ResidenceManager.ChunkRef> arrayList = new ArrayList<ResidenceManager.ChunkRef>();
        Location location = this.highPoints;
        Location location2 = this.lowPoints;
        int n = ResidenceManager.ChunkRef.getChunkCoord(location2.getBlockX());
        int n2 = ResidenceManager.ChunkRef.getChunkCoord(location2.getBlockZ());
        int n3 = ResidenceManager.ChunkRef.getChunkCoord(location.getBlockX());
        int n4 = ResidenceManager.ChunkRef.getChunkCoord(location.getBlockZ());
        int n5 = n;
        while (n5 <= n3) {
            int n6 = n2;
            while (n6 <= n4) {
                arrayList.add(new ResidenceManager.ChunkRef(n5, n6));
                ++n6;
            }
            ++n5;
        }
        return arrayList;
    }

    public void setHighLocation(Location location) {
        this.highPoints = location;
    }

    public void setLowLocation(Location location) {
        this.lowPoints = location;
    }

    public double getCost(PermissionGroup permissionGroup) {
        return (double)((int)((double)this.getSize() * permissionGroup.getCostPerBlock() * 100.0)) / 100.0;
    }
}

