/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.cmiLib.TitleMessageManager;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeMessages;
import com.bekvon.bukkit.residence.containers.RandomLoc;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.ResidenceBank;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.CancellableResidencePlayerEvent;
import com.bekvon.bukkit.residence.event.ResidenceAreaAddEvent;
import com.bekvon.bukkit.residence.event.ResidenceAreaDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceRaidPreStartEvent;
import com.bekvon.bukkit.residence.event.ResidenceRaidStartEvent;
import com.bekvon.bukkit.residence.event.ResidenceSizeChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceSubzoneCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceTPEvent;
import com.bekvon.bukkit.residence.itemlist.ItemList;
import com.bekvon.bukkit.residence.itemlist.ResidenceItemList;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.shopStuff.ShopVote;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ClaimedResidence {
    private String resName = null;
    protected ClaimedResidence parent;
    protected Map<String, CuboidArea> areas;
    protected Map<String, ClaimedResidence> subzones;
    protected ResidencePermissions perms;
    protected ResidenceBank bank;
    protected Double BlockSellPrice = 0.0;
    protected Location tpLoc;
    protected String enterMessage;
    protected String leaveMessage;
    protected String ShopDesc = null;
    protected String ChatPrefix = "";
    protected ChatColor ChannelColor = ChatColor.WHITE;
    protected ResidenceItemList ignorelist;
    protected ResidenceItemList blacklist;
    protected boolean mainRes = false;
    protected long createTime = 0L;
    private Long leaseExpireTime = null;
    protected List<String> cmdWhiteList = new ArrayList<String>();
    protected List<String> cmdBlackList = new ArrayList<String>();
    List<ShopVote> ShopVoteList = new ArrayList<ShopVote>();
    protected RentableLand rentableland = null;
    protected RentedLand rentedland = null;
    protected Integer sellPrice = -1;
    private Residence plugin;
    private ResidenceRaid raid;
    private Set<Signs> signsInResidence = new HashSet<Signs>();
    Integer repeatId = -1;

    public String getResidenceName() {
        return this.resName;
    }

    public void setName(String string) {
        this.resName = string.contains(".") ? string.split("\\.")[string.split("\\.").length - 1] : string;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Integer getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(Integer n) {
        this.sellPrice = n;
    }

    public boolean isForSell() {
        return this.plugin.getTransactionManager().isForSale(this.getName());
    }

    public boolean isForRent() {
        return this.plugin.getRentManager().isForRent(this);
    }

    public boolean isSubzoneForRent() {
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            if (entry.getValue().isForRent()) {
                return true;
            }
            if (!entry.getValue().isSubzoneForRent()) continue;
            return true;
        }
        return false;
    }

    public boolean isSubzoneRented() {
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            if (entry.getValue().isRented()) {
                return true;
            }
            if (!entry.getValue().isSubzoneRented()) continue;
            return true;
        }
        return false;
    }

    public ClaimedResidence getRentedSubzone() {
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            if (entry.getValue().isRented()) {
                return entry.getValue();
            }
            if (entry.getValue().getRentedSubzone() == null) continue;
            return entry.getValue().getRentedSubzone();
        }
        return null;
    }

    public boolean isParentForRent() {
        if (this.getParent() != null) {
            return this.getParent().isForRent() ? true : this.getParent().isParentForRent();
        }
        return false;
    }

    public boolean isParentForSell() {
        if (this.getParent() != null) {
            return this.getParent().isForSell() ? true : this.getParent().isParentForSell();
        }
        return false;
    }

    public boolean isRented() {
        return this.plugin.getRentManager().isRented(this);
    }

    public void setRentable(RentableLand rentableLand) {
        this.rentableland = rentableLand;
    }

    public RentableLand getRentable() {
        return this.rentableland;
    }

    public void setRented(RentedLand rentedLand) {
        this.rentedland = rentedLand;
    }

    public RentedLand getRentedLand() {
        return this.rentedland;
    }

    public ClaimedResidence(String string, Residence residence) {
        this(residence.getServerLandName(), string, residence);
    }

    public ClaimedResidence(String string, String string2, Residence residence) {
        this(residence);
        this.perms = new ResidencePermissions(this, string, string2);
    }

    public ClaimedResidence(String string, String string2, ClaimedResidence claimedResidence, Residence residence) {
        this(string, string2, residence);
        this.parent = claimedResidence;
    }

    public ClaimedResidence(Residence residence) {
        this.subzones = new HashMap<String, ClaimedResidence>();
        this.areas = new HashMap<String, CuboidArea>();
        this.bank = new ResidenceBank(this);
        this.blacklist = new ResidenceItemList(residence, this, ItemList.ListType.BLACKLIST);
        this.ignorelist = new ResidenceItemList(residence, this, ItemList.ListType.IGNORELIST);
        this.plugin = residence;
    }

    public boolean isMainResidence() {
        return this.mainRes;
    }

    public void setMainResidence(boolean bl) {
        this.mainRes = bl;
    }

    public boolean isSubzone() {
        return this.parent != null;
    }

    public int getSubzoneDeep() {
        return this.getSubzoneDeep(0);
    }

    public int getSubzoneDeep(int n) {
        ++n;
        if (this.parent != null) {
            return this.parent.getSubzoneDeep(n);
        }
        return n;
    }

    public boolean isBiggerThanMin(Player player, CuboidArea cuboidArea, boolean bl) {
        if (bl) {
            return true;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (cuboidArea.getXSize() < permissionGroup.getMinX()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallX, cuboidArea.getXSize(), permissionGroup.getMinX());
            return false;
        }
        if (cuboidArea.getYSize() < permissionGroup.getMinY()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallY, cuboidArea.getYSize(), permissionGroup.getMinY());
            return false;
        }
        if (cuboidArea.getZSize() < permissionGroup.getMinZ()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallZ, cuboidArea.getZSize(), permissionGroup.getMinZ());
            return false;
        }
        return true;
    }

    public boolean isBiggerThanMinSubzone(Player player, CuboidArea cuboidArea, boolean bl) {
        if (bl) {
            return true;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (cuboidArea.getXSize() < permissionGroup.getSubzoneMinX()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallX, cuboidArea.getXSize(), permissionGroup.getSubzoneMinX());
            return false;
        }
        if (cuboidArea.getYSize() < permissionGroup.getSubzoneMinY()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallY, cuboidArea.getYSize(), permissionGroup.getSubzoneMinY());
            return false;
        }
        if (cuboidArea.getZSize() < permissionGroup.getSubzoneMinZ()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToSmallZ, cuboidArea.getZSize(), permissionGroup.getSubzoneMinZ());
            return false;
        }
        return true;
    }

    public boolean isSmallerThanMax(Player player, CuboidArea cuboidArea, boolean bl) {
        if (bl) {
            return true;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (cuboidArea.getXSize() > permissionGroup.getMaxX()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigX, cuboidArea.getXSize(), permissionGroup.getMaxX());
            return false;
        }
        if (cuboidArea.getYSize() > permissionGroup.getMaxY()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigY, cuboidArea.getYSize(), permissionGroup.getMaxY());
            return false;
        }
        if (cuboidArea.getZSize() > permissionGroup.getMaxZ()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigZ, cuboidArea.getZSize(), permissionGroup.getMaxZ());
            return false;
        }
        return true;
    }

    public boolean isSmallerThanMaxSubzone(Player player, CuboidArea cuboidArea, boolean bl) {
        if (bl) {
            return true;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (cuboidArea.getXSize() > permissionGroup.getSubzoneMaxX()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigX, cuboidArea.getXSize(), permissionGroup.getSubzoneMaxX());
            return false;
        }
        if (cuboidArea.getYSize() > permissionGroup.getSubzoneMaxY()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigY, cuboidArea.getYSize(), permissionGroup.getSubzoneMaxY());
            return false;
        }
        if (cuboidArea.getZSize() > permissionGroup.getSubzoneMaxZ()) {
            this.plugin.msg((CommandSender)player, lm.Area_ToBigZ, cuboidArea.getZSize(), permissionGroup.getSubzoneMaxZ());
            return false;
        }
        return true;
    }

    public boolean addArea(CuboidArea cuboidArea, String string) {
        return this.addArea(null, cuboidArea, string, true);
    }

    public boolean addArea(Player player, CuboidArea cuboidArea, String string, boolean bl) {
        return this.addArea(player, cuboidArea, string, bl, true);
    }

    public boolean addArea(Player player, CuboidArea cuboidArea, String string, boolean bl, boolean bl2) {
        Object object;
        if (!this.plugin.validName(string)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            }
            return false;
        }
        String string2 = string;
        string = string.toLowerCase();
        if (this.areas.containsKey(string2)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_Exists, new Object[0]);
            }
            return false;
        }
        if (this.isSubzone() && !this.isBiggerThanMinSubzone(player, cuboidArea, bl) || !this.isSubzone() && !this.isBiggerThanMin(player, cuboidArea, bl)) {
            return false;
        }
        if (!bl && this.plugin.getConfigManager().getEnforceAreaInsideArea() && this.getParent() == null) {
            boolean bl3 = false;
            for (CuboidArea object22 : this.areas.values()) {
                if (!object22.isAreaWithinArea(cuboidArea)) continue;
                bl3 = true;
            }
            if (!bl3) {
                this.plugin.msg((CommandSender)player, lm.Subzone_SelectInside, new Object[0]);
                return false;
            }
        }
        if (!cuboidArea.getWorld().getName().equalsIgnoreCase(this.perms.getWorld())) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_DiffWorld, new Object[0]);
            }
            return false;
        }
        if (this.parent == null) {
            object = this.plugin.getResidenceManager().checkAreaCollision(cuboidArea, this);
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName((String)object);
            if (claimedResidence != null) {
                if (player != null) {
                    this.plugin.msg((CommandSender)player, lm.Area_Collision, claimedResidence.getName());
                    Visualizer visualizer = new Visualizer(player);
                    visualizer.setAreas(cuboidArea);
                    visualizer.setErrorAreas(claimedResidence);
                    this.plugin.getSelectionManager().showBounds(player, visualizer);
                }
                return false;
            }
        } else {
            object = this.parent.listSubzones();
            String[] stringArray = object;
            int n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray[n2];
                ClaimedResidence claimedResidence = this.parent.getSubzone(string3);
                if (claimedResidence != null && claimedResidence != this && claimedResidence.checkCollision(cuboidArea)) {
                    if (player != null) {
                        this.plugin.msg((CommandSender)player, lm.Area_SubzoneCollision, string3);
                    }
                    return false;
                }
                ++n2;
            }
        }
        if (!bl && player != null) {
            if (!this.perms.hasResidencePermission((CommandSender)player, true)) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.parent != null) {
                if (!this.parent.containsLoc(cuboidArea.getHighLoc()) || !this.parent.containsLoc(cuboidArea.getLowLoc())) {
                    this.plugin.msg((CommandSender)player, lm.Area_NotWithinParent, new Object[0]);
                    return false;
                }
                if (!this.parent.getPermissions().hasResidencePermission((CommandSender)player, true) && !this.parent.getPermissions().playerHas(player, Flags.subzone, FlagPermissions.FlagCombo.OnlyTrue)) {
                    this.plugin.msg((CommandSender)player, lm.Residence_ParentNoPermission, new Object[0]);
                    return false;
                }
            }
            object = this.plugin.getPlayerManager().getResidencePlayer(player);
            PermissionGroup permissionGroup = ((ResidencePlayer)object).getGroup();
            if (!this.isSubzone() && !permissionGroup.canCreateResidences() && !PermissionManager.ResPerm.create.hasPermission((CommandSender)player, true, new String[0]) || this.isSubzone() && !permissionGroup.canCreateResidences() && !PermissionManager.ResPerm.create_subzone.hasPermission((CommandSender)player, true, new String[0])) {
                return false;
            }
            if (this.areas.size() >= permissionGroup.getMaxPhysicalPerResidence()) {
                this.plugin.msg((CommandSender)player, lm.Area_MaxPhysical, new Object[0]);
                return false;
            }
            if (!this.isSubzone() && !this.isSmallerThanMax(player, cuboidArea, bl) || this.isSubzone() && !this.isSmallerThanMaxSubzone(player, cuboidArea, bl)) {
                this.plugin.msg((CommandSender)player, lm.Area_SizeLimit, new Object[0]);
                return false;
            }
            if (permissionGroup.getMinHeight() > cuboidArea.getLowLoc().getBlockY()) {
                this.plugin.msg((CommandSender)player, lm.Area_LowLimit, String.format("%d", permissionGroup.getMinHeight()));
                return false;
            }
            if (permissionGroup.getMaxHeight() < cuboidArea.getHighLoc().getBlockY()) {
                this.plugin.msg((CommandSender)player, lm.Area_HighLimit, String.format("%d", permissionGroup.getMaxHeight()));
                return false;
            }
            if (!bl) {
                if (this.plugin.getWorldGuard() != null && this.plugin.getWorldGuardUtil().isSelectionInArea(player)) {
                    return false;
                }
                if (this.plugin.getKingdomsManager() != null && this.plugin.getKingdomsUtil().isSelectionInArea(player)) {
                    return false;
                }
            }
            if (bl2 && this.parent == null && this.plugin.getConfigManager().enableEconomy() && !bl) {
                double d = cuboidArea.getCost(permissionGroup);
                if (!this.plugin.getTransactionManager().chargeEconomyMoney(player, d)) {
                    return false;
                }
            }
        }
        object = new ResidenceAreaAddEvent(player, string2, this, cuboidArea);
        this.plugin.getServ().getPluginManager().callEvent((Event)object);
        if (((CancellableResidencePlayerEvent)object).isCancelled()) {
            return false;
        }
        this.plugin.getResidenceManager().removeChunkList(this.getName());
        this.areas.put(string, cuboidArea);
        this.plugin.getResidenceManager().calculateChunks(this.getName());
        return true;
    }

    public boolean replaceArea(CuboidArea cuboidArea, String string) {
        return this.replaceArea(null, cuboidArea, string, true);
    }

    public boolean replaceArea(Player player, CuboidArea cuboidArea, String string, boolean bl) {
        int n;
        ClaimedResidence claimedResidence;
        int n2;
        int n3;
        String[] stringArray;
        Object object;
        Object object2;
        if (!this.areas.containsKey(string)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
            }
            return false;
        }
        CuboidArea cuboidArea2 = this.areas.get(string);
        if (!cuboidArea.getWorld().getName().equalsIgnoreCase(this.perms.getWorld())) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_DiffWorld, new Object[0]);
            }
            return false;
        }
        if (this.parent == null) {
            object2 = this.plugin.getResidenceManager().checkAreaCollision(cuboidArea, this);
            object = this.plugin.getResidenceManager().getByName((String)object2);
            if (object != null && player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_Collision, ((ClaimedResidence)object).getName());
                Visualizer visualizer = new Visualizer(player);
                visualizer.setAreas(this.getAreaArray());
                visualizer.setErrorAreas(((ClaimedResidence)object).getAreaArray());
                this.plugin.getSelectionManager().showBounds(player, visualizer);
                return false;
            }
        } else {
            stringArray = object2 = this.parent.listSubzones();
            n3 = ((String[])object2).length;
            n2 = 0;
            while (n2 < n3) {
                object = stringArray[n2];
                claimedResidence = this.parent.getSubzone((String)object);
                if (claimedResidence != null && claimedResidence != this && claimedResidence.checkCollision(cuboidArea)) {
                    if (player != null) {
                        this.plugin.msg((CommandSender)player, lm.Area_SubzoneCollision, object);
                        Visualizer visualizer = new Visualizer(player);
                        visualizer.setErrorAreas(claimedResidence.getAreaArray());
                        this.plugin.getSelectionManager().showBounds(player, visualizer);
                    }
                    return false;
                }
                ++n2;
            }
        }
        stringArray = object2 = this.listSubzones();
        n3 = ((String[])object2).length;
        n2 = 0;
        while (n2 < n3) {
            object = stringArray[n2];
            claimedResidence = this.getSubzone((String)object);
            if (claimedResidence != null && claimedResidence != this) {
                String[] stringArray2;
                String[] stringArray3 = stringArray2 = claimedResidence.getAreaList();
                int n4 = stringArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    String string2 = stringArray3[n5];
                    if (!cuboidArea.isAreaWithinArea(claimedResidence.getArea(string2))) {
                        Object object3;
                        boolean bl2 = false;
                        CuboidArea[] cuboidAreaArray = this.getAreaArray();
                        int n6 = cuboidAreaArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            object3 = cuboidAreaArray[n7];
                            if (object3 != cuboidArea2 && ((CuboidArea)object3).isAreaWithinArea(claimedResidence.getArea(string2))) {
                                bl2 = true;
                            }
                            ++n7;
                        }
                        if (!bl2) {
                            this.plugin.msg((CommandSender)player, lm.Area_Collision, claimedResidence.getName());
                            object3 = new Visualizer(player);
                            ((Visualizer)object3).setAreas(this.getAreaArray());
                            ((Visualizer)object3).setErrorAreas(claimedResidence.getAreaArray());
                            this.plugin.getSelectionManager().showBounds(player, (Visualizer)object3);
                            return false;
                        }
                    }
                    ++n5;
                }
                if (claimedResidence.getAreaArray().length == 0) {
                    this.removeSubzone((String)object);
                }
            }
            ++n2;
        }
        if (!bl && player != null) {
            double d;
            PermissionGroup permissionGroup;
            if (!this.perms.hasResidencePermission((CommandSender)player, true)) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.parent != null) {
                if (!this.parent.containsLoc(cuboidArea.getHighLoc()) || !this.parent.containsLoc(cuboidArea.getLowLoc())) {
                    this.plugin.msg((CommandSender)player, lm.Area_NotWithinParent, new Object[0]);
                    return false;
                }
                if (!this.parent.getPermissions().hasResidencePermission((CommandSender)player, true) && !this.parent.getPermissions().playerHas(player, Flags.subzone, FlagPermissions.FlagCombo.OnlyTrue)) {
                    this.plugin.msg((CommandSender)player, lm.Residence_ParentNoPermission, new Object[0]);
                    return false;
                }
            }
            if (!(permissionGroup = ((ResidencePlayer)(object = this.plugin.getPlayerManager().getResidencePlayer(player))).getGroup()).canCreateResidences() && !PermissionManager.ResPerm.resize.hasPermission((CommandSender)player, true, new String[0])) {
                return false;
            }
            if (cuboidArea2.getSize() < cuboidArea.getSize() && (!this.isSubzone() && !this.isSmallerThanMax(player, cuboidArea, bl) || this.isSubzone() && !this.isSmallerThanMaxSubzone(player, cuboidArea, bl))) {
                this.plugin.msg((CommandSender)player, lm.Area_SizeLimit, new Object[0]);
                return false;
            }
            if (permissionGroup.getMinHeight() > cuboidArea.getLowLoc().getBlockY()) {
                this.plugin.msg((CommandSender)player, lm.Area_LowLimit, String.format("%d", permissionGroup.getMinHeight()));
                return false;
            }
            if (permissionGroup.getMaxHeight() < cuboidArea.getHighLoc().getBlockY()) {
                this.plugin.msg((CommandSender)player, lm.Area_HighLimit, String.format("%d", permissionGroup.getMaxHeight()));
                return false;
            }
            if (!this.isBiggerThanMin(player, cuboidArea, bl)) {
                return false;
            }
            if (!bl) {
                if (this.plugin.getWorldGuard() != null && this.plugin.getWorldGuardUtil().isSelectionInArea(player)) {
                    return false;
                }
                if (this.plugin.getKingdomsManager() != null && this.plugin.getKingdomsUtil().isSelectionInArea(player)) {
                    return false;
                }
            }
            if (this.parent == null && this.plugin.getConfigManager().enableEconomy() && !bl && (d = cuboidArea.getCost(permissionGroup) - cuboidArea2.getCost(permissionGroup)) > 0.0 && !this.plugin.getTransactionManager().chargeEconomyMoney(player, d)) {
                return false;
            }
        }
        object = new ResidenceSizeChangeEvent(player, this, cuboidArea2, cuboidArea);
        this.plugin.getServ().getPluginManager().callEvent((Event)object);
        if (((CancellableResidencePlayerEvent)object).isCancelled()) {
            return false;
        }
        if (!bl && player != null && (n = (int)Math.ceil((double)(cuboidArea.getSize() - cuboidArea2.getSize()) * this.getBlockSellPrice())) < 0 && this.plugin.getConfigManager().useResMoneyBack() && !this.isServerLand()) {
            this.plugin.getTransactionManager().giveEconomyMoney(player, (double)(-n));
        }
        this.plugin.getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(string);
        this.areas.put(string, cuboidArea);
        this.plugin.getResidenceManager().calculateChunks(this.getName());
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Area_Update, new Object[0]);
        }
        return true;
    }

    public boolean addSubzone(String string, Location location, Location location2) {
        return this.addSubzone(null, location, location2, string, true);
    }

    public boolean addSubzone(Player player, Location location, Location location2, String string, boolean bl) {
        if (player == null) {
            return this.addSubzone(null, this.plugin.getServerLandName(), location, location2, string, bl);
        }
        return this.addSubzone(player, player.getName(), location, location2, string, bl);
    }

    public boolean isServerLand() {
        return this.getOwnerUUID().toString() == Residence.getInstance().getServerLandUUID();
    }

    public boolean addSubzone(Player player, String string, boolean bl) {
        if (Residence.getInstance().getSelectionManager().hasPlacedBoth(player)) {
            Location location = Residence.getInstance().getSelectionManager().getPlayerLoc1(player);
            Location location2 = Residence.getInstance().getSelectionManager().getPlayerLoc2(player);
            return this.addSubzone(player, player.getName(), location, location2, string, bl);
        }
        return false;
    }

    public boolean addSubzone(Player player, String string, Location location, Location location2, String string2, boolean bl) {
        Object object;
        Map.Entry<String, ClaimedResidence> entry2;
        if (!this.plugin.validName(string2)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            }
            return false;
        }
        if (!this.containsLoc(location) || !this.containsLoc(location2)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Subzone_SelectInside, new Object[0]);
            }
            return false;
        }
        String string3 = string2;
        if (this.subzones.containsKey(string2 = string2.toLowerCase())) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Subzone_Exists, string3);
            }
            return false;
        }
        if (!bl && player != null) {
            if (!this.perms.hasResidencePermission((CommandSender)player, true) && !this.perms.playerHas(player.getName(), Flags.subzone, this.perms.playerHas(player, Flags.admin, false))) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.getSubzoneList().length >= this.plugin.getPlayerManager().getResidencePlayer(string).getMaxSubzones()) {
                this.plugin.msg((CommandSender)player, lm.Subzone_MaxAmount, new Object[0]);
                return false;
            }
            if (this.getZoneDepth() >= this.plugin.getPlayerManager().getResidencePlayer(string).getMaxSubzoneDepth()) {
                this.plugin.msg((CommandSender)player, lm.Subzone_MaxDepth, new Object[0]);
                return false;
            }
        }
        CuboidArea cuboidArea = new CuboidArea(location, location2);
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry2 : set2) {
            object = entry2.getValue();
            if (!((ClaimedResidence)object).checkCollision(cuboidArea)) continue;
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Subzone_Collide, entry2.getKey());
                Visualizer visualizer = new Visualizer(player);
                visualizer.setAreas(cuboidArea);
                visualizer.setErrorAreas((ClaimedResidence)object);
                this.plugin.getSelectionManager().showBounds(player, visualizer);
            }
            return false;
        }
        if (player != null) {
            entry2 = new ClaimedResidence(string, this.perms.getWorld(), this, this.plugin);
            ((ClaimedResidence)((Object)entry2)).addArea(player, cuboidArea, string3, bl);
        } else {
            entry2 = new ClaimedResidence(string, this.perms.getWorld(), this, this.plugin);
            ((ClaimedResidence)((Object)entry2)).addArea(cuboidArea, string3);
        }
        if (((ClaimedResidence)((Object)entry2)).getAreaCount() != 0) {
            Object object2;
            ((ClaimedResidence)((Object)entry2)).getPermissions().applyDefaultFlags();
            if (player != null) {
                object2 = this.plugin.getPlayerManager().getResidencePlayer(player);
                object = ((ResidencePlayer)object2).getGroup();
                ((ClaimedResidence)((Object)entry2)).setEnterMessage(((PermissionGroup)object).getDefaultEnterMessage());
                ((ClaimedResidence)((Object)entry2)).setLeaveMessage(((PermissionGroup)object).getDefaultLeaveMessage());
            }
            if (this.plugin.getConfigManager().flagsInherit()) {
                ((ClaimedResidence)((Object)entry2)).getPermissions().setParent(this.perms);
            }
            ((ClaimedResidence)((Object)entry2)).resName = string3;
            ((ClaimedResidence)((Object)entry2)).setCreateTime();
            object2 = new ResidenceSubzoneCreationEvent(player, string3, (ClaimedResidence)((Object)entry2), cuboidArea);
            this.plugin.getServ().getPluginManager().callEvent((Event)object2);
            if (((CancellableResidencePlayerEvent)object2).isCancelled()) {
                return false;
            }
            this.subzones.put(string2, (ClaimedResidence)((Object)entry2));
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_Create, string3);
                this.plugin.msg((CommandSender)player, lm.Subzone_Create, string3);
            }
            return true;
        }
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Subzone_CreateFail, string3);
        }
        return false;
    }

    public ClaimedResidence getSubzoneByLoc(Location location) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        ClaimedResidence claimedResidence = null;
        for (Map.Entry<String, ClaimedResidence> object2 : set2) {
            if (!object2.getValue().containsLoc(location)) continue;
            claimedResidence = object2.getValue();
            break;
        }
        if (claimedResidence == null) {
            return null;
        }
        ClaimedResidence claimedResidence2 = claimedResidence.getSubzoneByLoc(location);
        if (claimedResidence2 == null) {
            return claimedResidence;
        }
        return claimedResidence2;
    }

    public ClaimedResidence getSubzone(String string) {
        if (!(string = string.toLowerCase()).contains(".")) {
            return this.subzones.get(string);
        }
        String[] stringArray = string.split("\\.");
        ClaimedResidence claimedResidence = this.subzones.get(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            if (claimedResidence == null) {
                return null;
            }
            claimedResidence = claimedResidence.getSubzone(stringArray[n]);
            ++n;
        }
        return claimedResidence;
    }

    public String getSubzoneNameByRes(ClaimedResidence claimedResidence) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (entry.getValue() == claimedResidence) {
                return entry.getValue().getResidenceName();
            }
            String string = entry.getValue().getSubzoneNameByRes(claimedResidence);
            if (string == null) continue;
            return String.valueOf(entry.getValue().getResidenceName()) + "." + string;
        }
        return null;
    }

    public String[] getSubzoneList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<String> set2 = this.subzones.keySet();
        for (String string : set2) {
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean checkCollision(CuboidArea cuboidArea) {
        Set<String> set2 = this.areas.keySet();
        for (String string : set2) {
            CuboidArea cuboidArea2 = this.areas.get(string);
            if (cuboidArea2 == null || !cuboidArea2.checkCollision(cuboidArea)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLoc(Location location) {
        Collection<CuboidArea> collection = this.areas.values();
        for (CuboidArea cuboidArea : collection) {
            if (!cuboidArea.containsLoc(location)) continue;
            if (this.parent != null) {
                return this.parent.containsLoc(location);
            }
            return true;
        }
        return false;
    }

    public ClaimedResidence getParent() {
        return this.parent;
    }

    public String getTopParentName() {
        return this.getTopParent().getName();
    }

    public ClaimedResidence getTopParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTopParent();
    }

    public boolean isTopArea() {
        return this.parent == null;
    }

    public boolean removeSubzone(String string) {
        return this.removeSubzone(null, string, true);
    }

    public boolean removeSubzone(Player player, String string, boolean bl) {
        if (string == null) {
            return false;
        }
        string = string.toLowerCase();
        ClaimedResidence claimedResidence = this.subzones.get(string);
        if (player != null && !claimedResidence.perms.hasResidencePermission((CommandSender)player, true) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return false;
        }
        this.subzones.remove(string);
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Subzone_Remove, string);
        }
        return true;
    }

    public long getTotalSize() {
        Collection<CuboidArea> collection = this.areas.values();
        long l = 0L;
        if (!this.plugin.getConfigManager().isNoCostForYBlocks()) {
            for (CuboidArea cuboidArea : collection) {
                l += cuboidArea.getSize();
            }
        } else {
            for (CuboidArea cuboidArea : collection) {
                l += (long)(cuboidArea.getXSize() * cuboidArea.getZSize());
            }
        }
        return l;
    }

    public long getXZSize() {
        Collection<CuboidArea> collection = this.areas.values();
        long l = 0L;
        for (CuboidArea cuboidArea : collection) {
            l += (long)(cuboidArea.getXSize() * cuboidArea.getZSize());
        }
        return l;
    }

    public CuboidArea[] getAreaArray() {
        CuboidArea[] cuboidAreaArray = new CuboidArea[this.areas.size()];
        int n = 0;
        Iterator<CuboidArea> iterator = this.areas.values().iterator();
        while (iterator.hasNext()) {
            CuboidArea cuboidArea;
            cuboidAreaArray[n] = cuboidArea = iterator.next();
            ++n;
        }
        return cuboidAreaArray;
    }

    public Map<String, CuboidArea> getAreaMap() {
        return this.areas;
    }

    public ResidencePermissions getPermissions() {
        return this.perms;
    }

    public String getEnterMessage() {
        return this.enterMessage;
    }

    public String getLeaveMessage() {
        return this.leaveMessage;
    }

    public String getShopDesc() {
        return this.ShopDesc;
    }

    public void setEnterMessage(String string) {
        this.enterMessage = string;
    }

    public void setLeaveMessage(String string) {
        this.leaveMessage = string;
    }

    public void setShopDesc(String string) {
        this.ShopDesc = string;
    }

    public void setEnterLeaveMessage(CommandSender commandSender, String string, boolean bl, boolean bl2) {
        if (string != null && string.equals("")) {
            string = null;
        }
        if (commandSender instanceof Player) {
            ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer((Player)commandSender);
            PermissionGroup permissionGroup = residencePlayer.getGroup();
            if (!permissionGroup.canSetEnterLeaveMessages() && !bl2) {
                this.plugin.msg(commandSender, lm.Residence_OwnerNoPermission, new Object[0]);
                return;
            }
            if (!this.perms.hasResidencePermission(commandSender, false) && !bl2) {
                this.plugin.msg(commandSender, lm.General_NoPermission, new Object[0]);
                return;
            }
        }
        if (bl) {
            this.setEnterMessage(string);
        } else {
            this.setLeaveMessage(string);
        }
        this.plugin.msg(commandSender, lm.Residence_MessageChange, new Object[0]);
    }

    public Location getMiddleFreeLoc(Location location, Player player) {
        CuboidArea cuboidArea = this.getAreaByLoc(location);
        if (cuboidArea == null) {
            return location;
        }
        int n = cuboidArea.getHighLoc().getBlockY();
        int n2 = cuboidArea.getLowLoc().getBlockY();
        int n3 = cuboidArea.getLowLoc().getBlockX() + cuboidArea.getXSize() / 2;
        int n4 = cuboidArea.getLowLoc().getBlockZ() + cuboidArea.getZSize() / 2;
        Location location2 = new Location(cuboidArea.getWorld(), (double)n3 + 0.5, (double)n, (double)n4 + 0.5);
        boolean bl = false;
        int n5 = location2.getBlockY() + 1;
        for (int i = 1; i < n5; ++i) {
            if (location2.getBlockY() < n2) break;
            location2.add(0.0, -1.0, 0.0);
            Block block = location2.getBlock();
            Block block2 = location2.clone().add(0.0, 1.0, 0.0).getBlock();
            Block block3 = location2.clone().add(0.0, -1.0, 0.0).getBlock();
            if (!ResidencePlayerListener.isEmptyBlock(block) || !ResidencePlayerListener.isEmptyBlock(block2) || ResidencePlayerListener.isEmptyBlock(block3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (player != null) {
                location2.setPitch(player.getLocation().getPitch());
                location2.setYaw(player.getLocation().getYaw());
            }
            return location2;
        }
        return this.getOutsideFreeLoc(location, player);
    }

    public Location getOutsideFreeLoc(Location location, Player player) {
        CuboidArea cuboidArea = this.getAreaByLoc(location);
        if (cuboidArea == null) {
            return location;
        }
        ArrayList<RandomLoc> arrayList = new ArrayList<RandomLoc>();
        int n = -1;
        while (n < cuboidArea.getZSize() + 2) {
            arrayList.add(new RandomLoc(cuboidArea.getLowLoc().getX(), 0.0, cuboidArea.getLowLoc().getZ() + (double)n));
            arrayList.add(new RandomLoc(cuboidArea.getLowLoc().getX() + (double)cuboidArea.getXSize(), 0.0, cuboidArea.getLowLoc().getZ() + (double)n));
            ++n;
        }
        n = -1;
        while (n < cuboidArea.getXSize() + 2) {
            arrayList.add(new RandomLoc(cuboidArea.getLowLoc().getX() + (double)n, 0.0, cuboidArea.getLowLoc().getZ()));
            arrayList.add(new RandomLoc(cuboidArea.getLowLoc().getX() + (double)n, 0.0, cuboidArea.getLowLoc().getZ() + (double)cuboidArea.getZSize()));
            ++n;
        }
        Location location2 = location.clone();
        boolean bl = PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player);
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 15;
        while (!bl2 && n2 < n3) {
            ClaimedResidence claimedResidence;
            ++n2;
            Random random = new Random(System.currentTimeMillis());
            if (arrayList.isEmpty()) break;
            int n4 = random.nextInt(arrayList.size());
            RandomLoc randomLoc = (RandomLoc)arrayList.get(n4);
            arrayList.remove(n4);
            double d = randomLoc.getX();
            double d2 = randomLoc.getZ();
            location2.setX(d);
            location2.setZ(d2);
            location2.setY((double)cuboidArea.getHighLoc().getBlockY());
            int n5 = cuboidArea.getHighLoc().getBlockY();
            int n6 = n5 = location2.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : n5;
            while ((double)n6 > cuboidArea.getLowLoc().getY()) {
                location2.setY((double)n6);
                Block block = location2.getBlock();
                Block block2 = location2.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = location2.clone().add(0.0, -1.0, 0.0).getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block3) && ResidencePlayerListener.isEmptyBlock(block) && ResidencePlayerListener.isEmptyBlock(block2)) break;
                --n6;
            }
            if (!ResidencePlayerListener.isEmptyBlock(location2.getBlock()) || location2.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.LAVA || location2.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.WATER || (claimedResidence = this.plugin.getResidenceManager().getByLoc(location2)) != null && player != null && !claimedResidence.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.TrueOrNone) && !bl) continue;
            bl2 = true;
            location2.add(0.5, 0.1, 0.5);
            if (this.plugin.getResidenceManager().getByLoc(location2) != this) break;
            location2.add(-1.0, 0.0, -1.0);
            break;
        }
        if (!bl2 && this.plugin.getConfigManager().getKickLocation() != null) {
            return this.plugin.getConfigManager().getKickLocation();
        }
        if (player != null) {
            location2.setPitch(player.getLocation().getPitch());
            location2.setYaw(player.getLocation().getYaw());
        }
        return location2;
    }

    public CuboidArea getMainArea() {
        Iterator<Map.Entry<String, CuboidArea>> iterator;
        CuboidArea cuboidArea = this.areas.get(this.isSubzone() ? this.getResidenceName() : "main");
        if (cuboidArea == null && !this.areas.isEmpty() && (iterator = this.areas.entrySet().iterator()).hasNext()) {
            Map.Entry<String, CuboidArea> entry = iterator.next();
            cuboidArea = entry.getValue();
        }
        return cuboidArea;
    }

    public CuboidArea getAreaByLoc(Location location) {
        for (CuboidArea cuboidArea : this.areas.values()) {
            if (!cuboidArea.containsLoc(location)) continue;
            return cuboidArea;
        }
        return null;
    }

    public String[] listSubzones() {
        String[] stringArray = new String[this.subzones.size()];
        int n = 0;
        Iterator<String> iterator = this.subzones.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = iterator.next();
            ++n;
        }
        return stringArray;
    }

    public List<ClaimedResidence> getSubzones() {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public int getSubzonesAmount(Boolean bl) {
        int n = 0;
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            ++n;
            if (!bl.booleanValue()) continue;
            n += entry.getValue().getSubzonesAmount(bl);
        }
        return n;
    }

    public void printSubzoneList(CommandSender commandSender, int n) {
        PageInfo pageInfo = new PageInfo(6, this.subzones.size(), n);
        if (!pageInfo.isPageOk()) {
            commandSender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        this.plugin.msg(commandSender, lm.InformationPage_TopSingle, this.plugin.msg(lm.General_Subzones, new Object[0]));
        this.plugin.msg(commandSender, lm.InformationPage_Page, this.plugin.msg(lm.General_GenericPages, String.format("%d", n), pageInfo.getTotalPages(), pageInfo.getTotalEntries()));
        RawMessage rawMessage = new RawMessage();
        int n2 = pageInfo.getStart();
        while (n2 <= pageInfo.getEnd()) {
            ClaimedResidence claimedResidence = this.getSubzones().get(n2);
            if (claimedResidence != null) {
                rawMessage.add(ChatColor.GREEN + claimedResidence.getResidenceName() + ChatColor.YELLOW + " - " + this.plugin.msg(lm.General_Owner, claimedResidence.getOwner()), "Teleport to " + claimedResidence.getName(), "res tp " + claimedResidence.getName());
                rawMessage.show(commandSender);
                rawMessage.clear();
            }
            ++n2;
        }
        this.plugin.getInfoPageManager().ShowPagination(commandSender, pageInfo, "res sublist " + this.getName());
    }

    public void printAreaList(Player player, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.areas.keySet()) {
            arrayList.add(string);
        }
        this.plugin.getInfoPageManager().printInfo((CommandSender)player, "res area list " + this.getName(), this.plugin.msg(lm.General_PhysicalAreas, new Object[0]), arrayList, n);
    }

    public void printAdvancedAreaList(Player player, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            CuboidArea cuboidArea = entry.getValue();
            Location location = cuboidArea.getHighLoc();
            Location location2 = cuboidArea.getLowLoc();
            if (this.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.OnlyFalse)) {
                arrayList.add(this.plugin.msg(lm.Area_ListAll, entry.getKey(), 0, 0, 0, 0, 0, 0, cuboidArea.getSize()));
                continue;
            }
            arrayList.add(this.plugin.msg(lm.Area_ListAll, entry.getKey(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), location2.getBlockX(), location2.getBlockY(), location2.getBlockZ(), cuboidArea.getSize()));
        }
        this.plugin.getInfoPageManager().printInfo((CommandSender)player, "res area listall " + this.getName(), this.plugin.msg(lm.General_PhysicalAreas, new Object[0]), arrayList, n);
    }

    public String[] getAreaList() {
        String[] stringArray = new String[this.areas.size()];
        int n = 0;
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            stringArray[n] = entry.getKey();
            ++n;
        }
        return stringArray;
    }

    public int getZoneDepth() {
        int n = 0;
        ClaimedResidence claimedResidence = this.parent;
        while (claimedResidence != null) {
            ++n;
            claimedResidence = claimedResidence.getParent();
        }
        return n;
    }

    public Location getTeleportLocation(Player player) {
        if (this.tpLoc == null) {
            if (this.getMainArea() == null) {
                return null;
            }
            Location location = this.getMainArea().getLowLoc();
            Location location2 = this.getMainArea().getHighLoc();
            Location location3 = new Location(location.getWorld(), (double)((location.getBlockX() + location2.getBlockX()) / 2), (double)((location.getBlockY() + location2.getBlockY()) / 2), (double)((location.getBlockZ() + location2.getBlockZ()) / 2));
            return this.getMiddleFreeLoc(location3, player);
        }
        return this.tpLoc;
    }

    public void setTpLoc(Player player, boolean bl) {
        if (!this.perms.hasResidencePermission((CommandSender)player, false) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (!this.containsLoc(player.getLocation())) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
            return;
        }
        this.tpLoc = player.getLocation();
        this.plugin.msg((CommandSender)player, lm.Residence_SetTeleportLocation, new Object[0]);
    }

    public int isSafeTp(Player player) {
        if (player.getAllowFlight()) {
            return 0;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return 0;
        }
        if (this.plugin.getNms().isSpectator(player.getGameMode())) {
            return 0;
        }
        if (this.tpLoc == null) {
            return 0;
        }
        Location location = new Location(this.tpLoc.getWorld(), this.tpLoc.getX(), this.tpLoc.getY(), this.tpLoc.getZ());
        int n = (int)location.getY();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 255) {
            location.setY((double)(n - n3));
            Block block = location.getBlock();
            if (!ResidencePlayerListener.isEmptyBlock(block)) break;
            ++n2;
            ++n3;
        }
        return n2;
    }

    public void tpToResidence(Player player, Player player2, boolean bl) {
        int n;
        Object object;
        boolean bl2 = this.plugin.isResAdminOn(player);
        if (this.isRaidInitialized()) {
            if (this.getRaid().isAttacker(player2)) {
                this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
                return;
            }
            if (this.getRaid().isDefender(player2) && !ConfigManager.RaidDefenderTeleport) {
                this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
                return;
            }
            if (!bl) {
                this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            }
        } else if (!bl && !bl2 && !PermissionManager.ResPerm.bypass_tp.hasPermission((CommandSender)player, 10000L, new String[0]) && (!this.isOwner(player2) || this.isOwner(player2) && Residence.getInstance().getConfigManager().isCanTeleportIncludeOwner())) {
            ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            object = residencePlayer.getGroup();
            if (!((PermissionGroup)object).hasTpAccess()) {
                this.plugin.msg((CommandSender)player, lm.General_TeleportDeny, new Object[0]);
                return;
            }
            if (!player.equals(player2)) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
            if (!this.perms.playerHas(player, Flags.tp, FlagPermissions.FlagCombo.TrueOrNone)) {
                this.plugin.msg((CommandSender)player, lm.Residence_TeleportNoFlag, new Object[0]);
                return;
            }
            if (!this.perms.playerHas(player, Flags.move, FlagPermissions.FlagCombo.TrueOrNone)) {
                this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, this.getName());
                return;
            }
        }
        if (!this.plugin.getTeleportMap().containsKey(player2.getName()) && !bl2 && (n = this.isSafeTp(player)) > 6) {
            this.plugin.msg((CommandSender)player, lm.General_TeleportConfirm, n);
            this.plugin.getTeleportMap().put(player.getName(), this);
            return;
        }
        boolean bl3 = PermissionManager.ResPerm.tpdelaybypass.hasPermission((CommandSender)player2);
        if (!(this.plugin.getConfigManager().getTeleportDelay() <= 0 || bl2 || bl || bl3)) {
            this.plugin.msg((CommandSender)player, lm.General_TeleportStarted, this.getName(), this.plugin.getConfigManager().getTeleportDelay());
            if (this.plugin.getConfigManager().isTeleportTitleMessage()) {
                this.TpTimer(player, this.plugin.getConfigManager().getTeleportDelay());
            }
            this.plugin.getTeleportDelayMap().add(player.getName());
        }
        object = this.getTeleportLocation(player2);
        if (this.plugin.getConfigManager().getTeleportDelay() > 0 && !bl2 && !bl3) {
            this.performDelaydTp((Location)object, player2, player, true);
        } else {
            this.performInstantTp((Location)object, player2, player, true);
        }
    }

    public void TpTimer(final Player player, final int n) {
        TitleMessageManager.send(player, this.plugin.msg(lm.General_TeleportTitle, new Object[0]), this.plugin.msg(lm.General_TeleportTitleTime, n));
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!ClaimedResidence.this.plugin.getTeleportDelayMap().contains(player.getName())) {
                    return;
                }
                if (n > 1) {
                    ClaimedResidence.this.TpTimer(player, n - 1);
                }
            }
        }, 20L);
    }

    public void performDelaydTp(final Location location, final Player player, Player player2, final boolean bl) {
        ResidenceTPEvent residenceTPEvent = new ResidenceTPEvent(this, location, player, player2);
        this.plugin.getServ().getPluginManager().callEvent((Event)residenceTPEvent);
        if (residenceTPEvent.isCancelled()) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (location == null || player == null || !player.isOnline()) {
                    return;
                }
                if (!ClaimedResidence.this.plugin.getTeleportDelayMap().contains(player.getName()) && ClaimedResidence.this.plugin.getConfigManager().getTeleportDelay() > 0) {
                    return;
                }
                if (ClaimedResidence.this.plugin.getTeleportDelayMap().contains(player.getName())) {
                    ClaimedResidence.this.plugin.getTeleportDelayMap().remove(player.getName());
                }
                player.closeInventory();
                player.teleport(location);
                if (bl) {
                    ClaimedResidence.this.plugin.msg((CommandSender)player, lm.Residence_TeleportNear, new Object[0]);
                } else {
                    ClaimedResidence.this.plugin.msg((CommandSender)player, lm.General_TeleportSuccess, new Object[0]);
                }
            }
        }, (long)this.plugin.getConfigManager().getTeleportDelay() * 20L);
    }

    private void performInstantTp(Location location, Player player, Player player2, boolean bl) {
        ResidenceTPEvent residenceTPEvent = new ResidenceTPEvent(this, location, player, player2);
        this.plugin.getServ().getPluginManager().callEvent((Event)residenceTPEvent);
        if (!residenceTPEvent.isCancelled()) {
            player.closeInventory();
            boolean bl2 = player.teleport(location);
            if (bl2) {
                if (bl) {
                    this.plugin.msg((CommandSender)player, lm.Residence_TeleportNear, new Object[0]);
                } else {
                    this.plugin.msg((CommandSender)player, lm.General_TeleportSuccess, new Object[0]);
                }
            }
        }
    }

    public String getAreaIDbyLoc(Location location) {
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            if (!entry.getValue().containsLoc(location)) continue;
            return entry.getKey();
        }
        return null;
    }

    public CuboidArea getCuboidAreabyName(String string) {
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            if (!entry.getKey().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void removeArea(String string) {
        this.plugin.getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(string);
        this.plugin.getResidenceManager().calculateChunks(this.getName());
    }

    public void removeArea(Player player, String string, boolean bl) {
        if (this.getPermissions().hasResidencePermission((CommandSender)player, true) || bl) {
            if (!this.areas.containsKey(string)) {
                this.plugin.msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
                return;
            }
            if (this.areas.size() == 1 && !this.plugin.getConfigManager().allowEmptyResidences()) {
                this.plugin.msg((CommandSender)player, lm.Area_RemoveLast, new Object[0]);
                return;
            }
            ResidenceAreaDeleteEvent residenceAreaDeleteEvent = new ResidenceAreaDeleteEvent(player, this, player == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceAreaDeleteEvent);
            if (residenceAreaDeleteEvent.isCancelled()) {
                return;
            }
            this.removeArea(string);
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_Remove, new Object[0]);
            }
        } else if (player != null) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    public Map<String, Object> save() {
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (this.mainRes) {
            hashMap.put("MainResidence", this.mainRes);
        }
        if (this.createTime != 0L) {
            hashMap.put("CreatedOn", this.createTime);
        }
        if (this.isTopArea() && this.isUnderRaidCooldown()) {
            hashMap.put("LastRaid", this.getRaid().getEndsAt());
        }
        if (this.isTopArea() && this.getRaid().isImmune()) {
            hashMap.put("Immunity", this.getRaid().getImmunityUntil());
        }
        if (this.plugin.getConfigManager().isNewSaveMechanic()) {
            if (this.enterMessage != null && this.leaveMessage != null) {
                object2 = this.plugin.getResidenceManager().addMessageToTempCache(this.getWorld(), this.enterMessage, this.leaveMessage);
                if (object2 == null) {
                    if (this.enterMessage != null) {
                        hashMap.put("EnterMessage", this.enterMessage);
                    }
                    if (this.leaveMessage != null) {
                        hashMap.put("LeaveMessage", this.leaveMessage);
                    }
                } else {
                    hashMap.put("Messages", ((MinimizeMessages)object2).getId());
                }
            }
        } else {
            if (this.enterMessage != null) {
                hashMap.put("EnterMessage", this.enterMessage);
            }
            if (this.leaveMessage != null) {
                hashMap.put("LeaveMessage", this.leaveMessage);
            }
        }
        if (this.ShopDesc != null) {
            hashMap.put("ShopDescription", this.ShopDesc);
        }
        if (this.bank.getStoredMoneyD() != 0.0) {
            hashMap.put("StoredMoney", this.bank.getStoredMoneyD());
        }
        if (this.BlockSellPrice != 0.0) {
            hashMap.put("BlockSellPrice", this.BlockSellPrice);
        }
        if (!this.ChatPrefix.equals("")) {
            hashMap.put("ChatPrefix", this.ChatPrefix);
        }
        if (!this.ChannelColor.name().equals(this.plugin.getConfigManager().getChatColor().name()) && !this.ChannelColor.name().equals("WHITE")) {
            hashMap.put("ChannelColor", this.ChannelColor.name());
        }
        if (!(object2 = this.blacklist.save()).isEmpty()) {
            hashMap.put("BlackList", object2);
        }
        if (!(object2 = this.ignorelist.save()).isEmpty()) {
            hashMap.put("IgnoreList", object2);
        }
        if (this.plugin.getConfigManager().isNewSaveMechanic()) {
            for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
                hashMap2.put(entry.getKey(), entry.getValue().newSave());
            }
        } else {
            for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
                hashMap2.put(entry.getKey(), entry.getValue().save());
            }
        }
        hashMap.put("Areas", hashMap2);
        HashMap<String, Map<String, Object>> hashMap3 = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            hashMap3.put(entry.getValue().getResidenceName(), entry.getValue().save());
        }
        if (!hashMap3.isEmpty()) {
            hashMap.put("Subzones", hashMap3);
        }
        hashMap.put("Permissions", this.perms.save(this.getWorld()));
        if (!this.cmdBlackList.isEmpty()) {
            hashMap.put("cmdBlackList", this.cmdBlackList);
        }
        if (!this.cmdWhiteList.isEmpty()) {
            hashMap.put("cmdWhiteList", this.cmdWhiteList);
        }
        if (this.tpLoc != null) {
            if (this.plugin.getConfigManager().isNewSaveMechanic()) {
                hashMap.put("TPLoc", String.valueOf(ClaimedResidence.convertDouble(this.tpLoc.getX())) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getY()) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getZ()) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getPitch()) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getYaw()));
            } else {
                HashMap<String, Double> hashMap4 = new HashMap<String, Double>();
                hashMap4.put("X", ClaimedResidence.convertDouble(this.tpLoc.getX()));
                hashMap4.put("Y", ClaimedResidence.convertDouble(this.tpLoc.getY()));
                hashMap4.put("Z", ClaimedResidence.convertDouble(this.tpLoc.getZ()));
                hashMap4.put("Pitch", ClaimedResidence.convertDouble(this.tpLoc.getPitch()));
                hashMap4.put("Yaw", ClaimedResidence.convertDouble(this.tpLoc.getYaw()));
                hashMap.put("TPLoc", hashMap4);
            }
        }
        return hashMap;
    }

    private static double convertDouble(double d) {
        return ClaimedResidence.convertDouble(String.valueOf(d));
    }

    private static double convertDouble(String string) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.getDefault()));
        string = string.replace(",", ".");
        Double d = 0.0;
        try {
            d = Double.valueOf(string);
            d = Double.valueOf(decimalFormat.format(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static ClaimedResidence load(String string, Map<String, Object> map, ClaimedResidence claimedResidence, Residence residence) {
        ClaimedResidence claimedResidence2 = new ClaimedResidence(residence);
        if (map == null) {
            throw new Exception("Null residence!");
        }
        if (map.containsKey("CapitalizedName")) {
            claimedResidence2.resName = (String)map.get("CapitalizedName");
        }
        claimedResidence2.createTime = map.containsKey("CreatedOn") ? (Long)map.get("CreatedOn") : System.currentTimeMillis();
        if (map.containsKey("LastRaid")) {
            claimedResidence2.getRaid().setEndsAt((Long)map.get("LastRaid"));
        }
        if (map.containsKey("Immunity")) {
            claimedResidence2.getRaid().setImmunityUntil((Long)map.get("Immunity"));
        }
        if (map.containsKey("ShopDescription")) {
            claimedResidence2.setShopDesc((String)map.get("ShopDescription"));
        }
        if (map.containsKey("StoredMoney")) {
            if (map.get("StoredMoney") instanceof Double) {
                claimedResidence2.bank.setStoredMoney((Double)map.get("StoredMoney"));
            } else {
                claimedResidence2.bank.setStoredMoney(((Integer)map.get("StoredMoney")).intValue());
            }
        }
        if (map.containsKey("BlackList")) {
            claimedResidence2.blacklist = ResidenceItemList.load(residence, claimedResidence2, (Map)map.get("BlackList"));
        }
        if (map.containsKey("IgnoreList")) {
            claimedResidence2.ignorelist = ResidenceItemList.load(residence, claimedResidence2, (Map)map.get("IgnoreList"));
        }
        Map map2 = (Map)map.get("Areas");
        claimedResidence2.perms = ResidencePermissions.load(string, claimedResidence2, (Map)map.get("Permissions"));
        if (claimedResidence2.getPermissions().getOwnerLastKnownName() == null) {
            return null;
        }
        if (map.containsKey("MainResidence")) {
            claimedResidence2.mainRes = (Boolean)map.get("MainResidence");
        }
        claimedResidence2.BlockSellPrice = map.containsKey("BlockSellPrice") ? (Double)map.get("BlockSellPrice") : Double.valueOf(0.0);
        World world = residence.getServ().getWorld(claimedResidence2.perms.getWorld());
        if (world == null) {
            throw new Exception("Cant Find World: " + claimedResidence2.perms.getWorld());
        }
        for (Map.Entry object2 : map2.entrySet()) {
            if (object2.getValue() instanceof String) {
                claimedResidence2.areas.put((String)object2.getKey(), CuboidArea.newLoad((String)object2.getValue(), world));
                continue;
            }
            claimedResidence2.areas.put((String)object2.getKey(), CuboidArea.load((Map)object2.getValue(), world));
        }
        if (map.containsKey("Subzones")) {
            Map map3 = (Map)map.get("Subzones");
            for (Map.Entry entry : map3.entrySet()) {
                ClaimedResidence claimedResidence3 = ClaimedResidence.load(string, (Map)entry.getValue(), claimedResidence2, residence);
                if (claimedResidence3 == null) continue;
                if (claimedResidence3.getResidenceName() == null) {
                    claimedResidence3.setName((String)entry.getKey());
                }
                if (residence.getConfigManager().flagsInherit()) {
                    claimedResidence3.getPermissions().setParent(claimedResidence2.getPermissions());
                }
                if (claimedResidence3.getParent() != null && !claimedResidence3.getOwnerUUID().equals(claimedResidence3.getParent().getOwnerUUID())) {
                    residence.getPlayerManager().addResidence(claimedResidence3.getOwner(), claimedResidence3);
                }
                claimedResidence2.subzones.put(((String)entry.getKey()).toLowerCase(), claimedResidence3);
            }
        }
        if (map.containsKey("EnterMessage") && map.get("EnterMessage") instanceof String) {
            claimedResidence2.enterMessage = (String)map.get("EnterMessage");
        }
        if (map.containsKey("LeaveMessage") && map.get("LeaveMessage") instanceof String) {
            claimedResidence2.leaveMessage = (String)map.get("LeaveMessage");
        }
        if (map.containsKey("Messages") && map.get("Messages") instanceof Integer) {
            claimedResidence2.enterMessage = residence.getResidenceManager().getChacheMessageEnter(string, (Integer)map.get("Messages"));
            claimedResidence2.leaveMessage = residence.getResidenceManager().getChacheMessageLeave(string, (Integer)map.get("Messages"));
        }
        claimedResidence2.parent = claimedResidence;
        if (map.get("TPLoc") instanceof String) {
            String string2 = (String)map.get("TPLoc");
            double d = 0.0;
            double d2 = 0.0;
            try {
                String[] stringArray = string2.split(":");
                if (stringArray.length > 4) {
                    d2 = ClaimedResidence.convertDouble(stringArray[4]);
                }
                if (stringArray.length > 3) {
                    d = ClaimedResidence.convertDouble(stringArray[3]);
                }
                claimedResidence2.tpLoc = new Location(world, ClaimedResidence.convertDouble(stringArray[0]), ClaimedResidence.convertDouble(stringArray[1]), ClaimedResidence.convertDouble(stringArray[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            claimedResidence2.tpLoc.setPitch((float)d);
            claimedResidence2.tpLoc.setYaw((float)d2);
        } else {
            Map map4 = (Map)map.get("TPLoc");
            if (map4 != null) {
                double d = 0.0;
                double d3 = 0.0;
                if (map4.containsKey("Yaw")) {
                    d3 = ClaimedResidence.convertDouble(map4.get("Yaw").toString());
                }
                if (map4.containsKey("Pitch")) {
                    d = ClaimedResidence.convertDouble(map4.get("Pitch").toString());
                }
                claimedResidence2.tpLoc = new Location(world, ClaimedResidence.convertDouble(map4.get("X").toString()), ClaimedResidence.convertDouble(map4.get("Y").toString()), ClaimedResidence.convertDouble(map4.get("Z").toString()));
                claimedResidence2.tpLoc.setPitch((float)d);
                claimedResidence2.tpLoc.setYaw((float)d3);
            }
        }
        if (map.containsKey("cmdBlackList")) {
            claimedResidence2.cmdBlackList = (List)map.get("cmdBlackList");
        }
        if (map.containsKey("cmdWhiteList")) {
            claimedResidence2.cmdWhiteList = (List)map.get("cmdWhiteList");
        }
        if (map.containsKey("ChatPrefix")) {
            claimedResidence2.ChatPrefix = (String)map.get("ChatPrefix");
        }
        claimedResidence2.ChannelColor = map.containsKey("ChannelColor") ? ChatColor.valueOf((String)((String)map.get("ChannelColor"))) : residence.getConfigManager().getChatColor();
        return claimedResidence2;
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public boolean renameSubzone(String string, String string2) {
        return this.renameSubzone(null, string, string2, true);
    }

    public boolean renameSubzone(Player player, String string, String string2, boolean bl) {
        if (!this.plugin.validName(string2)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        String string3 = string2;
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        ClaimedResidence claimedResidence = this.subzones.get(string);
        if (claimedResidence == null) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Subzone, new Object[0]);
            }
            return false;
        }
        if (player != null && !claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return false;
        }
        if (this.subzones.containsKey(string2)) {
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Subzone_Exists, string2);
            }
            return false;
        }
        claimedResidence.setName(string3);
        this.subzones.put(string2, claimedResidence);
        this.subzones.remove(string);
        if (player != null) {
            this.plugin.msg((CommandSender)player, lm.Subzone_Rename, string, string2);
        }
        return true;
    }

    public boolean renameArea(String string, String string2) {
        return this.renameArea(null, string, string2, true);
    }

    public boolean renameArea(Player player, String string, String string2, boolean bl) {
        if (!this.plugin.validName(string2)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (this.isRaidInitialized() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return false;
        }
        if (player == null || this.perms.hasResidencePermission((CommandSender)player, true) || bl) {
            if (this.areas.containsKey(string2)) {
                if (player != null) {
                    this.plugin.msg((CommandSender)player, lm.Area_Exists, new Object[0]);
                }
                return false;
            }
            CuboidArea cuboidArea = this.areas.get(string);
            if (cuboidArea == null) {
                if (player != null) {
                    this.plugin.msg((CommandSender)player, lm.Area_InvalidName, new Object[0]);
                }
                return false;
            }
            this.areas.put(string2, cuboidArea);
            this.areas.remove(string);
            if (player != null) {
                this.plugin.msg((CommandSender)player, lm.Area_Rename, string, string2);
            }
            return true;
        }
        this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        return false;
    }

    public CuboidArea getArea(String string) {
        return this.areas.get(string);
    }

    public String getName() {
        String string = this.resName;
        if (this.getParent() != null) {
            string = String.valueOf(this.getParent().getName()) + "." + string;
        }
        if (string == null) {
            return "Unknown";
        }
        return string;
    }

    public void remove() {
        this.plugin.getResidenceManager().removeResidence(this);
        this.plugin.getResidenceManager().removeChunkList(this.getName());
        this.plugin.getPlayerManager().removeResFromPlayer(this);
    }

    public ResidenceBank getBank() {
        return this.bank;
    }

    public String getWorld() {
        return this.perms.getWorld();
    }

    public ResidencePlayer getRPlayer() {
        return this.plugin.getPlayerManager().getResidencePlayer(this.getPermissions().getOwner());
    }

    public PermissionGroup getOwnerGroup() {
        return this.getRPlayer().getGroup(this.getPermissions().getWorld());
    }

    public String getOwner() {
        return this.perms.getOwner();
    }

    public boolean isOwner(String string) {
        Player player = Bukkit.getPlayer((String)string);
        if (player != null) {
            return this.isOwner(player);
        }
        return this.perms.getOwner().equalsIgnoreCase(string);
    }

    public boolean isOwner(UUID uUID) {
        return this.perms.getOwnerUUID().toString().equals(uUID.toString());
    }

    public boolean isOwner(Player player) {
        if (player == null) {
            return false;
        }
        if (this.plugin.getConfigManager().isOfflineMode()) {
            return this.perms.getOwner().equals(player.getName());
        }
        return this.perms.getOwnerUUID().equals(player.getUniqueId());
    }

    public boolean isOwner(CommandSender commandSender) {
        if (this.plugin.getConfigManager().isOfflineMode()) {
            return this.perms.getOwner().equals(commandSender.getName());
        }
        if (commandSender instanceof Player) {
            return this.perms.getOwnerUUID().equals(((Player)commandSender).getUniqueId());
        }
        return true;
    }

    public void setChatPrefix(String string) {
        this.ChatPrefix = string;
    }

    public String getChatPrefix() {
        return this.ChatPrefix == null ? "" : this.ChatPrefix;
    }

    public void setChannelColor(ChatColor chatColor) {
        this.ChannelColor = chatColor;
    }

    public ChatChannel getChatChannel() {
        return this.plugin.getChatManager().getChannel(this.getName());
    }

    public ChatColor getChannelColor() {
        return this.ChannelColor;
    }

    public UUID getOwnerUUID() {
        return this.perms.getOwnerUUID();
    }

    public ResidenceItemList getItemBlacklist() {
        return this.blacklist;
    }

    public ResidenceItemList getItemIgnoreList() {
        return this.ignorelist;
    }

    public List<String> getCmdBlackList() {
        return this.cmdBlackList;
    }

    public List<String> getCmdWhiteList() {
        return this.cmdWhiteList;
    }

    public boolean addCmdBlackList(String string) {
        if (string.contains("/")) {
            string = string.replace("/", "");
        }
        if (!this.cmdBlackList.contains(string.toLowerCase())) {
            this.cmdBlackList.add(string.toLowerCase());
            return true;
        }
        this.cmdBlackList.remove(string.toLowerCase());
        return false;
    }

    public boolean addCmdWhiteList(String string) {
        if (string.contains("/")) {
            string = string.replace("/", "");
        }
        if (!this.cmdWhiteList.contains(string.toLowerCase())) {
            this.cmdWhiteList.add(string.toLowerCase());
            return true;
        }
        this.cmdWhiteList.remove(string.toLowerCase());
        return false;
    }

    public Double getBlockSellPrice() {
        return this.BlockSellPrice;
    }

    public ArrayList<Player> getPlayersInResidence() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.containsLoc(player.getLocation())) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public List<ShopVote> GetShopVotes() {
        return this.ShopVoteList;
    }

    public void clearShopVotes() {
        this.ShopVoteList.clear();
    }

    public void addShopVote(List<ShopVote> list2) {
        this.ShopVoteList.addAll(list2);
    }

    public void addShopVote(ShopVote shopVote) {
        this.ShopVoteList.add(shopVote);
    }

    public Long getLeaseExpireTime() {
        return this.leaseExpireTime;
    }

    public void setLeaseExpireTime(Long l) {
        this.leaseExpireTime = l;
    }

    public boolean kickFromResidence(Player player) {
        if (!this.containsLoc(player.getLocation())) {
            return false;
        }
        Location location = Residence.getInstance().getConfigManager().getKickLocation();
        player.closeInventory();
        if (location != null) {
            return player.teleport(location);
        }
        return player.teleport(this.getOutsideFreeLoc(player.getLocation(), player));
    }

    public boolean isUnderRaid() {
        return this.getRaid().getEndsAt() > System.currentTimeMillis() && this.getRaid().getStartsAt() < System.currentTimeMillis();
    }

    public boolean isRaidInitialized() {
        if (this.isUnderRaid() || this.isInPreRaid()) {
            return true;
        }
        if (this.getParent() != null) {
            return this.getParent().isRaidInitialized();
        }
        return false;
    }

    public boolean isInPreRaid() {
        return this.getRaid().getEndsAt() > System.currentTimeMillis() && this.getRaid().getStartsAt() > System.currentTimeMillis();
    }

    public boolean canRaid() {
        return !this.isUnderRaid() && this.getRaid().getCooldownEnd() < System.currentTimeMillis();
    }

    public ResidenceRaid getRaid() {
        if (this.raid == null) {
            this.raid = new ResidenceRaid(this);
        }
        return this.raid;
    }

    public boolean isUnderRaidCooldown() {
        return this.getRaid().getCooldownEnd() > System.currentTimeMillis();
    }

    public boolean preStartRaid(Player player) {
        if (this.isUnderRaid() || this.isInPreRaid()) {
            return false;
        }
        if (this.getRaid().getCooldownEnd() > System.currentTimeMillis()) {
            return false;
        }
        if (player != null) {
            this.getRaid().addAttacker(player);
        }
        this.getRaid().addDefender(this.getRPlayer().getPlayer());
        this.getRaid().setStartsAt(System.currentTimeMillis() + (long)(ConfigManager.PreRaidTimer * 1000));
        this.getRaid().setEndsAt(this.getRaid().getStartsAt() + (long)(ConfigManager.RaidTimer * 1000));
        ResidenceRaidPreStartEvent residenceRaidPreStartEvent = new ResidenceRaidPreStartEvent(this.getResidence(), this.getRaid().getAttackers());
        Bukkit.getPluginManager().callEvent((Event)residenceRaidPreStartEvent);
        if (residenceRaidPreStartEvent.isCancelled()) {
            return false;
        }
        if (player != null) {
            this.plugin.getPlayerManager().getResidencePlayer(player).setLastRaidAttackTimer(System.currentTimeMillis());
        }
        this.getRPlayer().setLastRaidDefendTimer(System.currentTimeMillis());
        this.getRaid().setImmunityUntil((long)ConfigManager.RaidCooldown * 1000L);
        return true;
    }

    public boolean startRaid() {
        if (!this.isUnderRaid() && !this.isInPreRaid()) {
            return false;
        }
        final ResidenceRaidStartEvent residenceRaidStartEvent = new ResidenceRaidStartEvent(this.getResidence(), this.getRaid().getAttackers());
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Bukkit.getPluginManager().callEvent((Event)residenceRaidStartEvent);
                if (residenceRaidStartEvent.isCancelled()) {
                    residenceRaidStartEvent.getRes().getRaid().endRaid();
                }
            }
        }, (this.getRaid().getStartsAt() - System.currentTimeMillis()) / 50L);
        this.repeatId = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!ClaimedResidence.this.isUnderRaid() && !ClaimedResidence.this.isInPreRaid()) {
                    Bukkit.getServer().getScheduler().cancelTask(ClaimedResidence.this.repeatId.intValue());
                    return;
                }
                ClaimedResidence.this.getRaid().showBossBar();
            }
        }, this.isUnderRaid() ? 20L : 0L, 20L);
        this.getRaid().setSchedId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ClaimedResidence.this.getRaid().endRaid();
            }
        }, (this.getRaid().getEndsAt() - System.currentTimeMillis()) / 50L));
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this == object;
    }

    public Set<Signs> getSignsInResidence() {
        return this.signsInResidence;
    }

    public void setSignsInResidence(Set<Signs> set2) {
        this.signsInResidence = set2;
    }

    public double getWorthByOwner() {
        return (double)((int)((double)this.getTotalSize() * this.getOwnerGroup().getCostPerBlock() * 100.0)) / 100.0;
    }

    public double getWorth() {
        return (double)((int)((double)this.getTotalSize() * this.getBlockSellPrice() * 100.0)) / 100.0;
    }

    public void showBounds(Player player, boolean bl) {
        Visualizer visualizer = new Visualizer(player);
        visualizer.setAreas(this.getAreaArray());
        visualizer.setOnce(bl);
        this.plugin.getSelectionManager().showBounds(player, visualizer);
    }

    private ClaimedResidence getResidence() {
        return this;
    }
}

