/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.persistance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.ReaderException;

public class YMLSaveHelper {
    File f;
    Yaml yml;
    Map<String, Object> root;

    public YMLSaveHelper(File file) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setAllowUnicode(true);
        this.yml = new Yaml(dumperOptions);
        this.root = new LinkedHashMap<String, Object>();
        if (file == null) {
            throw new IOException("YMLSaveHelper: null file...");
        }
        this.f = file;
    }

    public void save() {
        if (this.f.isFile()) {
            this.f.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.f);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        this.yml.dump(this.root, (Writer)outputStreamWriter);
        outputStreamWriter.close();
    }

    public void load() {
        FileInputStream fileInputStream = new FileInputStream(this.f);
        try {
            this.root = (Map)this.yml.load((InputStream)fileInputStream);
        }
        catch (ReaderException readerException) {
            System.out.println("[Residence] - Failed to load " + this.yml.getName() + " file!");
        }
        ((InputStream)fileInputStream).close();
    }

    public Map<String, Object> getRoot() {
        return this.root;
    }
}

