/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.PlayerGroup;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.BPermissionsAdapter;
import com.bekvon.bukkit.residence.permissions.LegacyPermissions;
import com.bekvon.bukkit.residence.permissions.LuckPerms4Adapter;
import com.bekvon.bukkit.residence.permissions.LuckPerms5Adapter;
import com.bekvon.bukkit.residence.permissions.OriginalPermissions;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionInfo;
import com.bekvon.bukkit.residence.permissions.PermissionsBukkitAdapter;
import com.bekvon.bukkit.residence.permissions.PermissionsInterface;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

public class PermissionManager {
    protected static PermissionsInterface perms;
    protected LinkedHashMap<String, PermissionGroup> groups;
    protected Map<String, String> playersGroup;
    protected FlagPermissions globalFlagPerms;
    protected HashMap<String, PlayerGroup> groupsMap = new HashMap();
    private PermissionGroup defaultGroup = null;
    private Residence plugin;
    private int autoCacheClearId = 0;
    private static final int cacheClearDelay = 600;
    private Runnable cacheClear = new Runnable(){

        @Override
        public void run() {
            PermissionManager.this.cache.clear();
        }
    };
    private HashMap<UUID, HashMap<String, PermissionInfo>> cache = new HashMap();

    public PermissionManager(Residence residence) {
        this.plugin = residence;
        try {
            this.groups = new LinkedHashMap();
            this.playersGroup = Collections.synchronizedMap(new HashMap());
            this.globalFlagPerms = new FlagPermissions();
            this.readConfig();
            this.checkPermissions();
        }
        catch (Exception exception) {
            Logger.getLogger(PermissionManager.class.getName()).log(Level.SEVERE, null, exception);
        }
    }

    public void startCacheClearScheduler() {
        this.autoCacheClearId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this.cacheClear, 12000L, 12000L);
    }

    public void stopCacheClearScheduler() {
        try {
            if (this.autoCacheClearId > 0) {
                Bukkit.getScheduler().cancelTask(this.autoCacheClearId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public FlagPermissions getAllFlags() {
        return this.globalFlagPerms;
    }

    public Map<String, String> getPlayersGroups() {
        return this.playersGroup;
    }

    public Map<String, PermissionGroup> getGroups() {
        return this.groups;
    }

    public PermissionGroup getDefaultGroup() {
        if (this.defaultGroup == null) {
            this.defaultGroup = this.groups.get(Residence.getInstance().getConfigManager().getDefaultGroup().toLowerCase());
        }
        return this.defaultGroup;
    }

    public PermissionGroup getGroupByName(String string) {
        if (!this.groups.containsKey(string = string.toLowerCase())) {
            return this.getDefaultGroup();
        }
        return this.groups.get(string);
    }

    public String getPermissionsGroup(Player player) {
        return this.getPermissionsGroup(player.getName(), player.getWorld().getName()).toLowerCase();
    }

    public String getPermissionsGroup(String string, String string2) {
        if (perms == null) {
            return this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        }
        try {
            return perms.getPlayerGroup(string, string2).toLowerCase();
        }
        catch (Exception exception) {
            return this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        }
    }

    public boolean isResidenceAdmin(CommandSender commandSender) {
        return ResPerm.admin.hasPermission(commandSender) || commandSender.isOp() && this.plugin.getConfigManager().getOpsAreAdmins();
    }

    private void checkPermissions() {
        ResidenceVaultAdapter residenceVaultAdapter;
        Server server2 = this.plugin.getServ();
        Plugin plugin = server2.getPluginManager().getPlugin("Vault");
        if (plugin != null) {
            residenceVaultAdapter = new ResidenceVaultAdapter(server2);
            if (residenceVaultAdapter.permissionsOK()) {
                perms = residenceVaultAdapter;
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Vault using permissions plugin:" + residenceVaultAdapter.getPermissionsName());
                return;
            }
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Vault, but Vault reported no usable permissions system...");
        }
        if ((plugin = server2.getPluginManager().getPlugin("PermissionsBukkit")) != null) {
            perms = new PermissionsBukkitAdapter((PermissionsPlugin)plugin);
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found PermissionsBukkit Plugin!");
            return;
        }
        residenceVaultAdapter = this.plugin.getServer().getPluginManager();
        Plugin plugin2 = residenceVaultAdapter.getPlugin("LuckPerms");
        if (plugin2 != null && plugin2.isEnabled()) {
            Integer n = this.plugin.getVersionChecker().convertVersion(plugin2.getDescription().getVersion());
            if (n >= 40000 && n < 50000) {
                perms = new LuckPerms4Adapter();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found LuckPerms4 Plugin!");
                return;
            }
            if (n > 50000) {
                perms = new LuckPerms5Adapter();
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found LuckPerms5 Plugin!");
                return;
            }
            this.plugin.consoleMessage("&cLuckPerms plugin was found but its outdated");
        }
        if ((plugin = server2.getPluginManager().getPlugin("bPermissions")) != null) {
            perms = new BPermissionsAdapter();
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found bPermissions Plugin!");
            return;
        }
        plugin = server2.getPluginManager().getPlugin("Permissions");
        if (plugin != null) {
            if (this.plugin.getConfigManager().useLegacyPermissions()) {
                perms = new LegacyPermissions(((Permissions)plugin).getHandler());
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Permissions Plugin!");
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + "Permissions running in Legacy mode!");
            } else {
                perms = new OriginalPermissions(((Permissions)plugin).getHandler());
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Found Permissions Plugin!");
            }
            return;
        }
        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Permissions plugin NOT FOUND!");
    }

    private void readConfig() {
        Set set2;
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
        String string = this.plugin.getConfigManager().getDefaultGroup().toLowerCase();
        this.globalFlagPerms = FlagPermissions.parseFromConfigNode("FlagPermission", yamlConfiguration2.getConfigurationSection("Global"));
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("Groups");
        if (configurationSection != null) {
            set2 = configurationSection.getKeys(false);
            int n = 0;
            for (Object object : set2) {
                try {
                    PermissionGroup permissionGroup = this.groups.getOrDefault(((String)object).toLowerCase(), new PermissionGroup(((String)object).toLowerCase(), null, this.globalFlagPerms, ++n));
                    permissionGroup.mirrorIn(configurationSection.getConfigurationSection((String)object));
                    this.groups.put(((String)object).toLowerCase(), permissionGroup);
                    List list2 = configurationSection.getConfigurationSection((String)object).getStringList("Mirror");
                    for (String string2 : list2) {
                        this.groups.put(string2.toLowerCase(), new PermissionGroup(string2.toLowerCase(), configurationSection.getConfigurationSection((String)object), this.globalFlagPerms, n));
                    }
                }
                catch (Exception exception) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Error parsing group from config:" + (String)object + " Exception:" + exception);
                }
            }
        }
        if (!this.groups.containsKey(string)) {
            this.groups.put(string, new PermissionGroup(string));
        }
        if (yamlConfiguration.isConfigurationSection("GroupAssignments") && (set2 = yamlConfiguration.getConfigurationSection("GroupAssignments").getKeys(false)) != null) {
            for (String string3 : set2) {
                this.playersGroup.put(string3.toLowerCase(), yamlConfiguration.getString("GroupAssignments." + string3, string).toLowerCase());
            }
        }
    }

    public boolean hasGroup(String string) {
        string = string.toLowerCase();
        return this.groups.containsKey(string);
    }

    public PermissionsInterface getPermissionsPlugin() {
        return perms;
    }

    public void removeFromCache(Player player) {
        this.cache.remove(player.getUniqueId());
    }

    public PermissionInfo getFromCache(Player player, String string) {
        HashMap<String, PermissionInfo> hashMap = this.cache.get(player.getUniqueId());
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string);
    }

    public PermissionInfo addToCache(Player player, String string, boolean bl, Long l) {
        HashMap<String, PermissionInfo> hashMap = this.cache.get(player.getUniqueId());
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        PermissionInfo permissionInfo = new PermissionInfo(string, l);
        permissionInfo.setLastChecked(System.currentTimeMillis());
        permissionInfo.setEnabled(bl);
        hashMap.put(string, permissionInfo);
        this.cache.put(player.getUniqueId(), hashMap);
        return permissionInfo;
    }

    public PermissionAttachmentInfo getSetPermission(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            for (PermissionAttachmentInfo permissionAttachmentInfo : ((Player)commandSender).getEffectivePermissions()) {
                if (!permissionAttachmentInfo.getPermission().equalsIgnoreCase(string)) continue;
                return permissionAttachmentInfo;
            }
        }
        return null;
    }

    public boolean isSetPermission(CommandSender commandSender, String string) {
        if (commandSender instanceof Player) {
            return this.isSetPermission((Player)commandSender, string);
        }
        return true;
    }

    public boolean isSetPermission(Player player, String string) {
        return player.hasPermission(new Permission(string, PermissionDefault.FALSE));
    }

    public static enum ResPerm {
        chatcolor("Allows to change residence chat color"),
        chatprefix("Allows to change residence chat prefix"),
        chatkick("Allows to kick player from residence chat"),
        permisiononerror("Allows to see missing permission on error message"),
        command_message_enter("Allows to change residence enter message"),
        command_message_leave("Allows to change residence leave message"),
        command_message_enter_remove("Allows to remove residence enter message"),
        command_message_leave_remove("Allows to remove residence leave message"),
        cleanbypass("Prevents residence from ebing removed on automatic cleanup"),
        worldguard_$1("Allows to create residence inside region", "region"),
        flag_$1("Gives access to defined flag", "flagName"),
        tpdelaybypass("Allows to bypass teleport delay"),
        backup("Allows to use backup flag to save residence into schematics"),
        admin_tp("Allows teleportation into residence where its not allowed"),
        topadmin("Defines as residence top admin"),
        admin("Defines as residence admin"),
        admin_move("Allows movement in residence where its not allowed"),
        newguyresidence("Creates residence on first chest place"),
        bypass_ignorey("Allows to ignore Y corrdiante restrictions"),
        bypass_ignoreyinsubzone("Allows to ignore subzone limitations"),
        bypass_destroy("Allows to bypass destroy flag"),
        bypass_build("Allows to bypass build flag"),
        bypass_container("Allows to bypass container flag"),
        bypass_use("Allows to bypass use flag"),
        bypass_door("Allows to bypass door flag"),
        bypass_button("Allows to bypass button flag"),
        bypass_fly("Allows to bypass fly flag"),
        bypass_nofly("Allows to bypass nofly flag"),
        bypass_tp("Allows to bypass command flag"),
        bypass_command("Allows to bypass command flag"),
        bypass_itempickup("Allows to bypass itempickup flag"),
        buy("Allows to buy residence"),
        sell("Allows to sell residence"),
        max_res_unlimited("Defines residence limit as unlimited"),
        max_res_$1("Defines residence limit", "number"),
        max_subzones_unlimited("Defines subzone limit as unlimited"),
        max_subzones_$1("Defines subzone limit", "number"),
        max_subzonedepth_unlimited("Defines subzone depth limit as unlimited"),
        max_subzonedepth_$1("Defines subzone depth limit", "number"),
        max_rents_unlimited("Defines residence rent limit as unlimited"),
        max_rents_$1("Defines residence rent limit", "number"),
        group_$1("Defines players residence group", "groupName"),
        market_evict("Allows to evict players from rented residences"),
        rename("Allows to rename residence"),
        select("Allows to select residence area"),
        select_auto_others("Allows to toggle auto selection for others"),
        resize("Allows to resize residence"),
        create("Allows to create residence"),
        create_subzone("Allows to create residence subzones"),
        randomtp("Allows to use rt command"),
        randomtp_admin("Allows to use rt command on another player"),
        randomtp_cooldownbypass("Allows to bypass random teleport command cooldown"),
        randomtp_delaybypass("Allows to bypass random teleport command delay"),
        delete("Allows to delete residence"),
        delete_subzone("Allows to delete subzone"),
        command_kick_bypass("Allows to bypass kick from residence"),
        command_contract_subzone("Allows to contract subzones"),
        command_expand_subzone("Allows to expand subzones"),
        versioncheck("Shows when we have new version of plugin"),
        command_$1("Gives access to particular command", "commandName"),
        command_$1_others("Allows to perform command on another player", "commandName");

        private Boolean show = true;
        private String desc;
        private String[] wars;
        private String fixedPermission = null;

        private ResPerm(String string2, Boolean bl) {
            this.desc = string2;
            this.show = bl;
        }

        private ResPerm(String string2) {
            this.desc = string2;
        }

        private ResPerm(String string2, String ... stringArray) {
            this.desc = string2;
            this.wars = stringArray;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String string) {
            this.desc = string;
        }

        public String getPermissionForShow() {
            return this.getPermissionForShow(false);
        }

        public String getPermissionForShow(boolean bl) {
            if (this.getWars() == null) {
                return this.getPermission("");
            }
            String[] stringArray = new String[this.getWars().length];
            int n = 0;
            while (n < this.getWars().length) {
                stringArray[n] = String.valueOf(Residence.getInstance().getLM().getMessage(lm.Permissions_variableColor, new Object[0])) + "[" + this.getWars()[n] + "]" + (!bl ? Residence.getInstance().getLM().getMessage(lm.Permissions_permissionColor, new Object[0]) : Residence.getInstance().getLM().getMessage(lm.Permissions_cmdPermissionColor, new Object[0]));
                ++n;
            }
            return this.getPermission(stringArray);
        }

        public String getPermission() {
            return this.getPermission("");
        }

        public String getPermission(String ... stringArray) {
            if (this.fixedPermission != null) {
                return this.fixedPermission;
            }
            String string = this.name().replace("_", ".");
            int n = 0;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                ++n;
                if (string2 != null && !string2.isEmpty()) {
                    string = string.replace("$" + n, string2.toLowerCase());
                }
                ++n3;
            }
            string = string.replace("$star", "*");
            if (!this.name().contains("$")) {
                this.fixedPermission = "residence." + string;
            }
            return "residence." + string;
        }

        public boolean hasPermission(CommandSender commandSender) {
            return this.hasPermission(commandSender, false, new String[0]);
        }

        public boolean hasPermission(CommandSender commandSender, Integer ... integerArray) {
            String[] stringArray = new String[integerArray.length];
            int n = 0;
            while (n < integerArray.length) {
                stringArray[n] = String.valueOf(integerArray[n]);
                ++n;
            }
            return this.hasPermission(commandSender, false, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, lm lm2) {
            return this.hasPermission(commandSender, true, true, null, lm2, new String[0]);
        }

        public boolean hasPermission(CommandSender commandSender, lm lm2, String ... stringArray) {
            return this.hasPermission(commandSender, true, true, null, lm2, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, Flags flags2) {
            return this.hasPermission(commandSender, false, flags2.toString());
        }

        public boolean hasPermission(CommandSender commandSender, String ... stringArray) {
            return this.hasPermission(commandSender, false, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, Long l, String ... stringArray) {
            return this.hasPermission(commandSender, false, true, l, null, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, boolean bl, String ... stringArray) {
            return this.hasPermission(commandSender, bl, true, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, boolean bl, boolean bl2, String ... stringArray) {
            return this.hasPermission(commandSender, bl, bl2, (Long)null, (lm)null, stringArray);
        }

        public boolean hasPermission(CommandSender commandSender, boolean bl, Long l) {
            return this.hasPermission(commandSender, bl, true, l, null, new String[0]);
        }

        public boolean hasPermission(CommandSender commandSender, boolean bl, boolean bl2, Long l, lm lm2, String ... stringArray) {
            if (commandSender == null) {
                return false;
            }
            if (!(commandSender instanceof Player)) {
                return true;
            }
            String string = this.getPermission(stringArray);
            Player player = (Player)commandSender;
            PermissionInfo permissionInfo = Residence.getInstance().getPermissionManager().getFromCache(player, string);
            boolean bl3 = false;
            if (permissionInfo != null && permissionInfo.getDelay() + permissionInfo.getLastChecked() > System.currentTimeMillis()) {
                bl3 = permissionInfo.isEnabled();
            } else {
                bl3 = commandSender.hasPermission(string);
                Residence.getInstance().getPermissionManager().addToCache(player, string, bl3, l == null ? 200L : l);
            }
            if (!bl3 && bl) {
                boolean bl4 = permisiononerror.hasPermission(commandSender, 50000L, new String[0]);
                RawMessage rawMessage = new RawMessage();
                rawMessage.add(Residence.getInstance().getLM().getMessage(lm2 == null ? lm.General_NoPermission : lm2, new Object[0]), bl4 ? string : null);
                rawMessage.show(commandSender);
                ResPerm.informConsole(commandSender, string, bl2);
            }
            return bl3;
        }

        private static void informConsole(CommandSender commandSender, String string, boolean bl) {
            if (bl) {
                ConsoleCommandSender consoleCommandSender = Bukkit.getServer().getConsoleSender();
                Residence.getInstance().msg((CommandSender)consoleCommandSender, Residence.getInstance().getLM().getMessage(lm.General_NoPermission, "[playerName]", commandSender.getName(), "[permission]", string));
            }
        }

        public boolean hasSetPermission(CommandSender commandSender, String ... stringArray) {
            return this.hasSetPermission(commandSender, false, stringArray);
        }

        public boolean hasSetPermission(CommandSender commandSender, boolean bl, String ... stringArray) {
            return ResPerm.hasSetPermission(commandSender, this.getPermission(stringArray), bl);
        }

        public static boolean hasSetPermission(CommandSender commandSender, String string, boolean bl) {
            boolean bl2 = Residence.getInstance().getPermissionManager().isSetPermission(commandSender, string);
            if (!bl2 && bl) {
                boolean bl3 = permisiononerror.hasPermission(commandSender);
                RawMessage rawMessage = new RawMessage();
                rawMessage.add(Residence.getInstance().getLM().getMessage(lm.General_NoPermission, new Object[0]), bl3 ? string : null);
                rawMessage.show(commandSender);
                ResPerm.informConsole(commandSender, string, true);
            }
            return bl2;
        }

        public String[] getWars() {
            return this.wars;
        }

        public void setWars(String[] stringArray) {
            this.wars = stringArray;
        }

        public Boolean getShow() {
            return this.show;
        }

        public void setShow(Boolean bl) {
            this.show = bl;
        }

        public static boolean hasPermission(CommandSender commandSender, String string, Boolean bl) {
            return ResPerm.hasPermission(commandSender, string, bl, true);
        }

        public static boolean hasPermission(CommandSender commandSender, String string, Boolean bl, boolean bl2) {
            if (!(commandSender instanceof Player)) {
                return true;
            }
            Player player = (Player)commandSender;
            if (player.hasPermission(string)) {
                return true;
            }
            if (bl.booleanValue()) {
                boolean bl3 = permisiononerror.hasPermission(commandSender);
                RawMessage rawMessage = new RawMessage();
                rawMessage.add(Residence.getInstance().getLM().getMessage(lm.General_NoPermission, new Object[0]), bl3 ? string : null);
                rawMessage.show(commandSender);
                ResPerm.informConsole(commandSender, string, bl2);
            }
            return false;
        }
    }
}

