/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class PermissionGroup {
    private int xmax = 0;
    private int ymax = 0;
    private int zmax = 0;
    private int xmin = 0;
    private int ymin = 0;
    private int zmin = 0;
    protected int Subzonexmax = 0;
    protected int Subzoneymax = 0;
    protected int Subzonezmax = 0;
    protected int Subzonexmin = 0;
    protected int Subzoneymin = 0;
    protected int Subzonezmin = 0;
    protected int resmax = 0;
    private double costperarea = 0.0;
    private double sellperarea = 0.0;
    protected boolean tpaccess = false;
    protected int subzonedepth = 0;
    protected int maxSubzones = 3;
    protected FlagPermissions flagPerms = new FlagPermissions();
    protected Map<String, Boolean> creatorDefaultFlags = new HashMap<String, Boolean>();
    protected Map<String, Map<String, Boolean>> groupDefaultFlags;
    protected Map<String, Boolean> residenceDefaultFlags = new HashMap<String, Boolean>();
    protected boolean messageperms = false;
    protected String defaultEnterMessage = null;
    protected String defaultLeaveMessage = null;
    private int maxLeaseTime = 16;
    private int leaseGiveTime = 14;
    protected double renewcostperarea = 0.02;
    protected boolean canBuy = false;
    protected boolean canSell = false;
    protected boolean buyIgnoreLimits = false;
    protected boolean cancreate = false;
    protected String groupname;
    protected int maxPhysical = 2;
    protected boolean unstuck = false;
    protected boolean kick = false;
    protected int minHeight = 0;
    protected int maxHeight = 256;
    protected int maxRents = 0;
    protected int MaxRentDays = -1;
    protected int maxRentables = 0;
    protected boolean selectCommandAccess = true;
    protected boolean itemListAccess = true;
    protected int priority = 0;

    public PermissionGroup(String string) {
        this.groupDefaultFlags = new HashMap<String, Map<String, Boolean>>();
        this.groupname = string;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public PermissionGroup(String string, ConfigurationSection configurationSection) {
        this(string);
        this.parseGroup(configurationSection);
    }

    public PermissionGroup(String string, ConfigurationSection configurationSection, FlagPermissions flagPermissions) {
        this(string, configurationSection);
        this.flagPerms.setParent(flagPermissions);
    }

    public PermissionGroup(String string, ConfigurationSection configurationSection, FlagPermissions flagPermissions, int n) {
        this(string, configurationSection);
        this.flagPerms.setParent(flagPermissions);
        this.priority = n;
    }

    public void mirrorIn(ConfigurationSection configurationSection) {
        this.parseGroup(configurationSection);
    }

    private void parseGroup(ConfigurationSection configurationSection) {
        boolean bl;
        Object object3;
        Object object2;
        if (configurationSection == null) {
            return;
        }
        if (configurationSection.contains("Residence.CanCreate")) {
            this.cancreate = configurationSection.getBoolean("Residence.CanCreate", false);
        }
        if (configurationSection.contains("Residence.MaxResidences")) {
            this.resmax = configurationSection.getInt("Residence.MaxResidences", 0);
        }
        if (configurationSection.contains("Residence.MaxAreasPerResidence")) {
            this.maxPhysical = configurationSection.getInt("Residence.MaxAreasPerResidence", 2);
        }
        if (configurationSection.contains("Residence.MaxEastWest")) {
            this.xmax = configurationSection.getInt("Residence.MaxEastWest", 0);
        }
        if (configurationSection.contains("Residence.MinEastWest")) {
            this.xmin = configurationSection.getInt("Residence.MinEastWest", 0);
        }
        int n = this.xmin = this.getXmin() > this.getXmax() ? this.getXmax() : this.getXmin();
        if (configurationSection.contains("Residence.MaxUpDown")) {
            this.ymax = configurationSection.getInt("Residence.MaxUpDown", 0);
        }
        if (configurationSection.contains("Residence.MinUpDown")) {
            this.ymin = configurationSection.getInt("Residence.MinUpDown", 0);
        }
        int n2 = this.ymin = this.ymin > this.ymax ? this.ymax : this.ymin;
        if (Residence.getInstance().getConfigManager().isSelectionIgnoreY()) {
            this.ymin = 0;
            this.ymax = 256;
        }
        if (configurationSection.contains("Residence.MaxNorthSouth")) {
            this.zmax = configurationSection.getInt("Residence.MaxNorthSouth", 0);
        }
        if (configurationSection.contains("Residence.MinNorthSouth")) {
            this.zmin = configurationSection.getInt("Residence.MinNorthSouth", 0);
        }
        int n3 = this.zmin = this.zmin > this.zmax ? this.zmax : this.zmin;
        if (configurationSection.contains("Residence.MinHeight")) {
            this.minHeight = configurationSection.getInt("Residence.MinHeight", 0);
        }
        if (configurationSection.contains("Residence.MaxHeight")) {
            this.maxHeight = configurationSection.getInt("Residence.MaxHeight", 256);
        }
        if (configurationSection.contains("Residence.CanTeleport")) {
            this.tpaccess = configurationSection.getBoolean("Residence.CanTeleport", false);
        }
        if (configurationSection.contains("Residence.MaxSubzonesInArea")) {
            this.maxSubzones = configurationSection.getInt("Residence.MaxSubzonesInArea", 3);
        }
        if (configurationSection.contains("Residence.SubzoneDepth")) {
            this.subzonedepth = configurationSection.getInt("Residence.SubzoneDepth", 0);
        }
        if (configurationSection.contains("Residence.SubzoneMaxEastWest")) {
            this.Subzonexmax = configurationSection.getInt("Residence.SubzoneMaxEastWest", this.getXmax());
        }
        int n4 = this.Subzonexmax = this.getXmax() < this.Subzonexmax ? this.getXmax() : this.Subzonexmax;
        if (configurationSection.contains("Residence.SubzoneMinEastWest")) {
            this.Subzonexmin = configurationSection.getInt("Residence.SubzoneMinEastWest", 0);
        }
        int n5 = this.Subzonexmin = this.Subzonexmin > this.Subzonexmax ? this.Subzonexmax : this.Subzonexmin;
        if (configurationSection.contains("Residence.SubzoneMaxUpDown")) {
            this.Subzoneymax = configurationSection.getInt("Residence.SubzoneMaxUpDown", this.ymax);
        }
        int n6 = this.Subzoneymax = this.ymax < this.Subzoneymax ? this.ymax : this.Subzoneymax;
        if (configurationSection.contains("Residence.SubzoneMinUpDown")) {
            this.Subzoneymin = configurationSection.getInt("Residence.SubzoneMinUpDown", 0);
        }
        int n7 = this.Subzoneymin = this.Subzoneymin > this.Subzoneymax ? this.Subzoneymax : this.Subzoneymin;
        if (configurationSection.contains("Residence.SubzoneMaxNorthSouth")) {
            this.Subzonezmax = configurationSection.getInt("Residence.SubzoneMaxNorthSouth", this.zmax);
        }
        int n8 = this.Subzonezmax = this.zmax < this.Subzonezmax ? this.zmax : this.Subzonezmax;
        if (configurationSection.contains("Residence.SubzoneMinNorthSouth")) {
            this.Subzonezmin = configurationSection.getInt("Residence.SubzoneMinNorthSouth", 0);
        }
        int n9 = this.Subzonezmin = this.Subzonezmin > this.Subzonezmax ? this.Subzonezmax : this.Subzonezmin;
        if (configurationSection.contains("Messaging.CanChange")) {
            this.messageperms = configurationSection.getBoolean("Messaging.CanChange", false);
        }
        if (configurationSection.contains("Messaging.DefaultEnter")) {
            this.defaultEnterMessage = configurationSection.getString("Messaging.DefaultEnter", null);
        }
        if (configurationSection.contains("Messaging.DefaultLeave")) {
            this.defaultLeaveMessage = configurationSection.getString("Messaging.DefaultLeave", null);
        }
        if (configurationSection.contains("Lease.MaxDays")) {
            this.maxLeaseTime = configurationSection.getInt("Lease.MaxDays", 16);
        }
        if (configurationSection.contains("Lease.RenewIncrement")) {
            this.leaseGiveTime = configurationSection.getInt("Lease.RenewIncrement", 14);
        }
        if (configurationSection.contains("Rent.MaxRents")) {
            this.maxRents = configurationSection.getInt("Rent.MaxRents", 0);
        }
        if (configurationSection.contains("Rent.MaxRentDays")) {
            this.MaxRentDays = configurationSection.getInt("Rent.MaxRentDays", -1);
        }
        if (configurationSection.contains("Rent.MaxRentables")) {
            this.maxRentables = configurationSection.getInt("Rent.MaxRentables", 0);
        }
        if (configurationSection.contains("Economy.RenewCost")) {
            this.renewcostperarea = configurationSection.getDouble("Economy.RenewCost", 0.02);
        }
        if (configurationSection.contains("Economy.CanBuy")) {
            this.canBuy = configurationSection.getBoolean("Economy.CanBuy", false);
        }
        if (configurationSection.contains("Economy.CanSell")) {
            this.canSell = configurationSection.getBoolean("Economy.CanSell", false);
        }
        if (configurationSection.contains("Economy.IgnoreLimits")) {
            this.buyIgnoreLimits = configurationSection.getBoolean("Economy.IgnoreLimits", false);
        }
        if (configurationSection.contains("Economy.BuyCost")) {
            this.costperarea = configurationSection.getDouble("Economy.BuyCost", 0.0);
        }
        if (configurationSection.contains("Economy.SellCost")) {
            this.sellperarea = configurationSection.getDouble("Economy.SellCost", 0.0);
        }
        if (configurationSection.isBoolean("Economy.Unstuck")) {
            this.unstuck = configurationSection.getBoolean("Residence.Unstuck", false);
        }
        if (configurationSection.contains("Residence.Kick")) {
            this.kick = configurationSection.getBoolean("Residence.Kick", false);
        }
        if (configurationSection.contains("Residence.SelectCommandAccess")) {
            this.selectCommandAccess = configurationSection.getBoolean("Residence.SelectCommandAccess", true);
        }
        if (configurationSection.contains("Residence.ItemListAccess")) {
            this.itemListAccess = configurationSection.getBoolean("Residence.ItemListAccess", true);
        }
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("Flags.Permission");
        Set set2 = null;
        if (configurationSection2 != null) {
            set2 = configurationSection2.getKeys(false);
        }
        if (set2 != null) {
            object2 = set2.iterator();
            while (object2.hasNext()) {
                bl = configurationSection.getBoolean("Flags.Permission." + (String)(object3 = (String)object2.next()), false);
                this.flagPerms.setFlag((String)object3, bl ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE);
            }
        }
        if ((configurationSection2 = configurationSection.getConfigurationSection("Flags.CreatorDefault")) != null) {
            set2 = configurationSection2.getKeys(false);
        }
        if (set2 != null) {
            for (Object object3 : set2) {
                bl = configurationSection.getBoolean("Flags.CreatorDefault." + (String)object3, false);
                this.creatorDefaultFlags.put((String)object3, bl);
            }
        }
        if ((configurationSection2 = configurationSection.getConfigurationSection("Flags.Default")) != null) {
            set2 = configurationSection2.getKeys(false);
        }
        if (set2 != null) {
            for (Object object3 : set2) {
                bl = configurationSection.getBoolean("Flags.Default." + (String)object3, false);
                this.residenceDefaultFlags.put((String)object3, bl);
            }
        }
        configurationSection2 = configurationSection.getConfigurationSection("Flags.GroupDefault");
        object2 = null;
        if (configurationSection2 != null) {
            object2 = configurationSection2.getKeys(false);
        }
        if (object2 != null) {
            object3 = object2.iterator();
            while (object3.hasNext()) {
                String string = (String)object3.next();
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                set2 = configurationSection.getConfigurationSection("Flags.GroupDefault." + string).getKeys(false);
                for (String string2 : set2) {
                    boolean bl2 = configurationSection.getBoolean("Flags.GroupDefault." + string + "." + string2, false);
                    hashMap.put(string2, bl2);
                }
                this.groupDefaultFlags.put(string, hashMap);
            }
        }
    }

    public String getGroupName() {
        return this.groupname;
    }

    public int getMaxX() {
        return this.getXmax();
    }

    public int getMaxY() {
        return this.ymax;
    }

    public int getMaxZ() {
        return this.zmax;
    }

    public int getMinX() {
        return this.getXmin();
    }

    public int getMinY() {
        return this.ymin;
    }

    public int getMinZ() {
        return this.zmin;
    }

    public int getSubzoneMaxX() {
        return this.Subzonexmax;
    }

    public int getSubzoneMaxY() {
        return this.Subzoneymax;
    }

    public int getSubzoneMaxZ() {
        return this.Subzonezmax;
    }

    public int getSubzoneMinX() {
        return this.Subzonexmin;
    }

    public int getSubzoneMinY() {
        return this.Subzoneymin;
    }

    public int getSubzoneMinZ() {
        return this.Subzonezmin;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxZones() {
        return this.resmax;
    }

    public double getCostPerBlock() {
        return this.costperarea;
    }

    public double getSellPerBlock() {
        return this.sellperarea;
    }

    public boolean hasTpAccess() {
        return this.tpaccess;
    }

    public int getMaxSubzoneDepth() {
        return this.subzonedepth;
    }

    public int getMaxSubzones() {
        return this.maxSubzones;
    }

    public boolean canSetEnterLeaveMessages() {
        return this.messageperms;
    }

    public String getDefaultEnterMessage() {
        return this.defaultEnterMessage;
    }

    public String getDefaultLeaveMessage() {
        return this.defaultLeaveMessage;
    }

    public int getMaxLeaseTime() {
        return this.maxLeaseTime;
    }

    public int getLeaseGiveTime() {
        return this.leaseGiveTime;
    }

    public double getLeaseRenewCost() {
        return this.renewcostperarea;
    }

    public boolean canBuyLand() {
        return this.canBuy;
    }

    public boolean canSellLand() {
        return this.canSell;
    }

    public int getMaxRents() {
        return this.maxRents;
    }

    public int getMaxRentDays() {
        return this.MaxRentDays;
    }

    public int getMaxRentables() {
        return this.maxRentables;
    }

    public boolean buyLandIgnoreLimits() {
        return this.buyIgnoreLimits;
    }

    public boolean hasUnstuckAccess() {
        return this.unstuck;
    }

    public boolean hasKickAccess() {
        return this.kick;
    }

    public int getMaxPhysicalPerResidence() {
        return this.maxPhysical;
    }

    public Set<Map.Entry<String, Boolean>> getDefaultResidenceFlags() {
        return this.residenceDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Boolean>> getDefaultCreatorFlags() {
        return this.creatorDefaultFlags.entrySet();
    }

    public Set<Map.Entry<String, Map<String, Boolean>>> getDefaultGroupFlags() {
        return this.groupDefaultFlags.entrySet();
    }

    public boolean canCreateResidences() {
        return this.cancreate;
    }

    public boolean hasFlagAccess(Flags flags2) {
        return this.flagPerms.has(flags2, false);
    }

    @Deprecated
    public boolean hasFlagAccess(String string) {
        return this.flagPerms.has(string, false);
    }

    public boolean selectCommandAccess() {
        return this.selectCommandAccess;
    }

    public boolean itemListAccess() {
        return this.itemListAccess;
    }

    public void printLimits(CommandSender commandSender, OfflinePlayer offlinePlayer, boolean bl) {
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(offlinePlayer.getName());
        residencePlayer.forceUpdateGroup();
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        Residence.getInstance().msg(commandSender, lm.General_Separator, new Object[0]);
        Residence.getInstance().msg(commandSender, lm.Limits_PGroup, Residence.getInstance().getPermissionManager().getPermissionsGroup(offlinePlayer.getName(), offlinePlayer.isOnline() ? Bukkit.getPlayer((String)offlinePlayer.getName()).getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld()));
        Residence.getInstance().msg(commandSender, lm.Limits_RGroup, permissionGroup.getGroupName());
        if (offlinePlayer.isOnline() && bl) {
            Residence.getInstance().msg(commandSender, lm.Limits_Admin, Residence.getInstance().getPermissionManager().isResidenceAdmin(commandSender));
        }
        Residence.getInstance().msg(commandSender, lm.Limits_CanCreate, permissionGroup.canCreateResidences());
        Residence.getInstance().msg(commandSender, lm.Limits_MaxRes, residencePlayer.getMaxRes());
        Residence.getInstance().msg(commandSender, lm.Limits_NumberOwn, residencePlayer.getResAmount());
        Residence.getInstance().msg(commandSender, lm.Limits_MaxEW, String.valueOf(permissionGroup.xmin) + "-" + permissionGroup.xmax);
        Residence.getInstance().msg(commandSender, lm.Limits_MaxNS, String.valueOf(permissionGroup.zmin) + "-" + permissionGroup.zmax);
        Residence.getInstance().msg(commandSender, lm.Limits_MaxUD, String.valueOf(permissionGroup.ymin) + "-" + permissionGroup.ymax);
        Residence.getInstance().msg(commandSender, lm.Limits_MinMax, permissionGroup.minHeight, permissionGroup.maxHeight);
        Residence.getInstance().msg(commandSender, lm.Limits_MaxSubzones, residencePlayer.getMaxSubzones());
        Residence.getInstance().msg(commandSender, lm.Limits_MaxSubDepth, residencePlayer.getMaxSubzoneDepth());
        Residence.getInstance().msg(commandSender, lm.Limits_MaxRents, String.valueOf(residencePlayer.getMaxRents()) + (this.getMaxRentDays() != -1 ? Residence.getInstance().msg(lm.Limits_MaxRentDays, this.getMaxRentDays()) : ""));
        Residence.getInstance().msg(commandSender, lm.Limits_EnterLeave, permissionGroup.messageperms);
        if (Residence.getInstance().getEconomyManager() != null) {
            Residence.getInstance().msg(commandSender, lm.Limits_Cost, permissionGroup.costperarea);
            Residence.getInstance().msg(commandSender, lm.Limits_Sell, permissionGroup.sellperarea);
        }
        Residence.getInstance().msg(commandSender, lm.Limits_Flag, permissionGroup.flagPerms.listFlags());
        if (Residence.getInstance().getConfigManager().useLeases()) {
            Residence.getInstance().msg(commandSender, lm.Limits_MaxDays, permissionGroup.maxLeaseTime);
            Residence.getInstance().msg(commandSender, lm.Limits_LeaseTime, permissionGroup.leaseGiveTime);
            Residence.getInstance().msg(commandSender, lm.Limits_RenewCost, permissionGroup.renewcostperarea);
        }
        Residence.getInstance().msg(commandSender, lm.General_Separator, new Object[0]);
    }

    public double getCostperarea() {
        return this.costperarea;
    }

    public double getSellperarea() {
        return this.sellperarea;
    }

    public int getXmin() {
        return this.xmin;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getZmin() {
        return this.zmin;
    }

    public int getYmin() {
        return this.ymin;
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getZmax() {
        return this.zmax;
    }
}

