/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;

public class SpigotListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemDamage(PlayerItemDamageEvent playerItemDamageEvent) {
        if (Residence.getInstance().isDisabledWorldListener(playerItemDamageEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerItemDamageEvent.getPlayer();
        Location location = player.getLocation();
        FlagPermissions flagPermissions = Residence.getInstance().getPermsByLoc(location);
        if (!flagPermissions.has(Flags.nodurability, false)) {
            return;
        }
        ItemStack itemStack = Residence.getInstance().getNms().itemInMainHand(player);
        if (itemStack.getType() == Material.AIR || itemStack.getDurability() <= 0) {
            return;
        }
        if (itemStack.getType().toString().equalsIgnoreCase("TRIDENT")) {
            return;
        }
        itemStack.setDurability(itemStack.getDurability());
        player.setItemInHand(itemStack);
        playerItemDamageEvent.setDamage(0);
        playerItemDamageEvent.setCancelled(true);
    }
}

