/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarManager;
import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.cmiLib.TitleMessageManager;
import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.StuckInfo;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResidencePlayerListener
implements Listener {
    protected Map<UUID, ClaimedResidence> currentRes;
    protected Map<UUID, Long> lastUpdate;
    protected Map<UUID, Location> lastOutsideLoc;
    protected Map<UUID, StuckInfo> stuckTeleportCounter;
    protected int minUpdateTime;
    protected boolean chatenabled;
    protected Set<UUID> playerToggleChat = new HashSet<UUID>();
    private Residence plugin;
    HashMap<UUID, Long> informar = new HashMap();
    private static /* synthetic */ int[] $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags;

    public ResidencePlayerListener(Residence residence) {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = residence.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = residence.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.plugin = residence;
    }

    public void reload() {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = this.plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = this.plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler
    public void onJump(PlayerMoveEvent playerMoveEvent) {
        if (!Flags.jump3.isGlobalyEnabled() && !Flags.jump2.isGlobalyEnabled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (player.isFlying()) {
            return;
        }
        if (playerMoveEvent.getTo().getY() - playerMoveEvent.getFrom().getY() != (double)0.42f) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(player.getLocation());
        if (Flags.jump2.isGlobalyEnabled() && flagPermissions.has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.3)));
        } else if (Flags.jump3.isGlobalyEnabled() && flagPermissions.has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.6)));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent playerPickupItemEvent) {
        if (!Flags.itempickup.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(playerPickupItemEvent.getItem().getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (playerPickupItemEvent.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!claimedResidence.getPermissions().playerHas(playerPickupItemEvent.getPlayer(), Flags.itempickup, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_itempickup.hasPermission((CommandSender)playerPickupItemEvent.getPlayer(), 10000L, new String[0])) {
            return;
        }
        playerPickupItemEvent.setCancelled(true);
        playerPickupItemEvent.getItem().setPickupDelay(this.plugin.getConfigManager().getItemPickUpDelay() * 20);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerDropItemEvent playerDropItemEvent) {
        if (!Flags.itemdrop.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(playerDropItemEvent.getPlayer().getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (playerDropItemEvent.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!claimedResidence.getPermissions().playerHas(playerDropItemEvent.getPlayer(), Flags.itemdrop, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        playerDropItemEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerGlobalChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (this.plugin.isDisabledWorldListener(asyncPlayerChatEvent.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (residencePlayer == null) {
            return;
        }
        if (residencePlayer.getResList().isEmpty()) {
            return;
        }
        ClaimedResidence claimedResidence = residencePlayer.getMainResidence();
        if (claimedResidence == null) {
            return;
        }
        String string = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", claimedResidence.getTopParentName());
        String string2 = asyncPlayerChatEvent.getFormat();
        string2 = string2.replace("%1$s", String.valueOf(string) + "%1$s");
        asyncPlayerChatEvent.setFormat(string2);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerChatGlobalLow(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        this.procEvent(asyncPlayerChatEvent);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    private void processNEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        this.procEvent(asyncPlayerChatEvent);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void processHEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        this.procEvent(asyncPlayerChatEvent);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void processHHEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        this.procEvent(asyncPlayerChatEvent);
    }

    private void procEvent(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (this.plugin.isDisabledWorldListener(asyncPlayerChatEvent.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        String string = asyncPlayerChatEvent.getFormat();
        if (!string.contains("{residence}")) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (residencePlayer == null) {
            return;
        }
        ClaimedResidence claimedResidence = residencePlayer.getMainResidence();
        String string2 = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", claimedResidence == null ? "" : claimedResidence.getTopParentName());
        if (string2.equalsIgnoreCase(" ")) {
            string2 = "";
        }
        string = string.replace("{residence}", string2);
        asyncPlayerChatEvent.setFormat(string);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackup(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.backup.toString())) {
            return;
        }
        Player player = residenceFlagChangeEvent.getPlayer();
        if (!this.plugin.getConfigManager().RestoreAfterRentEnds) {
            return;
        }
        if (!this.plugin.getConfigManager().SchematicsSaveOnFlagChange) {
            return;
        }
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        if (player != null && !PermissionManager.ResPerm.backup.hasPermission((CommandSender)player)) {
            residenceFlagChangeEvent.setCancelled(true);
        } else {
            this.plugin.getSchematicManager().save(residenceFlagChangeEvent.getResidence());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackupRename(ResidenceRenameEvent residenceRenameEvent) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().rename(residenceRenameEvent.getResidence(), residenceRenameEvent.getNewResidenceName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent residenceDeleteEvent) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().delete(residenceDeleteEvent.getResidence());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFirstLogin(PlayerLoginEvent playerLoginEvent) {
        Player player = playerLoginEvent.getPlayer();
        if (!player.hasPlayedBefore()) {
            ResidenceBlockListener.newPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent playerLoginEvent) {
        if (!this.plugin.getConfigManager().isRentInformOnEnding()) {
            return;
        }
        final Player player = playerLoginEvent.getPlayer();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                List<String> list2 = ResidencePlayerListener.this.plugin.getRentManager().getRentedLandsList(player.getName());
                if (list2.isEmpty()) {
                    return;
                }
                for (String string : list2) {
                    RentedLand rentedLand = ResidencePlayerListener.this.plugin.getRentManager().getRentedLand(string);
                    if (rentedLand == null || rentedLand.AutoPay || rentedLand.endTime - System.currentTimeMillis() >= (long)(ResidencePlayerListener.this.plugin.getConfigManager().getRentInformBefore() * 60 * 24 * 7)) continue;
                    ResidencePlayerListener.this.plugin.msg((CommandSender)player, lm.Residence_EndingRent, string, GetTime.getTime(rentedLand.endTime));
                }
            }
        }, (long)this.plugin.getConfigManager().getRentInformDelay() * 20L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent playerFishEvent) {
        if (!Flags.hook.isGlobalyEnabled()) {
            return;
        }
        if (playerFishEvent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerFishEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerFishEvent.getPlayer();
        if (playerFishEvent.getCaught() == null) {
            return;
        }
        if (this.plugin.getNms().isArmorStandEntity(playerFishEvent.getCaught().getType()) || playerFishEvent.getCaught() instanceof Boat || playerFishEvent.getCaught() instanceof LivingEntity) {
            FlagPermissions flagPermissions = this.plugin.getPermsByLoc(playerFishEvent.getCaught().getLocation());
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(playerFishEvent.getCaught().getLocation());
            if (flagPermissions.has(Flags.hook, FlagPermissions.FlagCombo.OnlyFalse)) {
                playerFishEvent.setCancelled(true);
                if (claimedResidence != null) {
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.hook, claimedResidence.getName()});
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeDayNight(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.day.toString()) && !residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.night.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.resetPlayerTime();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.day.toString())) {
                    for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                        player.setPlayerTime(6000L, false);
                    }
                }
                if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.night.toString())) break;
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setPlayerTime(14000L, false);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeGlow(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.glow.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                if (!Version.isCurrentEqualOrHigher(Version.v1_9_R1) || !residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.glow.toString())) break;
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setGlowing(false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.glow.toString()) || !Version.isCurrentEqualOrHigher(Version.v1_9_R1)) break;
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setGlowing(true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDeleteEvent(ResidenceDeleteEvent residenceDeleteEvent) {
        if (residenceDeleteEvent.isCancelled()) {
            return;
        }
        ClaimedResidence claimedResidence = residenceDeleteEvent.getResidence();
        if (claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceDeleteEvent.getResidence().getPlayersInResidence()) {
                player.setWalkSpeed(0.2f);
            }
        }
        if (claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceDeleteEvent.getResidence().getPlayersInResidence()) {
                player.resetPlayerWeather();
            }
        }
        if (residenceDeleteEvent.getPlayer() != null && claimedResidence.getPermissions().playerHas(residenceDeleteEvent.getPlayer(), Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceDeleteEvent.getResidence().getPlayersInResidence()) {
                this.fly(player, false);
            }
        }
        if (claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && Version.isCurrentEqualOrHigher(Version.v1_9_R1)) {
            for (Player player : residenceDeleteEvent.getResidence().getPlayersInResidence()) {
                player.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.plugin.getPermissionManager().removeFromCache(player);
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setWalkSpeed(0.2f);
        }
        if (claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.resetPlayerWeather();
        }
        if (claimedResidence.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            this.fly(player, false);
        }
        if (claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && Version.isCurrentEqualOrHigher(Version.v1_9_R1)) {
            player.setGlowing(false);
        }
        this.plugin.getPlayerManager().getResidencePlayer(player).onQuit();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.wspeed1.toString()) && !residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setWalkSpeed(0.2f);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.wspeed1.toString())) {
                    for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                        player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
                    }
                    if (!residenceFlagChangeEvent.getResidence().getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    residenceFlagChangeEvent.getResidence().getPermissions().setFlag(Flags.wspeed2.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) break;
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
                }
                if (!residenceFlagChangeEvent.getResidence().getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) break;
                residenceFlagChangeEvent.getResidence().getPermissions().setFlag(Flags.wspeed1.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceOwnerChangeEvent residenceOwnerChangeEvent) {
        if (residenceOwnerChangeEvent.isCancelled()) {
            return;
        }
        ClaimedResidence claimedResidence = residenceOwnerChangeEvent.getResidence();
        if (claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceOwnerChangeEvent.getResidence().getPlayersInResidence()) {
                player.setWalkSpeed(0.2f);
            }
        }
        if (claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceOwnerChangeEvent.getResidence().getPlayersInResidence()) {
                player.resetPlayerWeather();
            }
        }
        if (claimedResidence.getPermissions().has(Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player player : residenceOwnerChangeEvent.getResidence().getPlayersInResidence()) {
                this.fly(player, false);
            }
        }
        if (claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && Version.isCurrentEqualOrHigher(Version.v1_9_R1)) {
            for (Player player : residenceOwnerChangeEvent.getResidence().getPlayersInResidence()) {
                player.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeJump(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.jump2.toString()) && !residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.jump3.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: 
            case INVALID: {
                break;
            }
            case TRUE: {
                if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.jump2.toString())) {
                    if (!residenceFlagChangeEvent.getResidence().getPermissions().has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    residenceFlagChangeEvent.getResidence().getPermissions().setFlag(Flags.jump3.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.jump3.toString()) || !residenceFlagChangeEvent.getResidence().getPermissions().has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                residenceFlagChangeEvent.getResidence().getPermissions().setFlag(Flags.jump2.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeSunRain(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.sun.toString()) && !residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.rain.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.resetPlayerWeather();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.sun.toString())) {
                    for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                        player.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
                if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.rain.toString())) break;
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    player.setPlayerWeather(WeatherType.DOWNFALL);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeFly(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        if (residenceFlagChangeEvent.isCancelled()) {
            return;
        }
        if (!residenceFlagChangeEvent.getFlag().equalsIgnoreCase(Flags.fly.toString())) {
            return;
        }
        switch (residenceFlagChangeEvent.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    this.fly(player, false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                for (Player player : residenceFlagChangeEvent.getResidence().getPlayersInResidence()) {
                    this.fly(player, true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        String string;
        if (!Flags.command.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerCommandPreprocessEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        ClaimedResidence claimedResidence = this.getCurrentResidence(player.getUniqueId());
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.getPermissions().playerHas(player, Flags.command, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_command.hasPermission((CommandSender)player, 10000L, new String[0])) {
            return;
        }
        String string2 = playerCommandPreprocessEvent.getMessage().replace(" ", "_").toLowerCase();
        int n = 0;
        int n2 = 0;
        for (String string3 : claimedResidence.getCmdWhiteList()) {
            string = string3.toLowerCase();
            if (!string2.startsWith("/" + string)) continue;
            if (string.contains("_") && string.split("_").length > n) {
                n = string.split("_").length;
                continue;
            }
            if (n != 0) continue;
            n = 1;
        }
        for (String string3 : claimedResidence.getCmdBlackList()) {
            string = string3.toLowerCase();
            if (!string2.startsWith("/" + string)) continue;
            if (string2.contains("_")) {
                n2 = string.split("_").length;
                break;
            }
            n2 = 1;
            break;
        }
        if (n2 == 0) {
            for (String string3 : claimedResidence.getCmdBlackList()) {
                string = string3.toLowerCase();
                if (!string.equalsIgnoreCase("*")) continue;
                if (!string2.contains("_")) break;
                n2 = string2.split("_").length;
                break;
            }
        }
        if (n != 0 && n >= n2 || n2 == 0) {
            return;
        }
        playerCommandPreprocessEvent.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.command, claimedResidence.getName()});
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null || !CMIMaterial.isSign(block.getType())) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = block.getLocation();
        Signs signs = this.plugin.getSignUtil().getSigns().getResSign(location);
        if (signs == null) {
            return;
        }
        ClaimedResidence claimedResidence = signs.getResidence();
        boolean bl = claimedResidence.isForSell();
        boolean bl2 = claimedResidence.isForRent();
        String string = claimedResidence.getName();
        if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (bl) {
                Bukkit.dispatchCommand((CommandSender)player, (String)("res market buy " + string));
                return;
            }
            if (bl2) {
                if (claimedResidence.isRented() && player.isSneaking()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market release " + string));
                } else {
                    boolean bl3 = true;
                    if (player.isSneaking()) {
                        bl3 = false;
                    }
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market rent " + string + " " + bl3));
                }
                return;
            }
        } else if (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK && bl2 && claimedResidence.isRented() && this.plugin.getRentManager().getRentingPlayer(claimedResidence).equals(player.getName())) {
            this.plugin.getRentManager().payRent(player, claimedResidence, false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent signChangeEvent) {
        Object object;
        if (this.plugin.isDisabledWorldListener(signChangeEvent.getPlayer().getWorld())) {
            return;
        }
        Block block = signChangeEvent.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (!CMIChatColor.stripColor(signChangeEvent.getLine(0)).equalsIgnoreCase(this.plugin.msg(lm.Sign_TopLine, new Object[0]))) {
            return;
        }
        Signs signs = new Signs();
        Location location = sign.getLocation();
        Player player = signChangeEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence claimedResidence = null;
        if (!signChangeEvent.getLine(1).equalsIgnoreCase("")) {
            object = signChangeEvent.getLine(1);
            if (!signChangeEvent.getLine(2).equalsIgnoreCase("")) {
                object = String.valueOf(object) + "." + signChangeEvent.getLine(2);
            }
            if (!signChangeEvent.getLine(3).equalsIgnoreCase("")) {
                object = String.valueOf(object) + "." + signChangeEvent.getLine(3);
            }
            if ((claimedResidence = this.plugin.getResidenceManager().getByName((String)object)) == null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return;
            }
        } else {
            claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        }
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        object = claimedResidence;
        signs.setResidence(claimedResidence);
        signs.setLocation(location);
        this.plugin.getSignUtil().getSigns().addSign(signs);
        this.plugin.getSignUtil().saveSigns();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable((ClaimedResidence)object){
            private final /* synthetic */ ClaimedResidence val$residence;
            {
                this.val$residence = claimedResidence;
            }

            @Override
            public void run() {
                ResidencePlayerListener.this.plugin.getSignUtil().CheckSign(this.val$residence);
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignDestroy(BlockBreakEvent blockBreakEvent) {
        if (this.plugin.isDisabledWorldListener(blockBreakEvent.getPlayer().getWorld())) {
            return;
        }
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        if (block == null) {
            return;
        }
        if (!CMIMaterial.isSign(block.getType())) {
            return;
        }
        Location location = block.getLocation();
        if (blockBreakEvent.getPlayer().hasMetadata("NPC")) {
            return;
        }
        Signs signs = this.plugin.getSignUtil().getSigns().getResSign(location);
        if (signs == null) {
            return;
        }
        this.plugin.getSignUtil().getSigns().removeSign(signs);
        if (signs.getResidence() != null) {
            signs.getResidence().getSignsInResidence().remove(signs);
        }
        this.plugin.getSignUtil().saveSigns();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        String string = playerQuitEvent.getPlayer().getName();
        this.currentRes.remove(playerQuitEvent.getPlayer().getUniqueId());
        this.lastUpdate.remove(playerQuitEvent.getPlayer().getUniqueId());
        this.lastOutsideLoc.remove(playerQuitEvent.getPlayer().getUniqueId());
        this.plugin.getChatManager().removeFromChannel(string);
        this.plugin.getPlayerListener().removePlayerResidenceChat(playerQuitEvent.getPlayer());
        this.plugin.addOfflinePlayerToChache((OfflinePlayer)playerQuitEvent.getPlayer());
        this.plugin.getAutoSelectionManager().getList().remove(playerQuitEvent.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        ClaimedResidence claimedResidence;
        if (!Flags.nofly.isGlobalyEnabled()) {
            return;
        }
        Player player = playerChangedWorldEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        if (!(!player.getAllowFlight() && !player.isFlying() || !flagPermissions.has(Flags.nofly, false) || this.plugin.isResAdminOn(player) || PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0]) || (claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation())) != null && claimedResidence.isOwner(player))) {
            Location location = player.getLocation();
            Location location2 = new Location(location.getWorld(), location.getX(), (double)location.getBlockY(), location.getZ());
            location2.setPitch(location.getPitch());
            location2.setYaw(location.getYaw());
            int n = location2.getBlockY();
            int n2 = location2.getWorld().getHighestBlockAt(location2).getLocation().getBlockY() + 3;
            if (location2.getWorld().getEnvironment() == World.Environment.NETHER) {
                n2 = 100;
            }
            int n3 = 0;
            while (n3 < n2) {
                location2.setY((double)(n - n3));
                Block block = location2.getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block)) {
                    location2.setY((double)(n - n3 + 1));
                    break;
                }
                if (location2.getBlockY() <= 0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location2.getWorld().getName()});
                    return;
                }
                ++n3;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location2.getWorld().getName()});
            player.closeInventory();
            player.teleport(location2);
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        this.lastUpdate.put(player.getUniqueId(), 0L);
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            this.plugin.turnResAdminOn(player);
        }
        this.handleNewLocation(player, player.getLocation(), true);
        this.plugin.getPlayerManager().playerJoin(player);
        if (PermissionManager.ResPerm.versioncheck.hasPermission((CommandSender)player)) {
            this.plugin.getVersionChecker().VersionCheck(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSpawn(PlayerRespawnEvent playerRespawnEvent) {
        if (this.plugin.isDisabledWorldListener(playerRespawnEvent.getRespawnLocation().getWorld())) {
            return;
        }
        Location location = playerRespawnEvent.getRespawnLocation();
        Boolean bl = playerRespawnEvent.isBedSpawn();
        Player player = playerRespawnEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (bl.booleanValue()) {
            location = player.getWorld().getSpawnLocation();
        }
        if ((claimedResidence = this.plugin.getResidenceManager().getByLoc(location)) != null && claimedResidence.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            location = claimedResidence.getOutsideFreeLoc(location, player);
        }
        this.plugin.msg((CommandSender)player, lm.General_NoSpawn, new Object[0]);
        playerRespawnEvent.setRespawnLocation(location);
    }

    private boolean isContainer(Material material2, Block block) {
        return FlagPermissions.getMaterialUseFlagList().containsKey(material2) && FlagPermissions.getMaterialUseFlagList().get(material2).equals((Object)Flags.container) || this.plugin.getConfigManager().getCustomContainers().contains((Object)CMIMaterial.get(block));
    }

    private boolean isCanUseEntity_RClickOnly(Material material2, Block block) {
        switch (material2.name()) {
            case "REDSTONE_COMPARATOR": 
            case "DIODE_BLOCK_OFF": 
            case "CRAFTING_TABLE": 
            case "DAYLIGHT_DETECTOR": 
            case "REDSTONE_COMPARATOR_OFF": 
            case "REDSTONE_COMPARATOR_ON": 
            case "DIODE_BLOCK_ON": 
            case "ITEM_FRAME": 
            case "WORKBENCH": 
            case "COMPARATOR": 
            case "CAKE_BLOCK": 
            case "BED_BLOCK": 
            case "DAMAGED_ANVIL": 
            case "CAKE": 
            case "ANVIL": 
            case "DIODE": 
            case "REPEATER": 
            case "ENCHANTING_TABLE": 
            case "LECTERN": 
            case "DAYLIGHT_DETECTOR_INVERTED": 
            case "FLOWER_POT": 
            case "BREWING_STAND": 
            case "ENCHANTMENT_TABLE": 
            case "COMMAND": 
            case "CHIPPED_ANVIL": 
            case "BEACON": {
                return true;
            }
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(material2);
        if (cMIMaterial != null && cMIMaterial.isPotted()) {
            return true;
        }
        return this.plugin.getConfigManager().getCustomRightClick().contains((Object)CMIMaterial.get(block));
    }

    public static boolean isCanUseEntity_BothClick(Material material2, Block block) {
        CMIMaterial cMIMaterial = CMIMaterial.get(material2);
        if (cMIMaterial.isDoor()) {
            return true;
        }
        if (cMIMaterial.isButton()) {
            return true;
        }
        if (cMIMaterial.isGate()) {
            return true;
        }
        if (cMIMaterial.isTrapDoor()) {
            return true;
        }
        switch (cMIMaterial) {
            case DRAGON_EGG: 
            case LEVER: 
            case NOTE_BLOCK: 
            case PISTON: 
            case STICKY_PISTON: {
                return true;
            }
        }
        return Residence.getInstance().getConfigManager().getCustomBothClick().contains((Object)CMIMaterial.get(block));
    }

    public static boolean isEmptyBlock(Block block) {
        CMIMaterial cMIMaterial = CMIMaterial.get(block);
        switch (cMIMaterial) {
            case COBWEB: 
            case ITEM_FRAME: 
            case PAINTING: 
            case STRING: 
            case TRIPWIRE: 
            case TRIPWIRE_HOOK: 
            case VINE: 
            case WALL_SIGN: {
                return true;
            }
        }
        if (cMIMaterial.isSapling()) {
            return true;
        }
        if (cMIMaterial.isAir()) {
            return true;
        }
        return cMIMaterial.isButton();
    }

    private boolean isCanUseEntity(Material material2, Block block) {
        return ResidencePlayerListener.isCanUseEntity_BothClick(material2, block) || this.isCanUseEntity_RClickOnly(material2, block);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFireInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block.getRelative(playerInteractEvent.getBlockFace());
        if (block2 == null) {
            return;
        }
        if (block2.getType() != Material.FIRE) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean bl = flagPermissions.playerHas(player, Flags.place, flagPermissions.playerHas(player, Flags.build, true));
        if (bl) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlatePress(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        CMIMaterial cMIMaterial = CMIMaterial.get(block);
        if (!this.plugin.isResAdminOn(player)) {
            boolean bl = flagPermissions.playerHas(player, Flags.use, true);
            boolean bl2 = flagPermissions.playerHas(player, Flags.pressure, bl);
            if (!((bl || bl2) && bl2 || !cMIMaterial.isPlate() || PermissionManager.ResPerm.bypass_use.hasPermission((CommandSender)player, 10000L, new String[0]))) {
                playerInteractEvent.setCancelled(true);
            }
        }
        if (!(flagPermissions.playerHas(player, Flags.trample, flagPermissions.playerHas(player, Flags.build, true)) || cMIMaterial != CMIMaterial.FARMLAND && cMIMaterial != CMIMaterial.SOUL_SAND)) {
            playerInteractEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSelection(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        CMIMaterial cMIMaterial = CMIMaterial.get(player.getItemInHand());
        if (cMIMaterial != this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (this.plugin.getWorldEditTool() == this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            playerInteractEvent.setCancelled(true);
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        boolean bl = this.plugin.isResAdminOn(player);
        if (PermissionManager.ResPerm.select.hasPermission((CommandSender)player) || PermissionManager.ResPerm.create.hasPermission((CommandSender)player) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || permissionGroup.canCreateResidences() && !PermissionManager.ResPerm.create.hasSetPermission((CommandSender)player, new String[0]) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || bl) {
            Block block = playerInteractEvent.getClickedBlock();
            if (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location location = block.getLocation();
                this.plugin.getSelectionManager().placeLoc1(player, location, true);
                this.plugin.msg((CommandSender)player, lm.Select_PrimaryPoint, this.plugin.msg(lm.General_CoordsTop, location.getBlockX(), location.getBlockY(), location.getBlockZ()));
                playerInteractEvent.setCancelled(true);
            } else if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && this.plugin.getNms().isMainHand(playerInteractEvent)) {
                Location location = block.getLocation();
                this.plugin.getSelectionManager().placeLoc2(player, location, true);
                this.plugin.msg((CommandSender)player, lm.Select_SecondaryPoint, this.plugin.msg(lm.General_CoordsBottom, location.getBlockX(), location.getBlockY(), location.getBlockZ()));
                playerInteractEvent.setCancelled(true);
            }
            if (this.plugin.getSelectionManager().hasPlacedBoth(player)) {
                this.plugin.getSelectionManager().showSelectionInfoInActionBar(player);
                this.plugin.getSelectionManager().updateLocations(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInfoCheck(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null) {
            return;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(itemStack);
        if (cMIMaterial != this.plugin.getConfigManager().getInfoTool()) {
            return;
        }
        if (this.isContainer(block.getType(), block)) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (claimedResidence != null) {
            this.plugin.getResidenceManager().printAreaInfo(claimedResidence.getName(), (CommandSender)player, false);
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_NoResHere, new Object[0]);
        }
        playerInteractEvent.setCancelled(true);
    }

    private static boolean placingMinecart(Block block, ItemStack itemStack) {
        return block != null && block.getType().name().contains("RAIL") && itemStack != null && itemStack.getType().name().contains("MINECART");
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent var1_1) {
        block30: {
            block31: {
                block34: {
                    block33: {
                        block32: {
                            if (var1_1.getPlayer() == null) {
                                return;
                            }
                            if (this.plugin.isDisabledWorldListener(var1_1.getPlayer().getWorld())) {
                                return;
                            }
                            var2_2 = var1_1.getPlayer();
                            var3_3 = var1_1.getClickedBlock();
                            if (var3_3 == null) {
                                return;
                            }
                            var4_4 = var1_1.getItem();
                            var5_5 = CMIMaterial.get(var4_4);
                            var6_6 = var3_3.getType();
                            if (!(var1_1.getAction() == Action.PHYSICAL || (this.isContainer(var6_6, var3_3) || this.isCanUseEntity_RClickOnly(var6_6, var3_3)) && var1_1.getAction() == Action.RIGHT_CLICK_BLOCK || ResidencePlayerListener.isCanUseEntity_BothClick(var6_6, var3_3) || var5_5.equals((Object)this.plugin.getConfigManager().getSelectionTool()) || var5_5.equals((Object)this.plugin.getConfigManager().getInfoTool()) || var5_5.isDye() || var5_5.equals((Object)CMIMaterial.ARMOR_STAND) || var5_5.isBoat() || ResidencePlayerListener.placingMinecart(var3_3, var4_4))) {
                                return;
                            }
                            if (var1_1.getAction() != Action.LEFT_CLICK_BLOCK && var1_1.getAction() != Action.RIGHT_CLICK_BLOCK) {
                                return;
                            }
                            var7_7 = this.plugin.isResAdminOn(var2_2);
                            if (var7_7) {
                                return;
                            }
                            if (var5_5.isValidItem() && !this.plugin.getItemManager().isAllowed(var5_5.getMaterial(), this.plugin.getPlayerManager().getResidencePlayer(var2_2).getGroup(), var2_2.getWorld().getName())) {
                                this.plugin.msg((CommandSender)var2_2, lm.General_ItemBlacklisted, new Object[0]);
                                var1_1.setCancelled(true);
                                return;
                            }
                            var8_8 = CMIMaterial.get(var3_3);
                            var9_9 = this.plugin.getPermsByLocForPlayer(var3_3.getLocation(), var2_2);
                            if (var1_1.getAction() == Action.RIGHT_CLICK_BLOCK) {
                                if (var5_5.isDye()) {
                                    var10_10 = CMIMaterial.get(var3_3);
                                    if ((var5_5.equals((Object)CMIMaterial.BONE_MEAL) && (var10_10 == CMIMaterial.GRASS_BLOCK || var10_10 == CMIMaterial.GRASS || var10_10.isSapling()) || var5_5 == CMIMaterial.COCOA_BEANS && var8_8 == CMIMaterial.JUNGLE_WOOD) && !(var9_9 = this.plugin.getPermsByLocForPlayer(var3_3.getRelative(var1_1.getBlockFace()).getLocation(), var2_2)).playerHas(var2_2, Flags.build, true)) {
                                        this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.build});
                                        var1_1.setCancelled(true);
                                        return;
                                    }
                                }
                                if ((var5_5.equals((Object)CMIMaterial.ARMOR_STAND) || var5_5.isBoat()) && !(var9_9 = this.plugin.getPermsByLocForPlayer(var3_3.getRelative(var1_1.getBlockFace()).getLocation(), var2_2)).playerHas(var2_2, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.build});
                                    var1_1.setCancelled(true);
                                    return;
                                }
                                if (ResidencePlayerListener.placingMinecart(var3_3, var4_4) && !(var9_9 = this.plugin.getPermsByLocForPlayer(var3_3.getLocation(), var2_2)).playerHas(var2_2, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.build});
                                    var1_1.setCancelled(true);
                                    return;
                                }
                            }
                            if (!this.isContainer(var6_6, var3_3) && !this.isCanUseEntity(var6_6, var3_3)) break block30;
                            var10_11 = var9_9.playerHas(var2_2, Flags.use, true);
                            var11_12 = this.plugin.getResidenceManager().getByLoc(var3_3.getLocation());
                            if (var11_12 != null && var11_12.isUnderRaid() && var11_12.getRaid().isDefender(var2_2) && !ConfigManager.RaidDefenderContainerUsage && (var12_13 = FlagPermissions.getMaterialUseFlagList().get(var6_6)) != null && var12_13.equals((Object)Flags.container)) {
                                var1_1.setCancelled(true);
                                this.plugin.msg((CommandSender)var2_2, lm.Raid_cantDo, new Object[0]);
                                return;
                            }
                            if (var11_12 != null && var11_12.isOwner(var2_2) || (var12_13 = FlagPermissions.getMaterialUseFlagList().get(var6_6)) == null || var9_9.playerHas(var2_2, var12_13, var10_11)) break block31;
                            if (!var10_11 && !var12_13.equals((Object)Flags.container)) break block32;
                            if (var11_12 == null || !var11_12.isUnderRaid() || !var11_12.getRaid().isAttacker(var2_2)) {
                                if (!PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)var2_2, 10000L, new String[0])) {
                                    var1_1.setCancelled(true);
                                    this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{var12_13});
                                }
                                return;
                            }
                            break block31;
                        }
                        if (var1_1.getAction() != Action.RIGHT_CLICK_BLOCK) break block33;
                        if (var11_12 != null && var11_12.isUnderRaid() && var11_12.getRaid().isAttacker(var2_2)) break block31;
                        switch (ResidencePlayerListener.$SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags()[var12_13.ordinal()]) {
                            case 33: {
                                if (!PermissionManager.ResPerm.bypass_door.hasPermission((CommandSender)var2_2, 10000L, new String[0])) ** GOTO lbl64
                                break block31;
                            }
                            case 13: {
                                if (PermissionManager.ResPerm.bypass_button.hasPermission((CommandSender)var2_2, 10000L, new String[0])) break block31;
                            }
lbl64:
                            // 3 sources

                            default: {
                                var1_1.setCancelled(true);
                                this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{var12_13});
                                return;
                            }
                            {
                                break block31;
                            }
                        }
                    }
                    if (!ResidencePlayerListener.isCanUseEntity_BothClick(var6_6, var3_3)) break block34;
                    if (var11_12 != null && var11_12.isUnderRaid() && var11_12.getRaid().isAttacker(var2_2)) break block31;
                    var1_1.setCancelled(true);
                    this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{var12_13});
                }
                return;
            }
            if (!(!this.plugin.getConfigManager().getCustomContainers().contains((Object)var8_8) || var9_9.playerHas(var2_2, Flags.container, var10_11) && PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)var2_2, 10000L, new String[0]))) {
                var1_1.setCancelled(true);
                this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.container});
                return;
            }
            if (this.plugin.getConfigManager().getCustomBothClick().contains((Object)var8_8) && !var10_11) {
                var1_1.setCancelled(true);
                this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.use});
                return;
            }
            if (this.plugin.getConfigManager().getCustomRightClick().contains((Object)var8_8) && var1_1.getAction() == Action.RIGHT_CLICK_BLOCK && !var10_11) {
                var1_1.setCancelled(true);
                this.plugin.msg((CommandSender)var2_2, lm.Flag_Deny, new Object[]{Flags.use});
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTradeEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (entity.getType() != EntityType.VILLAGER) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence != null && claimedResidence.getPermissions().playerHas(player, Flags.trade, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.trade, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    private static boolean canRide(EntityType entityType) {
        switch (entityType.name().toLowerCase()) {
            case "donkey": 
            case "pig": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    private static boolean canHaveContainer(EntityType entityType) {
        switch (entityType.name().toLowerCase()) {
            case "donkey": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithHorse(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (!ResidencePlayerListener.canHaveContainer(entity.getType())) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        boolean bl = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!bl && !claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse) && player.isSneaking()) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithRidable(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (!ResidencePlayerListener.canRide(entity.getType())) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.isOwner(player) && !claimedResidence.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.TrueOrNone)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecartStorage(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (entity.getType() != EntityType.MINECART_CHEST && entity.getType() != EntityType.MINECART_HOPPER) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        boolean bl = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!bl && !claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecart(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (entity.getType() != EntityType.MINECART && entity.getType() != EntityType.BOAT) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDyeSheep(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!Flags.dye.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (entity.getType() != EntityType.SHEEP) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.dye, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack itemStack = this.plugin.getNms().itemInMainHand(player);
            ItemStack itemStack2 = CMIReflections.getItemInOffHand(player);
            if (itemStack == null && itemStack2 == null) {
                return;
            }
            if (itemStack != null && !CMIMaterial.isDye(itemStack.getType()) && itemStack2 != null && !CMIMaterial.isDye(itemStack2.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.dye, claimedResidence.getName()});
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent playerShearEntityEvent) {
        if (!Flags.shear.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerShearEntityEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerShearEntityEvent.isCancelled()) {
            return;
        }
        Player player = playerShearEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerShearEntityEvent.getEntity();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (!claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.shear, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack itemStack = this.plugin.getNms().itemInMainHand(player);
            ItemStack itemStack2 = CMIReflections.getItemInOffHand(player);
            if (itemStack == null && itemStack2 == null) {
                return;
            }
            if (itemStack != null && !CMIMaterial.SHEARS.equals(itemStack.getType()) && itemStack2 != null && !CMIMaterial.SHEARS.equals(itemStack2.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.shear, claimedResidence.getName()});
            playerShearEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemFrameInteract(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerInteractEntityEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerInteractEntityEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractEntityEvent.getRightClicked();
        if (entity.getType() != EntityType.ITEM_FRAME) {
            return;
        }
        if (!(entity instanceof Hanging)) {
            return;
        }
        Material material2 = this.plugin.getNms().itemInMainHand(player).getType();
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(entity.getLocation(), player);
        String string = player.getWorld().getName();
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (!this.plugin.getItemManager().isAllowed(material2, permissionGroup, string)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            playerInteractEntityEvent.setCancelled(true);
            return;
        }
        boolean bl = PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]);
        if (!bl && !flagPermissions.playerHas(player, Flags.container, flagPermissions.playerHas(player, Flags.use, true))) {
            playerInteractEntityEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent playerBucketEmptyEvent) {
        FlagPermissions flagPermissions;
        if (this.plugin.isDisabledWorldListener(playerBucketEmptyEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerBucketEmptyEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location location = playerBucketEmptyEvent.getBlockClicked().getLocation();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence != null) {
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(claimedResidence.getName())) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                playerBucketEmptyEvent.setCancelled(true);
                return;
            }
            flagPermissions = playerBucketEmptyEvent.getBucket();
            if (claimedResidence.getPermissions().playerHas(player, Flags.build, FlagPermissions.FlagCombo.OnlyFalse) && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName()) && (flagPermissions == Material.LAVA_BUCKET || flagPermissions == Material.WATER_BUCKET)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                playerBucketEmptyEvent.setCancelled(true);
                return;
            }
        }
        if (!(flagPermissions = this.plugin.getPermsByLocForPlayer(location, player)).playerHas(player, Flags.build, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
            playerBucketEmptyEvent.setCancelled(true);
            return;
        }
        Material material2 = playerBucketEmptyEvent.getBucket();
        int n = this.plugin.getConfigManager().getPlaceLevel();
        if (claimedResidence == null && this.plugin.getConfigManager().isNoLavaPlace() && location.getBlockY() >= n - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName()) && material2 == Material.LAVA_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceLava, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceLava, n);
            }
            playerBucketEmptyEvent.setCancelled(true);
            return;
        }
        if (claimedResidence == null && this.plugin.getConfigManager().isNoWaterPlace() && location.getBlockY() >= n - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName()) && material2 == Material.WATER_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceWater, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceWater, n);
            }
            playerBucketEmptyEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent playerBucketFillEvent) {
        if (this.plugin.isDisabledWorldListener(playerBucketFillEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerBucketFillEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(playerBucketFillEvent.getBlockClicked().getLocation());
        if (claimedResidence != null && this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(claimedResidence.getName())) {
            this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            playerBucketFillEvent.setCancelled(true);
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(playerBucketFillEvent.getBlockClicked().getLocation(), player);
        boolean bl = flagPermissions.playerHas(player, Flags.destroy, flagPermissions.playerHas(player, Flags.build, true));
        if (!bl) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            playerBucketFillEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent playerTeleportEvent) {
        if (this.plugin.isDisabledWorldListener(playerTeleportEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerTeleportEvent.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = playerTeleportEvent.getTo();
        if (this.plugin.isResAdminOn(player)) {
            this.handleNewLocation(player, location, false);
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence == null) {
            return;
        }
        if (playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            if (claimedResidence.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !claimedResidence.isOwner(player) && !PermissionManager.ResPerm.bypass_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                playerTeleportEvent.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, claimedResidence.getName());
                return;
            }
        } else if (playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && claimedResidence.getPermissions().playerHas(player, Flags.enderpearl, FlagPermissions.FlagCombo.OnlyFalse)) {
            playerTeleportEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.enderpearl, claimedResidence.getName()});
            return;
        }
        if ((playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || playerTeleportEvent.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) && this.plugin.getConfigManager().isBlockAnyTeleportation() && !claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            playerTeleportEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.General_TeleportDeny, claimedResidence.getName());
            return;
        }
        if (this.plugin.getNms().isChorusTeleport(playerTeleportEvent.getCause()) && !claimedResidence.isOwner(player) && claimedResidence.getPermissions().playerHas(player, Flags.chorustp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            playerTeleportEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chorustp, claimedResidence.getName()});
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(final PlayerDeathEvent playerDeathEvent) {
        if (this.plugin.isDisabledWorldListener(playerDeathEvent.getEntity().getWorld())) {
            return;
        }
        Player player = playerDeathEvent.getEntity();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = player.getLocation();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().has(Flags.keepinv, false)) {
            playerDeathEvent.setKeepInventory(true);
            if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
                playerDeathEvent.getDrops().clear();
            }
        }
        if (claimedResidence.getPermissions().has(Flags.keepexp, false)) {
            playerDeathEvent.setKeepLevel(true);
            playerDeathEvent.setDroppedExp(0);
        }
        if (claimedResidence.getPermissions().has(Flags.respawn, false) && Bukkit.getVersion().toString().contains("Spigot")) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        playerDeathEvent.getEntity().spigot().respawn();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 20L);
        }
    }

    private static Location getSafeLocation(Location location) {
        Block block;
        int n = location.getBlockY();
        int n2 = 0;
        while (n2 <= n) {
            block = location.clone().add(0.0, (double)(-n2), 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return location.clone().add(0.0, (double)(-n2 + 1), 0.0);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 <= location.getWorld().getMaxHeight() - n) {
            block = location.clone().add(0.0, (double)n2, 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return location.clone().add(0.0, (double)(n2 + 1), 0.0);
            }
            ++n2;
        }
        return null;
    }

    private void fly(Player player, boolean bl) {
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_fly.hasPermission((CommandSender)player, 10000L, new String[0])) {
            return;
        }
        if (!bl) {
            boolean bl2 = player.isFlying();
            player.setFlying(bl);
            player.setAllowFlight(bl);
            if (bl2) {
                Location location = ResidencePlayerListener.getSafeLocation(player.getLocation());
                if (location == null && (location = this.plugin.getConfigManager().getFlyLandLocation()) == null) {
                    location = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
                }
                if (location != null) {
                    player.closeInventory();
                    player.teleport(location);
                }
            }
        } else {
            player.setAllowFlight(true);
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence != null && claimedResidence.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && player.isOnline()) {
                    player.setAllowFlight(true);
                }
            }, 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChange(ResidenceChangedEvent residenceChangedEvent) {
        ClaimedResidence claimedResidence = residenceChangedEvent.getTo();
        ClaimedResidence claimedResidence2 = residenceChangedEvent.getFrom();
        Player player = residenceChangedEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (claimedResidence == null && claimedResidence2 != null) {
            if (claimedResidence2.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence2.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (claimedResidence2.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence2.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (claimedResidence2.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || claimedResidence2.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (claimedResidence2.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, false);
            }
            if (Version.isCurrentEqualOrHigher(Version.v1_9_R1) && claimedResidence2.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(false);
            }
        }
        if (claimedResidence != null && claimedResidence2 != null && !claimedResidence.equals(claimedResidence2)) {
            if (Version.isCurrentEqualOrHigher(Version.v1_9_R1)) {
                if (claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(true);
                } else if (claimedResidence2.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(false);
                }
            }
            if (claimedResidence.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, true);
            } else if (claimedResidence2.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, false);
            }
            if (claimedResidence.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            } else if (claimedResidence2.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (claimedResidence.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            } else if (claimedResidence2.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            } else if (claimedResidence2.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            } else if (claimedResidence2.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            } else if (claimedResidence2.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (claimedResidence2.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue) && !claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
        }
        if (claimedResidence != null && claimedResidence2 == null) {
            if (Version.isCurrentEqualOrHigher(Version.v1_9_R1) && claimedResidence.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(true);
            }
            if (claimedResidence.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, true);
            }
            if (claimedResidence.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            }
            if (claimedResidence.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            }
            if (claimedResidence.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            }
            if (claimedResidence.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            }
            if (claimedResidence.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            }
            if (claimedResidence.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        if (this.plugin.isDisabledWorldListener(playerMoveEvent.getPlayer().getWorld())) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        Long l = this.lastUpdate.get(player.getUniqueId());
        if (l != null && System.currentTimeMillis() - l < (long)this.plugin.getConfigManager().getMinMoveUpdateInterval()) {
            return;
        }
        this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        boolean bl = this.handleNewLocation(player, location2, true);
        if (!bl) {
            playerMoveEvent.setCancelled(true);
        }
        if (!this.plugin.getTeleportDelayMap().isEmpty() && this.plugin.getConfigManager().getTeleportDelay() > 0 && this.plugin.getTeleportDelayMap().contains(player.getName())) {
            this.plugin.getTeleportDelayMap().remove(player.getName());
            this.plugin.msg((CommandSender)player, lm.General_TeleportCanceled, new Object[0]);
            if (this.plugin.getConfigManager().isTeleportTitleMessage()) {
                TitleMessageManager.send(player, "", "");
            }
        }
    }

    private static boolean teleport(Player player, Location location) {
        if (player == null || !player.isOnline() || location == null) {
            return false;
        }
        return player.teleport(location);
    }

    public boolean handleNewLocation(final Player player, Location location, boolean bl) {
        ResidenceChangedEvent residenceChangedEvent;
        UUID uUID;
        ClaimedResidence claimedResidence;
        ClaimedResidence claimedResidence2;
        ClaimedResidence claimedResidence3 = claimedResidence2 = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence2 != null) {
            while (claimedResidence2.getSubzoneByLoc(location) != null) {
                claimedResidence2 = claimedResidence2.getSubzoneByLoc(player.getLocation());
            }
        }
        if ((claimedResidence = this.currentRes.get(uUID = player.getUniqueId())) == null) {
            this.currentRes.remove(uUID);
        } else if (claimedResidence2 != null && claimedResidence.getName().equals(claimedResidence2.getName())) {
            if (Flags.nofly.isGlobalyEnabled() && player.isFlying() && claimedResidence2.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0]) && !claimedResidence2.isOwner(player)) {
                Location location2 = player.getLocation();
                Location location3 = new Location(location2.getWorld(), location2.getX(), (double)location2.getBlockY(), location2.getZ());
                location3.setPitch(location2.getPitch());
                location3.setYaw(location2.getYaw());
                int n = location3.getBlockY();
                int n2 = n + 3;
                n2 = location3.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : location3.getWorld().getHighestBlockAt(location3).getLocation().getBlockY() + 3;
                int n3 = 0;
                while (n3 < n2) {
                    location3.setY((double)(n - n3));
                    Block block = location3.getBlock();
                    if (!ResidencePlayerListener.isEmptyBlock(block)) {
                        location3.setY((double)(n - n3 + 1));
                        break;
                    }
                    if (location3.getBlockY() <= 0) {
                        Location location4 = this.lastOutsideLoc.get(uUID);
                        player.closeInventory();
                        boolean bl2 = false;
                        bl2 = location4 != null ? ResidencePlayerListener.teleport(player, location4) : ResidencePlayerListener.teleport(player, claimedResidence2.getOutsideFreeLoc(location, player));
                        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, claimedResidence3.getName()});
                        return bl2;
                    }
                    ++n3;
                }
                this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, claimedResidence3.getName()});
                player.closeInventory();
                n3 = ResidencePlayerListener.teleport(player, location3) ? 1 : 0;
                if (n3 == 0) {
                    return false;
                }
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            this.lastOutsideLoc.put(uUID, location);
            return true;
        }
        if (!this.plugin.getAutoSelectionManager().getList().isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ResidencePlayerListener.this.plugin.getAutoSelectionManager().UpdateSelection(player);
                }
            });
        }
        if (claimedResidence2 == null) {
            this.lastOutsideLoc.put(uUID, location);
            if (claimedResidence != null) {
                ResidenceChangedEvent residenceChangedEvent2 = new ResidenceChangedEvent(claimedResidence, null, player);
                this.plugin.getServ().getPluginManager().callEvent((Event)residenceChangedEvent2);
                this.currentRes.remove(uUID);
            }
            return true;
        }
        if (bl) {
            if (claimedResidence2.isUnderRaid()) {
                Object object;
                Object object2;
                if (claimedResidence2.getRaid().isAttacker(player.getUniqueId()) || claimedResidence2.getRaid().isDefender(player.getUniqueId())) {
                    return true;
                }
                Location location5 = this.lastOutsideLoc.get(uUID);
                if (this.plugin.getConfigManager().BounceAnimation()) {
                    object2 = new Visualizer(player);
                    ((Visualizer)object2).setErrorAreas(claimedResidence2);
                    ((Visualizer)object2).setOnce(true);
                    this.plugin.getSelectionManager().showBounds(player, (Visualizer)object2);
                }
                object2 = this.plugin.getResidenceManager().getByLoc(location5);
                boolean bl3 = false;
                if (object2 != null && ((ClaimedResidence)object2).getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                    object = claimedResidence2.getOutsideFreeLoc(location, player);
                    player.closeInventory();
                    bl3 = ResidencePlayerListener.teleport(player, (Location)object);
                } else if (location5 != null) {
                    object = this.updateStuckTeleport(player, location);
                    player.closeInventory();
                    if (object != null && ((StuckInfo)object).getTimesTeleported() > 5) {
                        Location location6 = claimedResidence2.getOutsideFreeLoc(location, player);
                        bl3 = ResidencePlayerListener.teleport(player, location6);
                    } else {
                        bl3 = ResidencePlayerListener.teleport(player, location5);
                    }
                } else {
                    object = claimedResidence2.getOutsideFreeLoc(location, player);
                    player.closeInventory();
                    bl3 = ResidencePlayerListener.teleport(player, (Location)object);
                }
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: 
                    case TitleBar: {
                        object = claimedResidence2.getPermissions();
                        if (!((FlagPermissions)object).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) break;
                        ActionBarManager.send(player, this.plugin.msg(lm.Raid_cantDo, new Object[0]));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg((CommandSender)player, lm.Raid_cantDo, claimedResidence3.getName());
                        break;
                    }
                }
                return bl3;
            }
            if (claimedResidence2.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !this.plugin.isResAdminOn(player) && !claimedResidence2.isOwner(player) && !PermissionManager.ResPerm.admin_move.hasPermission((CommandSender)player, 10000L, new String[0])) {
                Object object;
                Object object3;
                Location location7 = this.lastOutsideLoc.get(uUID);
                if (this.plugin.getConfigManager().BounceAnimation()) {
                    object3 = new Visualizer(player);
                    ((Visualizer)object3).setErrorAreas(claimedResidence2);
                    ((Visualizer)object3).setOnce(true);
                    this.plugin.getSelectionManager().showBounds(player, (Visualizer)object3);
                }
                object3 = this.plugin.getResidenceManager().getByLoc(location7);
                boolean bl4 = false;
                if (object3 != null && ((ClaimedResidence)object3).getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                    object = claimedResidence2.getOutsideFreeLoc(location, player);
                    player.closeInventory();
                    bl4 = ResidencePlayerListener.teleport(player, (Location)object);
                } else if (location7 != null) {
                    object = this.updateStuckTeleport(player, location);
                    player.closeInventory();
                    if (object != null && ((StuckInfo)object).getTimesTeleported() > 5) {
                        Location location8 = claimedResidence2.getOutsideFreeLoc(location, player);
                        bl4 = ResidencePlayerListener.teleport(player, location8);
                    } else {
                        bl4 = ResidencePlayerListener.teleport(player, location7);
                    }
                } else {
                    object = claimedResidence2.getOutsideFreeLoc(location, player);
                    player.closeInventory();
                    bl4 = ResidencePlayerListener.teleport(player, (Location)object);
                }
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: 
                    case TitleBar: {
                        object = claimedResidence2.getPermissions();
                        if (!((FlagPermissions)object).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) break;
                        ActionBarManager.send(player, this.plugin.msg(lm.Residence_MoveDeny, claimedResidence3.getName()));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, claimedResidence3.getName());
                        break;
                    }
                }
                return bl4;
            }
            if (Flags.nofly.isGlobalyEnabled() && player.isFlying() && claimedResidence2.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !PermissionManager.ResPerm.bypass_nofly.hasPermission((CommandSender)player, 10000L, new String[0]) && claimedResidence2.isOwner(player)) {
                residenceChangedEvent = player.getLocation();
                Location location9 = new Location(residenceChangedEvent.getWorld(), residenceChangedEvent.getX(), (double)residenceChangedEvent.getBlockY(), residenceChangedEvent.getZ());
                location9.setPitch(residenceChangedEvent.getPitch());
                location9.setYaw(residenceChangedEvent.getYaw());
                int n = location9.getBlockY();
                int n4 = location9.getWorld().getMaxHeight() - 1;
                boolean bl5 = false;
                int n5 = 0;
                while (n5 < n4) {
                    location9.setY((double)(n - n5));
                    Block block = location9.getBlock();
                    if (!ResidencePlayerListener.isEmptyBlock(block)) {
                        location9.setY((double)(n - n5 + 1));
                        break;
                    }
                    if (location9.getBlockY() <= 0) {
                        Location location10 = this.lastOutsideLoc.get(uUID);
                        player.closeInventory();
                        bl5 = location10 != null ? ResidencePlayerListener.teleport(player, location10) : ResidencePlayerListener.teleport(player, claimedResidence2.getOutsideFreeLoc(location, player));
                        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, claimedResidence3.getName()});
                        return bl5;
                    }
                    ++n5;
                }
                this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, claimedResidence3.getName()});
                player.closeInventory();
                bl5 = ResidencePlayerListener.teleport(player, location9);
                if (!bl5) {
                    return false;
                }
                player.setFlying(false);
                player.setAllowFlight(false);
            }
        }
        this.lastOutsideLoc.put(uUID, location);
        if (!this.currentRes.containsKey(uUID) || claimedResidence != claimedResidence2) {
            this.currentRes.put(uUID, claimedResidence2);
            residenceChangedEvent = new ResidenceChangedEvent(claimedResidence, claimedResidence2, player);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceChangedEvent);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleportEvent(PlayerTeleportEvent playerTeleportEvent) {
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(location2);
        if (claimedResidence != null && claimedResidence2 != null && claimedResidence.equals(claimedResidence2)) {
            return;
        }
        if (playerTeleportEvent.getPlayer().hasMetadata("NPC")) {
            return;
        }
        ResidenceChangedEvent residenceChangedEvent = new ResidenceChangedEvent(claimedResidence, claimedResidence2, playerTeleportEvent.getPlayer());
        this.plugin.getServ().getPluginManager().callEvent((Event)residenceChangedEvent);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChangeMessagePrint(ResidenceChangedEvent residenceChangedEvent) {
        Object object;
        Player player;
        ClaimedResidence claimedResidence;
        ClaimedResidence claimedResidence2 = residenceChangedEvent.getFrom();
        ClaimedResidence claimedResidence3 = residenceChangedEvent.getTo();
        String string = null;
        ClaimedResidence claimedResidence4 = claimedResidence = claimedResidence2 == null ? claimedResidence3 : claimedResidence2;
        if (claimedResidence2 == null && claimedResidence3 != null) {
            string = claimedResidence3.getEnterMessage();
            claimedResidence = claimedResidence3;
        }
        if (claimedResidence2 != null && claimedResidence3 == null) {
            string = claimedResidence2.getLeaveMessage();
            claimedResidence = claimedResidence2;
        }
        if (claimedResidence2 != null && claimedResidence3 != null) {
            string = claimedResidence3.getEnterMessage();
            claimedResidence = claimedResidence3;
        }
        if ((player = residenceChangedEvent.getPlayer()).hasMetadata("NPC")) {
            return;
        }
        if (string != null && ((object = this.informar.get(player.getUniqueId())) == null || (Long)object + 100L < System.currentTimeMillis())) {
            if (claimedResidence.getPermissions().has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) {
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: {
                        ActionBarManager.send(player, ChatColor.YELLOW + this.insertMessages(player, claimedResidence, string));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, claimedResidence, string));
                        break;
                    }
                    case TitleBar: {
                        TitleMessageManager.send(player, ChatColor.YELLOW + this.insertMessages(player, claimedResidence, string), null);
                        break;
                    }
                }
            }
            this.informar.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (claimedResidence3 != null && this.plugin.getConfigManager().isEnterAnimation() && claimedResidence3.isTopArea() && (claimedResidence2 == null || claimedResidence2.getTopParent() != claimedResidence3)) {
            claimedResidence3.showBounds(player, true);
        }
        if (claimedResidence2 == null || claimedResidence == null) {
            return;
        }
        if (claimedResidence != claimedResidence2.getParent() && this.plugin.getConfigManager().isExtraEnterMessage() && !claimedResidence.isOwner(player) && (this.plugin.getRentManager().isForRent(claimedResidence2) || this.plugin.getTransactionManager().isForSale(claimedResidence2))) {
            if (this.plugin.getRentManager().isForRent(claimedResidence2) && !this.plugin.getRentManager().isRented(claimedResidence2)) {
                object = this.plugin.getRentManager().getRentableLand(claimedResidence2);
                if (object != null) {
                    ActionBarManager.send(player, this.plugin.msg(lm.Residence_CanBeRented, claimedResidence2.getName(), ((RentableLand)object).cost, ((RentableLand)object).days));
                }
            } else if (this.plugin.getTransactionManager().isForSale(claimedResidence2) && !claimedResidence.isOwner(player)) {
                int n = this.plugin.getTransactionManager().getSaleAmount(claimedResidence2);
                ActionBarManager.send(player, this.plugin.msg(lm.Residence_CanBeBought, claimedResidence2.getName(), n));
            }
        }
    }

    private StuckInfo updateStuckTeleport(Player player, Location location) {
        if (location.getY() >= player.getLocation().getY()) {
            return null;
        }
        StuckInfo stuckInfo = this.stuckTeleportCounter.get(player.getUniqueId());
        if (stuckInfo == null) {
            stuckInfo = new StuckInfo(player);
            this.stuckTeleportCounter.put(player.getUniqueId(), stuckInfo);
        }
        stuckInfo.updateLastTp();
        return stuckInfo;
    }

    public String insertMessages(Player player, ClaimedResidence claimedResidence, String string) {
        try {
            string = string.replace("%player", player.getName());
            string = string.replace("%owner", claimedResidence.getPermissions().getOwner());
            string = string.replace("%residence", claimedResidence.getName());
            string = string.replace("%zone", claimedResidence.getResidenceName());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    public void doHeals() {
        if (!Flags.healing.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                Player player2;
                double d;
                ClaimedResidence claimedResidence = this.getCurrentResidence(player.getUniqueId());
                if (claimedResidence == null || !claimedResidence.getPermissions().has(Flags.healing, false) || !((d = (player2 = player).getHealth()) < player2.getMaxHealth()) || player.isDead()) continue;
                player.setHealth(d + 1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feed() {
        if (!Flags.feed.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                int n;
                ClaimedResidence claimedResidence = this.getCurrentResidence(player.getUniqueId());
                if (claimedResidence == null || !claimedResidence.getPermissions().has(Flags.feed, false) || (n = player.getFoodLevel()) >= 20 || player.isDead()) continue;
                player.setFoodLevel(n + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DespawnMobs() {
        if (!Flags.nomobs.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                ClaimedResidence claimedResidence = this.getCurrentResidence(player.getUniqueId());
                if (claimedResidence == null || !claimedResidence.getPermissions().has(Flags.nomobs, false)) continue;
                List list2 = Bukkit.getServer().getWorld(claimedResidence.getWorld()).getEntities();
                for (Entity entity : list2) {
                    ClaimedResidence claimedResidence2;
                    if (!ResidenceEntityListener.isMonster(entity) || !claimedResidence.containsLoc(entity.getLocation()) || !(claimedResidence2 = this.plugin.getResidenceManager().getByLoc(entity.getLocation())).getPermissions().has(Flags.nomobs, FlagPermissions.FlagCombo.OnlyTrue)) continue;
                    entity.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (this.plugin.isDisabledWorldListener(asyncPlayerChatEvent.getPlayer().getWorld())) {
            return;
        }
        String string = asyncPlayerChatEvent.getPlayer().getName();
        if (!this.chatenabled || !this.playerToggleChat.contains(asyncPlayerChatEvent.getPlayer().getUniqueId())) {
            return;
        }
        ChatChannel chatChannel = this.plugin.getChatManager().getPlayerChannel(string);
        if (chatChannel != null) {
            chatChannel.chat(string, asyncPlayerChatEvent.getMessage());
        }
        asyncPlayerChatEvent.setCancelled(true);
    }

    public void tooglePlayerResidenceChat(Player player, String string) {
        this.playerToggleChat.add(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelChange, string);
    }

    @Deprecated
    public void removePlayerResidenceChat(String string) {
        this.removePlayerResidenceChat(Bukkit.getPlayer((String)string));
    }

    public void removePlayerResidenceChat(Player player) {
        if (player == null) {
            return;
        }
        this.playerToggleChat.remove(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelLeave, new Object[0]);
    }

    public ClaimedResidence getCurrentResidence(UUID uUID) {
        return this.currentRes.get(uUID);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags() {
        if ($SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags != null) {
            return $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags;
        }
        int[] nArray = new int[Flags.values().length];
        try {
            nArray[Flags.admin.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.animalkilling.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.animals.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.anvil.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.anvilbreak.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.backup.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.bank.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.beacon.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.bed.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.brew.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.build.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.burn.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.button.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.cake.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.canimals.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.chat.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.chorustp.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.cmonsters.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.command.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.commandblock.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.container.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.coords.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.craft.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.creeper.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.damage.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.day.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.decay.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.destroy.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.diode.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.door.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dragongrief.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dryup.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.dye.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.egg.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.enchant.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.enderpearl.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.explode.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.falldamage.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fallinprotection.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.feed.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fireball.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.firespread.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flow.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flowerpot.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.flowinprotection.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.fly.ordinal()] = 74;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.friendlyfire.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.glow.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.grow.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.healing.ordinal()] = 52;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hidden.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hook.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.hotfloor.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.iceform.ordinal()] = 53;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.icemelt.ordinal()] = 54;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.ignite.ordinal()] = 55;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.itemdrop.ordinal()] = 56;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.itempickup.ordinal()] = 57;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.jump2.ordinal()] = 58;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.jump3.ordinal()] = 59;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.keepexp.ordinal()] = 61;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.keepinv.ordinal()] = 60;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.lavaflow.ordinal()] = 62;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.leash.ordinal()] = 63;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.lever.ordinal()] = 64;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobexpdrop.ordinal()] = 65;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobitemdrop.ordinal()] = 66;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.mobkilling.ordinal()] = 67;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.monsters.ordinal()] = 68;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.move.ordinal()] = 69;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nanimals.ordinal()] = 70;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.night.ordinal()] = 72;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nmonsters.ordinal()] = 71;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nodurability.ordinal()] = 77;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nofly.ordinal()] = 73;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.nomobs.ordinal()] = 75;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.note.ordinal()] = 76;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.overridepvp.ordinal()] = 78;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.phantomspawn.ordinal()] = 106;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.piston.ordinal()] = 80;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pistonprotection.ordinal()] = 81;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.place.ordinal()] = 82;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pressure.ordinal()] = 79;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.pvp.ordinal()] = 83;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.rain.ordinal()] = 84;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.respawn.ordinal()] = 85;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.riding.ordinal()] = 86;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.sanimals.ordinal()] = 93;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shear.ordinal()] = 94;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shoot.ordinal()] = 87;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.shop.ordinal()] = 89;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.smonsters.ordinal()] = 95;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.snowball.ordinal()] = 92;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.snowtrail.ordinal()] = 90;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.spread.ordinal()] = 91;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.subzone.ordinal()] = 96;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.sun.ordinal()] = 88;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.table.ordinal()] = 98;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.title.ordinal()] = 97;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.tnt.ordinal()] = 99;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.tp.ordinal()] = 100;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.trade.ordinal()] = 101;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.trample.ordinal()] = 102;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.use.ordinal()] = 103;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.vehicledestroy.ordinal()] = 104;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.waterflow.ordinal()] = 109;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherdamage.ordinal()] = 107;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherdestruction.ordinal()] = 108;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.witherspawn.ordinal()] = 105;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.wspeed1.ordinal()] = 110;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Flags.wspeed2.ordinal()] = 111;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$bekvon$bukkit$residence$containers$Flags = nArray;
        return nArray;
    }
}

