/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarManager;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Witch;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class ResidenceEntityListener
implements Listener {
    Residence plugin;
    private static final String CrossbowShooter = "CrossbowShooter";

    public ResidenceEntityListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndermanChangeBlock(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (this.plugin.isDisabledWorldListener(entityChangeBlockEvent.getBlock().getWorld())) {
            return;
        }
        if (entityChangeBlockEvent.getEntityType() != EntityType.ENDERMAN) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(entityChangeBlockEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.destroy, true)) {
            entityChangeBlockEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent entityInteractEvent) {
        if (!Flags.trample.isGlobalyEnabled()) {
            return;
        }
        Block block = entityInteractEvent.getBlock();
        if (block == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(block.getWorld())) {
            return;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(block);
        Entity entity = entityInteractEvent.getEntity();
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(block.getLocation());
        boolean bl = flagPermissions.has(Flags.trample, flagPermissions.has(Flags.build, true));
        if (!bl && entity.getType() != EntityType.FALLING_BLOCK && (cMIMaterial.equals((Object)CMIMaterial.FARMLAND) || cMIMaterial.equals((Object)CMIMaterial.SOUL_SAND))) {
            entityInteractEvent.setCancelled(true);
        }
    }

    public static boolean isMonster(Entity entity) {
        return entity instanceof Monster || entity instanceof Slime || entity instanceof Ghast;
    }

    private static boolean isTamed(Entity entity) {
        return entity instanceof Tameable ? ((Tameable)entity).isTamed() : false;
    }

    private static boolean damageableProjectile(Entity entity) {
        if (entity instanceof Projectile && entity.getType().toString().equalsIgnoreCase("Splash_potion")) {
            if (((ThrownPotion)entity).getEffects().isEmpty()) {
                return true;
            }
            for (PotionEffect potionEffect : ((ThrownPotion)entity).getEffects()) {
                for (String string : Residence.getInstance().getConfigManager().getNegativePotionEffects()) {
                    if (!string.equalsIgnoreCase(potionEffect.getType().getName())) continue;
                    return true;
                }
            }
        }
        return entity instanceof Arrow || entity.getType().toString().equalsIgnoreCase("Trident") || entity.getType().toString().equalsIgnoreCase("Spectral_Arrow");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(EntityDamageEvent entityDamageEvent) {
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.LIGHTNING || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK) {
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
            if (claimedResidence != null && claimedResidence.getPermissions().has(Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
                entityDamageEvent.setCancelled(true);
            }
            return;
        }
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        boolean bl = ResidenceEntityListener.damageableProjectile(entity2);
        if (!bl && !(entity2 instanceof Player)) {
            return;
        }
        if (bl && !(((Projectile)entity2).getShooter() instanceof Player)) {
            return;
        }
        Player player = null;
        player = entity2 instanceof Player ? (Player)entity2 : (Player)((Projectile)entity2).getShooter();
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().playerHas(player, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, claimedResidence.getName()});
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKillingByFlame(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityCombustByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityCombustByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityCombustByEntityEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        Entity entity2 = entityCombustByEntityEvent.getCombuster();
        if (!ResidenceEntityListener.damageableProjectile(entity2) && !(entity2 instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(entity2) && !(((Projectile)entity2).getShooter() instanceof Player)) {
            return;
        }
        Player player = null;
        player = entity2 instanceof Player ? (Player)entity2 : (Player)((Projectile)entity2).getShooter();
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        if (claimedResidence.getPermissions().playerHas(player, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, claimedResidence.getName()});
            entityCombustByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalDamageByMobs(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        FlagPermissions flagPermissions;
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        if (entity2 instanceof Projectile && ((Projectile)entity2).getShooter() instanceof Player || entity2 instanceof Player) {
            return;
        }
        FlagPermissions flagPermissions2 = this.plugin.getPermsByLoc(entity.getLocation());
        if (!flagPermissions2.has(Flags.animalkilling, (flagPermissions = this.plugin.getWorldFlags().getPerms(entity.getWorld().getName())).has(Flags.animalkilling, true))) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void OnEntityDeath(EntityDeathEvent entityDeathEvent) {
        if (!Flags.mobitemdrop.isGlobalyEnabled() && !Flags.mobexpdrop.isGlobalyEnabled()) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(livingEntity.getWorld())) {
            return;
        }
        if (livingEntity instanceof Player) {
            return;
        }
        Location location = livingEntity.getLocation();
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(location);
        if (!flagPermissions.has(Flags.mobitemdrop, true)) {
            entityDeathEvent.getDrops().clear();
        }
        if (!flagPermissions.has(Flags.mobexpdrop, true)) {
            entityDeathEvent.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void VehicleDestroy(VehicleDestroyEvent vehicleDestroyEvent) {
        FlagPermissions flagPermissions;
        if (!Flags.vehicledestroy.isGlobalyEnabled()) {
            return;
        }
        Entity entity = vehicleDestroyEvent.getAttacker();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        Vehicle vehicle = vehicleDestroyEvent.getVehicle();
        if (vehicle == null) {
            return;
        }
        if ((entity instanceof Projectile && !(((Projectile)entity).getShooter() instanceof Player) || !(entity instanceof Player)) && !(flagPermissions = this.plugin.getPermsByLoc(vehicle.getLocation())).has(Flags.vehicledestroy, true)) {
            vehicleDestroyEvent.setCancelled(true);
            return;
        }
        flagPermissions = null;
        if (entity instanceof Player) {
            flagPermissions = (Player)entity;
        } else if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            flagPermissions = (Player)((Projectile)entity).getShooter();
        }
        if (flagPermissions == null) {
            return;
        }
        if (this.plugin.isResAdminOn((Player)flagPermissions)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(vehicle.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().playerHas((Player)flagPermissions, Flags.vehicledestroy, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)flagPermissions, lm.Residence_FlagDeny, new Object[]{Flags.vehicledestroy, claimedResidence.getName()});
            vehicleDestroyEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void MonsterKilling(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!Flags.mobkilling.isGlobalyEnabled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.isMonster(entity)) {
            return;
        }
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        if (!ResidenceEntityListener.damageableProjectile(entity2) && !(entity2 instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(entity2) && !(((Projectile)entity2).getShooter() instanceof Player)) {
            return;
        }
        Player player = null;
        player = entity2 instanceof Player ? (Player)entity2 : (Player)((Projectile)entity2).getShooter();
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().playerHas(player, Flags.mobkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.mobkilling, claimedResidence.getName()});
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalLeash(PlayerLeashEntityEvent playerLeashEntityEvent) {
        if (!Flags.leash.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(playerLeashEntityEvent.getEntity().getWorld())) {
            return;
        }
        Player player = playerLeashEntityEvent.getPlayer();
        Entity entity = playerLeashEntityEvent.getEntity();
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.getPermissions().playerHas(player, Flags.leash, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.leash, claimedResidence.getName()});
            playerLeashEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWitherSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (!Flags.witherspawn.isGlobalyEnabled()) {
            return;
        }
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(livingEntity.getWorld())) {
            return;
        }
        if (livingEntity.getType() != EntityType.WITHER) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(creatureSpawnEvent.getLocation());
        if (flagPermissions.has(Flags.witherspawn, FlagPermissions.FlagCombo.OnlyFalse)) {
            creatureSpawnEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPhantomSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (Version.isCurrentLower(Version.v1_13_R1)) {
            return;
        }
        if (!Flags.phantomspawn.isGlobalyEnabled()) {
            return;
        }
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(livingEntity.getWorld())) {
            return;
        }
        if (livingEntity.getType() != EntityType.PHANTOM) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(creatureSpawnEvent.getLocation());
        if (flagPermissions.has(Flags.phantomspawn, FlagPermissions.FlagCombo.OnlyFalse)) {
            creatureSpawnEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        block20: {
            FlagPermissions flagPermissions;
            LivingEntity livingEntity;
            block19: {
                livingEntity = creatureSpawnEvent.getEntity();
                if (livingEntity == null) {
                    return;
                }
                if (this.plugin.isDisabledWorldListener(livingEntity.getWorld())) {
                    return;
                }
                flagPermissions = this.plugin.getPermsByLoc(creatureSpawnEvent.getLocation());
                if (!this.plugin.getNms().isAnimal((Entity)livingEntity)) break block19;
                if (!flagPermissions.has(Flags.animals, true)) {
                    creatureSpawnEvent.setCancelled(true);
                    return;
                }
                switch (creatureSpawnEvent.getSpawnReason()) {
                    case BUILD_WITHER: {
                        break;
                    }
                    case BUILD_SNOWMAN: 
                    case BUILD_IRONGOLEM: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (flagPermissions.has(Flags.canimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            creatureSpawnEvent.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case EGG: 
                    case VILLAGE_DEFENSE: 
                    case VILLAGE_INVASION: 
                    case BREEDING: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case CURED: 
                    case OCELOT_BABY: 
                    case MOUNT: {
                        if (flagPermissions.has(Flags.nanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            creatureSpawnEvent.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (flagPermissions.has(Flags.sanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            creatureSpawnEvent.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (ResidenceEntityListener.isMonster((Entity)livingEntity)) {
                if (flagPermissions.has(Flags.monsters, FlagPermissions.FlagCombo.OnlyFalse)) {
                    creatureSpawnEvent.setCancelled(true);
                    return;
                }
                switch (creatureSpawnEvent.getSpawnReason()) {
                    case BUILD_WITHER: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (!flagPermissions.has(Flags.cmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        creatureSpawnEvent.setCancelled(true);
                        return;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case LIGHTNING: 
                    case SLIME_SPLIT: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case INFECTION: 
                    case CURED: 
                    case SILVERFISH_BLOCK: 
                    case MOUNT: {
                        if (!flagPermissions.has(Flags.nmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        creatureSpawnEvent.setCancelled(true);
                        return;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (!flagPermissions.has(Flags.smonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        creatureSpawnEvent.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent hangingPlaceEvent) {
        Player player = hangingPlaceEvent.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(player.getWorld())) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(hangingPlaceEvent.getEntity().getLocation(), player);
        if (!flagPermissions.playerHas(player, Flags.place, flagPermissions.playerHas(player, Flags.build, true))) {
            hangingPlaceEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent projectileLaunchEvent) {
        if (!Flags.shoot.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(projectileLaunchEvent.getEntity().getWorld())) {
            return;
        }
        if (projectileLaunchEvent.getEntityType().equals((Object)EntityType.THROWN_EXP_BOTTLE)) {
            return;
        }
        if (projectileLaunchEvent.getEntity().getShooter() instanceof Player && this.plugin.isResAdminOn((Player)projectileLaunchEvent.getEntity().getShooter())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(projectileLaunchEvent.getEntity().getLocation());
        if (flagPermissions.has(Flags.shoot, FlagPermissions.FlagCombo.OnlyFalse)) {
            projectileLaunchEvent.setCancelled(true);
            if (projectileLaunchEvent.getEntity().getShooter() instanceof Player) {
                this.plugin.msg((CommandSender)((Player)projectileLaunchEvent.getEntity().getShooter()), lm.Flag_Deny, new Object[]{Flags.shoot});
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        Hanging hanging = hangingBreakByEntityEvent.getEntity();
        if (hanging == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(hanging.getWorld())) {
            return;
        }
        if (!(hangingBreakByEntityEvent.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)hangingBreakByEntityEvent.getRemover();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        if (this.plugin.getResidenceManager().isOwnerOfLocation(player, hanging.getLocation())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(hanging.getLocation(), player);
        if (!flagPermissions.playerHas(player, Flags.destroy, flagPermissions.playerHas(player, Flags.build, true))) {
            hangingBreakByEntityEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakEventByExplosion(HangingBreakEvent hangingBreakEvent) {
        Hanging hanging = hangingBreakEvent.getEntity();
        if (hanging == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(hanging.getWorld())) {
            return;
        }
        if (!hangingBreakEvent.getCause().equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(hanging.getLocation());
        if (flagPermissions.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) {
            hangingBreakEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakEvent(HangingBreakEvent hangingBreakEvent) {
        Hanging hanging = hangingBreakEvent.getEntity();
        if (hanging == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(hanging.getWorld())) {
            return;
        }
        if (!hangingBreakEvent.getEntity().getType().equals((Object)EntityType.ITEM_FRAME)) {
            return;
        }
        if (!hangingBreakEvent.getCause().equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(hanging.getLocation());
        if (!flagPermissions.has(Flags.destroy, flagPermissions.has(Flags.build, true))) {
            hangingBreakEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent hangingBreakByEntityEvent) {
        Hanging hanging = hangingBreakByEntityEvent.getEntity();
        if (hanging == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(hanging.getWorld())) {
            return;
        }
        if (hangingBreakByEntityEvent.getRemover() instanceof Player) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(hanging.getLocation());
        if (!flagPermissions.has(Flags.destroy, flagPermissions.has(Flags.build, true))) {
            hangingBreakByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent entityCombustEvent) {
        if (!Flags.burn.isGlobalyEnabled()) {
            return;
        }
        Entity entity = entityCombustEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(entity.getLocation());
        if (!flagPermissions.has(Flags.burn, true)) {
            entityCombustEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent explosionPrimeEvent) {
        Entity entity = explosionPrimeEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        EntityType entityType = explosionPrimeEvent.getEntityType();
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(entity.getLocation());
        switch (entityType) {
            case CREEPER: {
                if (!Flags.creeper.isGlobalyEnabled() || flagPermissions.has(Flags.creeper, flagPermissions.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                    if (entity.getLocation().getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                        explosionPrimeEvent.setCancelled(true);
                        entity.remove();
                        break;
                    }
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
                    if (claimedResidence == null) break;
                    explosionPrimeEvent.setCancelled(true);
                    entity.remove();
                    break;
                }
                explosionPrimeEvent.setCancelled(true);
                entity.remove();
                break;
            }
            case PRIMED_TNT: 
            case MINECART_TNT: {
                if (!Flags.tnt.isGlobalyEnabled() || flagPermissions.has(Flags.tnt, flagPermissions.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                    if (entity.getLocation().getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                        explosionPrimeEvent.setCancelled(true);
                        entity.remove();
                        break;
                    }
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
                    if (claimedResidence == null) break;
                    explosionPrimeEvent.setCancelled(true);
                    entity.remove();
                    break;
                }
                explosionPrimeEvent.setCancelled(true);
                entity.remove();
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                if (!Flags.explode.isGlobalyEnabled() || !flagPermissions.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !flagPermissions.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) break;
                explosionPrimeEvent.setCancelled(true);
                entity.remove();
                break;
            }
            case WITHER_SKULL: {
                if (!Flags.explode.isGlobalyEnabled() || !flagPermissions.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !flagPermissions.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) break;
                explosionPrimeEvent.setCancelled(true);
                entity.remove();
                break;
            }
            case WITHER: {
                break;
            }
            default: {
                if (!flagPermissions.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) break;
                explosionPrimeEvent.setCancelled(true);
                entity.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent entityExplodeEvent) {
        Object object;
        FlagPermissions flagPermissions;
        FlagPermissions flagPermissions2;
        Boolean bl;
        Boolean bl2;
        Entity entity;
        block43: {
            block44: {
                Location location = entityExplodeEvent.getLocation();
                if (this.plugin.isDisabledWorldListener(location.getWorld())) {
                    return;
                }
                if (entityExplodeEvent.isCancelled()) {
                    return;
                }
                entity = entityExplodeEvent.getEntity();
                bl2 = false;
                bl = true;
                flagPermissions2 = this.plugin.getPermsByLoc(location);
                flagPermissions = this.plugin.getWorldFlags().getPerms(location.getWorld().getName());
                if (entity == null) break block44;
                switch (entityExplodeEvent.getEntityType()) {
                    case CREEPER: {
                        if (!Flags.creeper.isGlobalyEnabled()) break block43;
                        if (!flagPermissions2.has(Flags.creeper, flagPermissions2.has(Flags.explode, true))) {
                            if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                                if (location.getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                    bl2 = true;
                                    break;
                                }
                                object = this.plugin.getResidenceManager().getByLoc(location);
                                if (object != null) {
                                    bl2 = true;
                                    break;
                                }
                                break block43;
                            } else {
                                bl2 = true;
                                break;
                            }
                        }
                        break block43;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        if (Flags.tnt.isGlobalyEnabled()) {
                            if (!flagPermissions2.has(Flags.tnt, flagPermissions2.has(Flags.explode, true))) {
                                if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                                    if (location.getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                        bl2 = true;
                                        break;
                                    }
                                    object = this.plugin.getResidenceManager().getByLoc(location);
                                    if (object != null) {
                                        bl2 = true;
                                        break;
                                    }
                                    break block43;
                                } else {
                                    bl2 = true;
                                    break;
                                }
                            }
                        }
                        break block43;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (!Flags.explode.isGlobalyEnabled()) {
                            return;
                        }
                        if (flagPermissions2.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || flagPermissions2.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
                            bl2 = true;
                            break;
                        }
                        break block43;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (Flags.explode.isGlobalyEnabled()) {
                            if (flagPermissions2.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || flagPermissions2.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
                                bl2 = true;
                                break;
                            }
                        }
                        break block43;
                    }
                    case ENDER_DRAGON: {
                        bl = false;
                        break;
                    }
                    default: {
                        if (!flagPermissions2.has(Flags.destroy, flagPermissions.has(Flags.destroy, true))) {
                            bl2 = true;
                            bl = false;
                            break;
                        }
                        break block43;
                    }
                }
                break block43;
            }
            if (!flagPermissions2.has(Flags.destroy, flagPermissions.has(Flags.destroy, true))) {
                bl2 = true;
            }
        }
        if (bl2.booleanValue()) {
            entityExplodeEvent.setCancelled(true);
            if (entity != null && bl.booleanValue() && !entityExplodeEvent.getEntityType().equals((Object)EntityType.WITHER)) {
                entity.remove();
            }
            return;
        }
        object = new ArrayList();
        block15: for (Block block : entityExplodeEvent.blockList()) {
            FlagPermissions flagPermissions3 = this.plugin.getPermsByLoc(block.getLocation());
            if (entity != null) {
                switch (entityExplodeEvent.getEntityType()) {
                    case CREEPER: {
                        ClaimedResidence claimedResidence;
                        if (!Flags.creeper.isGlobalyEnabled()) continue block15;
                        if (flagPermissions3.has(Flags.creeper, flagPermissions3.has(Flags.explode, true))) continue block15;
                        if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                object.add(block);
                                break;
                            }
                            claimedResidence = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (claimedResidence == null) continue block15;
                            object.add(block);
                            break;
                        }
                        object.add(block);
                        break;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        ClaimedResidence claimedResidence;
                        if (!Flags.tnt.isGlobalyEnabled()) continue block15;
                        if (flagPermissions3.has(Flags.tnt, flagPermissions3.has(Flags.explode, true))) continue block15;
                        if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                object.add(block);
                                break;
                            }
                            claimedResidence = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (claimedResidence == null) continue block15;
                            object.add(block);
                            break;
                        }
                        object.add(block);
                        break;
                    }
                    case ENDER_DRAGON: {
                        if (!Flags.dragongrief.isGlobalyEnabled()) continue block15;
                        if (!flagPermissions3.has(Flags.dragongrief, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        object.add(block);
                        break;
                    }
                    case ENDER_CRYSTAL: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!flagPermissions3.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        object.add(block);
                        break;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!flagPermissions3.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !flagPermissions2.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        object.add(block);
                        break;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!flagPermissions3.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !flagPermissions3.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        object.add(block);
                        break;
                    }
                    default: {
                        if (!flagPermissions3.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        object.add(block);
                        break;
                    }
                }
                continue;
            }
            if (flagPermissions3.has(Flags.destroy, flagPermissions.has(Flags.destroy, true))) continue;
            object.add(block);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Block block;
            block = (Block)iterator.next();
            entityExplodeEvent.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (!Flags.witherdestruction.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityChangeBlockEvent.getEntity().getWorld())) {
            return;
        }
        if (entityChangeBlockEvent.isCancelled()) {
            return;
        }
        Entity entity = entityChangeBlockEvent.getEntity();
        if (entity.getType() != EntityType.WITHER) {
            return;
        }
        if (!this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        entityChangeBlockEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(PotionSplashEvent potionSplashEvent) {
        PotionEffect potionEffect22;
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(potionSplashEvent.getEntity().getWorld())) {
            return;
        }
        if (potionSplashEvent.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = potionSplashEvent.getPotion().getShooter();
        if (projectileSource instanceof Witch) {
            return;
        }
        boolean bl = false;
        block0: for (PotionEffect potionEffect22 : potionSplashEvent.getPotion().getEffects()) {
            for (String object : this.plugin.getConfigManager().getNegativePotionEffects()) {
                if (!object.equalsIgnoreCase(potionEffect22.getType().getName())) continue;
                bl = true;
                break block0;
            }
        }
        if (!bl) {
            return;
        }
        potionEffect22 = potionSplashEvent.getEntity();
        boolean bl2 = this.plugin.getPermsByLoc(potionEffect22.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        for (LivingEntity livingEntity : potionSplashEvent.getAffectedEntities()) {
            if (livingEntity.getType() != EntityType.PLAYER) continue;
            Boolean bl3 = this.plugin.getPermsByLoc(livingEntity.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
            if (!bl2 || !bl3.booleanValue()) {
                potionSplashEvent.setIntensity(livingEntity, 0.0);
                continue;
            }
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(livingEntity.getLocation());
            if (!(livingEntity instanceof Player) || !(projectileSource instanceof Player)) continue;
            Player player = null;
            if (projectileSource instanceof Player) {
                player = (Player)projectileSource;
            }
            if (player == null) continue;
            if (!(livingEntity instanceof Player)) {
                return;
            }
            ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(player.getLocation());
            if (claimedResidence2 == null || claimedResidence == null || !claimedResidence2.equals(claimedResidence) || !claimedResidence2.getPermissions().playerHas((Player)livingEntity, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse) || !claimedResidence2.getPermissions().playerHas(player, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse)) continue;
            ActionBarManager.send(player, this.plugin.getLM().getMessage(lm.General_NoFriendlyFire, new Object[0]));
            potionSplashEvent.setIntensity(livingEntity, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerKillingByFlame(EntityCombustByEntityEvent entityCombustByEntityEvent) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityCombustByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityCombustByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityCombustByEntityEvent.getEntity();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (claimedResidence == null) {
            return;
        }
        Entity entity2 = entityCombustByEntityEvent.getCombuster();
        if (!ResidenceEntityListener.damageableProjectile(entity2) && !(entity2 instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(entity2) && !(((Projectile)entity2).getShooter() instanceof Player)) {
            return;
        }
        Player player = null;
        player = entity2 instanceof Player ? (Player)entity2 : (Player)((Projectile)entity2).getShooter();
        if (player == null) {
            return;
        }
        Boolean bl = this.plugin.getPermsByLoc(player.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        Boolean bl2 = this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        if (!bl.booleanValue() || !bl2.booleanValue()) {
            entityCombustByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void OnFallDamage(EntityDamageEvent entityDamageEvent) {
        if (!Flags.falldamage.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.falldamage, FlagPermissions.FlagCombo.TrueOrNone)) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void OnArmorStandFlameDamage(EntityDamageEvent entityDamageEvent) {
        if (this.plugin.isDisabledWorldListener(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!this.plugin.getNms().isArmorStandEntity(entity.getType()) && !(entity instanceof Arrow)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.destroy, true)) {
            entityDamageEvent.setCancelled(true);
            entity.setFireTicks(0);
        }
    }

    @EventHandler
    public void OnArmorStandExplosion(EntityDamageEvent entityDamageEvent) {
        if (this.plugin.isDisabledWorldListener(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!this.plugin.getNms().isArmorStandEntity(entity.getType()) && !(entity instanceof Arrow)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.destroy, true)) {
            entityDamageEvent.setCancelled(true);
            entity.setFireTicks(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCatchingFire(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.damageableProjectile(entityDamageByEntityEvent.getDamager())) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() == null || !(entityDamageByEntityEvent.getEntity() instanceof Player)) {
            return;
        }
        Projectile projectile = (Projectile)entityDamageByEntityEvent.getDamager();
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(projectile.getLocation());
        if (!flagPermissions.has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            projectile.setFireTicks(0);
        }
    }

    @EventHandler
    public void OnPlayerDamageByLightning(EntityDamageEvent entityDamageEvent) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.LIGHTNING) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByFireballEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!Flags.fireball.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity.getType() != EntityType.SMALL_FIREBALL && entity.getType() != EntityType.FIREBALL) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(entityDamageByEntityEvent.getEntity().getLocation());
        if (flagPermissions.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByWitherEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (!Flags.witherdamage.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity.getType() != EntityType.WITHER && entity.getType() != EntityType.WITHER_SKULL) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(entityDamageByEntityEvent.getEntity().getLocation());
        if (flagPermissions.has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        ItemFrame itemFrame;
        Object object;
        if (this.plugin.isDisabledWorldListener(entityDamageByEntityEvent.getEntity().getWorld())) {
            return;
        }
        if (entityDamageByEntityEvent.isCancelled()) {
            return;
        }
        if (entityDamageByEntityEvent.getEntityType() != EntityType.ENDER_CRYSTAL && entityDamageByEntityEvent.getEntityType() != EntityType.ITEM_FRAME && !this.plugin.getNms().isArmorStandEntity(entityDamageByEntityEvent.getEntityType())) {
            return;
        }
        Entity entity = entityDamageByEntityEvent.getDamager();
        Player player = null;
        if (entity instanceof Player) {
            player = (Player)entityDamageByEntityEvent.getDamager();
        } else if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            player = (Player)((Projectile)entity).getShooter();
        } else {
            if (entity instanceof Projectile && !(((Projectile)entity).getShooter() instanceof Player)) {
                Location location = entityDamageByEntityEvent.getEntity().getLocation();
                FlagPermissions flagPermissions = this.plugin.getPermsByLoc(location);
                if (flagPermissions.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) {
                    entityDamageByEntityEvent.setCancelled(true);
                }
                return;
            }
            if (entity.getType() == EntityType.PRIMED_TNT || entity.getType() == EntityType.MINECART_TNT) {
                if (Flags.explode.isGlobalyEnabled() && ((FlagPermissions)(object = this.plugin.getPermsByLoc(entityDamageByEntityEvent.getEntity().getLocation()))).has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) {
                    entityDamageByEntityEvent.setCancelled(true);
                    return;
                }
            } else if ((entity.getType() == EntityType.WITHER_SKULL || entity.getType() == EntityType.WITHER) && Flags.witherdamage.isGlobalyEnabled() && ((FlagPermissions)(object = this.plugin.getPermsByLoc(entityDamageByEntityEvent.getEntity().getLocation()))).has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
                entityDamageByEntityEvent.setCancelled(true);
                return;
            }
        }
        object = entityDamageByEntityEvent.getEntity().getLocation();
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc((Location)object);
        if (claimedResidence == null) {
            return;
        }
        if (ResidenceEntityListener.isMonster(entity) && !claimedResidence.getPermissions().has(Flags.destroy, false)) {
            entityDamageByEntityEvent.setCancelled(true);
            return;
        }
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer((Location)object, player);
        if (entityDamageByEntityEvent.getEntityType() == EntityType.ITEM_FRAME && (itemFrame = (ItemFrame)entityDamageByEntityEvent.getEntity()).getItem() != null) {
            if (!PermissionManager.ResPerm.bypass_container.hasPermission((CommandSender)player, 10000L, new String[0]) && !flagPermissions.playerHas(player, Flags.container, true)) {
                entityDamageByEntityEvent.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            }
            return;
        }
        if (!flagPermissions.playerHas(player, Flags.destroy, flagPermissions.playerHas(player, Flags.build, true))) {
            entityDamageByEntityEvent.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityShootBowEvent(EntityShootBowEvent entityShootBowEvent) {
        if (Version.isCurrentEqualOrLower(Version.v1_14_R1)) {
            return;
        }
        if (entityShootBowEvent.getBow() == null) {
            return;
        }
        if (entityShootBowEvent.getBow().getType() != Material.CROSSBOW) {
            return;
        }
        if (!(entityShootBowEvent.getEntity() instanceof Player)) {
            return;
        }
        if (entityShootBowEvent.getProjectile().getType() == EntityType.FIREWORK) {
            entityShootBowEvent.getProjectile().setMetadata(CrossbowShooter, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)entityShootBowEvent.getEntity().getUniqueId()));
        }
    }

    public static boolean canDamageEntity(Entity entity, Entity entity2, boolean bl) {
        boolean bl2 = ResidenceEntityListener.isTamed(entity2);
        ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(entity2.getLocation());
        if (claimedResidence != null && entity2 instanceof Player && entity instanceof Player && (claimedResidence.getPermissions().has(Flags.overridepvp, false) || Residence.getInstance().getConfigManager().isOverridePvp() && claimedResidence.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.OnlyFalse))) {
            return false;
        }
        ClaimedResidence claimedResidence2 = null;
        if (entity != null) {
            claimedResidence2 = Residence.getInstance().getResidenceManager().getByLoc(entity.getLocation());
        }
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (claimedResidence2 != null) {
            bl3 = claimedResidence2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        }
        if ((entity2 instanceof Player || bl2) && (entity instanceof Player || entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) || entity instanceof Firework) {
            Object object;
            Player player = null;
            if (entity instanceof Player) {
                player = (Player)entity;
            } else if (entity instanceof Projectile) {
                object = (Projectile)entity;
                if (object.getType() == EntityType.SNOWBALL && claimedResidence2 != null) {
                    bl5 = true;
                    bl4 = claimedResidence2.getPermissions().has(Flags.snowball, FlagPermissions.FlagCombo.TrueOrNone);
                }
                if (object.getFireTicks() > 0) {
                    bl6 = true;
                }
                player = (Player)((Projectile)entity).getShooter();
            } else if (entity instanceof Firework && (object = entity.getMetadata(CrossbowShooter)) != null && !object.isEmpty()) {
                try {
                    String string = ((MetadataValue)object.get(0)).asString();
                    player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!(entity2 instanceof Player)) {
                return true;
            }
            if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence.isUnderRaid() && claimedResidence.getRaid().onSameTeam(player, (Player)entity2) && !ConfigManager.RaidFriendlyFire) {
                return false;
            }
            if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence.isUnderRaid() && !claimedResidence.getRaid().onSameTeam(player, (Player)entity2)) {
                return true;
            }
            if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence2.getPermissions().playerHas((Player)entity2, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse) && claimedResidence2.getPermissions().playerHas(player, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse)) {
                ActionBarManager.send(player, Residence.getInstance().getLM().getMessage(lm.General_NoFriendlyFire, new Object[0]));
                if (bl6) {
                    entity2.setFireTicks(0);
                }
                return false;
            }
            if (!bl3 && !bl5 || !bl4 && bl5) {
                if (player != null && bl) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                }
                if (bl6) {
                    entity2.setFireTicks(0);
                }
                return false;
            }
            if (claimedResidence == null) {
                if (entity != null && !Residence.getInstance().getWorldFlags().getPerms(entity.getWorld().getName()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                    if (player != null && bl) {
                        Residence.getInstance().msg((CommandSender)player, lm.General_WorldPVPDisabled, new Object[0]);
                    }
                    return false;
                }
                if (player != null && !((FlagPermissions)(object = Residence.getInstance().getPermsByLoc(player.getLocation()))).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                    if (bl) {
                        Residence.getInstance().msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                    }
                    return false;
                }
            } else if (!bl5 && !claimedResidence.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone) || bl5 && !bl4) {
                if (player != null && bl) {
                    Residence.getInstance().msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                }
                return false;
            }
            return true;
        }
        return !(entity2 instanceof Player) && !bl2 || !(entity instanceof Creeper) || (claimedResidence != null || Residence.getInstance().getWorldFlags().getPerms(entity.getWorld().getName()).has(Flags.creeper, true)) && (claimedResidence == null || claimedResidence.getPermissions().has(Flags.creeper, true));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        if (this.plugin.isDisabledWorldListener(entityDamageEvent.getEntity().getWorld())) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity.hasMetadata("NPC")) {
            return;
        }
        boolean bl = ResidenceEntityListener.isTamed(entity);
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            Entity entity2 = entityDamageByEntityEvent.getDamager();
            if (claimedResidence != null && entity instanceof Player && entity2 instanceof Player && (claimedResidence.getPermissions().has(Flags.overridepvp, false) || this.plugin.getConfigManager().isOverridePvp() && claimedResidence.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.OnlyFalse))) {
                Player player;
                Player player2 = player = (Player)entity;
                player2.damage(entityDamageEvent.getDamage());
                player2.setVelocity(entity2.getLocation().getDirection());
                entityDamageEvent.setCancelled(true);
                return;
            }
            ClaimedResidence claimedResidence2 = null;
            if (entity2 != null) {
                claimedResidence2 = this.plugin.getResidenceManager().getByLoc(entity2.getLocation());
            }
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (claimedResidence2 != null) {
                bl2 = claimedResidence2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
            }
            if (((entity = entityDamageByEntityEvent.getEntity()) instanceof Player || bl) && (entity2 instanceof Player || entity2 instanceof Projectile && ((Projectile)entity2).getShooter() instanceof Player) && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.FALL || entity2 instanceof Firework) {
                Object object;
                Player player = null;
                if (entity2 instanceof Player) {
                    player = (Player)entity2;
                } else if (entity2 instanceof Projectile) {
                    object = (Projectile)entity2;
                    if (object.getType() == EntityType.SNOWBALL && claimedResidence2 != null) {
                        bl4 = true;
                        bl3 = claimedResidence2.getPermissions().has(Flags.snowball, FlagPermissions.FlagCombo.TrueOrNone);
                    }
                    if (object.getFireTicks() > 0) {
                        bl5 = true;
                    }
                    player = (Player)((Projectile)entity2).getShooter();
                } else if (entity2 instanceof Firework && (object = entity2.getMetadata(CrossbowShooter)) != null && !object.isEmpty()) {
                    try {
                        String string = ((MetadataValue)object.get(0)).asString();
                        player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!(entity instanceof Player)) {
                    return;
                }
                if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence.isUnderRaid() && claimedResidence.getRaid().onSameTeam(player, (Player)entity) && !ConfigManager.RaidFriendlyFire) {
                    entityDamageEvent.setCancelled(true);
                }
                if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence.isUnderRaid() && !claimedResidence.getRaid().onSameTeam(player, (Player)entity)) {
                    return;
                }
                if (claimedResidence2 != null && claimedResidence != null && claimedResidence2.equals(claimedResidence) && player != null && claimedResidence2.getPermissions().playerHas((Player)entity, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse) && claimedResidence2.getPermissions().playerHas(player, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse)) {
                    ActionBarManager.send(player, this.plugin.getLM().getMessage(lm.General_NoFriendlyFire, new Object[0]));
                    if (bl5) {
                        entity.setFireTicks(0);
                    }
                    entityDamageEvent.setCancelled(true);
                }
                if (!bl2 && !bl4 || !bl3 && bl4) {
                    if (player != null) {
                        this.plugin.msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (bl5) {
                        entity.setFireTicks(0);
                    }
                    entityDamageEvent.setCancelled(true);
                    return;
                }
                if (claimedResidence == null) {
                    if (entity2 != null && !this.plugin.getWorldFlags().getPerms(entity2.getWorld().getName()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        if (player != null) {
                            this.plugin.msg((CommandSender)player, lm.General_WorldPVPDisabled, new Object[0]);
                        }
                        if (bl5) {
                            entity.setFireTicks(0);
                        }
                        entityDamageEvent.setCancelled(true);
                        return;
                    }
                    if (player != null && !((FlagPermissions)(object = this.plugin.getPermsByLoc(player.getLocation()))).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        this.plugin.msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                        if (bl5) {
                            entity.setFireTicks(0);
                        }
                        entityDamageEvent.setCancelled(true);
                        return;
                    }
                } else if (!bl4 && !claimedResidence.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone) || bl4 && !bl3) {
                    if (player != null) {
                        this.plugin.msg((CommandSender)player, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (bl5) {
                        entity.setFireTicks(0);
                    }
                    entityDamageEvent.setCancelled(true);
                    return;
                }
                return;
            }
            if ((entity instanceof Player || bl) && entity2 instanceof Creeper) {
                if (claimedResidence == null && !this.plugin.getWorldFlags().getPerms(entity2.getWorld().getName()).has(Flags.creeper, true)) {
                    entityDamageEvent.setCancelled(true);
                } else if (claimedResidence != null && !claimedResidence.getPermissions().has(Flags.creeper, true)) {
                    entityDamageEvent.setCancelled(true);
                }
            }
        }
        if (claimedResidence == null) {
            if (!this.plugin.getWorldFlags().getPerms(entity.getWorld().getName()).has(Flags.damage, true) && (entity instanceof Player || bl)) {
                entityDamageEvent.setCancelled(true);
            }
        } else if (!claimedResidence.getPermissions().has(Flags.damage, true) && (entity instanceof Player || bl)) {
            entityDamageEvent.setCancelled(true);
        }
        if (entityDamageEvent.isCancelled() && (entity instanceof Player || bl) && (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            entity.setFireTicks(0);
        }
    }
}

