/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarManager;
import com.bekvon.bukkit.cmiLib.CMIBlock;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.commands.auto;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ResidenceBlockListener
implements Listener {
    private List<String> MessageInformed = new ArrayList<String>();
    private Set<UUID> ResCreated = new HashSet<UUID>();
    public static Set<UUID> newPlayers = new HashSet<UUID>();
    private Residence plugin;
    public static final String SourceResidenceName = "SourceResidenceName";

    public ResidenceBlockListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAnvilInventoryClick(InventoryClickEvent inventoryClickEvent) {
        if (!Flags.anvilbreak.isGlobalyEnabled()) {
            return;
        }
        Inventory inventory = inventoryClickEvent.getInventory();
        try {
            if (inventory == null || inventory.getType() != InventoryType.ANVIL || inventoryClickEvent.getInventory().getLocation() == null) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError throwable) {
            return;
        }
        Block block = inventoryClickEvent.getInventory().getLocation().getBlock();
        if (block == null || !CMIMaterial.isAnvil(block.getType())) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(inventoryClickEvent.getInventory().getLocation());
        if (claimedResidence == null) {
            return;
        }
        if (inventoryClickEvent.getRawSlot() != 2) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem() == null || inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (!claimedResidence.getPermissions().has(Flags.anvilbreak, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (Version.isCurrentLower(Version.v1_13_R1)) {
            try {
                block.getClass().getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)1);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        } else {
            block.setType(CMIMaterial.ANVIL.getMaterial());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlantGrow(BlockGrowEvent blockGrowEvent) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockGrowEvent.getBlock().getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockGrowEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.grow, true)) {
            blockGrowEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVineGrow(BlockSpreadEvent blockSpreadEvent) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (blockSpreadEvent.getSource().getType() != Material.VINE) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockSpreadEvent.getBlock().getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockSpreadEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.grow, true)) {
            blockSpreadEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onleaveDecay(LeavesDecayEvent leavesDecayEvent) {
        if (!Flags.decay.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(leavesDecayEvent.getBlock().getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(leavesDecayEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.decay, true)) {
            leavesDecayEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrowt(StructureGrowEvent structureGrowEvent) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(structureGrowEvent.getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(structureGrowEvent.getLocation());
        if (!flagPermissions.has(Flags.grow, true)) {
            structureGrowEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent structureGrowEvent) {
        if (this.plugin.isDisabledWorldListener(structureGrowEvent.getWorld())) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(structureGrowEvent.getLocation());
        List list2 = structureGrowEvent.getBlocks();
        for (BlockState blockState : new ArrayList(list2)) {
            ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(blockState.getLocation());
            if ((claimedResidence != null || claimedResidence2 == null) && (claimedResidence2 == null || claimedResidence == null || claimedResidence.getName().equals(claimedResidence2.getName()) || claimedResidence.isOwner(claimedResidence2.getOwner()))) continue;
            list2.remove(blockState);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        if (!ResidenceBlockListener.canBreakBlock(blockBreakEvent.getPlayer(), blockBreakEvent.getBlock(), true)) {
            blockBreakEvent.setCancelled(true);
        }
    }

    public static boolean canBreakBlock(Player player, Block block, boolean bl) {
        if (player == null) {
            return true;
        }
        if (Residence.getInstance().isDisabledWorldListener(block.getWorld())) {
            return true;
        }
        if (Residence.getInstance().isResAdminOn(player)) {
            return true;
        }
        Material material2 = block.getType();
        String string = block.getWorld().getName();
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (Residence.getInstance().getItemManager().isIgnored(material2, permissionGroup, string)) {
            return true;
        }
        ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(block.getLocation());
        if (claimedResidence != null && claimedResidence.getItemIgnoreList().isListed(material2)) {
            return true;
        }
        if (Residence.getInstance().getConfigManager().enabledRentSystem() && claimedResidence != null && Residence.getInstance().getConfigManager().preventRentModify() && claimedResidence.isRented()) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            }
            return false;
        }
        FlagPermissions flagPermissions = Residence.getInstance().getPermsByLocForPlayer(block.getLocation(), player);
        boolean bl2 = flagPermissions.playerHas(player, Flags.destroy, flagPermissions.playerHas(player, Flags.build, true));
        if (claimedResidence != null && claimedResidence.isUnderRaid() && (claimedResidence.getRaid().isAttacker(player.getUniqueId()) && ConfigManager.RaidAttackerBlockBreak || claimedResidence.getRaid().isDefender(player.getUniqueId()) && ConfigManager.RaidDefenderBlockBreak)) {
            bl2 = true;
        }
        if (!bl2 && !PermissionManager.ResPerm.bypass_destroy.hasPermission((CommandSender)player, 10000L, new String[0])) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            }
            return false;
        }
        if (material2 == Material.CHEST && !flagPermissions.playerHas(player, Flags.container, true)) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            }
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent blockFormEvent) {
        FlagPermissions flagPermissions;
        if (!Flags.snowtrail.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockFormEvent.getBlock().getWorld())) {
            return;
        }
        if (!(blockFormEvent instanceof EntityBlockFormEvent)) {
            return;
        }
        if (((EntityBlockFormEvent)blockFormEvent).getEntity() instanceof Snowman && !(flagPermissions = this.plugin.getPermsByLoc(blockFormEvent.getBlock().getLocation())).has(Flags.snowtrail, true)) {
            blockFormEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceForm(BlockFormEvent blockFormEvent) {
        if (!Flags.iceform.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockFormEvent.getBlock().getWorld())) {
            return;
        }
        Material material2 = Material.getMaterial((String)"FROSTED_ICE");
        if (blockFormEvent.getNewState().getType() != Material.SNOW && blockFormEvent.getNewState().getType() != Material.ICE && material2 != null && material2 != blockFormEvent.getNewState().getType()) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockFormEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.iceform, true)) {
            blockFormEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceMelt(BlockFadeEvent blockFadeEvent) {
        if (!Flags.icemelt.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockFadeEvent.getBlock().getWorld())) {
            return;
        }
        if (!CMIMaterial.get(blockFadeEvent.getNewState().getType()).equals((Object)CMIMaterial.WATER) && blockFadeEvent.getBlock().getState().getType() != Material.SNOW && blockFadeEvent.getBlock().getState().getType() != Material.SNOW_BLOCK) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockFadeEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.icemelt, true)) {
            blockFadeEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (!Flags.fallinprotection.isGlobalyEnabled()) {
            return;
        }
        if (entityChangeBlockEvent.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Entity entity = entityChangeBlockEvent.getEntity();
        if (!entity.hasMetadata(SourceResidenceName)) {
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
            String string = claimedResidence == null ? "NULL" : claimedResidence.getName();
            entity.setMetadata(SourceResidenceName, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)string));
        } else {
            String string;
            String string2 = ((MetadataValue)entity.getMetadata(SourceResidenceName).get(0)).asString();
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
            if (claimedResidence != null && claimedResidence.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) {
                return;
            }
            String string3 = string = claimedResidence == null ? "NULL" : claimedResidence.getName();
            if (!string2.equalsIgnoreCase(string)) {
                entityChangeBlockEvent.setCancelled(true);
                entity.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFall(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (!Flags.fallinprotection.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entityChangeBlockEvent.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isBlockFall()) {
            return;
        }
        if (entityChangeBlockEvent.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (entityChangeBlockEvent.getTo().hasGravity()) {
            return;
        }
        Block block = entityChangeBlockEvent.getBlock();
        if (block == null) {
            return;
        }
        if (!this.plugin.getConfigManager().getBlockFallWorlds().contains(block.getLocation().getWorld().getName())) {
            return;
        }
        if (block.getY() <= this.plugin.getConfigManager().getBlockFallLevel()) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        Location location = new Location(block.getLocation().getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
        int n = location.getBlockY() - 1;
        while (n >= this.plugin.getConfigManager().getBlockFallLevel() - 1) {
            block12: {
                block13: {
                    ClaimedResidence claimedResidence2;
                    location.setY((double)n);
                    if (location.getBlock().getType() == Material.AIR || (claimedResidence2 = this.plugin.getResidenceManager().getByLoc(location)) == null) break block12;
                    if (claimedResidence == null || claimedResidence.getName().equals(claimedResidence2.getName())) break block13;
                    if (claimedResidence2.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) break block12;
                    entityChangeBlockEvent.setCancelled(true);
                    block.setType(Material.AIR);
                }
                return;
            }
            --n;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlace(BlockPlaceEvent blockPlaceEvent) {
        if (this.plugin.isDisabledWorldListener(blockPlaceEvent.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().ShowNoobMessage()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        if (this.plugin.getPlayerManager().getResidenceCount(player.getUniqueId()) != 0) {
            return;
        }
        if (this.MessageInformed.contains(player.getName())) {
            return;
        }
        if (!PermissionManager.ResPerm.newguyresidence.hasPermission((CommandSender)player)) {
            return;
        }
        this.plugin.msg((CommandSender)player, lm.General_NewPlayerInfo, new Object[0]);
        this.MessageInformed.add(player.getName());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChestPlaceNearResidence(BlockPlaceEvent blockPlaceEvent) {
        if (this.plugin.isDisabledWorldListener(blockPlaceEvent.getBlock().getWorld())) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        boolean bl = false;
        ClaimedResidence claimedResidence2 = null;
        Block block2 = block.getLocation().clone().add(0.0, 0.0, -1.0).getBlock();
        if (block2.getType() == block.getType() && (claimedResidence2 = this.plugin.getResidenceManager().getByLoc(block2.getLocation())) != null && !claimedResidence2.equals(claimedResidence)) {
            bl = true;
        }
        if ((block2 = block.getLocation().clone().add(0.0, 0.0, 1.0).getBlock()).getType() == block.getType() && (claimedResidence2 = this.plugin.getResidenceManager().getByLoc(block2.getLocation())) != null && !claimedResidence2.equals(claimedResidence)) {
            bl = true;
        }
        if ((block2 = block.getLocation().clone().add(1.0, 0.0, 0.0).getBlock()).getType() == block.getType() && (claimedResidence2 = this.plugin.getResidenceManager().getByLoc(block2.getLocation())) != null && !claimedResidence2.equals(claimedResidence)) {
            bl = true;
        }
        if ((block2 = block.getLocation().clone().add(-1.0, 0.0, 0.0).getBlock()).getType() == block.getType() && (claimedResidence2 = this.plugin.getResidenceManager().getByLoc(block2.getLocation())) != null && !claimedResidence2.equals(claimedResidence)) {
            bl = true;
        }
        if (bl) {
            ActionBarManager.send(player, this.plugin.msg(lm.General_CantPlaceChest, new Object[0]));
            blockPlaceEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlaceCreateRes(BlockPlaceEvent blockPlaceEvent) {
        if (this.plugin.isDisabledWorldListener(blockPlaceEvent.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isNewPlayerUse()) {
            return;
        }
        Player player = blockPlaceEvent.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = blockPlaceEvent.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        if (this.plugin.getPlayerManager().getResidenceCount(player.getUniqueId()) != 0) {
            return;
        }
        if (this.ResCreated.contains(player.getUniqueId())) {
            return;
        }
        if (!newPlayers.contains(player.getUniqueId())) {
            return;
        }
        Location location = block.getLocation();
        this.plugin.getSelectionManager().placeLoc1(player, new Location(location.getWorld(), (double)(location.getBlockX() - 1), (double)(location.getBlockY() - 1), (double)(location.getBlockZ() - 1)), true);
        this.plugin.getSelectionManager().placeLoc2(player, new Location(location.getWorld(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1)), true);
        ResidenceBlockListener.resize(this.plugin, player, this.plugin.getSelectionManager().getSelectionCuboid(player), !this.plugin.getConfigManager().isNewPlayerFree(), this.plugin.getConfigManager().getNewPlayerRangeX() * 2, this.plugin.getConfigManager().getNewPlayerRangeY() * 2, this.plugin.getConfigManager().getNewPlayerRangeZ() * 2);
        boolean bl = this.plugin.getResidenceManager().addResidence(player, player.getName(), this.plugin.getSelectionManager().getPlayerLoc1(player), this.plugin.getSelectionManager().getPlayerLoc2(player), this.plugin.getConfigManager().isNewPlayerFree());
        if (bl) {
            this.ResCreated.add(player.getUniqueId());
            newPlayers.remove(player.getUniqueId());
        }
    }

    public static void resize(Residence residence, Player player, CuboidArea cuboidArea, boolean bl, int n, int n2, int n3) {
        ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        double d = cuboidArea.getCost(permissionGroup);
        double d2 = 0.0;
        if (residence.getEconomyManager() != null) {
            d2 = residence.getEconomyManager().getBalance(player.getName());
        }
        auto.direction direction2 = auto.direction.Top;
        ArrayList<auto.direction> arrayList = new ArrayList<auto.direction>();
        boolean bl2 = residence.getConfigManager().isAutomaticResidenceCreationCheckCollision();
        int n4 = 0;
        int n5 = 0;
        while (n4 < 6 && ++n5 <= 10000) {
            if (arrayList.contains((Object)direction2)) {
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            CuboidArea cuboidArea2 = new CuboidArea();
            cuboidArea2.setLowLocation(cuboidArea.getLowLoc().clone().add(-direction2.getLow().getX(), -direction2.getLow().getY(), -direction2.getLow().getZ()));
            cuboidArea2.setHighLocation(cuboidArea.getHighLoc().clone().add(direction2.getHigh().getX(), direction2.getHigh().getY(), direction2.getHigh().getZ()));
            if (cuboidArea2.getLowLoc().getY() < 0.0) {
                cuboidArea2.getLowLoc().setY(0.0);
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            if (cuboidArea2.getHighLoc().getY() >= (double)cuboidArea2.getWorld().getMaxHeight()) {
                cuboidArea2.getHighLoc().setY((double)(cuboidArea2.getWorld().getMaxHeight() - 1));
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            if (bl2 && residence.getResidenceManager().collidesWithResidence(cuboidArea2) != null) {
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            if (cuboidArea2.getXSize() >= n - permissionGroup.getMinX()) {
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            if (cuboidArea2.getYSize() >= n2 - permissionGroup.getMinY()) {
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            if (cuboidArea2.getZSize() >= n3 - permissionGroup.getMinZ()) {
                arrayList.add(direction2);
                direction2 = direction2.getNext();
                ++n4;
                continue;
            }
            n4 = 0;
            if (bl && residence.getConfigManager().enableEconomy() && (d = cuboidArea2.getCost(permissionGroup)) > d2) break;
            cuboidArea.setLowLocation(cuboidArea2.getLowLoc());
            cuboidArea.setHighLocation(cuboidArea2.getHighLoc());
            direction2 = direction2.getNext();
        }
        residence.getSelectionManager().placeLoc1(player, cuboidArea.getLowLoc());
        residence.getSelectionManager().placeLoc2(player, cuboidArea.getHighLoc());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        if (!ResidenceBlockListener.canPlaceBlock(blockPlaceEvent.getPlayer(), blockPlaceEvent.getBlock(), true)) {
            blockPlaceEvent.setCancelled(true);
        }
    }

    public static boolean canPlaceBlock(Player player, Block block, boolean bl) {
        CMIBlock cMIBlock;
        Block block2;
        Object object;
        if (Residence.getInstance().isDisabledWorldListener(block.getWorld())) {
            return true;
        }
        if (Residence.getInstance().isResAdminOn(player)) {
            return true;
        }
        Material material2 = block.getType();
        String string = block.getWorld().getName();
        ResidencePlayer residencePlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (Residence.getInstance().getItemManager().isIgnored(material2, permissionGroup, string)) {
            return true;
        }
        ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByLoc(block.getLocation());
        if (Residence.getInstance().getConfigManager().enabledRentSystem() && claimedResidence != null) {
            object = claimedResidence.getName();
            if (Residence.getInstance().getConfigManager().preventRentModify() && Residence.getInstance().getRentManager().isRented((String)object)) {
                if (bl) {
                    Residence.getInstance().msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                }
                return false;
            }
        }
        if (claimedResidence != null && !claimedResidence.getItemBlacklist().isAllowed(material2)) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            }
            return false;
        }
        object = Residence.getInstance().getPermsByLocForPlayer(block.getLocation(), player);
        boolean bl2 = ((FlagPermissions)object).playerHas(player, Flags.place, ((FlagPermissions)object).playerHas(player, Flags.build, true));
        if (claimedResidence != null && claimedResidence.isUnderRaid() && (claimedResidence.getRaid().isAttacker(player.getUniqueId()) && ConfigManager.RaidAttackerBlockPlace || claimedResidence.getRaid().isDefender(player.getUniqueId()) && ConfigManager.RaidDefenderBlockPlace)) {
            bl2 = true;
        }
        if (!bl2 && !PermissionManager.ResPerm.bypass_build.hasPermission((CommandSender)player, 10000L, new String[0])) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
            }
            return false;
        }
        if (CMIMaterial.isBed(material2) && (block2 = (cMIBlock = new CMIBlock(block)).getSecondaryBedBlock()) != null && !(bl2 = ((FlagPermissions)(object = Residence.getInstance().getPermsByLocForPlayer(block2.getLocation(), player))).playerHas(player, Flags.place, ((FlagPermissions)object).playerHas(player, Flags.build, true))) && !PermissionManager.ResPerm.bypass_build.hasPermission((CommandSender)player, 10000L, new String[0])) {
            if (bl) {
                Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
            }
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent blockSpreadEvent) {
        if (!Flags.spread.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockSpreadEvent.getBlock().getWorld())) {
            return;
        }
        Location location = blockSpreadEvent.getBlock().getLocation();
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(location);
        if (!flagPermissions.has(Flags.spread, true)) {
            blockSpreadEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        if (this.plugin.isDisabledWorldListener(blockPistonRetractEvent.getBlock().getWorld())) {
            return;
        }
        if (!Flags.piston.isGlobalyEnabled()) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockPistonRetractEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.piston, true)) {
            blockPistonRetractEvent.setCancelled(true);
            return;
        }
        if (!Flags.pistonprotection.isGlobalyEnabled()) {
            return;
        }
        List<Block> list2 = this.plugin.getNms().getPistonRetractBlocks(blockPistonRetractEvent);
        if (!blockPistonRetractEvent.isSticky()) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(blockPistonRetractEvent.getBlock().getLocation());
        for (Block block : list2) {
            Location location = block.getLocation();
            ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(location);
            if (claimedResidence2 == null || claimedResidence2 == claimedResidence || claimedResidence != null && claimedResidence2.isOwner(claimedResidence.getOwner()) || !claimedResidence2.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            blockPistonRetractEvent.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        Location location;
        Object object2;
        if (this.plugin.isDisabledWorldListener(blockPistonExtendEvent.getBlock().getWorld())) {
            return;
        }
        if (!Flags.piston.isGlobalyEnabled()) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockPistonExtendEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.piston, true)) {
            blockPistonExtendEvent.setCancelled(true);
            return;
        }
        if (!Flags.pistonprotection.isGlobalyEnabled()) {
            return;
        }
        Location location2 = blockPistonExtendEvent.getBlock().getLocation();
        int n = 255;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = -2147483647;
        int n6 = -2147483647;
        BlockFace blockFace = blockPistonExtendEvent.getDirection();
        for (Object object2 : blockPistonExtendEvent.getBlocks()) {
            location = object2.getLocation().clone().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ());
            if (location.getBlockY() < n) {
                n = location.getBlockY();
            }
            if (location.getBlockX() < n3) {
                n3 = location.getBlockX();
            }
            if (location.getBlockZ() < n4) {
                n4 = location.getBlockZ();
            }
            if (location.getBlockY() > n2) {
                n2 = location.getBlockY();
            }
            if (location.getBlockX() > n5) {
                n5 = location.getBlockX();
            }
            if (location.getBlockZ() <= n6) continue;
            n6 = location.getBlockZ();
        }
        object2 = this.plugin.getResidenceManager().getByLoc(blockPistonExtendEvent.getBlock().getLocation());
        if (object2 != null && ((ClaimedResidence)object2).containsLoc(new Location(location2.getWorld(), (double)n3, (double)n, (double)n4)) && ((ClaimedResidence)object2).containsLoc(new Location(location2.getWorld(), (double)n5, (double)n2, (double)n6))) {
            return;
        }
        int n7 = blockPistonExtendEvent.getBlocks().size() - 1;
        while (n7 >= 0) {
            boolean bl;
            location = (Block)blockPistonExtendEvent.getBlocks().get(n7);
            Location location3 = location.getLocation().clone().add((double)blockFace.getModX(), (double)blockFace.getModY(), (double)blockFace.getModZ());
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location3);
            boolean bl2 = bl = claimedResidence != null && claimedResidence.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue);
            if (object2 == null && bl || claimedResidence != null && object2 != null && !claimedResidence.isOwner(((ClaimedResidence)object2).getOwner()) && bl) {
                blockPistonExtendEvent.setCancelled(true);
                return;
            }
            --n7;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent blockFromToEvent) {
        if (this.plugin.isDisabledWorldListener(blockFromToEvent.getBlock().getWorld())) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(blockFromToEvent.getBlock().getLocation());
        ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(blockFromToEvent.getToBlock().getLocation());
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockFromToEvent.getToBlock().getLocation());
        boolean bl = flagPermissions.has(Flags.flow, FlagPermissions.FlagCombo.TrueOrNone);
        Material material2 = blockFromToEvent.getBlock().getType();
        if (flagPermissions.has(Flags.flowinprotection, FlagPermissions.FlagCombo.TrueOrNone) && (claimedResidence == null && claimedResidence2 != null || claimedResidence != null && claimedResidence2 != null && !claimedResidence.equals(claimedResidence2) && !claimedResidence.isOwner(claimedResidence2.getOwner()))) {
            blockFromToEvent.setCancelled(true);
            return;
        }
        if (flagPermissions.has(Flags.flow, FlagPermissions.FlagCombo.OnlyFalse)) {
            blockFromToEvent.setCancelled(true);
            return;
        }
        if (material2 == Material.LAVA) {
            if (!flagPermissions.has(Flags.lavaflow, bl)) {
                blockFromToEvent.setCancelled(true);
            }
            return;
        }
        if (material2 == Material.WATER) {
            if (!flagPermissions.has(Flags.waterflow, bl)) {
                blockFromToEvent.setCancelled(true);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryFade(BlockFadeEvent blockFadeEvent) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockFadeEvent.getBlock().getWorld())) {
            return;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(blockFadeEvent.getBlock());
        if (!cMIMaterial.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockFadeEvent.getNewState().getLocation());
        if (!flagPermissions.has(Flags.dryup, true)) {
            Block block = blockFadeEvent.getBlock();
            try {
                block.getClass().getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)7);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            blockFadeEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent blockPhysicsEvent) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockPhysicsEvent.getBlock().getWorld())) {
            return;
        }
        if (!blockPhysicsEvent.getBlock().getWorld().isChunkLoaded((int)Math.floor(blockPhysicsEvent.getBlock().getLocation().getX()) >> 4, (int)Math.floor(blockPhysicsEvent.getBlock().getLocation().getZ()) >> 4)) {
            return;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(blockPhysicsEvent.getBlock());
        if (!cMIMaterial.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockPhysicsEvent.getBlock().getLocation());
        if (flagPermissions.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) {
            Block block = blockPhysicsEvent.getBlock();
            try {
                block.getClass().getMethod("setData", Byte.TYPE).invoke((Object)block, (byte)7);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            blockPhysicsEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDispense(BlockDispenseEvent blockDispenseEvent) {
        ClaimedResidence claimedResidence;
        if (this.plugin.isDisabledWorldListener(blockDispenseEvent.getBlock().getWorld())) {
            return;
        }
        if (blockDispenseEvent.isCancelled()) {
            return;
        }
        Location location = new Location(blockDispenseEvent.getBlock().getWorld(), (double)blockDispenseEvent.getVelocity().getBlockX(), (double)blockDispenseEvent.getVelocity().getBlockY(), (double)blockDispenseEvent.getVelocity().getBlockZ());
        ClaimedResidence claimedResidence2 = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence2 == null && location.getBlockY() >= this.plugin.getConfigManager().getPlaceLevel() && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName())) {
            claimedResidence = blockDispenseEvent.getItem();
            if (this.plugin.getConfigManager().isNoLavaPlace() && claimedResidence.getType() == Material.LAVA_BUCKET) {
                blockDispenseEvent.setCancelled(true);
                return;
            }
            if (this.plugin.getConfigManager().isNoWaterPlace() && claimedResidence.getType() == Material.WATER_BUCKET) {
                blockDispenseEvent.setCancelled(true);
                return;
            }
        }
        if (((claimedResidence = this.plugin.getResidenceManager().getByLoc(blockDispenseEvent.getBlock().getLocation())) == null && claimedResidence2 != null || claimedResidence != null && claimedResidence2 == null || claimedResidence != null && claimedResidence2 != null && !claimedResidence.getName().equals(claimedResidence2.getName())) && (blockDispenseEvent.getItem().getType() == Material.LAVA_BUCKET || blockDispenseEvent.getItem().getType() == Material.WATER_BUCKET)) {
            blockDispenseEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLavaWaterFlow(BlockFromToEvent blockFromToEvent) {
        if (this.plugin.isDisabledWorldListener(blockFromToEvent.getBlock().getWorld())) {
            return;
        }
        Material material2 = blockFromToEvent.getBlock().getType();
        Location location = blockFromToEvent.getToBlock().getLocation();
        if (!this.plugin.getConfigManager().getNoFlowWorlds().contains(location.getWorld().getName())) {
            return;
        }
        if (location.getBlockY() < this.plugin.getConfigManager().getFlowLevel()) {
            return;
        }
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(location);
        if (claimedResidence != null) {
            return;
        }
        if (this.plugin.getConfigManager().isNoLava() && material2 == Material.LAVA) {
            blockFromToEvent.setCancelled(true);
            return;
        }
        if (this.plugin.getConfigManager().isNoWater() && material2 == Material.WATER) {
            blockFromToEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent blockBurnEvent) {
        if (!Flags.firespread.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockBurnEvent.getBlock().getWorld())) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockBurnEvent.getBlock().getLocation());
        if (!flagPermissions.has(Flags.firespread, true)) {
            blockBurnEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent blockIgniteEvent) {
        if (this.plugin.isDisabledWorldListener(blockIgniteEvent.getBlock().getWorld())) {
            return;
        }
        BlockIgniteEvent.IgniteCause igniteCause = blockIgniteEvent.getCause();
        if (igniteCause == BlockIgniteEvent.IgniteCause.SPREAD) {
            if (!Flags.firespread.isGlobalyEnabled()) {
                return;
            }
            FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockIgniteEvent.getBlock().getLocation());
            if (!flagPermissions.has(Flags.firespread, true)) {
                blockIgniteEvent.setCancelled(true);
            }
        } else if (igniteCause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            if (!Flags.ignite.isGlobalyEnabled()) {
                return;
            }
            Player player = blockIgniteEvent.getPlayer();
            FlagPermissions flagPermissions = this.plugin.getPermsByLocForPlayer(blockIgniteEvent.getBlock().getLocation(), player);
            if (player != null && !flagPermissions.playerHas(player, Flags.ignite, true) && !this.plugin.isResAdminOn(player)) {
                blockIgniteEvent.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.ignite});
            }
        } else {
            if (!Flags.ignite.isGlobalyEnabled()) {
                return;
            }
            FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockIgniteEvent.getBlock().getLocation());
            if (!flagPermissions.has(Flags.ignite, true)) {
                blockIgniteEvent.setCancelled(true);
            }
        }
    }
}

