/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.itemlist;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.itemlist.WorldItemList;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class WorldItemManager {
    protected List<WorldItemList> lists;
    private Residence plugin;

    public WorldItemManager(Residence residence) {
        this.plugin = residence;
        this.lists = new ArrayList<WorldItemList>();
        this.readLists();
    }

    public boolean isAllowed(Material material2, PermissionGroup permissionGroup, String string) {
        if (material2 == null) {
            return true;
        }
        if (permissionGroup == null) {
            return true;
        }
        return this.isAllowed(material2, permissionGroup.getGroupName(), string);
    }

    public boolean isAllowed(Material material2, String string, String string2) {
        if (material2 == null) {
            return true;
        }
        if (!CMIMaterial.isValidItem(material2)) {
            return true;
        }
        for (WorldItemList worldItemList : this.lists) {
            if (worldItemList.isAllowed(material2, string2, string)) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnored(Material material2, PermissionGroup permissionGroup, String string) {
        if (permissionGroup == null) {
            return false;
        }
        return this.isIgnored(material2, permissionGroup.getGroupName(), string);
    }

    public boolean isIgnored(Material material2, String string, String string2) {
        for (WorldItemList worldItemList : this.lists) {
            if (!worldItemList.isIgnored(material2, string2, string)) continue;
            return true;
        }
        return false;
    }

    private void readLists() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
        if (!yamlConfiguration.isConfigurationSection("ItemList")) {
            return;
        }
        Set set2 = yamlConfiguration.getConfigurationSection("ItemList").getKeys(false);
        if (set2 != null) {
            for (String string : set2) {
                try {
                    WorldItemList worldItemList = WorldItemList.readList(yamlConfiguration.getConfigurationSection("ItemList." + string));
                    this.lists.add(worldItemList);
                }
                catch (Exception exception) {
                    System.out.println("Failed to load item list:" + string);
                }
            }
        }
    }
}

