/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.itemlist;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ItemList {
    protected List<Material> list = new ArrayList<Material>();
    protected ListType type;

    public ItemList(ListType listType) {
        this();
        this.type = listType;
    }

    protected ItemList() {
    }

    public ListType getType() {
        return this.type;
    }

    public boolean contains(Material material2) {
        if (material2 == null || CMIMaterial.isAir(material2)) {
            return false;
        }
        return this.list.contains(material2);
    }

    public void add(Material material2) {
        if (!this.list.contains(material2) && material2 != null && !CMIMaterial.isAir(material2)) {
            this.list.add(material2);
        }
    }

    public boolean toggle(Material material2) {
        if (this.list.contains(material2)) {
            this.list.remove(material2);
            return false;
        }
        if (material2 != null && !CMIMaterial.isAir(material2)) {
            this.list.add(material2);
        }
        return true;
    }

    public void remove(Material material2) {
        this.list.remove(material2);
    }

    public boolean isAllowed(Material material2) {
        if (material2 == null) {
            return true;
        }
        if (this.type == ListType.BLACKLIST) {
            return !this.list.contains(material2);
        }
        if (this.type == ListType.WHITELIST) {
            return this.list.contains(material2);
        }
        return true;
    }

    public boolean isIgnored(Material material2) {
        if (material2 == null) {
            return false;
        }
        return this.type == ListType.IGNORELIST && this.list.contains(material2);
    }

    public boolean isListed(Material material2) {
        return this.contains(material2);
    }

    public int getListSize() {
        return this.list.size();
    }

    public static ItemList readList(ConfigurationSection configurationSection) {
        return ItemList.readList(configurationSection, new ItemList());
    }

    protected static ItemList readList(ConfigurationSection configurationSection, ItemList itemList) {
        ListType listType;
        itemList.type = listType = ListType.valueOf(configurationSection.getString("Type", "").toUpperCase());
        List list2 = configurationSection.getStringList("Items");
        if (list2 != null) {
            for (String string : list2) {
                Material material2;
                int n = -1;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == -1) {
                    try {
                        material2 = CMIMaterial.get(string.toUpperCase()).getMaterial();
                        if (material2 == null) continue;
                        itemList.add(material2);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    material2 = CMIMaterial.get(n).getMaterial();
                    if (material2 == null) continue;
                    itemList.add(material2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return itemList;
    }

    public void printList(Player player) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Material material2 : this.list) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                stringBuilder.append(ChatColor.YELLOW);
            }
            stringBuilder.append(material2);
            bl = false;
        }
        player.sendMessage(stringBuilder.toString());
    }

    public Material[] toArray() {
        Material[] materialArray = new Material[this.list.size()];
        int n = 0;
        Iterator<Material> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            Material material2;
            materialArray[n] = material2 = iterator.next();
            ++n;
        }
        return materialArray;
    }

    public Map<String, Object> save() {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (this.list.isEmpty()) {
            return linkedHashMap;
        }
        linkedHashMap.put("Type", this.type.toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Material material2 : this.list) {
            arrayList.add(material2.toString());
        }
        linkedHashMap.put("ItemList", arrayList);
        return linkedHashMap;
    }

    public static ItemList load(Map<String, Object> map) {
        ItemList itemList = new ItemList();
        return ItemList.load(map, itemList);
    }

    protected static ItemList load(Map<String, Object> map, ItemList itemList) {
        try {
            itemList.type = ListType.valueOf((String)map.get("Type"));
            List list2 = (List)map.get("ItemList");
            for (String string : list2) {
                CMIMaterial cMIMaterial = CMIMaterial.get(string);
                if (cMIMaterial == null || cMIMaterial.getMaterial() == null) continue;
                itemList.add(cMIMaterial.getMaterial());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemList;
    }

    public static enum ListType {
        BLACKLIST,
        WHITELIST,
        IGNORELIST,
        OTHER;

    }
}

