/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.gui;

import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.gui.FlagData;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class setFlagInfo {
    private ClaimedResidence residence;
    private Player player;
    private String targetPlayer = null;
    private LinkedHashMap<Flags, List<String>> description = new LinkedHashMap();
    private List<CMIGuiButton> buttons = new ArrayList<CMIGuiButton>();
    private boolean admin = false;

    public setFlagInfo(ClaimedResidence claimedResidence, Player player, boolean bl) {
        this.residence = claimedResidence;
        this.player = player;
        this.admin = bl;
        this.fillFlagDescriptions();
    }

    public setFlagInfo(ClaimedResidence claimedResidence, Player player, String string, boolean bl) {
        this.residence = claimedResidence;
        this.player = player;
        this.targetPlayer = string;
        this.admin = bl;
        this.fillFlagDescriptions();
    }

    public void setAdmin(boolean bl) {
        this.admin = bl;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public ClaimedResidence getResidence() {
        return this.residence;
    }

    public Player getPlayer() {
        return this.player;
    }

    private void fillFlagDescriptions() {
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags flags2 = flagsArray[n2];
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = 0;
            String string = "";
            String[] stringArray = flags2.getDesc().split(" ");
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String string2 = stringArray[n5];
                string = String.valueOf(string) + string2 + " ";
                if (n3 > 4) {
                    arrayList.add(ChatColor.YELLOW + string);
                    string = "";
                    n3 = 0;
                }
                ++n3;
                ++n5;
            }
            arrayList.add(ChatColor.YELLOW + string);
            this.description.put(flags2, arrayList);
            ++n2;
        }
    }

    public void recalculate() {
        if (this.targetPlayer == null) {
            this.recalculateResidence();
        } else {
            this.recalculatePlayer();
        }
    }

    private void recalculateResidence() {
        Map.Entry<String, Boolean> entry2;
        this.buttons.clear();
        List<String> list2 = this.residence.getPermissions().getPosibleFlags(this.player, true, this.admin);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Map<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, Boolean> map2 = Residence.getInstance().getPermissionManager().getAllFlags().getFlags();
        for (Map.Entry<String, Boolean> entry2 : this.residence.getPermissions().getFlags().entrySet()) {
            if (!list2.contains(entry2.getKey())) continue;
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        for (Map.Entry<String, Boolean> entry2 : map2.entrySet()) {
            String string = entry2.getKey();
            Flags flags2 = Flags.getFlag(string);
            if (flags2 != null && !flags2.isGlobalyEnabled() || !list2.contains(entry2.getKey())) continue;
            if (hashMap.containsKey(entry2.getKey())) {
                map.put((String)entry2.getKey(), (Object)((Boolean)hashMap.get(entry2.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE));
                continue;
            }
            map.put((String)entry2.getKey(), (Object)FlagPermissions.FlagState.NEITHER);
        }
        if (this.targetPlayer == null) {
            map.remove("admin");
        }
        map = Residence.getInstance().getSortingManager().sortByKeyASC(map);
        entry2 = new LinkedHashMap();
        for (Map.Entry entry3 : map.entrySet()) {
            ((HashMap)((Object)entry2)).put((String)entry3.getKey(), (Boolean)entry3.getValue());
        }
        final String string = this.admin ? "resadmin" : "res";
        int n = 0;
        for (final Map.Entry entry4 : ((LinkedHashMap)((Object)entry2)).entrySet()) {
            n = n > 44 ? 0 : n;
            CMIGuiButton cMIGuiButton = new CMIGuiButton(n, this.updateLook((String)entry4.getKey())){

                @Override
                public void click(GUIManager.GUIClickType gUIClickType) {
                    String string2 = "true";
                    switch (gUIClickType) {
                        case Left: {
                            break;
                        }
                        case Right: {
                            string2 = "false";
                            break;
                        }
                        case LeftShift: 
                        case RightShift: 
                        case MiddleMouse: {
                            string2 = "remove";
                            break;
                        }
                    }
                    Bukkit.dispatchCommand((CommandSender)setFlagInfo.this.player, (String)(String.valueOf(string) + " set " + setFlagInfo.this.residence.getName() + " " + (String)entry4.getKey() + " " + string2));
                    if (Residence.getInstance().getConfigManager().isConsoleLogsShowFlagChanges()) {
                        Residence.getInstance().consoleMessage(String.valueOf(setFlagInfo.this.player.getName()) + " issued server command: /" + string + " set " + setFlagInfo.this.residence.getName() + " " + (String)entry4.getKey() + " " + string2);
                    }
                    this.updateLooks();
                }

                @Override
                public void updateLooks() {
                    this.setItem(setFlagInfo.this.updateLook((String)entry4.getKey()));
                    this.hideItemFlags();
                    this.update();
                }
            };
            cMIGuiButton.hideItemFlags();
            this.buttons.add(cMIGuiButton);
            ++n;
        }
    }

    private void recalculatePlayer() {
        Object object;
        HashMap<String, Boolean> object3 = new HashMap<String, Boolean>();
        Flags[] object42 = Flags.values();
        int n = object42.length;
        int n2 = 0;
        while (n2 < n) {
            object = object42[n2];
            object3.put(((Enum)object).toString(), ((Flags)((Object)object)).isEnabled());
            ++n2;
        }
        object = this.residence.getPermissions().getPosibleFlags(this.player, false, this.admin);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> entry : this.residence.getPermissions().getFlags().entrySet()) {
            if (!object.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        if (this.targetPlayer != null) {
            Set<String> set2 = FlagPermissions.getAllPosibleFlags();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            for (String string : set2) {
                if (!object3.containsKey(string)) continue;
                hashMap2.put(string, (Boolean)object3.get(string));
            }
            object3 = hashMap2;
            Map<String, Boolean> map = this.residence.getPermissions().getPlayerFlags(this.targetPlayer);
            if (map != null) {
                for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : object3.entrySet()) {
            if (!object.contains(entry.getKey())) continue;
            if (hashMap.containsKey(entry.getKey())) {
                linkedHashMap.put((String)entry.getKey(), (Object)((Boolean)hashMap.get(entry.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE));
                continue;
            }
            linkedHashMap.put((String)entry.getKey(), (Object)FlagPermissions.FlagState.NEITHER);
        }
        LinkedHashMap linkedHashMap2 = (LinkedHashMap)Residence.getInstance().getSortingManager().sortByKeyASC(linkedHashMap);
        LinkedHashMap linkedHashMap3 = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            linkedHashMap3.put((String)entry.getKey(), entry.getValue());
        }
        final String string = this.targetPlayer == null ? "" : " " + this.targetPlayer;
        final String string2 = this.admin ? "resadmin" : "res";
        int n3 = 0;
        for (final Map.Entry entry : linkedHashMap3.entrySet()) {
            n3 = n3 > 44 ? 0 : n3;
            CMIGuiButton cMIGuiButton = new CMIGuiButton(n3, this.updateLook((String)entry.getKey())){

                @Override
                public void click(GUIManager.GUIClickType gUIClickType) {
                    String string3 = "true";
                    switch (gUIClickType) {
                        case Left: {
                            break;
                        }
                        case Right: {
                            string3 = "false";
                            break;
                        }
                        case LeftShift: 
                        case RightShift: 
                        case MiddleMouse: {
                            string3 = "remove";
                            break;
                        }
                    }
                    Bukkit.dispatchCommand((CommandSender)setFlagInfo.this.player, (String)(String.valueOf(string2) + " pset " + setFlagInfo.this.residence.getName() + string + " " + (String)entry.getKey() + " " + string3));
                    if (Residence.getInstance().getConfigManager().isConsoleLogsShowFlagChanges()) {
                        Residence.getInstance().consoleMessage(String.valueOf(setFlagInfo.this.player.getName()) + " issued server command: /" + string2 + " pset " + setFlagInfo.this.residence.getName() + string + " " + (String)entry.getKey() + " " + string3);
                    }
                    this.updateLooks();
                }

                @Override
                public void updateLooks() {
                    this.setItem(setFlagInfo.this.updateLook((String)entry.getKey()));
                    this.hideItemFlags();
                    this.update();
                }
            };
            ++n3;
            cMIGuiButton.hideItemFlags();
            this.buttons.add(cMIGuiButton);
        }
    }

    private ItemStack updateLook(String string) {
        ItemMeta itemMeta;
        Boolean bl = null;
        ResidencePermissions residencePermissions = this.residence.getPermissions();
        if (this.targetPlayer != null) {
            if (residencePermissions.playerHas(this.targetPlayer, string, FlagPermissions.FlagCombo.OnlyTrue)) {
                bl = true;
            } else if (residencePermissions.playerHas(this.targetPlayer, string, FlagPermissions.FlagCombo.OnlyFalse)) {
                bl = false;
            }
        } else if (residencePermissions.has(string, FlagPermissions.FlagCombo.OnlyTrue)) {
            bl = true;
        } else if (residencePermissions.has(string, FlagPermissions.FlagCombo.OnlyFalse)) {
            bl = false;
        }
        FlagPermissions.FlagState flagState = FlagPermissions.FlagState.NEITHER;
        if (bl != null) {
            flagState = bl != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE;
        }
        ItemStack itemStack = Residence.getInstance().getConfigManager().getGuiBottonStates(flagState).clone();
        FlagData flagData = Residence.getInstance().getFlagUtilManager().getFlagData();
        if (flagData.contains(string)) {
            itemStack = flagData.getItem(string).clone();
        }
        if (flagState == FlagPermissions.FlagState.TRUE) {
            itemMeta = itemStack.getItemMeta();
            itemMeta.addEnchant(Enchantment.LUCK, 1, true);
            itemStack.setItemMeta(itemMeta);
        } else {
            itemStack.removeEnchantment(Enchantment.LUCK);
        }
        itemMeta = itemStack.getItemMeta();
        Flags flags2 = Flags.getFlag(string);
        if (flags2 != null) {
            string = flags2.getName();
        }
        if (string == null) {
            string = "Unknown";
        }
        if (itemMeta == null) {
            return itemStack;
        }
        itemMeta.setDisplayName(ChatColor.GREEN + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        switch (flagState) {
            case FALSE: {
                string2 = Residence.getInstance().msg(lm.General_False, new Object[0]);
                break;
            }
            case TRUE: {
                string2 = Residence.getInstance().msg(lm.General_True, new Object[0]);
                break;
            }
            case NEITHER: {
                string2 = Residence.getInstance().msg(lm.General_Removed, new Object[0]);
            }
        }
        arrayList.add(Residence.getInstance().msg(lm.General_FlagState, string2));
        if (this.description.containsKey((Object)flags2)) {
            arrayList.addAll((Collection)this.description.get((Object)flags2));
        }
        arrayList.addAll(Residence.getInstance().msgL(lm.Gui_Actions));
        itemMeta.setLore(arrayList);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public List<CMIGuiButton> getButtons() {
        return this.buttons;
    }
}

