/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.gui;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.gui.FlagData;
import com.bekvon.bukkit.residence.gui.setFlagInfo;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FlagUtil {
    private FlagData flagData = new FlagData();
    private Residence plugin;

    public FlagUtil(Residence residence) {
        this.plugin = residence;
    }

    public void load() {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader("flags.yml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader != null) {
            if (!configReader.getC().isConfigurationSection("Global.FlagPermission")) {
                return;
            }
            Set set2 = configReader.getC().getConfigurationSection("Global.FlagPermission").getKeys(false);
            for (String string : set2) {
                if (!configReader.getC().contains("Global.FlagGui." + string)) continue;
                String string2 = configReader.get("Global.FlagGui." + string, "WHITE_WOOL");
                CMIMaterial cMIMaterial = CMIMaterial.get(string2 = string2.replace("-", ":"));
                if (cMIMaterial == null) {
                    cMIMaterial = CMIMaterial.STONE;
                }
                ItemStack itemStack = cMIMaterial.newItemStack();
                this.flagData.addFlagButton(string.toLowerCase(), itemStack);
            }
        }
    }

    public void openPsetFlagGui(Player player, String string, ClaimedResidence claimedResidence, boolean bl, int n) {
        if (player == null || !player.isOnline()) {
            return;
        }
        setFlagInfo setFlagInfo2 = new setFlagInfo(claimedResidence, player, string, bl);
        setFlagInfo2.recalculate();
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle(Residence.getInstance().msg(lm.Gui_Set_Title, claimedResidence.getName()));
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        PageInfo pageInfo = new PageInfo(45, setFlagInfo2.getButtons().size(), n);
        this.fillButtons(setFlagInfo2, pageInfo, cMIGui);
        cMIGui.open();
    }

    private void fillButtons(final setFlagInfo setFlagInfo2, final PageInfo pageInfo, final CMIGui cMIGui) {
        Object object;
        CMIGuiButton cMIGuiButton2;
        cMIGui.clearButtons();
        for (CMIGuiButton cMIGuiButton2 : setFlagInfo2.getButtons()) {
            if (pageInfo.isContinue()) continue;
            if (pageInfo.isBreak()) break;
            cMIGui.addButton(cMIGuiButton2);
            cMIGui.updateButton(cMIGuiButton2);
        }
        if (pageInfo.getCurrentPage() < pageInfo.getTotalPages()) {
            cMIGuiButton2 = new ItemStack(Material.ARROW);
            object = new CMIGuiButton(53, (ItemStack)cMIGuiButton2){

                @Override
                public void click(GUIManager.GUIClickType gUIClickType) {
                    FlagUtil.this.fillButtons(setFlagInfo2, new PageInfo(45, setFlagInfo2.getButtons().size(), pageInfo.getCurrentPage() + 1), cMIGui);
                }
            };
            ((CMIGuiButton)object).setName(Residence.getInstance().msg(lm.General_nextPage, new Object[0]));
            cMIGui.addButton((CMIGuiButton)object);
            cMIGui.updateButton((CMIGuiButton)object);
        }
        if (pageInfo.getCurrentPage() > 1) {
            cMIGuiButton2 = new ItemStack(Material.ARROW);
            object = new CMIGuiButton(45, (ItemStack)cMIGuiButton2){

                @Override
                public void click(GUIManager.GUIClickType gUIClickType) {
                    FlagUtil.this.fillButtons(setFlagInfo2, new PageInfo(45, setFlagInfo2.getButtons().size(), pageInfo.getCurrentPage() - 1), cMIGui);
                }
            };
            ((CMIGuiButton)object).setName(Residence.getInstance().msg(lm.General_prevPage, new Object[0]));
            cMIGui.addButton((CMIGuiButton)object);
            cMIGui.updateButton((CMIGuiButton)object);
        }
    }

    public void openSetFlagGui(Player player, ClaimedResidence claimedResidence, boolean bl, int n) {
        if (player == null || !player.isOnline()) {
            return;
        }
        setFlagInfo setFlagInfo2 = new setFlagInfo(claimedResidence, player, bl);
        setFlagInfo2.recalculate();
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setTitle(Residence.getInstance().msg(lm.Gui_Set_Title, claimedResidence.getName()));
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        PageInfo pageInfo = new PageInfo(45, setFlagInfo2.getButtons().size(), n);
        this.fillButtons(setFlagInfo2, pageInfo, cMIGui);
        cMIGui.open();
    }

    public FlagData getFlagData() {
        return this.flagData;
    }
}

