/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy.rent;

import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.MarketRentInterface;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.CancellableResidencePlayerEvent;
import com.bekvon.bukkit.residence.event.ResidenceRentEvent;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class RentManager
implements MarketRentInterface {
    private Set<ClaimedResidence> rentedLand;
    private Set<ClaimedResidence> rentableLand;
    private Residence plugin;

    public RentManager(Residence residence) {
        this.plugin = residence;
        this.rentedLand = new HashSet<ClaimedResidence>();
        this.rentableLand = new HashSet<ClaimedResidence>();
    }

    @Override
    public RentedLand getRentedLand(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentedLand(claimedResidence);
    }

    public RentedLand getRentedLand(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return null;
        }
        return claimedResidence.isRented() ? claimedResidence.getRentedLand() : null;
    }

    @Override
    public List<String> getRentedLands(String string) {
        return this.getRentedLands(string, false);
    }

    public List<String> getRentedLands(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (claimedResidence == null || !claimedResidence.isRented() || !claimedResidence.getRentedLand().player.equals(string)) continue;
            String string2 = " ";
            ClaimedResidence claimedResidence2 = claimedResidence.getTopParent();
            string2 = claimedResidence2.getWorld();
            boolean bl2 = claimedResidence2.getPermissions().has("hidden", false);
            if (bl && !bl2) continue;
            arrayList.add(String.valueOf(this.plugin.msg(lm.Residence_List, "", claimedResidence.getName(), string2)) + this.plugin.msg(lm.Rent_Rented, new Object[0]));
        }
        return arrayList;
    }

    public List<ClaimedResidence> getRents(String string) {
        return this.getRents(string, false);
    }

    public List<ClaimedResidence> getRents(String string, boolean bl) {
        return this.getRents(string, bl, null);
    }

    public List<ClaimedResidence> getRents(String string, boolean bl, World world) {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (claimedResidence == null || !claimedResidence.isRented() || !claimedResidence.getRentedLand().player.equalsIgnoreCase(string)) continue;
            ClaimedResidence claimedResidence2 = claimedResidence.getTopParent();
            boolean bl2 = claimedResidence2.getPermissions().has("hidden", false);
            if (bl && !bl2 || world != null && !world.getName().equalsIgnoreCase(claimedResidence.getWorld())) continue;
            arrayList.add(claimedResidence);
        }
        return arrayList;
    }

    public TreeMap<String, ClaimedResidence> getRentsMap(String string, boolean bl, World world) {
        TreeMap<String, ClaimedResidence> treeMap = new TreeMap<String, ClaimedResidence>();
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (claimedResidence == null || !claimedResidence.isRented() || !claimedResidence.getRentedLand().player.equalsIgnoreCase(string)) continue;
            ClaimedResidence claimedResidence2 = claimedResidence.getTopParent();
            boolean bl2 = claimedResidence2.getPermissions().has("hidden", false);
            if (bl && !bl2 || world != null && !world.getName().equalsIgnoreCase(claimedResidence.getWorld())) continue;
            treeMap.put(claimedResidence.getName(), claimedResidence);
        }
        return treeMap;
    }

    public List<String> getRentedLandsList(Player player) {
        return this.getRentedLandsList(player.getName());
    }

    public List<String> getRentedLandsList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (claimedResidence == null || !claimedResidence.isRented() || !claimedResidence.getRentedLand().player.equalsIgnoreCase(string)) continue;
            arrayList.add(claimedResidence.getName());
        }
        return arrayList;
    }

    @Override
    public void setForRent(Player player, String string, int n, int n2, boolean bl, boolean bl2) {
        this.setForRent(player, string, n, n2, bl, this.plugin.getConfigManager().isRentStayInMarket(), bl2);
    }

    @Override
    public void setForRent(Player player, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.setForRent(player, string, n, n2, bl, bl2, this.plugin.getConfigManager().isRentAllowAutoPay(), bl3);
    }

    @Override
    public void setForRent(Player player, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.setForRent(player, claimedResidence, n, n2, bl, bl2, bl3, bl4);
    }

    public void setForRent(Player player, ClaimedResidence claimedResidence, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Object object2;
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (claimedResidence.isRaidInitialized() && !bl4) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return;
        }
        if (!this.plugin.getConfigManager().enabledRentSystem()) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return;
        }
        if (claimedResidence.isForSell() && !bl4) {
            this.plugin.msg((CommandSender)player, lm.Economy_SellRentFail, new Object[0]);
            return;
        }
        if (claimedResidence.isParentForSell() && !bl4) {
            this.plugin.msg((CommandSender)player, lm.Economy_ParentSellRentFail, new Object[0]);
            return;
        }
        if (!bl4) {
            if (!claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true)) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
            object2 = this.plugin.getPlayerManager().getResidencePlayer(player);
            object = ((ResidencePlayer)object2).getGroup();
            int n3 = n2 = ((PermissionGroup)object).getMaxRentDays() < n2 ? ((PermissionGroup)object).getMaxRentDays() : n2;
            if (this.getRentableCount(player.getName()) >= ((PermissionGroup)object).getMaxRentables()) {
                this.plugin.msg((CommandSender)player, lm.Residence_MaxRent, new Object[0]);
                return;
            }
        }
        if (!this.rentableLand.contains(claimedResidence)) {
            object2 = new ResidenceRentEvent(claimedResidence, player, ResidenceRentEvent.RentEventType.RENTABLE);
            this.plugin.getServ().getPluginManager().callEvent((Event)object2);
            if (((CancellableResidencePlayerEvent)object2).isCancelled()) {
                return;
            }
            object = new RentableLand();
            ((RentableLand)object).days = n2;
            ((RentableLand)object).cost = n;
            ((RentableLand)object).AllowRenewing = bl;
            ((RentableLand)object).StayInMarket = bl2;
            ((RentableLand)object).AllowAutoPay = bl3;
            claimedResidence.setRentable((RentableLand)object);
            this.rentableLand.add(claimedResidence);
            this.plugin.getSignUtil().CheckSign(claimedResidence);
            this.plugin.msg((CommandSender)player, lm.Residence_ForRentSuccess, claimedResidence.getResidenceName(), n, n2);
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_AlreadyRent, new Object[0]);
        }
    }

    @Override
    public void rent(Player player, String string, boolean bl, boolean bl2) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.rent(player, claimedResidence, bl, bl2);
    }

    public void rent(Player player, ClaimedResidence claimedResidence, boolean bl, boolean bl2) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (claimedResidence.isRaidInitialized() && !bl2) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return;
        }
        if (!this.plugin.getConfigManager().enabledRentSystem()) {
            this.plugin.msg((CommandSender)player, lm.Rent_Disabled, new Object[0]);
            return;
        }
        if (claimedResidence.isOwner(player)) {
            this.plugin.msg((CommandSender)player, lm.Economy_OwnerRentFail, new Object[0]);
            return;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (!bl2 && this.getRentCount(player.getName()) >= residencePlayer.getMaxRents()) {
            this.plugin.msg((CommandSender)player, lm.Residence_MaxRent, new Object[0]);
            return;
        }
        if (!claimedResidence.isForRent()) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotForRent, new Object[0]);
            return;
        }
        if (claimedResidence.isRented()) {
            this.printRentInfo(player, claimedResidence.getName());
            return;
        }
        RentableLand rentableLand = claimedResidence.getRentable();
        if (this.plugin.getEconomyManager().canAfford(player.getName(), rentableLand.cost)) {
            ResidenceRentEvent residenceRentEvent = new ResidenceRentEvent(claimedResidence, player, ResidenceRentEvent.RentEventType.RENT);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceRentEvent);
            if (residenceRentEvent.isCancelled()) {
                return;
            }
            if (!rentableLand.AllowAutoPay && bl) {
                this.plugin.msg((CommandSender)player, lm.Residence_CantAutoPay, new Object[0]);
                bl = false;
            }
            if (this.plugin.getEconomyManager().transfer(player.getName(), claimedResidence.getPermissions().getOwner(), rentableLand.cost)) {
                RentedLand rentedLand = new RentedLand();
                rentedLand.player = player.getName();
                rentedLand.startTime = System.currentTimeMillis();
                rentedLand.endTime = System.currentTimeMillis() + RentManager.daysToMs(rentableLand.days);
                rentedLand.AutoPay = bl;
                claimedResidence.setRented(rentedLand);
                this.rentedLand.add(claimedResidence);
                this.plugin.getSignUtil().CheckSign(claimedResidence);
                Visualizer visualizer = new Visualizer(player);
                visualizer.setAreas(claimedResidence);
                this.plugin.getSelectionManager().showBounds(player, visualizer);
                claimedResidence.getPermissions().copyUserPermissions(claimedResidence.getPermissions().getOwner(), player.getName());
                claimedResidence.getPermissions().clearPlayersFlags(claimedResidence.getPermissions().getOwner());
                claimedResidence.getPermissions().applyDefaultRentedFlags();
                this.plugin.msg((CommandSender)player, lm.Residence_RentSuccess, claimedResidence.getName(), rentableLand.days);
                if (this.plugin.getSchematicManager() != null && this.plugin.getConfigManager().RestoreAfterRentEnds && !this.plugin.getConfigManager().SchematicsSaveOnFlagChange && claimedResidence.getPermissions().has("backup", true)) {
                    this.plugin.getSchematicManager().save(claimedResidence);
                }
            } else {
                player.sendMessage(ChatColor.RED + "Error, unable to transfer money...");
            }
        } else {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
        }
    }

    public void payRent(Player player, String string, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.payRent(player, claimedResidence, bl);
    }

    public void payRent(Player player, ClaimedResidence claimedResidence, boolean bl) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (!this.plugin.getConfigManager().enabledRentSystem()) {
            this.plugin.msg((CommandSender)player, lm.Rent_Disabled, new Object[0]);
            return;
        }
        if (!claimedResidence.isForRent()) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotForRent, new Object[0]);
            return;
        }
        if (claimedResidence.isRented() && !this.getRentingPlayer(claimedResidence).equals(player.getName()) && !bl) {
            this.plugin.msg((CommandSender)player, lm.Rent_NotByYou, new Object[0]);
            return;
        }
        RentableLand rentableLand = claimedResidence.getRentable();
        RentedLand rentedLand = claimedResidence.getRentedLand();
        if (rentedLand == null) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotRented, new Object[0]);
            return;
        }
        if (!rentableLand.AllowRenewing) {
            this.plugin.msg((CommandSender)player, lm.Rent_OneTime, new Object[0]);
            return;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (!bl && permissionGroup.getMaxRentDays() != -1 && RentManager.msToDays(rentedLand.endTime - System.currentTimeMillis() + RentManager.daysToMs(rentableLand.days)) >= permissionGroup.getMaxRentDays()) {
            this.plugin.msg((CommandSender)player, lm.Rent_MaxRentDays, permissionGroup.getMaxRentDays());
            return;
        }
        if (this.plugin.getEconomyManager().canAfford(player.getName(), rentableLand.cost)) {
            ResidenceRentEvent residenceRentEvent = new ResidenceRentEvent(claimedResidence, player, ResidenceRentEvent.RentEventType.RENT);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceRentEvent);
            if (residenceRentEvent.isCancelled()) {
                return;
            }
            if (this.plugin.getEconomyManager().transfer(player.getName(), claimedResidence.getPermissions().getOwner(), rentableLand.cost)) {
                rentedLand.endTime += RentManager.daysToMs(rentableLand.days);
                this.plugin.getSignUtil().CheckSign(claimedResidence);
                Visualizer visualizer = new Visualizer(player);
                visualizer.setAreas(claimedResidence);
                this.plugin.getSelectionManager().showBounds(player, visualizer);
                this.plugin.msg((CommandSender)player, lm.Rent_Extended, rentableLand.days, claimedResidence.getName());
                this.plugin.msg((CommandSender)player, lm.Rent_Expire, GetTime.getTime(rentedLand.endTime));
            } else {
                player.sendMessage(ChatColor.RED + "Error, unable to transfer money...");
            }
        } else {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
        }
    }

    @Override
    public void unrent(Player player, String string, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.unrent(player, claimedResidence, bl);
    }

    public void unrent(Player player, ClaimedResidence claimedResidence, boolean bl) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (claimedResidence.isRaidInitialized() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return;
        }
        RentedLand rentedLand = claimedResidence.getRentedLand();
        if (rentedLand == null) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotRented, new Object[0]);
            return;
        }
        if (bl || rentedLand.player.equals(player.getName()) || claimedResidence.isOwner(player) && PermissionManager.ResPerm.market_evict.hasPermission((CommandSender)player)) {
            ResidenceRentEvent residenceRentEvent = new ResidenceRentEvent(claimedResidence, player, ResidenceRentEvent.RentEventType.UNRENTABLE);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceRentEvent);
            if (residenceRentEvent.isCancelled()) {
                return;
            }
            this.rentedLand.remove(claimedResidence);
            claimedResidence.setRented(null);
            if (!claimedResidence.getRentable().AllowRenewing && !claimedResidence.getRentable().StayInMarket) {
                this.rentableLand.remove(claimedResidence);
                claimedResidence.setRentable(null);
            }
            boolean bl2 = claimedResidence.getPermissions().has("backup", false);
            if (this.plugin.getConfigManager().isRemoveLwcOnUnrent()) {
                this.plugin.getResidenceManager().removeLwcFromResidence(player, claimedResidence);
            }
            claimedResidence.getPermissions().applyDefaultFlags();
            if (this.plugin.getSchematicManager() != null && this.plugin.getConfigManager().RestoreAfterRentEnds && bl2) {
                this.plugin.getSchematicManager().load(claimedResidence);
                claimedResidence.getPermissions().setFlag("backup", FlagPermissions.FlagState.TRUE);
            }
            this.plugin.getSignUtil().CheckSign(claimedResidence);
            this.plugin.msg((CommandSender)player, lm.Residence_Unrent, claimedResidence.getName());
        } else {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    private static long daysToMs(int n) {
        return (long)n * 24L * 60L * 60L * 1000L;
    }

    private static int msToDays(long l) {
        return (int)Math.ceil((double)l / 1000.0 / 60.0 / 60.0 / 24.0);
    }

    @Override
    public void removeFromForRent(Player player, String string, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.removeFromForRent(player, claimedResidence, bl);
    }

    public void removeFromForRent(Player player, ClaimedResidence claimedResidence, boolean bl) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (!claimedResidence.getPermissions().hasResidencePermission((CommandSender)player, true) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (this.rentableLand.contains(claimedResidence)) {
            ResidenceRentEvent residenceRentEvent = new ResidenceRentEvent(claimedResidence, player, ResidenceRentEvent.RentEventType.UNRENT);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceRentEvent);
            if (residenceRentEvent.isCancelled()) {
                return;
            }
            this.rentableLand.remove(claimedResidence);
            claimedResidence.setRentable(null);
            claimedResidence.getPermissions().applyDefaultFlags();
            this.plugin.getSignUtil().CheckSign(claimedResidence);
            this.plugin.msg((CommandSender)player, lm.Residence_RemoveRentable, claimedResidence.getResidenceName());
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_NotForRent, new Object[0]);
        }
    }

    @Override
    public void removeFromRent(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.removeFromRent(claimedResidence);
    }

    public void removeFromRent(ClaimedResidence claimedResidence) {
        this.rentedLand.remove(claimedResidence);
    }

    @Override
    public void removeRentable(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.removeRentable(claimedResidence);
    }

    public void removeRentable(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        this.removeFromRent(claimedResidence);
        this.rentableLand.remove(claimedResidence);
        this.plugin.getSignUtil().removeSign(claimedResidence.getName());
    }

    @Override
    public boolean isForRent(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.isForRent(claimedResidence);
    }

    public boolean isForRent(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return this.rentableLand.contains(claimedResidence);
    }

    public RentableLand getRentableLand(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentableLand(claimedResidence);
    }

    public RentableLand getRentableLand(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return null;
        }
        if (claimedResidence.isForRent()) {
            return claimedResidence.getRentable();
        }
        return null;
    }

    @Override
    public boolean isRented(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.isRented(claimedResidence);
    }

    public boolean isRented(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return this.rentedLand.contains(claimedResidence);
    }

    @Override
    public String getRentingPlayer(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentingPlayer(claimedResidence);
    }

    public String getRentingPlayer(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return null;
        }
        return claimedResidence.isRented() ? claimedResidence.getRentedLand().player : null;
    }

    @Override
    public int getCostOfRent(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getCostOfRent(claimedResidence);
    }

    public int getCostOfRent(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return 0;
        }
        return claimedResidence.isForRent() ? claimedResidence.getRentable().cost : 0;
    }

    @Override
    public boolean getRentableRepeatable(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentableRepeatable(claimedResidence);
    }

    public boolean getRentableRepeatable(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return claimedResidence.isForRent() ? claimedResidence.getRentable().AllowRenewing : false;
    }

    @Override
    public boolean getRentedAutoRepeats(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentedAutoRepeats(claimedResidence);
    }

    public boolean getRentedAutoRepeats(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return this.getRentableRepeatable(claimedResidence) ? (this.rentedLand.contains(claimedResidence) ? claimedResidence.getRentedLand().AutoPay : false) : false;
    }

    @Override
    public int getRentDays(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getRentDays(claimedResidence);
    }

    public int getRentDays(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return 0;
        }
        return claimedResidence.isForRent() ? claimedResidence.getRentable().days : 0;
    }

    @Override
    public void checkCurrentRents() {
        HashSet<ClaimedResidence> hashSet = new HashSet<ClaimedResidence>();
        hashSet.addAll(this.rentedLand);
        for (ClaimedResidence claimedResidence : hashSet) {
            RentedLand rentedLand;
            if (claimedResidence == null || (rentedLand = claimedResidence.getRentedLand()) == null || rentedLand.endTime > System.currentTimeMillis()) continue;
            if (this.plugin.getConfigManager().debugEnabled()) {
                System.out.println("Rent Check: " + claimedResidence.getName());
            }
            ResidenceRentEvent residenceRentEvent = new ResidenceRentEvent(claimedResidence, null, ResidenceRentEvent.RentEventType.RENT_EXPIRE);
            this.plugin.getServ().getPluginManager().callEvent((Event)residenceRentEvent);
            if (residenceRentEvent.isCancelled()) continue;
            RentableLand rentableLand = claimedResidence.getRentable();
            if (!rentableLand.AllowRenewing) {
                if (!rentableLand.StayInMarket) {
                    this.rentableLand.remove(claimedResidence);
                    claimedResidence.setRentable(null);
                }
                this.rentedLand.remove(claimedResidence);
                claimedResidence.setRented(null);
                claimedResidence.getPermissions().applyDefaultFlags();
                this.plugin.getSignUtil().CheckSign(claimedResidence);
                continue;
            }
            if (rentedLand.AutoPay && rentableLand.AllowAutoPay) {
                Double d = 0.0;
                if (this.plugin.getConfigManager().isDeductFromBankThenPlayer()) {
                    d = d + claimedResidence.getBank().getStoredMoneyD();
                    d = d + this.plugin.getEconomyManager().getBalance(rentedLand.player);
                } else {
                    d = this.plugin.getConfigManager().isDeductFromBank() ? Double.valueOf(d + claimedResidence.getBank().getStoredMoneyD()) : Double.valueOf(d + this.plugin.getEconomyManager().getBalance(rentedLand.player));
                }
                if (d < (double)rentableLand.cost) {
                    if (!rentableLand.StayInMarket) {
                        this.rentableLand.remove(claimedResidence);
                        claimedResidence.setRentable(null);
                    }
                    this.rentedLand.remove(claimedResidence);
                    claimedResidence.setRented(null);
                    claimedResidence.getPermissions().applyDefaultFlags();
                } else {
                    double d2;
                    double d3;
                    boolean bl = true;
                    if (this.plugin.getConfigManager().isDeductFromBankThenPlayer()) {
                        d3 = rentableLand.cost;
                        d2 = claimedResidence.getBank().getStoredMoneyD();
                        if (d2 < d3) {
                            d3 -= d2;
                            d2 = 0.0;
                        } else {
                            d2 -= d3;
                            d3 = 0.0;
                        }
                        double d4 = d2 = d2 < 0.0 ? 0.0 : d2;
                        if (this.plugin.getEconomyManager().getBalance(rentedLand.player) < d3) {
                            bl = false;
                        } else if (d3 == 0.0 || this.plugin.getEconomyManager().subtract(rentedLand.player, d3)) {
                            this.plugin.getEconomyManager().add(claimedResidence.getPermissions().getOwner(), rentableLand.cost);
                            claimedResidence.getBank().setStoredMoney(d2);
                            bl = true;
                        }
                    } else if (this.plugin.getConfigManager().isDeductFromBank()) {
                        d3 = rentableLand.cost;
                        d2 = claimedResidence.getBank().getStoredMoneyD();
                        if (d2 < d3) {
                            bl = false;
                        } else {
                            claimedResidence.getBank().setStoredMoney(d2 - d3);
                            this.plugin.getEconomyManager().add(claimedResidence.getPermissions().getOwner(), rentableLand.cost);
                            bl = true;
                        }
                    } else {
                        bl = this.plugin.getEconomyManager().transfer(rentedLand.player, claimedResidence.getPermissions().getOwner(), rentableLand.cost);
                    }
                    if (!bl) {
                        if (!rentableLand.StayInMarket) {
                            this.rentableLand.remove(claimedResidence);
                            claimedResidence.setRentable(null);
                        }
                        this.rentedLand.remove(claimedResidence);
                        claimedResidence.setRented(null);
                        claimedResidence.getPermissions().applyDefaultFlags();
                    } else {
                        rentedLand.endTime = System.currentTimeMillis() + RentManager.daysToMs(rentableLand.days);
                    }
                }
                this.plugin.getSignUtil().CheckSign(claimedResidence);
                continue;
            }
            if (!rentableLand.StayInMarket) {
                this.rentableLand.remove(claimedResidence);
                claimedResidence.setRentable(null);
            }
            this.rentedLand.remove(claimedResidence);
            claimedResidence.setRented(null);
            boolean bl = claimedResidence.getPermissions().has("backup", false);
            claimedResidence.getPermissions().applyDefaultFlags();
            if (this.plugin.getSchematicManager() != null && this.plugin.getConfigManager().RestoreAfterRentEnds && bl) {
                this.plugin.getSchematicManager().load(claimedResidence);
                this.plugin.getSignUtil().CheckSign(claimedResidence);
                claimedResidence.getPermissions().setFlag("backup", FlagPermissions.FlagState.TRUE);
                break;
            }
            this.plugin.getSignUtil().CheckSign(claimedResidence);
        }
    }

    @Override
    public void setRentRepeatable(Player player, String string, boolean bl, boolean bl2) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.setRentRepeatable(player, claimedResidence, bl, bl2);
    }

    public void setRentRepeatable(Player player, ClaimedResidence claimedResidence, boolean bl, boolean bl2) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        RentableLand rentableLand = claimedResidence.getRentable();
        if (!claimedResidence.isOwner(player) && !bl2) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotOwner, new Object[0]);
            return;
        }
        if (rentableLand == null || !claimedResidence.isOwner(player) && !bl2) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotOwner, new Object[0]);
            return;
        }
        rentableLand.AllowRenewing = bl;
        if (!bl && this.isRented(claimedResidence)) {
            claimedResidence.getRentedLand().AutoPay = false;
        }
        if (bl) {
            this.plugin.msg((CommandSender)player, lm.Rentable_EnableRenew, claimedResidence.getResidenceName());
        } else {
            this.plugin.msg((CommandSender)player, lm.Rentable_DisableRenew, claimedResidence.getResidenceName());
        }
    }

    @Override
    public void setRentedRepeatable(Player player, String string, boolean bl, boolean bl2) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.setRentedRepeatable(player, claimedResidence, bl, bl2);
    }

    public void setRentedRepeatable(Player player, ClaimedResidence claimedResidence, boolean bl, boolean bl2) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        RentedLand rentedLand = claimedResidence.getRentedLand();
        if (rentedLand == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (!claimedResidence.getRentable().AllowAutoPay && bl) {
            this.plugin.msg((CommandSender)player, lm.Residence_CantAutoPay, new Object[0]);
            return;
        }
        if (!rentedLand.player.equals(player.getName()) && !bl2) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotOwner, new Object[0]);
            return;
        }
        if (!rentedLand.player.equals(player.getName()) && !bl2) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotOwner, new Object[0]);
            return;
        }
        rentedLand.AutoPay = bl;
        if (bl) {
            this.plugin.msg((CommandSender)player, lm.Rent_EnableRenew, claimedResidence.getResidenceName());
        } else {
            this.plugin.msg((CommandSender)player, lm.Rent_DisableRenew, claimedResidence.getResidenceName());
        }
        this.plugin.getSignUtil().CheckSign(claimedResidence);
    }

    public void printRentInfo(Player player, String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.printRentInfo(player, claimedResidence);
    }

    public void printRentInfo(Player player, ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        RentableLand rentableLand = claimedResidence.getRentable();
        RentedLand rentedLand = claimedResidence.getRentedLand();
        if (rentableLand != null) {
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            this.plugin.msg((CommandSender)player, lm.General_Land, claimedResidence.getName());
            this.plugin.msg((CommandSender)player, lm.General_Cost, rentableLand.cost, rentableLand.days);
            this.plugin.msg((CommandSender)player, lm.Rentable_AllowRenewing, rentableLand.AllowRenewing);
            this.plugin.msg((CommandSender)player, lm.Rentable_StayInMarket, rentableLand.StayInMarket);
            this.plugin.msg((CommandSender)player, lm.Rentable_AllowAutoPay, rentableLand.AllowAutoPay);
            if (rentedLand != null) {
                this.plugin.msg((CommandSender)player, lm.Residence_RentedBy, rentedLand.player);
                if (rentedLand.player.equals(player.getName()) || claimedResidence.isOwner(player) || this.plugin.isResAdminOn(player)) {
                    player.sendMessage(String.valueOf(rentedLand.AutoPay ? this.plugin.msg(lm.Rent_AutoPayTurnedOn, new Object[0]) : this.plugin.msg(lm.Rent_AutoPayTurnedOff, new Object[0])) + "\n");
                }
                this.plugin.msg((CommandSender)player, lm.Rent_Expire, GetTime.getTime(rentedLand.endTime));
            } else {
                this.plugin.msg((CommandSender)player, lm.General_Status, this.plugin.msg(lm.General_Available, new Object[0]));
            }
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        } else {
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
            this.plugin.msg((CommandSender)player, lm.Residence_NotForRent, new Object[0]);
            this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        }
    }

    public void printRentableResidences(Player player, int n) {
        this.plugin.msg((CommandSender)player, lm.Rentable_Land, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ChatColor.GREEN);
        PageInfo pageInfo = new PageInfo(10, this.rentableLand.size(), n);
        int n2 = -1;
        for (ClaimedResidence claimedResidence : this.rentableLand) {
            Object object;
            if (claimedResidence == null) continue;
            if (++n2 > pageInfo.getEnd()) break;
            if (!pageInfo.isInRange(n2)) continue;
            boolean bl = claimedResidence.isRented();
            if (!claimedResidence.getRentable().AllowRenewing && bl) continue;
            String string = "";
            String string2 = "";
            if (bl) {
                object = claimedResidence.getRentedLand();
                string = this.plugin.msg(lm.Residence_RentedBy, ((RentedLand)object).player);
                string2 = GetTime.getTime(((RentedLand)object).endTime);
            }
            object = this.plugin.msg(lm.Rent_RentList, pageInfo.getPositionForOutput(n2), claimedResidence.getName(), claimedResidence.getRentable().cost, claimedResidence.getRentable().days, claimedResidence.getRentable().AllowRenewing, claimedResidence.getOwner(), string);
            RawMessage rawMessage = new RawMessage();
            rawMessage.add((String)object, "&2" + string2);
            if (!string2.equalsIgnoreCase("")) {
                rawMessage.show(player);
                continue;
            }
            player.sendMessage((String)object);
        }
        this.plugin.getInfoPageManager().ShowPagination((CommandSender)player, pageInfo, "/res market list rent");
    }

    @Override
    public int getRentCount(String string) {
        int n = 0;
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (!claimedResidence.getRentedLand().player.equalsIgnoreCase(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getRentableCount(String string) {
        int n = 0;
        for (ClaimedResidence claimedResidence : this.rentableLand) {
            if (claimedResidence == null || !claimedResidence.isOwner(string)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Set<ClaimedResidence> getRentableResidences() {
        return this.rentableLand;
    }

    @Override
    public Set<ClaimedResidence> getCurrentlyRentedResidences() {
        return this.rentedLand;
    }

    public void load(Map<String, Object> map) {
        Object object;
        if (map == null) {
            return;
        }
        this.rentableLand.clear();
        Map map2 = (Map)map.get("Rentables");
        for (Map.Entry entry : map2.entrySet()) {
            RentableLand rentableLand = RentManager.loadRentable((Map)entry.getValue());
            object = this.plugin.getResidenceManager().getByName((String)entry.getKey());
            if (object == null) continue;
            ((ClaimedResidence)object).setRentable(rentableLand);
            this.rentableLand.add((ClaimedResidence)object);
        }
        Map map3 = (Map)map.get("Rented");
        for (Map.Entry entry : map3.entrySet()) {
            object = RentManager.loadRented((Map)entry.getValue());
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName((String)entry.getKey());
            if (claimedResidence == null) continue;
            claimedResidence.setRented((RentedLand)object);
            this.rentedLand.add(claimedResidence);
        }
    }

    public Map<String, Object> save() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> hashMap2 = new HashMap<String, Map<String, Object>>();
        for (ClaimedResidence claimedResidence : this.rentableLand) {
            if (claimedResidence == null || claimedResidence.getRentable() == null) continue;
            hashMap2.put(claimedResidence.getName(), claimedResidence.getRentable().save());
        }
        HashMap<String, Map<String, Object>> hashMap3 = new HashMap<String, Map<String, Object>>();
        for (ClaimedResidence claimedResidence : this.rentedLand) {
            if (claimedResidence == null || claimedResidence.getRentedLand() == null) continue;
            hashMap3.put(claimedResidence.getName(), claimedResidence.getRentedLand().save());
        }
        hashMap.put("Rentables", hashMap2);
        hashMap.put("Rented", hashMap3);
        return hashMap;
    }

    private static RentableLand loadRentable(Map<String, Object> map) {
        RentableLand rentableLand = new RentableLand();
        rentableLand.cost = (Integer)map.get("Cost");
        rentableLand.days = (Integer)map.get("Days");
        rentableLand.AllowRenewing = (Boolean)map.get("Repeatable");
        if (map.containsKey("StayInMarket")) {
            rentableLand.StayInMarket = (Boolean)map.get("StayInMarket");
        }
        if (map.containsKey("AllowAutoPay")) {
            rentableLand.AllowAutoPay = (Boolean)map.get("AllowAutoPay");
        }
        return rentableLand;
    }

    private static RentedLand loadRented(Map<String, Object> map) {
        RentedLand rentedLand = new RentedLand();
        rentedLand.player = (String)map.get("Player");
        rentedLand.startTime = (Long)map.get("StartTime");
        rentedLand.endTime = (Long)map.get("EndTime");
        rentedLand.AutoPay = (Boolean)map.get("AutoRefresh");
        return rentedLand;
    }
}

