/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.MarketBuyInterface;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransactionManager
implements MarketBuyInterface {
    private Set<ClaimedResidence> sellAmount;
    private Residence plugin;

    public TransactionManager(Residence residence) {
        this.plugin = residence;
        this.sellAmount = new HashSet<ClaimedResidence>();
    }

    public boolean chargeEconomyMoney(Player player, double d) {
        EconomyInterface economyInterface = this.plugin.getEconomyManager();
        if (economyInterface == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return false;
        }
        if (!economyInterface.canAfford(player.getName(), d)) {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
            return false;
        }
        economyInterface.subtract(player.getName(), d);
        try {
            if (d != 0.0) {
                this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(d), economyInterface.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean giveEconomyMoney(Player player, double d) {
        if (player == null) {
            return false;
        }
        if (d == 0.0) {
            return true;
        }
        EconomyInterface economyInterface = this.plugin.getEconomyManager();
        if (economyInterface == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return false;
        }
        economyInterface.add(player.getName(), d);
        this.plugin.msg((CommandSender)player, lm.Economy_MoneyAdded, this.plugin.getEconomyManager().format(d), economyInterface.getName());
        return true;
    }

    @Deprecated
    public boolean giveEconomyMoney(String string, double d) {
        if (string == null) {
            return false;
        }
        if (d == 0.0) {
            return true;
        }
        EconomyInterface economyInterface = this.plugin.getEconomyManager();
        if (economyInterface == null) {
            return false;
        }
        economyInterface.add(string, d);
        return true;
    }

    public void putForSale(String string, Player player, int n, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.putForSale(claimedResidence, player, n, bl);
    }

    public void putForSale(ClaimedResidence claimedResidence, Player player, int n, boolean bl) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && !bl) {
            if (claimedResidence.isForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_RentSellFail, new Object[0]);
                return;
            }
            if (claimedResidence.isSubzoneForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_SubzoneRentSellFail, new Object[0]);
                return;
            }
            if (claimedResidence.isParentForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_ParentRentSellFail, new Object[0]);
                return;
            }
        }
        if (!this.plugin.getConfigManager().isSellSubzone() && claimedResidence.isSubzone()) {
            this.plugin.msg((CommandSender)player, lm.Economy_SubzoneSellFail, new Object[0]);
            return;
        }
        if (!bl) {
            if (!this.plugin.getConfigManager().enableEconomy() || this.plugin.getEconomyManager() == null) {
                this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
                return;
            }
            ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            if (!(bl || residencePlayer.getGroup().canSellLand() || PermissionManager.ResPerm.sell.hasPermission((CommandSender)player))) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
            if (n <= 0) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                return;
            }
        }
        if (!claimedResidence.isOwner(player) && !bl) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (this.sellAmount.contains(claimedResidence)) {
            this.plugin.msg((CommandSender)player, lm.Economy_AlreadySellFail, new Object[0]);
            return;
        }
        claimedResidence.setSellPrice(n);
        this.sellAmount.add(claimedResidence);
        this.plugin.getSignUtil().CheckSign(claimedResidence);
        this.plugin.msg((CommandSender)player, lm.Residence_ForSale, claimedResidence.getName(), n);
    }

    @Override
    public boolean putForSale(String string, int n) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.putForSale(claimedResidence, n);
    }

    public boolean putForSale(ClaimedResidence claimedResidence, int n) {
        if (claimedResidence == null) {
            return false;
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && (claimedResidence.isForRent() || claimedResidence.isSubzoneForRent() || claimedResidence.isParentForRent())) {
            return false;
        }
        if (this.sellAmount.contains(claimedResidence)) {
            return false;
        }
        claimedResidence.setSellPrice(n);
        this.sellAmount.add(claimedResidence);
        return true;
    }

    @Override
    public void buyPlot(String string, Player player, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.buyPlot(claimedResidence, player, bl);
    }

    public void buyPlot(ClaimedResidence claimedResidence, Player player, boolean bl) {
        Object object;
        Object object2;
        CuboidArea[] cuboidAreaArray;
        if (claimedResidence == null || !claimedResidence.isForSell()) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (!bl) {
            boolean bl2;
            if (!this.plugin.getConfigManager().enableEconomy() || this.plugin.getEconomyManager() == null) {
                this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
                return;
            }
            boolean bl3 = bl2 = permissionGroup.canBuyLand() || PermissionManager.ResPerm.buy.hasPermission((CommandSender)player);
            if (!bl2 && !bl) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
        }
        if (claimedResidence.getPermissions().getOwner().equals(player.getName())) {
            this.plugin.msg((CommandSender)player, lm.Economy_OwnerBuyFail, new Object[0]);
            return;
        }
        if (this.plugin.getResidenceManager().getOwnedZoneCount(player.getName()) >= residencePlayer.getMaxRes() && !bl) {
            this.plugin.msg((CommandSender)player, lm.Residence_TooMany, new Object[0]);
            return;
        }
        Server server2 = this.plugin.getServ();
        int n = claimedResidence.getSellPrice();
        if (!bl && !permissionGroup.buyLandIgnoreLimits()) {
            cuboidAreaArray = claimedResidence.getAreaArray();
            object2 = cuboidAreaArray;
            int n2 = cuboidAreaArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                if (!claimedResidence.isSubzone() && !claimedResidence.isSmallerThanMax(player, (CuboidArea)object, bl) || claimedResidence.isSubzone() && !claimedResidence.isSmallerThanMaxSubzone(player, (CuboidArea)object, bl)) {
                    this.plugin.msg((CommandSender)player, lm.Residence_BuyTooBig, new Object[0]);
                    return;
                }
                ++n3;
            }
        }
        if ((cuboidAreaArray = this.plugin.getEconomyManager()) == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return;
        }
        object = player.getName();
        String string = claimedResidence.getPermissions().getOwner();
        Player player2 = this.plugin.getServ().getPlayer(string);
        if (player2 != null) {
            string = player2.getName();
        }
        if (cuboidAreaArray.canAfford((String)object, n)) {
            if (!cuboidAreaArray.transfer((String)object, string, n)) {
                player.sendMessage(ChatColor.RED + "Error, could not transfer " + n + " from " + (String)object + " to " + string);
                return;
            }
            claimedResidence.getPermissions().setOwner(player, true);
            claimedResidence.getPermissions().applyDefaultFlags();
            this.removeFromSale(claimedResidence);
            if (this.plugin.getConfigManager().isRemoveLwcOnBuy()) {
                this.plugin.getResidenceManager().removeLwcFromResidence(player, claimedResidence);
            }
            this.plugin.getSignUtil().CheckSign(claimedResidence);
            object2 = new Visualizer(player);
            ((Visualizer)object2).setAreas(claimedResidence);
            this.plugin.getSelectionManager().showBounds(player, (Visualizer)object2);
            this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(n), cuboidAreaArray.getName());
            this.plugin.msg((CommandSender)player, lm.Residence_Bought, claimedResidence.getResidenceName());
            Player player3 = server2.getPlayer(string);
            if (player3 != null && player3.isOnline()) {
                player3.sendMessage(this.plugin.msg(lm.Residence_Buy, player.getName(), claimedResidence.getResidenceName()));
                player3.sendMessage(this.plugin.msg(lm.Economy_MoneyCredit, this.plugin.getEconomyManager().format(n), cuboidAreaArray.getName()));
            }
        } else {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
        }
    }

    public void removeFromSale(Player player, String string, boolean bl) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.removeFromSale(player, claimedResidence, bl);
    }

    public void removeFromSale(Player player, ClaimedResidence claimedResidence, boolean bl) {
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
            return;
        }
        if (!claimedResidence.isForSell()) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotForSale, new Object[0]);
            return;
        }
        if (claimedResidence.isOwner(player) || bl) {
            this.removeFromSale(claimedResidence);
            this.plugin.getSignUtil().CheckSign(claimedResidence);
            this.plugin.msg((CommandSender)player, lm.Residence_StopSelling, new Object[0]);
        } else {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    @Override
    public void removeFromSale(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        this.removeFromSale(claimedResidence);
    }

    public void removeFromSale(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        this.sellAmount.remove(claimedResidence);
        this.plugin.getSignUtil().removeSign(claimedResidence);
    }

    @Override
    public boolean isForSale(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.isForSale(claimedResidence);
    }

    public boolean isForSale(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return false;
        }
        return this.sellAmount.contains(claimedResidence);
    }

    public boolean viewSaleInfo(String string, Player player) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.viewSaleInfo(claimedResidence, player);
    }

    public boolean viewSaleInfo(ClaimedResidence claimedResidence, Player player) {
        String string;
        if (claimedResidence == null || !claimedResidence.isForSell()) {
            return false;
        }
        if (!this.sellAmount.contains(claimedResidence)) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        this.plugin.msg((CommandSender)player, lm.Area_Name, claimedResidence.getName());
        this.plugin.msg((CommandSender)player, lm.Economy_SellAmount, claimedResidence.getSellPrice());
        if (this.plugin.getConfigManager().useLeases() && (string = this.plugin.getLeaseManager().getExpireTime(claimedResidence)) != null) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseExpire, string);
        }
        this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        return true;
    }

    public void printForSaleResidences(Player player, int n) {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        this.plugin.msg((CommandSender)player, lm.Economy_LandForSale, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ChatColor.GREEN);
        PageInfo pageInfo = new PageInfo(10, this.sellAmount.size(), n);
        int n2 = -1;
        for (ClaimedResidence claimedResidence : this.sellAmount) {
            if (++n2 > pageInfo.getEnd()) break;
            if (!pageInfo.isInRange(n2)) continue;
            if (claimedResidence == null) {
                arrayList.add(claimedResidence);
                continue;
            }
            this.plugin.msg((CommandSender)player, lm.Economy_SellList, pageInfo.getPositionForOutput(n2), claimedResidence.getName(), claimedResidence.getSellPrice(), claimedResidence.getOwner());
        }
        for (ClaimedResidence claimedResidence : arrayList) {
            this.sellAmount.remove(claimedResidence);
        }
        this.plugin.getInfoPageManager().ShowPagination((CommandSender)player, pageInfo, "/res market list sell");
    }

    public void clearSales() {
        for (ClaimedResidence claimedResidence : this.sellAmount) {
            if (claimedResidence == null) continue;
            claimedResidence.setSellPrice(-1);
        }
        this.sellAmount.clear();
        System.out.println("[Residence] - ReInit land selling.");
    }

    @Override
    public int getSaleAmount(String string) {
        ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(string);
        return this.getSaleAmount(claimedResidence);
    }

    public int getSaleAmount(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return -1;
        }
        return claimedResidence.getSellPrice();
    }

    public void load(Map<String, Integer> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByName(entry.getKey());
            if (claimedResidence == null) continue;
            claimedResidence.setSellPrice(entry.getValue());
            this.sellAmount.add(claimedResidence);
        }
    }

    @Override
    public Map<String, Integer> getBuyableResidences() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (ClaimedResidence claimedResidence : this.sellAmount) {
            if (claimedResidence == null) continue;
            hashMap.put(claimedResidence.getName(), claimedResidence.getSellPrice());
        }
        return hashMap;
    }

    public Map<String, Integer> save() {
        return this.getBuyableResidences();
    }
}

