/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidenceBank {
    Double storedMoney = 0.0;
    ClaimedResidence res;

    public ResidenceBank(ClaimedResidence claimedResidence) {
        this.res = claimedResidence;
    }

    @Deprecated
    public int getStoredMoney() {
        return this.storedMoney.intValue();
    }

    public Double getStoredMoneyD() {
        return this.storedMoney;
    }

    public String getStoredMoneyFormated() {
        try {
            return Residence.getInstance().getEconomyManager().format(this.storedMoney);
        }
        catch (Exception exception) {
            return String.valueOf(this.storedMoney);
        }
    }

    public void setStoredMoney(double d) {
        this.storedMoney = d;
    }

    public void add(double d) {
        this.storedMoney = this.storedMoney + d;
    }

    public boolean hasEnough(double d) {
        return this.storedMoney >= d;
    }

    public void subtract(double d) {
        this.storedMoney = this.storedMoney - d;
        if (this.storedMoney < 0.0) {
            this.storedMoney = 0.0;
        }
    }

    @Deprecated
    public void withdraw(CommandSender commandSender, int n, boolean bl) {
        this.withdraw(commandSender, (double)n, bl);
    }

    public void withdraw(CommandSender commandSender, double d, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(commandSender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!bl && !this.res.getPermissions().playerHas(player, Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(commandSender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (!this.hasEnough(d)) {
            Residence.getInstance().msg(commandSender, lm.Bank_NoMoney, new Object[0]);
            return;
        }
        if (!bl && this.res.isRented() && !this.res.getRentedLand().player.equalsIgnoreCase(commandSender.getName())) {
            Residence.getInstance().msg(commandSender, lm.Bank_rentedWithdraw, this.res.getName());
            return;
        }
        if (commandSender instanceof Player && Residence.getInstance().getEconomyManager().add(commandSender.getName(), d) || !(commandSender instanceof Player)) {
            this.subtract(d);
            Residence.getInstance().msg(commandSender, lm.Bank_Withdraw, String.format("%.2f", d));
        }
    }

    @Deprecated
    public void deposit(CommandSender commandSender, int n, boolean bl) {
        this.deposit(commandSender, (double)n, bl);
    }

    public void deposit(CommandSender commandSender, double d, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(commandSender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!bl && !this.res.getPermissions().playerHas(player, Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(commandSender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (commandSender instanceof Player && !Residence.getInstance().getEconomyManager().canAfford(commandSender.getName(), d)) {
            Residence.getInstance().msg(commandSender, lm.Economy_NotEnoughMoney, new Object[0]);
            return;
        }
        if (commandSender instanceof Player && Residence.getInstance().getEconomyManager().subtract(commandSender.getName(), d) || !(commandSender instanceof Player)) {
            this.add(d);
            Residence.getInstance().msg(commandSender, lm.Bank_Deposit, Residence.getInstance().getEconomyManager().format(d));
        }
    }
}

