/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import org.bukkit.entity.Player;

public class EssentialsEcoAdapter
implements EconomyInterface {
    Essentials plugin;

    public EssentialsEcoAdapter(Essentials essentials) {
        this.plugin = essentials;
        String string = Residence.getInstance().getServerLandName();
        if (!Economy.playerExists((String)string)) {
            Economy.createNPC((String)string);
        }
    }

    @Override
    public double getBalance(Player player) {
        try {
            if (Economy.playerExists((String)player.getName())) {
                return Economy.getMoney((String)player.getName());
            }
            return 0.0;
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            return 0.0;
        }
    }

    @Override
    public double getBalance(String string) {
        try {
            if (Economy.playerExists((String)string)) {
                return Economy.getMoney((String)string);
            }
            return 0.0;
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            return 0.0;
        }
    }

    @Override
    public boolean canAfford(String string, double d) {
        try {
            if (Economy.playerExists((String)string)) {
                return Economy.hasEnough((String)string, (double)d);
            }
            return false;
        }
        catch (UserDoesNotExistException userDoesNotExistException) {
            return false;
        }
    }

    @Override
    public boolean add(String string, double d) {
        if (Economy.playerExists((String)string)) {
            try {
                Economy.add((String)string, (double)d);
                return true;
            }
            catch (UserDoesNotExistException userDoesNotExistException) {
                return false;
            }
            catch (NoLoanPermittedException noLoanPermittedException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean subtract(String string, double d) {
        if (Economy.playerExists((String)string)) {
            try {
                Economy.subtract((String)string, (double)d);
                return true;
            }
            catch (UserDoesNotExistException userDoesNotExistException) {
                return false;
            }
            catch (NoLoanPermittedException noLoanPermittedException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean transfer(String string, String string2, double d) {
        block4: {
            block5: {
                try {
                    if (!Economy.playerExists((String)string) || !Economy.playerExists((String)string2) || !Economy.hasEnough((String)string, (double)d)) break block4;
                    if (this.subtract(string, d)) break block5;
                    return false;
                }
                catch (UserDoesNotExistException userDoesNotExistException) {
                    return false;
                }
            }
            if (!this.add(string2, d)) {
                this.add(string, d);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "EssentialsEconomy";
    }

    @Override
    public String format(double d) {
        return Economy.format((double)d);
    }
}

