/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.dynmap;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.dynmap.AreaStyle;
import com.bekvon.bukkit.residence.economy.TransactionManager;
import com.bekvon.bukkit.residence.economy.rent.RentManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;

public class DynMapManager {
    Residence plugin;
    public DynmapAPI api;
    MarkerAPI markerapi;
    MarkerSet set;
    private Map<String, AreaMarker> resareas = new HashMap<String, AreaMarker>();
    private int schedId = -1;

    public DynMapManager(Residence residence) {
        this.plugin = residence;
    }

    public MarkerSet getMarkerSet() {
        return this.set;
    }

    public void fireUpdateAdd(final ClaimedResidence claimedResidence, final int n) {
        if (this.api == null || this.set == null) {
            return;
        }
        if (claimedResidence == null) {
            return;
        }
        if (this.schedId != -1) {
            Bukkit.getServer().getScheduler().cancelTask(this.schedId);
        }
        this.schedId = Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                DynMapManager.this.schedId = -1;
                DynMapManager.this.handleResidenceAdd(claimedResidence.getName(), claimedResidence, n);
            }
        }, 10L);
    }

    public void fireUpdateRemove(ClaimedResidence claimedResidence, int n) {
        if (this.api == null || this.set == null) {
            return;
        }
        if (claimedResidence == null) {
            return;
        }
        this.handleResidenceRemove(claimedResidence.getName(), claimedResidence, n);
    }

    private String formatInfoWindow(String string, ClaimedResidence claimedResidence, String string2) {
        String string3;
        boolean bl;
        if (claimedResidence == null) {
            return null;
        }
        if (claimedResidence.getName() == null) {
            return null;
        }
        if (claimedResidence.getOwner() == null) {
            return null;
        }
        String string4 = "<div class=\"regioninfo\"><div class=\"infowindow\"><span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />";
        if (this.plugin.getConfigManager().DynMapShowFlags) {
            string4 = String.valueOf(string4) + CMIChatColor.stripColor(this.plugin.msg(lm.General_ResidenceFlags, "")) + "<br /><span style=\"font-weight:bold;\">%flags%</span>";
        }
        string4 = String.valueOf(string4) + "</div></div>";
        if (this.plugin.getRentManager().isForRent(claimedResidence.getName())) {
            string4 = "<div class=\"regioninfo\"><div class=\"infowindow\">" + CMIChatColor.stripColor(this.plugin.msg(lm.Rentable_Land, "")) + "<span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br />" + CMIChatColor.stripColor(this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />" + CMIChatColor.stripColor(this.plugin.msg(lm.Residence_RentedBy, "")) + "<span style=\"font-weight:bold;\">%renter%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.General_LandCost, "")) + "<span style=\"font-weight:bold;\">%rent%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.Rent_Days, "")) + "<span style=\"font-weight:bold;\">%rentdays%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.Rentable_AllowRenewing, "")) + "<span style=\"font-weight:bold;\">%renew%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.Rent_Expire, "")) + "<span style=\"font-weight:bold;\">%expire%</span></div></div>";
        }
        if (this.plugin.getTransactionManager().isForSale(claimedResidence.getName())) {
            string4 = "<div class=\"regioninfo\"><div class=\"infowindow\">" + CMIChatColor.stripColor(this.plugin.msg(lm.Economy_LandForSale, " ")) + "<span style=\"font-size:140%;font-weight:bold;\">%regionname%</span><br /> " + CMIChatColor.stripColor(this.plugin.msg(lm.General_Owner, "")) + "<span style=\"font-weight:bold;\">%playerowners%</span><br />" + CMIChatColor.stripColor(this.plugin.msg(lm.Economy_SellAmount, "")) + "<span style=\"font-weight:bold;\">%price%</span><br /></div></div>";
        }
        string4 = string4.replace("%regionname%", string2);
        string4 = string4.replace("%playerowners%", claimedResidence.getOwner());
        String string5 = claimedResidence.getEnterMessage();
        string4 = string4.replace("%entermsg%", string5 != null ? string5 : "");
        string5 = claimedResidence.getLeaveMessage();
        string4 = string4.replace("%leavemsg%", string5 != null ? string5 : "");
        ResidencePermissions residencePermissions = claimedResidence.getPermissions();
        String string6 = "";
        Map<String, Boolean> map = this.plugin.getPermissionManager().getAllFlags().getFlags();
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            stringArray[n] = entry.getKey();
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (residencePermissions.isSet(stringArray[n2])) {
                if (string6.length() > 0) {
                    string6 = String.valueOf(string6) + "<br/>";
                }
                boolean bl2 = residencePermissions.has(stringArray[n2], false);
                string6 = String.valueOf(string6) + stringArray[n2] + ": " + bl2;
                string4 = string4.replace("%flag." + stringArray[n2] + "%", Boolean.toString(bl2));
            } else {
                string4 = string4.replace("%flag." + stringArray[n2] + "%", "");
            }
            ++n2;
        }
        string4 = string4.replace("%flags%", string6);
        RentManager rentManager = this.plugin.getRentManager();
        TransactionManager transactionManager = this.plugin.getTransactionManager();
        if (rentManager.isForRent(claimedResidence.getName())) {
            long l;
            bl = rentManager.isRented(string);
            string4 = string4.replace("%isrented%", Boolean.toString(bl));
            string3 = "";
            if (bl) {
                string3 = rentManager.getRentingPlayer(string);
            }
            string4 = string4.replace("%renter%", string3);
            string4 = string4.replace("%rent%", String.valueOf(rentManager.getCostOfRent(string)));
            string4 = string4.replace("%rentdays%", String.valueOf(rentManager.getRentDays(string)));
            boolean bl3 = rentManager.getRentableRepeatable(string);
            string4 = string4.replace("%renew%", String.valueOf(bl3));
            String string7 = "";
            if (bl && (l = rentManager.getRentedLand((String)string).endTime) != 0L) {
                string7 = GetTime.getTime(l);
            }
            string4 = string4.replace("%expire%", string7);
        }
        if (transactionManager.isForSale(claimedResidence.getName())) {
            bl = transactionManager.isForSale(string);
            string4 = string4.replace("%isforsale%", Boolean.toString(transactionManager.isForSale(string)));
            string3 = "";
            if (bl) {
                string3 = Integer.toString(transactionManager.getSaleAmount(string));
            }
            string4 = string4.replace("%price%", string3);
        }
        return string4;
    }

    private boolean isVisible(String string, String string2) {
        List<String> list2 = this.plugin.getConfigManager().DynMapVisibleRegions;
        List<String> list3 = this.plugin.getConfigManager().DynMapHiddenRegions;
        if (list2 != null && list2.size() > 0 && !list2.contains(string) && !list2.contains("world:" + string2)) {
            return false;
        }
        return list3 == null || list3.size() <= 0 || !list3.contains(string) && !list3.contains("world:" + string2);
    }

    private void addStyle(String string, AreaMarker areaMarker) {
        AreaStyle areaStyle = new AreaStyle();
        int n = 0xFF0000;
        int n2 = 0xFF0000;
        try {
            n = Integer.parseInt(areaStyle.strokecolor.substring(1), 16);
            n2 = this.plugin.getRentManager().isForRent(string) && !this.plugin.getRentManager().isRented(string) ? Integer.parseInt(areaStyle.forrentstrokecolor.substring(1), 16) : (this.plugin.getRentManager().isForRent(string) && this.plugin.getRentManager().isRented(string) ? Integer.parseInt(areaStyle.rentedstrokecolor.substring(1), 16) : (this.plugin.getTransactionManager().isForSale(string) ? Integer.parseInt(areaStyle.forsalestrokecolor.substring(1), 16) : Integer.parseInt(areaStyle.fillcolor.substring(1), 16)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        areaMarker.setLineStyle(areaStyle.strokeweight, areaStyle.strokeopacity, n);
        areaMarker.setFillStyle(areaStyle.fillopacity, n2);
        areaMarker.setRangeY((double)areaStyle.y, (double)areaStyle.y);
    }

    private void handleResidenceAdd(String string, ClaimedResidence claimedResidence, int n) {
        if (claimedResidence == null) {
            return;
        }
        boolean bl = claimedResidence.getPermissions().has("hidden", false);
        if (bl && this.plugin.getConfigManager().DynMapHideHidden) {
            this.fireUpdateRemove(claimedResidence, n);
            return;
        }
        for (Map.Entry<String, CuboidArea> entry : claimedResidence.getAreaMap().entrySet()) {
            String string2 = String.valueOf(entry.getKey()) + "." + string;
            String string3 = claimedResidence.getName();
            double[] dArray = new double[4];
            double[] dArray2 = new double[4];
            String string4 = claimedResidence.getName();
            if (claimedResidence.getAreaMap().size() > 1) {
                string4 = String.valueOf(claimedResidence.getName()) + " (" + entry.getKey() + ")";
            }
            String string5 = this.formatInfoWindow(string, claimedResidence, string4);
            if (!this.isVisible(string, claimedResidence.getWorld())) {
                return;
            }
            Location location = entry.getValue().getLowLoc();
            Location location2 = entry.getValue().getHighLoc();
            dArray[0] = location.getX();
            dArray2[0] = location.getZ();
            dArray[1] = location.getX();
            dArray2[1] = location2.getZ() + 1.0;
            dArray[2] = location2.getX() + 1.0;
            dArray2[2] = location2.getZ() + 1.0;
            dArray[3] = location2.getX() + 1.0;
            dArray2[3] = location.getZ();
            AreaMarker areaMarker = null;
            if (this.resareas.containsKey(string2)) {
                areaMarker = this.resareas.get(string2);
                this.resareas.remove(string2);
                areaMarker.deleteMarker();
            }
            if ((areaMarker = this.set.createAreaMarker(string2, string3, true, claimedResidence.getWorld(), dArray, dArray2, true)) == null) {
                return;
            }
            if (this.plugin.getConfigManager().DynMapLayer3dRegions) {
                areaMarker.setRangeY(location2.getY(), location.getY());
            }
            areaMarker.setDescription(string5);
            this.addStyle(string, areaMarker);
            this.resareas.put(string2, areaMarker);
            if (n > this.plugin.getConfigManager().DynMapLayerSubZoneDepth) continue;
            List<ClaimedResidence> list2 = claimedResidence.getSubzones();
            for (ClaimedResidence claimedResidence2 : list2) {
                this.handleResidenceAdd(claimedResidence2.getName(), claimedResidence2, n + 1);
            }
        }
    }

    public void handleResidenceRemove(String string, ClaimedResidence claimedResidence, int n) {
        if (string == null) {
            return;
        }
        if (claimedResidence == null) {
            return;
        }
        for (Map.Entry<String, CuboidArea> entry : claimedResidence.getAreaMap().entrySet()) {
            Object object;
            String string2 = String.valueOf(entry.getKey()) + "." + string;
            if (this.resareas.containsKey(string2)) {
                object = this.resareas.remove(string2);
                object.deleteMarker();
            }
            if (n > this.plugin.getConfigManager().DynMapLayerSubZoneDepth + 1) continue;
            object = claimedResidence.getSubzones();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ClaimedResidence claimedResidence2 = (ClaimedResidence)iterator.next();
                this.handleResidenceRemove(claimedResidence2.getName(), claimedResidence2, n + 1);
            }
        }
    }

    public void activate() {
        try {
            this.markerapi = this.api.getMarkerAPI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.markerapi == null) {
            Bukkit.getConsoleSender().sendMessage("[Residence] Error loading dynmap marker API!");
            return;
        }
        if (this.set != null) {
            this.set.deleteMarkerSet();
            this.set = null;
        }
        this.set = this.markerapi.getMarkerSet("residence.markerset");
        if (this.set == null) {
            this.set = this.markerapi.createMarkerSet("residence.markerset", "Residence", null, false);
        } else {
            this.set.setMarkerSetLabel("Residence");
        }
        if (this.set == null) {
            Bukkit.getConsoleSender().sendMessage("Error creating marker set");
            return;
        }
        this.set.setLayerPriority(1);
        this.set.setHideByDefault(this.plugin.getConfigManager().DynMapHideByDefault);
        Bukkit.getConsoleSender().sendMessage("[Residence] DynMap residence activated!");
        for (Map.Entry<String, ClaimedResidence> entry : this.plugin.getResidenceManager().getResidences().entrySet()) {
            this.plugin.getDynManager().fireUpdateAdd(entry.getValue(), entry.getValue().getSubzoneDeep());
            this.handleResidenceAdd(entry.getValue().getName(), entry.getValue(), entry.getValue().getSubzoneDeep());
        }
    }
}

