/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.dynmap;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.event.ResidenceAreaAddEvent;
import com.bekvon.bukkit.residence.event.ResidenceAreaDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.event.ResidenceRentEvent;
import com.bekvon.bukkit.residence.event.ResidenceSizeChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceSubzoneCreationEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class DynMapListeners
implements Listener {
    private Residence plugin;

    public DynMapListeners(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceAreaAdd(ResidenceAreaAddEvent residenceAreaAddEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceAreaAddEvent.getResidence(), residenceAreaAddEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceAreaDelete(ResidenceAreaDeleteEvent residenceAreaDeleteEvent) {
        this.plugin.getDynManager().fireUpdateRemove(residenceAreaDeleteEvent.getResidence(), residenceAreaDeleteEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceSubZoneCreate(ResidenceSubzoneCreationEvent residenceSubzoneCreationEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceSubzoneCreationEvent.getResidence(), residenceSubzoneCreationEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceFlagChange(ResidenceFlagChangeEvent residenceFlagChangeEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceFlagChangeEvent.getResidence(), residenceFlagChangeEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent residenceDeleteEvent) {
        this.plugin.getDynManager().fireUpdateRemove(residenceDeleteEvent.getResidence(), residenceDeleteEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceOwnerChange(ResidenceOwnerChangeEvent residenceOwnerChangeEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceOwnerChangeEvent.getResidence(), residenceOwnerChangeEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRename(ResidenceRenameEvent residenceRenameEvent) {
        this.plugin.getDynManager().handleResidenceRemove(residenceRenameEvent.getOldResidenceName(), residenceRenameEvent.getResidence(), residenceRenameEvent.getResidence().getSubzoneDeep());
        this.plugin.getDynManager().fireUpdateAdd(residenceRenameEvent.getResidence(), residenceRenameEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRent(ResidenceRentEvent residenceRentEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceRentEvent.getResidence(), residenceRentEvent.getResidence().getSubzoneDeep());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceSizeChange(ResidenceSizeChangeEvent residenceSizeChangeEvent) {
        this.plugin.getDynManager().fireUpdateAdd(residenceSizeChangeEvent.getResidence(), residenceSizeChangeEvent.getResidence().getSubzoneDeep());
    }
}

