/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.BossBar.BossBarInfo;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.PlayerGroup;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ResidencePlayer {
    private String userName = null;
    private Player player = null;
    private OfflinePlayer ofPlayer = null;
    private UUID uuid = null;
    private Set<ClaimedResidence> ResidenceList = new HashSet<ClaimedResidence>();
    private ClaimedResidence mainResidence = null;
    private PlayerGroup groups = null;
    private int maxRes = -1;
    private int maxRents = -1;
    private int maxSubzones = -1;
    private int maxSubzoneDepth = -1;
    private int maxValue = 9999;
    private Long lastRaidAttackTimer = 0L;
    private Long lastRaidDefendTimer = 0L;
    private ResidenceRaid raid = null;
    private Long lastMaxResRecalculation = 0L;
    private Long lastMaxRentsRecalculation = 0L;
    private Long lastMaxSubzonesRecalculation = 0L;
    private Long lastMaxSubzonesDepthRecalculation = 0L;
    private boolean updated = false;
    HashMap<String, BossBarInfo> barMap = new HashMap();

    public ResidencePlayer(OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            return;
        }
        this.uuid = offlinePlayer.getUniqueId();
        this.userName = offlinePlayer.getName();
        Residence.getInstance().addOfflinePlayerToChache(offlinePlayer);
        this.updatePlayer();
    }

    public ResidencePlayer(Player player) {
        if (player == null) {
            return;
        }
        Residence.getInstance().addOfflinePlayerToChache((OfflinePlayer)player);
        this.updatePlayer(player);
    }

    public boolean isOnline() {
        this.updatePlayer();
        return this.player != null && this.player.isOnline();
    }

    public ResidencePlayer(String string, UUID uUID) {
        this.userName = string;
        this.uuid = uUID;
    }

    public ResidencePlayer(String string) {
        this.userName = string;
    }

    public void setMainResidence(ClaimedResidence claimedResidence) {
        if (this.mainResidence != null) {
            this.mainResidence.setMainResidence(false);
        }
        this.mainResidence = claimedResidence;
    }

    public ClaimedResidence getMainResidence() {
        if (this.mainResidence == null || !this.mainResidence.isOwner(this.getPlayerName())) {
            for (ClaimedResidence object : this.ResidenceList) {
                if (object == null || !object.isMainResidence()) continue;
                this.mainResidence = object;
                return this.mainResidence;
            }
            for (String string : Residence.getInstance().getRentManager().getRentedLands(this.userName)) {
                ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByName(string);
                if (claimedResidence == null) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
            for (ClaimedResidence claimedResidence : this.ResidenceList) {
                if (claimedResidence == null) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
        }
        return this.mainResidence;
    }

    public void recountMaxRes() {
        if (this.lastMaxResRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxResRecalculation = System.currentTimeMillis();
        if (this.getGroup() != null) {
            this.maxRes = this.getGroup().getMaxZones();
        }
        int n = this.maxRes = this.maxRes == -1 ? this.maxValue : this.maxRes;
        if (this.player != null && this.player.isOnline()) {
            if (PermissionManager.ResPerm.max_res_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRes = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_res_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRes = this.maxValue;
            return;
        }
        int n2 = 1;
        while (n2 <= Residence.getInstance().getConfigManager().getMaxResCount()) {
            if (this.player != null && this.player.isOnline()) {
                if (PermissionManager.ResPerm.max_res_$1.hasSetPermission((CommandSender)this.player, String.valueOf(n2))) {
                    this.maxRes = n2;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_res_$1.getPermission(String.valueOf(n2)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRes = n2;
            }
            ++n2;
        }
    }

    public void recountMaxRents() {
        if (this.lastMaxRentsRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxRentsRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_rents_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRents = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_rents_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRents = this.maxValue;
            return;
        }
        int n = 1;
        while (n <= Residence.getInstance().getConfigManager().getMaxRentCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_rents_$1.hasSetPermission((CommandSender)this.player, String.valueOf(n))) {
                    this.maxRents = n;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_rents_$1.getPermission(String.valueOf(n)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRents = n;
            }
            ++n;
        }
        n = this.getGroup().getMaxRents();
        int n2 = n = n == -1 ? this.maxValue : n;
        if (this.maxRents < n) {
            this.maxRents = n;
        }
    }

    public int getMaxRents() {
        this.recountMaxRents();
        return this.maxRents;
    }

    public void recountMaxSubzones() {
        if (this.lastMaxSubzonesRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxSubzonesRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzones_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzones = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzones_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzones = this.maxValue;
            return;
        }
        int n = 1;
        while (n <= Residence.getInstance().getConfigManager().getMaxSubzonesCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_subzones_$1.hasSetPermission((CommandSender)this.player, String.valueOf(n))) {
                    this.maxSubzones = n;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzones_$1.getPermission(String.valueOf(n)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzones = n;
            }
            ++n;
        }
        n = this.getGroup().getMaxSubzones();
        int n2 = n = n == -1 ? this.maxValue : n;
        if (this.maxSubzones < n) {
            this.maxSubzones = n;
        }
    }

    public int getMaxSubzones() {
        this.recountMaxSubzones();
        return this.maxSubzones;
    }

    public void recountMaxSubzoneDepth() {
        if (this.lastMaxSubzonesDepthRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxSubzonesDepthRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzonedepth_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzoneDepth = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzonedepth_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzoneDepth = this.maxValue;
            return;
        }
        int n = 1;
        while (n <= Residence.getInstance().getConfigManager().getMaxSubzoneDepthCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_subzonedepth_$1.hasSetPermission((CommandSender)this.player, String.valueOf(n))) {
                    this.maxSubzoneDepth = n;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzonedepth_$1.getPermission(String.valueOf(n)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzoneDepth = n;
            }
            ++n;
        }
        n = this.getGroup().getMaxSubzoneDepth();
        int n2 = n = n == -1 ? this.maxValue : n;
        if (this.maxSubzoneDepth < n) {
            this.maxSubzoneDepth = n;
        }
    }

    public int getMaxSubzoneDepth() {
        this.recountMaxSubzoneDepth();
        return this.maxSubzoneDepth;
    }

    public int getMaxRes() {
        this.recountMaxRes();
        PermissionGroup permissionGroup = this.getGroup();
        if (this.maxRes < permissionGroup.getMaxZones()) {
            return permissionGroup.getMaxZones();
        }
        return this.maxRes;
    }

    public PermissionGroup forceUpdateGroup() {
        this.updatePlayer();
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld(), true);
    }

    public PermissionGroup getGroup() {
        this.updatePlayer();
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld());
    }

    public PermissionGroup getGroup(String string) {
        return this.getGroup(string, false);
    }

    public PermissionGroup getGroup(String string, boolean bl) {
        if (this.groups == null) {
            this.groups = new PlayerGroup(this);
        }
        this.groups.updateGroup(string, bl);
        PermissionGroup permissionGroup = this.groups.getGroup(string);
        if (permissionGroup == null) {
            permissionGroup = Residence.getInstance().getPermissionManager().getDefaultGroup();
        }
        return permissionGroup;
    }

    public ResidencePlayer updatePlayer(Player player) {
        if (this.updated) {
            return this;
        }
        if (player.isOnline()) {
            this.updated = true;
        }
        this.player = player;
        this.uuid = player.getUniqueId();
        this.userName = player.getName();
        this.ofPlayer = player;
        return this;
    }

    public void onQuit() {
        this.ofPlayer = null;
        this.player = null;
        this.updated = false;
    }

    private void updatePlayer() {
        this.player = Bukkit.getPlayer((UUID)this.uuid);
        if (this.player != null) {
            this.updatePlayer(this.player);
        }
        if (this.player != null && this.player.isOnline()) {
            return;
        }
        if (this.uuid != null && Bukkit.getPlayer((UUID)this.uuid) != null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
            this.userName = this.player.getName();
            return;
        }
        if (this.userName != null) {
            this.player = Bukkit.getPlayer((String)this.userName);
        }
        if (this.player != null) {
            this.userName = this.player.getName();
            this.uuid = this.player.getUniqueId();
            this.ofPlayer = this.player;
            return;
        }
        if (this.player == null && this.ofPlayer == null) {
            this.ofPlayer = Residence.getInstance().getOfflinePlayer(this.userName);
        }
        if (this.ofPlayer != null) {
            this.userName = this.ofPlayer.getName();
            this.uuid = this.ofPlayer.getUniqueId();
            return;
        }
    }

    public void addResidence(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        if (claimedResidence.isSubzone()) {
            return;
        }
        claimedResidence.getPermissions().setOwnerUUID(this.uuid);
        if (this.userName != null) {
            claimedResidence.getPermissions().setOwnerLastKnownName(this.userName);
        }
        this.ResidenceList.add(claimedResidence);
    }

    public void removeResidence(ClaimedResidence claimedResidence) {
        if (claimedResidence == null) {
            return;
        }
        boolean bl = this.ResidenceList.remove(claimedResidence);
        if (!bl) {
            Iterator<ClaimedResidence> iterator = this.ResidenceList.iterator();
            while (iterator.hasNext()) {
                ClaimedResidence claimedResidence2 = iterator.next();
                if (!claimedResidence2.getName().equalsIgnoreCase(claimedResidence.getName())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public int getResAmount() {
        int n = 0;
        for (ClaimedResidence claimedResidence : this.ResidenceList) {
            if (claimedResidence.isSubzone()) continue;
            ++n;
        }
        return n;
    }

    public List<ClaimedResidence> getResList() {
        ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
        arrayList.addAll(this.ResidenceList);
        return arrayList;
    }

    @Deprecated
    public String getPlayerName() {
        return this.getName();
    }

    public String getName() {
        this.updatePlayer();
        return this.userName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUniqueId();
    }

    public Player getPlayer() {
        this.updatePlayer();
        return this.player;
    }

    public void removeBossBar(BossBarInfo bossBarInfo) {
        if (bossBarInfo == null) {
            return;
        }
        if (bossBarInfo.getBar() != null) {
            bossBarInfo.getBar().setVisible(false);
        }
        bossBarInfo.cancelAutoScheduler();
        bossBarInfo.cancelHideScheduler();
        this.barMap.remove(bossBarInfo.getNameOfBar().toLowerCase());
    }

    public void addBossBar(BossBarInfo bossBarInfo) {
        if (!this.barMap.containsKey(bossBarInfo.getNameOfBar().toLowerCase())) {
            this.barMap.put(bossBarInfo.getNameOfBar().toLowerCase(), bossBarInfo);
            Residence.getInstance().getBossBarManager().Show(bossBarInfo);
        } else {
            BossBarInfo bossBarInfo2 = this.getBossBar(bossBarInfo.getNameOfBar().toLowerCase());
            if (bossBarInfo2 != null) {
                if (bossBarInfo.getColor() != null) {
                    bossBarInfo2.setColor(bossBarInfo.getColor());
                }
                if (bossBarInfo.getKeepFor() != null) {
                    bossBarInfo2.setKeepForTicks(bossBarInfo.getKeepFor());
                }
                if (bossBarInfo.getPercentage() != null) {
                    bossBarInfo2.setPercentage(bossBarInfo.getPercentage());
                }
                if (bossBarInfo.getUser() != null) {
                    bossBarInfo2.setUser(bossBarInfo.getUser());
                }
                if (bossBarInfo.getAdjustPerc() != null) {
                    bossBarInfo2.setAdjustPerc(bossBarInfo.getAdjustPerc());
                }
                if (bossBarInfo.getStyle() != null) {
                    bossBarInfo2.setStyle(bossBarInfo.getStyle());
                }
                if (!bossBarInfo.getTitleOfBar().isEmpty()) {
                    bossBarInfo2.setTitleOfBar(bossBarInfo.getTitleOfBar());
                }
                if (bossBarInfo.getBar() != null) {
                    bossBarInfo2.setBar(bossBarInfo.getBar());
                }
                if (bossBarInfo.getId() != null) {
                    bossBarInfo2.setId(bossBarInfo.getId());
                }
                if (bossBarInfo.getAuto() != null) {
                    bossBarInfo2.setAuto(bossBarInfo.getAuto());
                }
            }
            Residence.getInstance().getBossBarManager().Show(bossBarInfo2);
        }
    }

    public BossBarInfo getBossBar(String string) {
        return this.barMap.get(string.toLowerCase());
    }

    public synchronized HashMap<String, BossBarInfo> getBossBarInfo() {
        return this.barMap;
    }

    public synchronized void hideBossBars() {
        for (Map.Entry<String, BossBarInfo> entry : this.barMap.entrySet()) {
            entry.getValue().getBar().setVisible(false);
        }
    }

    public void clearBossMaps() {
        for (Map.Entry<String, BossBarInfo> entry : this.barMap.entrySet()) {
            entry.getValue().cancelHideScheduler();
        }
        this.barMap.clear();
    }

    public ClaimedResidence getCurrentlyRaidedResidence() {
        for (ClaimedResidence claimedResidence : this.getResList()) {
            if (!claimedResidence.isUnderRaid() && !claimedResidence.isInPreRaid()) continue;
            return claimedResidence;
        }
        return null;
    }

    public Long getLastRaidAttackTimer() {
        return this.lastRaidAttackTimer;
    }

    public void setLastRaidAttackTimer(Long l) {
        this.lastRaidAttackTimer = l;
    }

    public Long getLastRaidDefendTimer() {
        return this.lastRaidDefendTimer;
    }

    public void setLastRaidDefendTimer(Long l) {
        this.lastRaidDefendTimer = l;
    }

    public ResidenceRaid getJoinedRaid() {
        return this.raid;
    }

    public void setJoinedRaid(ResidenceRaid residenceRaid) {
        this.raid = residenceRaid;
    }

    public PlayerGroup getGroups() {
        return this.groups;
    }

    @Deprecated
    public boolean canBreakBlock(Location location, boolean bl) {
        return this.canBreakBlock(location.getBlock(), bl);
    }

    public boolean canBreakBlock(Block block, boolean bl) {
        return ResidenceBlockListener.canBreakBlock(this.getPlayer(), block, bl);
    }

    @Deprecated
    public boolean canPlaceBlock(Location location, boolean bl) {
        return this.canPlaceBlock(location.getBlock(), bl);
    }

    public boolean canPlaceBlock(Block block, boolean bl) {
        return ResidenceBlockListener.canPlaceBlock(this.getPlayer(), block, bl);
    }

    public boolean canDamageEntity(Entity entity, boolean bl) {
        return ResidenceEntityListener.canDamageEntity((Entity)this.getPlayer(), entity, bl);
    }
}

