/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.shopStuff.Board;
import com.bekvon.bukkit.residence.shopStuff.ShopListener;
import com.bekvon.bukkit.residence.shopStuff.ShopVote;
import com.bekvon.bukkit.residence.shopStuff.Vote;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class shop
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1700)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        Player player = (Player)commandSender;
        int n = 1;
        try {
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[stringArray.length - 1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((stringArray.length == 1 || stringArray.length == 2 || stringArray.length == 3) && (stringArray[0].equalsIgnoreCase("votes") || stringArray[0].equalsIgnoreCase("likes"))) {
            int n2 = 1;
            ClaimedResidence claimedResidence = null;
            if (stringArray.length == 1) {
                claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                    return true;
                }
            } else if (stringArray.length == 2) {
                claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    try {
                        n2 = Integer.parseInt(stringArray[1]);
                        claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                        if (claimedResidence == null) {
                            residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                        return true;
                    }
                }
            } else if (stringArray.length == 3) {
                claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                    return true;
                }
                try {
                    n2 = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                    return true;
                }
            }
            if (claimedResidence == null) {
                residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                return true;
            }
            List<ShopVote> list2 = claimedResidence.GetShopVotes();
            String string = residence.msg(lm.InformationPage_SmallSeparator, new Object[0]);
            PageInfo pageInfo = new PageInfo(10, list2.size(), n);
            if (!pageInfo.isPageOk()) {
                residence.msg(commandSender, lm.Shop_NoVotes, new Object[0]);
                return true;
            }
            residence.msg((CommandSender)player, lm.Shop_VotesTopLine, string, claimedResidence.getName(), n2, pageInfo.getTotalPages(), string);
            int n3 = -1;
            for (ShopVote shopVote : list2) {
                if (++n3 > pageInfo.getEnd()) break;
                if (!pageInfo.isInRange(n3)) continue;
                Date date = new Date(shopVote.getTime());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(residence.getConfigManager().getTimeZone()));
                String string2 = simpleDateFormat.format(date);
                String string3 = residence.msg(lm.Shop_VotesList, pageInfo.getStart() + n3 + 1, shopVote.getName(), residence.getConfigManager().isOnlyLike() ? "" : Integer.valueOf(shopVote.getVote()), string2);
                player.sendMessage(string3);
            }
            residence.getInfoPageManager().ShowPagination(commandSender, pageInfo, "/res shop votes " + claimedResidence.getName());
            return true;
        }
        if ((stringArray.length == 1 || stringArray.length == 2) && stringArray[0].equalsIgnoreCase("list")) {
            int n4 = 1;
            if (stringArray.length == 2) {
                try {
                    n4 = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                    return true;
                }
            }
            Map<String, Double> map = residence.getShopSignUtilManager().getSortedShopList();
            String string = residence.msg(lm.InformationPage_SmallSeparator, new Object[0]);
            PageInfo pageInfo = new PageInfo(10, map.size(), n);
            if (!pageInfo.isPageOk()) {
                residence.msg(commandSender, lm.Shop_NoVotes, new Object[0]);
                return true;
            }
            residence.msg((CommandSender)player, lm.Shop_ListTopLine, string, n4, pageInfo.getTotalPages(), string);
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!pageInfo.isEntryOk()) continue;
                if (pageInfo.isBreak()) break;
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(entry.getKey());
                if (claimedResidence == null) continue;
                Vote vote = residence.getShopSignUtilManager().getAverageVote(entry.getKey());
                String string4 = "";
                string4 = residence.getConfigManager().isOnlyLike() ? (vote.getAmount() == 0 ? "" : residence.msg(lm.Shop_ListLiked, residence.getShopSignUtilManager().getLikes(entry.getKey()))) : (vote.getAmount() == 0 ? "" : residence.msg(lm.Shop_ListVoted, vote.getVote(), vote.getAmount()));
                String string5 = claimedResidence.getOwner();
                String string6 = residence.msg(lm.Shop_List, pageInfo.getPositionForOutput(), entry.getKey(), string5, string4);
                String string7 = claimedResidence.getShopDesc() == null ? residence.msg(lm.Shop_NoDesc, new Object[0]) : residence.msg(lm.Shop_Desc, CMIChatColor.translate(claimedResidence.getShopDesc().replace("/n", "\n")));
                RawMessage rawMessage = new RawMessage();
                rawMessage.addText(" " + string6).addHover(string7).addCommand("/res tp " + entry.getKey());
                rawMessage.show(commandSender);
            }
            residence.getInfoPageManager().ShowPagination(commandSender, pageInfo, "/res shop list");
            return true;
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("DeleteBoard")) {
            if (!bl) {
                residence.msg((CommandSender)player, lm.General_AdminOnly, new Object[0]);
                return true;
            }
            ShopListener.Delete.add(player.getName());
            residence.msg((CommandSender)player, lm.Shop_DeleteBoard, new Object[0]);
            return true;
        }
        if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("setdesc")) {
            ClaimedResidence claimedResidence = null;
            String string = "";
            if (stringArray.length >= 1) {
                claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                    return true;
                }
                int n5 = 2;
                while (n5 < stringArray.length) {
                    string = String.valueOf(string) + stringArray[n5];
                    if (n5 < stringArray.length - 1) {
                        string = String.valueOf(string) + " ";
                    }
                    ++n5;
                }
            }
            if (claimedResidence == null) {
                return true;
            }
            if (!claimedResidence.isOwner(player) && !bl) {
                residence.msg((CommandSender)player, lm.Residence_NonAdmin, new Object[0]);
                return true;
            }
            claimedResidence.setShopDesc(string);
            residence.msg((CommandSender)player, lm.Shop_DescChange, CMIChatColor.translate(string));
            return true;
        }
        if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("createboard")) {
            CuboidArea cuboidArea;
            if (!bl) {
                residence.msg((CommandSender)player, lm.General_AdminOnly, new Object[0]);
                return true;
            }
            if (!residence.getSelectionManager().hasPlacedBoth(player)) {
                residence.msg((CommandSender)player, lm.Select_Points, new Object[0]);
                return true;
            }
            int n6 = 1;
            try {
                n6 = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                return true;
            }
            if (n6 < 1) {
                n6 = 1;
            }
            if ((cuboidArea = residence.getSelectionManager().getSelectionCuboid(player)).getXSize() > 16 || cuboidArea.getYSize() > 16 || cuboidArea.getZSize() > 16) {
                residence.msg((CommandSender)player, lm.Shop_ToBigSelection, new Object[0]);
                return true;
            }
            if (cuboidArea.getXSize() != 1 && cuboidArea.getZSize() != 1) {
                residence.msg((CommandSender)player, lm.Shop_ToDeapSelection, new Object[0]);
                return true;
            }
            Location location = residence.getSelectionManager().getPlayerLoc1(player);
            Location location2 = residence.getSelectionManager().getPlayerLoc2(player);
            if (location.getBlockY() < location2.getBlockY()) {
                residence.msg((CommandSender)player, lm.Shop_InvalidSelection, new Object[0]);
                return true;
            }
            Board board = new Board();
            board.setStartPlace(n6);
            board.setTopLoc(location);
            board.setBottomLoc(location2);
            if (residence.getShopSignUtilManager().exist(board)) {
                commandSender.sendMessage(residence.msg(lm.Shop_BoardExist, new Object[0]));
                return true;
            }
            residence.getShopSignUtilManager().addBoard(board);
            residence.msg((CommandSender)player, lm.Shop_NewBoard, new Object[0]);
            residence.getShopSignUtilManager().BoardUpdate();
            residence.getShopSignUtilManager().saveSigns();
            return true;
        }
        if ((stringArray.length == 1 || stringArray.length == 2 || stringArray.length == 3) && (stringArray[0].equalsIgnoreCase("vote") || stringArray[0].equalsIgnoreCase("like"))) {
            String string = "";
            int n7 = 5;
            ClaimedResidence claimedResidence = null;
            if (stringArray.length == 2) {
                if (residence.getConfigManager().isOnlyLike()) {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                    if (claimedResidence == null) {
                        residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                        return true;
                    }
                    n7 = residence.getConfigManager().getVoteRangeTo();
                } else {
                    claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                    if (claimedResidence == null) {
                        residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                        return true;
                    }
                    try {
                        n7 = Integer.parseInt(stringArray[1]);
                    }
                    catch (Exception exception) {
                        residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                        return true;
                    }
                }
            } else if (stringArray.length == 1 && residence.getConfigManager().isOnlyLike()) {
                claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                    return true;
                }
                n7 = residence.getConfigManager().getVoteRangeTo();
            } else if (stringArray.length == 3 && !residence.getConfigManager().isOnlyLike()) {
                claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                try {
                    n7 = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                    return true;
                }
            } else if (stringArray.length == 2 && !residence.getConfigManager().isOnlyLike()) {
                claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                try {
                    n7 = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.General_UseNumbers, new Object[0]);
                    return true;
                }
            } else {
                return false;
            }
            string = claimedResidence.getName();
            if (!claimedResidence.getPermissions().has("shop", false)) {
                residence.msg((CommandSender)player, lm.Shop_CantVote, new Object[0]);
                return true;
            }
            if (n7 < residence.getConfigManager().getVoteRangeFrom() || n7 > residence.getConfigManager().getVoteRangeTo()) {
                residence.msg((CommandSender)player, lm.Shop_VotedRange, residence.getConfigManager().getVoteRangeFrom(), residence.getConfigManager().getVoteRangeTo());
                return true;
            }
            if (!claimedResidence.GetShopVotes().isEmpty()) {
                List<ShopVote> list3 = claimedResidence.GetShopVotes();
                boolean bl2 = false;
                for (ShopVote shopVote : list3) {
                    if (!shopVote.getName().equalsIgnoreCase(player.getName()) && (shopVote.getUuid() == null || shopVote.getUuid() != player.getUniqueId())) continue;
                    if (residence.getConfigManager().isOnlyLike()) {
                        residence.msg((CommandSender)player, lm.Shop_AlreadyLiked, string);
                        return true;
                    }
                    residence.msg((CommandSender)player, lm.Shop_VoteChanged, shopVote.getVote(), n7, string);
                    shopVote.setVote(n7);
                    shopVote.setName(player.getName());
                    shopVote.setTime(System.currentTimeMillis());
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    ShopVote shopVote;
                    shopVote = new ShopVote(player.getName(), player.getUniqueId(), n7, System.currentTimeMillis());
                    list3.add(shopVote);
                    if (residence.getConfigManager().isOnlyLike()) {
                        residence.msg((CommandSender)player, lm.Shop_Liked, string);
                    } else {
                        residence.msg((CommandSender)player, lm.Shop_Voted, n7, string);
                    }
                }
            } else {
                ShopVote shopVote = new ShopVote(player.getName(), player.getUniqueId(), n7, System.currentTimeMillis());
                claimedResidence.addShopVote(shopVote);
                if (residence.getConfigManager().isOnlyLike()) {
                    residence.msg((CommandSender)player, lm.Shop_Liked, string);
                } else {
                    residence.msg((CommandSender)player, lm.Shop_Voted, n7, string);
                }
            }
            residence.getShopSignUtilManager().saveShopVotes();
            residence.getShopSignUtilManager().BoardUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Manage residence shop");
        configReader.get("Info", Arrays.asList("Manages residence shop feature"));
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("list.Description", "Shows list of res shops");
        configReader.get("list.Info", Arrays.asList("&eUsage: &6/res shop list", "Shows full list of all residences with shop flag"));
        configReader.get("vote.Description", "Vote for residence shop");
        configReader.get("vote.Info", Arrays.asList("&eUsage: &6/res shop vote <residence> [amount]", "Votes for current or defined residence"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "vote"), Arrays.asList("[residence]", "10"));
        configReader.get("like.Description", "Give like for residence shop");
        configReader.get("like.Info", Arrays.asList("&eUsage: &6/res shop like <residence>", "Gives like for residence shop"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "like"), Arrays.asList("[residenceshop]"));
        configReader.get("votes.Description", "Shows res shop votes");
        configReader.get("votes.Info", Arrays.asList("&eUsage: &6/res shop votes <residence> <page>", "Shows full vote list of current or defined residence shop"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "votes"), Arrays.asList("[residenceshop]"));
        configReader.get("likes.Description", "Shows res shop likes");
        configReader.get("likes.Info", Arrays.asList("&eUsage: &6/res shop likes <residence> <page>", "Shows full like list of current or defined residence shop"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "likes"), Arrays.asList("[residenceshop]"));
        configReader.get("setdesc.Description", "Sets residence shop description");
        configReader.get("setdesc.Info", Arrays.asList("&eUsage: &6/res shop setdesc [text]", "Sets residence shop description. Color code supported. For new line use /n"));
        configReader.get("createboard.Description", "Create res shop board");
        configReader.get("createboard.Info", Arrays.asList("&eUsage: &6/res shop createboard [place]", "Creates res shop board from selected area. Place - position from which to start filling board"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "createboard"), Arrays.asList("1"));
        configReader.get("deleteboard.Description", "Deletes res shop board");
        configReader.get("deleteboard.Info", Arrays.asList("&eUsage: &6/res shop deleteboard", "Deletes res shop board bi right clicking on one of signs"));
    }
}

