/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class select
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1300)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        Player player;
        block80: {
            block78: {
                if (!(commandSender instanceof Player)) {
                    return false;
                }
                player = (Player)commandSender;
                ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(player);
                PermissionGroup permissionGroup = residencePlayer.getGroup();
                if (!permissionGroup.selectCommandAccess() && !bl) {
                    residence.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (!permissionGroup.canCreateResidences() && residencePlayer.getMaxSubzones() <= 0 && !bl) {
                    residence.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (!(PermissionManager.ResPerm.create.hasPermission((CommandSender)player) || PermissionManager.ResPerm.select.hasPermission((CommandSender)player) || bl)) {
                    residence.msg((CommandSender)player, lm.Select_Disabled, new Object[0]);
                    return true;
                }
                if (stringArray.length != 1) break block78;
                switch (stringArray[0].toLowerCase()) {
                    case "cost": 
                    case "size": {
                        if (residence.getSelectionManager().hasPlacedBoth(player) || residence.getSelectionManager().worldEdit(player)) {
                            try {
                                residence.getSelectionManager().showSelectionInfo(player);
                                return true;
                            }
                            catch (Exception exception) {
                                Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, exception);
                                return true;
                            }
                        }
                        return false;
                    }
                    case "vert": {
                        residence.getSelectionManager().vert(player, bl);
                        residence.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "sky": {
                        residence.getSelectionManager().sky(player, bl);
                        residence.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "bedrock": {
                        residence.getSelectionManager().bedrock(player, bl);
                        residence.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "coords": {
                        Location location;
                        residence.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                        if (!residence.getSelectionManager().hasPlacedBoth(player)) {
                            residence.msg((CommandSender)player, lm.Select_Points, new Object[0]);
                            return true;
                        }
                        Location location2 = residence.getSelectionManager().getPlayerLoc1(player);
                        if (location2 != null) {
                            residence.msg((CommandSender)player, lm.Select_Primary, residence.msg(lm.General_CoordsTop, location2.getBlockX(), location2.getBlockY(), location2.getBlockZ()));
                        }
                        if ((location = residence.getSelectionManager().getPlayerLoc2(player)) != null) {
                            residence.msg((CommandSender)player, lm.Select_Secondary, residence.msg(lm.General_CoordsBottom, location.getBlockX(), location.getBlockY(), location.getBlockZ()));
                        }
                        residence.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                        residence.getSelectionManager().afterSelectionUpdate(player, false);
                        return true;
                    }
                    case "chunk": {
                        residence.getSelectionManager().getSelection(player).selectChunk();
                        residence.getSelectionManager().afterSelectionUpdate(player, true);
                        return true;
                    }
                    case "worldedit": {
                        if (residence.getSelectionManager().worldEdit(player)) {
                            residence.msg((CommandSender)player, lm.Select_Success, new Object[0]);
                            residence.getSelectionManager().afterSelectionUpdate(player, false);
                        }
                        return true;
                    }
                }
                break block80;
            }
            if (stringArray.length != 2) break block80;
            int n = 0;
            switch (stringArray[0].toLowerCase()) {
                case "expand": 
                case "contract": 
                case "shift": {
                    try {
                        n = Integer.parseInt(stringArray[1]);
                        break;
                    }
                    catch (Exception exception) {
                        residence.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                        return true;
                    }
                }
            }
            switch (stringArray[0].toLowerCase()) {
                case "expand": {
                    residence.getSelectionManager().modify(player, false, n);
                    return true;
                }
                case "contract": {
                    residence.getSelectionManager().contract(player, n);
                    return true;
                }
                case "shift": {
                    if (n > 100) {
                        n = 100;
                    }
                    if (n < -100) {
                        n = -100;
                    }
                    residence.getSelectionManager().modify(player, true, n);
                    return true;
                }
            }
        }
        if ((stringArray.length == 1 || stringArray.length == 2) && stringArray[0].equals("auto")) {
            Player player2 = player;
            if (stringArray.length == 2) {
                if (!PermissionManager.ResPerm.select_auto_others.hasPermission((CommandSender)player, true, new String[0])) {
                    return true;
                }
                player2 = Bukkit.getPlayer((String)stringArray[1]);
                if (player2 == null) {
                    residence.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
                    return true;
                }
            }
            residence.getSelectionManager().clearSelection(player2);
            residence.getSelectionManager().placeLoc1(player, player.getLocation().clone(), false);
            residence.getSelectionManager().placeLoc2(player, player.getLocation().clone().add(0.0, 1.0, 0.0), true);
            residence.getAutoSelectionManager().switchAutoSelection(player2);
            return true;
        }
        if (stringArray.length > 0 && stringArray[0].equals("residence")) {
            String string;
            Object object = null;
            object = stringArray.length > 1 ? residence.getResidenceManager().getByName(stringArray[1]) : residence.getResidenceManager().getByLoc(player.getLocation());
            if (object == null) {
                residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return true;
            }
            String string2 = ((ClaimedResidence)object).getName();
            CuboidArea cuboidArea = null;
            if (stringArray.length > 2) {
                cuboidArea = ((ClaimedResidence)object).getArea(stringArray[2]);
                string = stringArray[2];
            } else {
                string = ((ClaimedResidence)object).getAreaIDbyLoc(player.getLocation());
                cuboidArea = ((ClaimedResidence)object).getArea(string);
            }
            if (cuboidArea != null) {
                residence.getSelectionManager().placeLoc1(player, cuboidArea.getHighLoc(), false);
                residence.getSelectionManager().placeLoc2(player, cuboidArea.getLowLoc(), true);
                residence.msg((CommandSender)player, lm.Select_Area, string, string2);
            } else {
                residence.msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
            }
            return true;
        }
        try {
            residence.getSelectionManager().selectBySize(player, Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Selection Commands");
        configReader.get("Info", Arrays.asList("This command selects areas for usage with residence.", "/res select [x] [y] [z] - selects a radius of blocks, with you in the middle."));
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("coords.Description", "Display selected coordinates");
        configReader.get("coords.Info", Arrays.asList("&eUsage: &6/res select coords"));
        configReader.get("size.Description", "Display selected size");
        configReader.get("size.Info", Arrays.asList("&eUsage: &6/res select size"));
        configReader.get("auto.Description", "Turns on auto selection tool");
        configReader.get("auto.Info", Arrays.asList("&eUsage: &6/res select auto [playername]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "auto"), Arrays.asList("[playername]"));
        configReader.get("cost.Description", "Display selection cost");
        configReader.get("cost.Info", Arrays.asList("&eUsage: &6/res select cost"));
        configReader.get("vert.Description", "Expand Selection Vertically");
        configReader.get("vert.Info", Arrays.asList("&eUsage: &6/res select vert", "Will expand selection as high and as low as allowed."));
        configReader.get("sky.Description", "Expand Selection to Sky");
        configReader.get("sky.Info", Arrays.asList("&eUsage: &6/res select sky", "Expands as high as your allowed to go."));
        configReader.get("bedrock.Description", "Expand Selection to Bedrock");
        configReader.get("bedrock.Info", Arrays.asList("&eUsage: &6/res select bedrock", "Expands as low as your allowed to go."));
        configReader.get("expand.Description", "Expand selection in a direction.");
        configReader.get("expand.Info", Arrays.asList("&eUsage: &6/res select expand <amount>", "Expands <amount> in the direction your looking."));
        configReader.get("shift.Description", "Shift selection in a direction");
        configReader.get("shift.Info", Arrays.asList("&eUsage: &6/res select shift <amount>", "Pushes your selection by <amount> in the direction your looking."));
        configReader.get("chunk.Description", "Select the chunk your currently in.");
        configReader.get("chunk.Info", Arrays.asList("&eUsage: &6/res select chunk", "Selects the chunk your currently standing in."));
        configReader.get("residence.Description", "Select a existing area in a residence.");
        configReader.get("residence.Info", Arrays.asList("&eUsage: &6/res select residence <residence>", "Selects a existing area in a residence."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "residence"), Arrays.asList("[residence]"));
        configReader.get("worldedit.Description", "Set selection using the current WorldEdit selection.");
        configReader.get("worldedit.Info", Arrays.asList("&eUsage: &6/res select worldedit", "Sets selection area using the current WorldEdit selection."));
    }
}

