/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class rc
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=1100)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return true;
        }
        Player player = (Player)commandSender;
        String string = player.getName();
        if (!residence.getConfigManager().chatEnabled()) {
            residence.msg((CommandSender)player, lm.Residence_ChatDisabled, new Object[0]);
            return false;
        }
        if (stringArray.length == 0) {
            ClaimedResidence claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
            if (claimedResidence == null) {
                ChatChannel chatChannel = residence.getChatManager().getPlayerChannel(string);
                if (chatChannel != null) {
                    residence.getChatManager().removeFromChannel(string);
                    residence.getPlayerListener().removePlayerResidenceChat(player);
                    return true;
                }
                residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                return true;
            }
            ChatChannel chatChannel = residence.getChatManager().getPlayerChannel(string);
            if (chatChannel != null && chatChannel.getChannelName().equals(claimedResidence.getName())) {
                residence.getChatManager().removeFromChannel(string);
                residence.getPlayerListener().removePlayerResidenceChat(player);
                return true;
            }
            if (!claimedResidence.getPermissions().playerHas(player.getName(), Flags.chat, true) && !residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                residence.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chat, claimedResidence.getName()});
                return false;
            }
            residence.getPlayerListener().tooglePlayerResidenceChat(player, claimedResidence.getName());
            residence.getChatManager().setChannel(string, claimedResidence);
            return true;
        }
        if (stringArray.length == 1) {
            if (stringArray[0].equalsIgnoreCase("l") || stringArray[0].equalsIgnoreCase("leave")) {
                residence.getChatManager().removeFromChannel(string);
                residence.getPlayerListener().removePlayerResidenceChat(player);
                return true;
            }
            ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[0]);
            if (claimedResidence == null) {
                residence.msg((CommandSender)player, lm.Chat_InvalidChannel, new Object[0]);
                return true;
            }
            if (!claimedResidence.getPermissions().playerHas(player.getName(), Flags.chat, true) && !residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                residence.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chat, claimedResidence.getName()});
                return false;
            }
            residence.getPlayerListener().tooglePlayerResidenceChat(player, claimedResidence.getName());
            residence.getChatManager().setChannel(string, claimedResidence);
            return true;
        }
        if (stringArray.length == 2) {
            if (stringArray[0].equalsIgnoreCase("setcolor")) {
                ChatChannel chatChannel = residence.getChatManager().getPlayerChannel(string);
                if (chatChannel == null) {
                    residence.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(chatChannel.getChannelName());
                if (claimedResidence == null) {
                    return false;
                }
                if (!claimedResidence.isOwner(player) && !residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    residence.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!PermissionManager.ResPerm.chatcolor.hasPermission((CommandSender)player)) {
                    return true;
                }
                String string2 = stringArray[1];
                if (!string2.contains("&")) {
                    string2 = "&" + string2;
                }
                if (string2.length() != 2 || CMIChatColor.stripColor(CMIChatColor.translate(string2)).length() != 0) {
                    residence.msg((CommandSender)player, lm.Chat_InvalidColor, new Object[0]);
                    return true;
                }
                ChatColor chatColor = ChatColor.getByChar((String)string2.replace("&", ""));
                claimedResidence.setChannelColor(chatColor);
                chatChannel.setChannelColor(chatColor);
                residence.msg((CommandSender)player, lm.Chat_ChangedColor, chatColor.name());
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("setprefix")) {
                ChatChannel chatChannel = residence.getChatManager().getPlayerChannel(string);
                if (chatChannel == null) {
                    residence.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(chatChannel.getChannelName());
                if (claimedResidence == null) {
                    return false;
                }
                if (!claimedResidence.isOwner(player) && !residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    residence.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!PermissionManager.ResPerm.chatprefix.hasPermission((CommandSender)player)) {
                    return true;
                }
                String string3 = stringArray[1];
                if (string3.length() > residence.getConfigManager().getChatPrefixLength()) {
                    residence.msg((CommandSender)player, lm.Chat_InvalidPrefixLength, residence.getConfigManager().getChatPrefixLength());
                    return true;
                }
                claimedResidence.setChatPrefix(string3);
                chatChannel.setChatPrefix(string3);
                residence.msg((CommandSender)player, lm.Chat_ChangedPrefix, CMIChatColor.translate(string3));
                return true;
            }
            if (stringArray[0].equalsIgnoreCase("kick")) {
                ChatChannel chatChannel = residence.getChatManager().getPlayerChannel(string);
                if (chatChannel == null) {
                    residence.msg((CommandSender)player, lm.Chat_JoinFirst, new Object[0]);
                    return true;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(chatChannel.getChannelName());
                if (claimedResidence == null) {
                    return false;
                }
                if (!claimedResidence.getOwner().equals(player.getName()) && !residence.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                    residence.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (!PermissionManager.ResPerm.chatkick.hasPermission((CommandSender)player)) {
                    return true;
                }
                String string4 = stringArray[1];
                if (!chatChannel.hasMember(string4)) {
                    residence.msg((CommandSender)player, lm.Chat_NotInChannel, new Object[0]);
                    return false;
                }
                chatChannel.leave(string4);
                residence.getPlayerListener().removePlayerResidenceChat(string4);
                residence.msg((CommandSender)player, lm.Chat_Kicked, string4, chatChannel.getChannelName());
                return true;
            }
        }
        return true;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Joins current or defined residence chat channel");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res rc (residence)", "Join residence chat channel."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[residence]"));
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("leave.Description", "Leaves current residence chat channel");
        configReader.get("leave.Info", Arrays.asList("&eUsage: &6/res rc leave", "If you are in residence chat channel then you will leave it"));
        configReader.get("setcolor.Description", "Sets residence chat channel text color");
        configReader.get("setcolor.Info", Arrays.asList("&eUsage: &6/res rc setcolor [colorCode]", "Sets residence chat channel text color"));
        configReader.get("setprefix.Description", "Sets residence chat channel prefix");
        configReader.get("setprefix.Info", Arrays.asList("&eUsage: &6/res rc setprefix [newName]", "Sets residence chat channel prefix"));
        configReader.get("kick.Description", "Kicks player from channel");
        configReader.get("kick.Info", Arrays.asList("&eUsage: &6/res rc kick [player]", "Kicks player from channel"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "kick"), Arrays.asList("[playername]"));
    }
}

