/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.RaidAttacker;
import com.bekvon.bukkit.residence.raid.RaidDefender;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class raidstatus
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=3100)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        if (!(commandSender instanceof Player)) {
            return false;
        }
        Player player = (Player)commandSender;
        if (stringArray.length != 0 && stringArray.length != 1) {
            return false;
        }
        if (!ConfigManager.RaidEnabled) {
            residence.msg((CommandSender)player, lm.Raid_NotEnabled, new Object[0]);
            return true;
        }
        ClaimedResidence claimedResidence = null;
        if (stringArray.length > 0) {
            claimedResidence = residence.getResidenceManager().getByName(stringArray[0]);
        }
        if (claimedResidence == null) {
            claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
        }
        if (claimedResidence == null && (object2 = residence.getOfflinePlayer(stringArray[0])) != null) {
            object = residence.getPlayerManager().getResidencePlayer(object2.getUniqueId());
            claimedResidence = ((ResidencePlayer)object).getCurrentlyRaidedResidence();
        }
        if (claimedResidence == null) {
            claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
        }
        if (claimedResidence == null) {
            residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return true;
        }
        object2 = claimedResidence.getRaid();
        residence.msg(commandSender, "&7----------- &f" + claimedResidence.getName() + "(" + claimedResidence.getOwner() + ") &7-----------");
        if (claimedResidence.getRaid().isImmune()) {
            residence.msg(commandSender, "&eImmune to raids for next: " + Utils.to24hourShort(((ResidenceRaid)object2).getImmunityUntil() - System.currentTimeMillis() + 1000L));
        } else if (claimedResidence.isInPreRaid()) {
            residence.msg(commandSender, "&7Raid starts in: " + Utils.to24hourShort(((ResidenceRaid)object2).getStartsAt() - System.currentTimeMillis()));
            object = new RawMessage();
            ((RawMessage)object).add("&7Attackers: &4" + ((ResidenceRaid)object2).getAttackers().size(), this.getAttackers((ResidenceRaid)object2));
            ((RawMessage)object).show(commandSender);
            object = new RawMessage();
            ((RawMessage)object).add("&7Defenders: &2" + ((ResidenceRaid)object2).getDefenders().size(), this.getDefenders((ResidenceRaid)object2));
            ((RawMessage)object).show(commandSender);
        } else if (claimedResidence.isUnderRaid()) {
            residence.msg(commandSender, "&7Raid ends in: " + Utils.to24hourShort(((ResidenceRaid)object2).getEndsAt() - System.currentTimeMillis()));
            object = new RawMessage();
            ((RawMessage)object).add("&7Attackers: &4" + ((ResidenceRaid)object2).getAttackers().size(), this.getAttackers((ResidenceRaid)object2));
            ((RawMessage)object).show(commandSender);
            object = new RawMessage();
            ((RawMessage)object).add("&7Defenders: &2" + ((ResidenceRaid)object2).getDefenders().size(), this.getDefenders((ResidenceRaid)object2));
            ((RawMessage)object).show(commandSender);
        } else {
            residence.msg(commandSender, ((ResidenceRaid)object2).getCooldownEnd() < System.currentTimeMillis() ? "&2Can be raided" : "&ePosible raid in: " + Utils.to24hourShort(((ResidenceRaid)object2).getCooldownEnd() - System.currentTimeMillis() + 1000L));
        }
        return true;
    }

    private String getAttackers(ResidenceRaid residenceRaid) {
        String string = "";
        int n = 0;
        for (Map.Entry<UUID, RaidAttacker> entry : residenceRaid.getAttackers().entrySet()) {
            if (!entry.getValue().getPlayer().isOnline()) continue;
            if (++n >= 5) {
                string = String.valueOf(string) + " \n";
            }
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ", ";
            }
            if (!entry.getValue().getPlayer().isOnline()) continue;
            string = String.valueOf(string) + entry.getValue().getPlayer().getPlayer().getDisplayName();
        }
        return string;
    }

    private String getDefenders(ResidenceRaid residenceRaid) {
        String string = "";
        int n = 0;
        for (Map.Entry<UUID, RaidDefender> entry : residenceRaid.getDefenders().entrySet()) {
            if (!entry.getValue().getPlayer().isOnline()) continue;
            if (++n >= 5) {
                string = String.valueOf(string) + " \n";
            }
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ", ";
            }
            if (!entry.getValue().getPlayer().isOnline()) continue;
            string = String.valueOf(string) + entry.getValue().getPlayer().getPlayer().getDisplayName();
        }
        return string;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Check raid status for a residence");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res raidstatus (resName/playerName)"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[cresidence]%%[playername]"));
    }
}

