/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.utils.TimeModifier;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class raid
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=3100, regVar={1, 2, 3, 4}, consoleVar={2, 3, 4})
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        if (!ConfigManager.RaidEnabled) {
            residence.msg(commandSender, lm.Raid_NotEnabled, new Object[0]);
            return true;
        }
        if (!bl && !residence.isResAdminOn(commandSender)) {
            residence.msg(commandSender, lm.General_NoPermission, new Object[0]);
            return null;
        }
        States states = States.getState(stringArray[0]);
        if (states == null) {
            return false;
        }
        switch (states) {
            case immunity: {
                ClaimedResidence claimedResidence = null;
                if (stringArray.length > 2) {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[2]);
                }
                if (claimedResidence == null && commandSender instanceof Player) {
                    claimedResidence = residence.getResidenceManager().getByLoc(((Player)commandSender).getLocation());
                }
                if (claimedResidence == null) {
                    residence.msg(commandSender, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                Long l = null;
                if (stringArray.length > 3) {
                    l = TimeModifier.getTimeRangeFromString(stringArray[3]);
                }
                if (stringArray.length < 2) {
                    return false;
                }
                if (l == null && stringArray.length > 2) {
                    l = TimeModifier.getTimeRangeFromString(stringArray[2]);
                }
                switch (stringArray[1].toLowerCase()) {
                    case "add": {
                        if (l == null) {
                            return false;
                        }
                        Long l2 = claimedResidence.getRaid().getImmunityUntil();
                        l2 = l2 == null || l2 < System.currentTimeMillis() ? System.currentTimeMillis() : l2;
                        l2 = l2 + l * 1000L;
                        claimedResidence.getRaid().setImmunityUntil(l2);
                        residence.msg(commandSender, lm.Raid_immune, Utils.to24hourShort(l2 - System.currentTimeMillis()));
                        return true;
                    }
                    case "take": {
                        if (l == null) {
                            return false;
                        }
                        Long l3 = claimedResidence.getRaid().getImmunityUntil();
                        l3 = l3 == null || l3 < System.currentTimeMillis() ? System.currentTimeMillis() : l3;
                        l3 = l3 - l * 1000L;
                        claimedResidence.getRaid().setImmunityUntil(l3);
                        if (claimedResidence.getRaid().isImmune()) {
                            residence.msg(commandSender, lm.Raid_immune, Utils.to24hourShort(l3 - System.currentTimeMillis()));
                        } else {
                            residence.msg(commandSender, lm.Raid_notImmune, new Object[0]);
                        }
                        return true;
                    }
                    case "set": {
                        if (l == null) {
                            return false;
                        }
                        Long l4 = System.currentTimeMillis() + l * 1000L;
                        claimedResidence.getRaid().setImmunityUntil(l4);
                        residence.msg(commandSender, lm.Raid_immune, Utils.to24hourShort(l4 - System.currentTimeMillis()));
                        return true;
                    }
                    case "clear": {
                        claimedResidence.getRaid().setImmunityUntil(null);
                        residence.msg(commandSender, lm.Raid_notImmune, new Object[0]);
                        return true;
                    }
                }
                break;
            }
            case kick: {
                if (stringArray.length < 2) {
                    return false;
                }
                String string = stringArray[1];
                ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(string);
                if (residencePlayer == null) {
                    residence.msg(commandSender, lm.Invalid_Player, new Object[0]);
                    return null;
                }
                if (residencePlayer.getJoinedRaid() == null || residencePlayer.getJoinedRaid().isEnded()) {
                    residence.msg(commandSender, lm.Raid_notInRaid, new Object[0]);
                    return null;
                }
                ResidenceRaid residenceRaid = residencePlayer.getJoinedRaid();
                if (residenceRaid == null || !residenceRaid.getRes().isUnderRaid() && !residenceRaid.getRes().isInPreRaid()) {
                    residence.msg(commandSender, lm.Raid_NotIn, new Object[0]);
                    return true;
                }
                if (residenceRaid.getRes().isOwner(residencePlayer.getUniqueId())) {
                    residence.msg(commandSender, lm.Raid_CantKick, residenceRaid.getRes().getName());
                    return true;
                }
                residenceRaid.removeAttacker(residencePlayer);
                residenceRaid.removeDefender(residencePlayer);
                residenceRaid.getRes().kickFromResidence(residencePlayer.getPlayer());
                residence.msg(commandSender, lm.Raid_Kicked, residencePlayer.getName(), residenceRaid.getRes().getName());
                return true;
            }
            case start: {
                ClaimedResidence claimedResidence = null;
                if (stringArray.length > 1) {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[2]);
                }
                if (claimedResidence == null && commandSender instanceof Player) {
                    claimedResidence = residence.getResidenceManager().getByLoc(((Player)commandSender).getLocation());
                }
                if (claimedResidence == null) {
                    residence.msg(commandSender, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                if (claimedResidence.isUnderRaid() || claimedResidence.isInPreRaid()) {
                    return null;
                }
                boolean bl2 = claimedResidence.preStartRaid(null);
                if (!bl2) break;
                claimedResidence.startRaid();
                return true;
            }
            case stop: {
                break;
            }
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Manage raid in residence");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res raid start [resname] (playerName)", "&6/res raid stop [resname]", "&6/res raid kick [playerName]", "&6/res raid immunity [add/take/set/clear] [resname/currentres] [time]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("start%%stop%%kick%%immunity"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "start"), Arrays.asList("[residence]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "stop"), Arrays.asList("[residence]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "kick"), Arrays.asList("[playername]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "immunity"), Arrays.asList("add%%take%%set%%clear", "[residence]"));
    }

    static enum States {
        start,
        stop,
        immunity,
        kick;


        public static States getState(String string) {
            States[] statesArray = States.values();
            int n = statesArray.length;
            int n2 = 0;
            while (n2 < n) {
                States states = statesArray[n2];
                if (states.toString().equalsIgnoreCase(string)) {
                    return states;
                }
                ++n2;
            }
            return null;
        }
    }
}

