/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class market
implements cmd {
    Residence plugin;

    @Override
    @CommandAnnotation(simple=true, priority=2600)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        this.plugin = residence;
        if (!(commandSender instanceof Player)) {
            return false;
        }
        if (stringArray.length == 0) {
            return false;
        }
        Player player = (Player)commandSender;
        int n = 1;
        try {
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[stringArray.length - 1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (stringArray[0].toLowerCase()) {
            case "list": {
                return this.commandResMarketList(stringArray, player, n);
            }
            case "autopay": {
                return this.commandResMarketAutoPay(stringArray, bl, player);
            }
            case "payrent": {
                return this.commandResMarketPayRent(stringArray, bl, player);
            }
            case "rentable": {
                return this.commandResMarketRentable(stringArray, bl, player);
            }
            case "rent": {
                return this.commandResMarketRent(stringArray, bl, player);
            }
            case "unrent": 
            case "release": {
                if (stringArray.length != 2 && stringArray.length != 1) {
                    return false;
                }
                ClaimedResidence claimedResidence = null;
                claimedResidence = stringArray.length == 1 ? residence.getResidenceManager().getByLoc(player.getLocation()) : residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                if (claimedResidence.isRented()) {
                    if (bl || residence.isResAdminOn(player) || PermissionManager.ResPerm.market_evict.hasPermission((CommandSender)player)) {
                        residence.UnrentConfirm.put(player.getName(), claimedResidence.getName());
                        residence.msg(commandSender, lm.Rent_EvictConfirm, claimedResidence.getName());
                    } else if (residence.getRentManager().getRentingPlayer(claimedResidence).equalsIgnoreCase(commandSender.getName())) {
                        residence.UnrentConfirm.put(player.getName(), claimedResidence.getName());
                        residence.msg(commandSender, lm.Rent_UnrentConfirm, claimedResidence.getName());
                    } else {
                        residence.getRentManager().printRentInfo(player, claimedResidence);
                    }
                } else {
                    residence.UnrentConfirm.put(player.getName(), claimedResidence.getName());
                    residence.msg(commandSender, lm.Rent_ReleaseConfirm, claimedResidence.getName());
                }
                return true;
            }
            case "confirm": {
                if (!residence.UnrentConfirm.containsKey(player.getName())) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return false;
                }
                String string = residence.UnrentConfirm.remove(player.getName());
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(string);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                if (!claimedResidence.isRented()) {
                    residence.getRentManager().removeFromForRent(player, claimedResidence, bl);
                    ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(player);
                    if (residencePlayer != null && residencePlayer.getMainResidence() == claimedResidence) {
                        residencePlayer.setMainResidence(null);
                    }
                } else {
                    residence.getRentManager().unrent(player, string, bl);
                }
                return true;
            }
            case "sign": {
                if (stringArray.length != 2) {
                    return false;
                }
                Block block = Utils.getTargetBlock(player, 10);
                if (!(block.getState() instanceof Sign)) {
                    residence.msg((CommandSender)player, lm.Sign_LookAt, new Object[0]);
                    return true;
                }
                Sign sign = (Sign)block.getState();
                Signs signs = new Signs();
                Signs signs2 = residence.getSignUtil().getSignFromLoc(sign.getLocation());
                if (signs2 != null) {
                    signs = signs2;
                }
                Location location = sign.getLocation();
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByLoc(sign.getLocation());
                if (claimedResidence != null && !claimedResidence.isOwner(player) && !bl) {
                    residence.msg((CommandSender)player, lm.Residence_NotOwner, new Object[0]);
                    return true;
                }
                ClaimedResidence claimedResidence2 = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence2 == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                boolean bl2 = claimedResidence2.isForSell();
                boolean bl3 = claimedResidence2.isForRent();
                if (!bl2 && !bl3) {
                    residence.msg((CommandSender)player, lm.Residence_NotForRentOrSell, new Object[0]);
                    return true;
                }
                signs.setResidence(claimedResidence2);
                signs.setLocation(location);
                residence.getSignUtil().getSigns().addSign(signs);
                residence.getSignUtil().saveSigns();
                residence.getSignUtil().CheckSign(claimedResidence2, 5);
                return true;
            }
            case "info": {
                ClaimedResidence claimedResidence = null;
                if (stringArray.length == 1) {
                    claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                } else if (stringArray.length == 2) {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                }
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                boolean bl4 = residence.getTransactionManager().viewSaleInfo(claimedResidence, player);
                if (residence.getConfigManager().enabledRentSystem() && claimedResidence.isForRent()) {
                    residence.getRentManager().printRentInfo(player, claimedResidence);
                } else if (!bl4) {
                    residence.msg(commandSender, lm.Residence_NotForRentOrSell, new Object[0]);
                }
                return true;
            }
            case "buy": {
                ClaimedResidence claimedResidence = null;
                if (stringArray.length == 1) {
                    claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                } else if (stringArray.length == 2) {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                }
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return true;
                }
                boolean bl5 = residence.getTransactionManager().viewSaleInfo(claimedResidence, player);
                if (bl5) {
                    residence.getTransactionManager().buyPlot(claimedResidence, player, bl);
                } else {
                    residence.msg(commandSender, lm.Residence_NotForRentOrSell, new Object[0]);
                }
                return true;
            }
            case "unsell": {
                if (stringArray.length != 2) {
                    return false;
                }
                residence.getTransactionManager().removeFromSale(player, stringArray[1], bl);
                return true;
            }
            case "sell": {
                int n2;
                if (stringArray.length != 3) {
                    return false;
                }
                try {
                    n2 = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                    return true;
                }
                residence.getTransactionManager().putForSale(stringArray[1], player, n2, bl);
                return true;
            }
        }
        return false;
    }

    private boolean commandResMarketRent(String[] stringArray, boolean bl, Player player) {
        if (stringArray.length < 1 || stringArray.length > 3) {
            return false;
        }
        boolean bl2 = this.plugin.getConfigManager().isRentPlayerAutoPay();
        ClaimedResidence claimedResidence = null;
        if (stringArray.length == 3) {
            if (stringArray[2].equalsIgnoreCase("t") || stringArray[2].equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (stringArray[2].equalsIgnoreCase("f") || stringArray[2].equalsIgnoreCase("false")) {
                bl2 = false;
            } else {
                this.plugin.msg((CommandSender)player, lm.Invalid_Boolean, new Object[0]);
                return true;
            }
        }
        if (stringArray.length == 1) {
            claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation());
        } else if (stringArray.length > 1) {
            claimedResidence = this.plugin.getResidenceManager().getByName(stringArray[1]);
        }
        if (claimedResidence != null) {
            this.plugin.getRentManager().rent(player, claimedResidence, bl2, bl);
        } else {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
        }
        return true;
    }

    private boolean commandResMarketPayRent(String[] stringArray, boolean bl, Player player) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            return false;
        }
        ClaimedResidence claimedResidence = null;
        claimedResidence = stringArray.length == 1 ? this.plugin.getResidenceManager().getByLoc(player.getLocation()) : this.plugin.getResidenceManager().getByName(stringArray[1]);
        if (claimedResidence != null) {
            this.plugin.getRentManager().payRent(player, claimedResidence, bl);
        } else {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
        }
        return true;
    }

    private boolean commandResMarketRentable(String[] stringArray, boolean bl, Player player) {
        int n;
        int n2;
        if (stringArray.length < 4 || stringArray.length > 7) {
            return false;
        }
        if (!this.plugin.getConfigManager().enabledRentSystem()) {
            this.plugin.msg((CommandSender)player, lm.Rent_Disabled, new Object[0]);
            return true;
        }
        try {
            n2 = Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Cost, new Object[0]);
            return true;
        }
        try {
            n = Integer.parseInt(stringArray[3]);
        }
        catch (Exception exception) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Days, new Object[0]);
            return true;
        }
        boolean bl2 = this.plugin.getConfigManager().isRentAllowRenewing();
        if (stringArray.length >= 5) {
            String string = stringArray[4];
            if (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string.equalsIgnoreCase("f") || string.equalsIgnoreCase("false")) {
                bl2 = false;
            } else {
                this.plugin.msg((CommandSender)player, lm.Invalid_Boolean, new Object[0]);
                return true;
            }
        }
        boolean bl3 = this.plugin.getConfigManager().isRentStayInMarket();
        if (stringArray.length >= 6) {
            String string = stringArray[5];
            if (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true")) {
                bl3 = true;
            } else if (string.equalsIgnoreCase("f") || string.equalsIgnoreCase("false")) {
                bl3 = false;
            } else {
                this.plugin.msg((CommandSender)player, lm.Invalid_Boolean, new Object[0]);
                return true;
            }
        }
        boolean bl4 = this.plugin.getConfigManager().isRentAllowAutoPay();
        if (stringArray.length >= 7) {
            String string = stringArray[6];
            if (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true")) {
                bl4 = true;
            } else if (string.equalsIgnoreCase("f") || string.equalsIgnoreCase("false")) {
                bl4 = false;
            } else {
                this.plugin.msg((CommandSender)player, lm.Invalid_Boolean, new Object[0]);
                return true;
            }
        }
        this.plugin.getRentManager().setForRent(player, stringArray[1], n2, n, bl2, bl3, bl4, bl);
        return true;
    }

    private boolean commandResMarketAutoPay(String[] stringArray, boolean bl, Player player) {
        boolean bl2;
        if (!this.plugin.getConfigManager().enableEconomy()) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return true;
        }
        if (stringArray.length != 2 && stringArray.length != 3) {
            return false;
        }
        String string = "";
        ClaimedResidence claimedResidence = null;
        if (stringArray.length == 2) {
            string = stringArray[1];
            claimedResidence = this.plugin.getResidenceManager().getByLoc(player.getLocation());
        } else {
            string = stringArray[2];
            claimedResidence = this.plugin.getResidenceManager().getByName(stringArray[1]);
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t")) {
            bl2 = true;
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f")) {
            bl2 = false;
        } else {
            this.plugin.msg((CommandSender)player, lm.Invalid_Boolean, new Object[0]);
            return true;
        }
        if (claimedResidence == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return true;
        }
        if (claimedResidence.isRented() && claimedResidence.getRentedLand().player.equalsIgnoreCase(player.getName())) {
            this.plugin.getRentManager().setRentedRepeatable(player, claimedResidence.getName(), bl2, bl);
        } else if (claimedResidence.isForRent()) {
            this.plugin.getRentManager().setRentRepeatable(player, claimedResidence.getName(), bl2, bl);
        } else {
            this.plugin.msg((CommandSender)player, lm.Economy_RentReleaseInvalid, ChatColor.YELLOW + claimedResidence.getName() + ChatColor.RED);
        }
        return true;
    }

    private boolean commandResMarketList(String[] stringArray, Player player, int n) {
        if (!this.plugin.getConfigManager().enableEconomy()) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return true;
        }
        this.plugin.msg((CommandSender)player, lm.General_MarketList, new Object[0]);
        if (stringArray.length < 2) {
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("sell")) {
            this.plugin.getTransactionManager().printForSaleResidences(player, n);
            return true;
        }
        if (stringArray[1].equalsIgnoreCase("rent")) {
            if (this.plugin.getConfigManager().enabledRentSystem()) {
                this.plugin.getRentManager().printRentableResidences(player, n);
            }
            return true;
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Buy, Sell, or Rent Residences");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res market ? for more Info"));
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("Info.Description", "Get economy Info on residence");
        configReader.get("Info.Info", Arrays.asList("&eUsage: &6/res market Info [residence]", "Shows if the Residence is for sale or for rent, and the cost."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "Info"), Arrays.asList("[residence]"));
        configReader.get("list.Description", "Lists rentable and for sale residences.");
        configReader.get("list.Info", Arrays.asList("&eUsage: &6/res market list [rent/sell]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "list"), Arrays.asList("rent%%sell"));
        configReader.get("list.SubCommands.rent.Description", "Lists rentable residences.");
        configReader.get("list.SubCommands.rent.Info", Arrays.asList("&eUsage: &6/res market list rent"));
        configReader.get("list.SubCommands.sell.Description", "Lists for sale residences.");
        configReader.get("list.SubCommands.sell.Info", Arrays.asList("&eUsage: &6/res market list sell"));
        configReader.get("sell.Description", "Sell a residence");
        configReader.get("sell.Info", Arrays.asList("&eUsage: &6/res market sell [residence] [amount]", "Puts a residence for sale for [amount] of money.", "Another player can buy the residence with /res market buy"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "sell"), Arrays.asList("[residence]"));
        configReader.get("sign.Description", "Set market sign");
        configReader.get("sign.Info", Arrays.asList("&eUsage: &6/res market sign [residence]", "Sets market sign you are looking at."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "sign"), Arrays.asList("[residence]"));
        configReader.get("buy.Description", "Buy a residence");
        configReader.get("buy.Info", Arrays.asList("&eUsage: &6/res market buy [residence]", "Buys a Residence if its for sale."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "buy"), Arrays.asList("[residence]"));
        configReader.get("unsell.Description", "Stops selling a residence");
        configReader.get("unsell.Info", Arrays.asList("&eUsage: &6/res market unsell [residence]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "unsell"), Arrays.asList("[residence]"));
        configReader.get("rent.Description", "ent a residence");
        configReader.get("rent.Info", Arrays.asList("&eUsage: &6/res market rent [residence] <AutoPay>", "Rents a residence.  Autorenew can be either true or false.  If true, the residence will be automatically re-rented upon expire if the residence owner has allowed it."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "rent"), Arrays.asList("[cresidence]", "true%%false"));
        configReader.get("rentable.Description", "Make a residence rentable.");
        configReader.get("rentable.Info", Arrays.asList("&eUsage: &6/res market rentable [residence] [cost] [days] <AllowRenewing> <StayInMarket> <AllowAutoPay>", "Makes a residence rentable for [cost] money for every [days] number of days.", "If <AllowRenewing> is true, the residence will be able to be rented again before rent expires.", "If <StayInMarket> is true, the residence will stay in market after last renter will be removed.", "If <AllowAutoPay> is true, money for rent will be automaticaly taken from players balance if he chosen that option when renting"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "rentable"), Arrays.asList("[residence]", "1000", "7", "true", "true", "true"));
        configReader.get("autopay.Description", "Sets residence AutoPay to given value");
        configReader.get("autopay.Info", Arrays.asList("&eUsage: &6/res market autopay <residence> [true/false]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "autopay"), Arrays.asList("[residence]%%true%%false", "true%%false"));
        configReader.get("payrent.Description", "Pays rent for defined residence");
        configReader.get("payrent.Info", Arrays.asList("&eUsage: &6/res market payrent <residence>"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "payrent"), Arrays.asList("[residence]"));
        configReader.get("confirm.Description", "Confirms residence unrent/release action");
        configReader.get("confirm.Info", Arrays.asList("&eUsage: &6/res market confirm"));
        configReader.get("unrent.Description", "Remove a residence from rent or rentable.");
        configReader.get("unrent.Info", Arrays.asList("&eUsage: &6/res market unrent [residence]", "If you are the renter, this command releases the rent on the house for you.", "If you are the owner, this command makes the residence not for rent anymore."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "release"), Arrays.asList("[residence]"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "unrent"), Arrays.asList("[residence]"));
    }
}

