/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class lease
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=3900)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        Player player = (Player)commandSender;
        if (stringArray.length == 1 || stringArray.length == 2 || stringArray.length == 3) {
            if (stringArray[0].equals("set")) {
                int n;
                if (!bl) {
                    residence.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (stringArray[2].equals("infinite")) {
                    if (residence.getLeaseManager().isLeased(residence.getResidenceManager().getByName(stringArray[1]))) {
                        residence.getLeaseManager().removeExpireTime(residence.getResidenceManager().getByName(stringArray[1]));
                        residence.msg((CommandSender)player, lm.Economy_LeaseInfinite, new Object[0]);
                    } else {
                        residence.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                    }
                    return true;
                }
                try {
                    n = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    residence.msg((CommandSender)player, lm.Invalid_Days, new Object[0]);
                    return true;
                }
                residence.getLeaseManager().setExpireTime(player, residence.getResidenceManager().getByName(stringArray[1]), n);
                return true;
            }
            if (stringArray[0].equals("expires")) {
                String string;
                ClaimedResidence claimedResidence = null;
                if (stringArray.length == 1) {
                    claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                    if (claimedResidence == null) {
                        residence.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                        return true;
                    }
                } else {
                    claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                    if (claimedResidence == null) {
                        residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                        return true;
                    }
                }
                if ((string = residence.getLeaseManager().getExpireTime(claimedResidence)) != null) {
                    residence.msg((CommandSender)player, lm.Economy_LeaseRenew, string);
                }
                return true;
            }
            if (stringArray[0].equals("renew")) {
                if (stringArray.length == 2) {
                    residence.getLeaseManager().renewArea(residence.getResidenceManager().getByName(stringArray[1]), player);
                } else {
                    ClaimedResidence claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                    if (claimedResidence != null) {
                        residence.getLeaseManager().renewArea(claimedResidence, player);
                    } else {
                        return false;
                    }
                }
                return true;
            }
            if (stringArray[0].equals("list")) {
                ClaimedResidence claimedResidence = null;
                int n = -1;
                if (stringArray.length > 1) {
                    try {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    catch (Exception exception) {
                        claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                    }
                }
                if (stringArray.length > 2 && n == -1) {
                    try {
                        n = Integer.parseInt(stringArray[2]);
                    }
                    catch (Exception exception) {
                        claimedResidence = residence.getResidenceManager().getByName(stringArray[2]);
                    }
                }
                if (claimedResidence == null) {
                    claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                }
                if (claimedResidence == null) {
                    return false;
                }
                ArrayList<ClaimedResidence> arrayList = new ArrayList<ClaimedResidence>();
                if (residence.getLeaseManager().isLeased(claimedResidence)) {
                    arrayList.add(claimedResidence);
                }
                for (ClaimedResidence object2 : claimedResidence.getSubzones()) {
                    if (!residence.getLeaseManager().isLeased(object2)) continue;
                    arrayList.add(object2);
                }
                PageInfo pageInfo = new PageInfo(3, arrayList.size(), n);
                residence.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                for (Object object3 : arrayList) {
                    if (!pageInfo.isEntryOk()) continue;
                    if (pageInfo.isBreak()) break;
                    if (claimedResidence.isOwner(player)) {
                        residence.msg((CommandSender)player, lm.Economy_LeaseList, pageInfo.getPositionForOutput(), ((ClaimedResidence)object3).getName(), residence.getLeaseManager().getExpireTime((ClaimedResidence)object3), ((ClaimedResidence)object3).getOwner());
                        continue;
                    }
                    residence.msg((CommandSender)player, lm.Economy_LeaseList, pageInfo.getPositionForOutput(), ((ClaimedResidence)object3).getName(), "", "");
                }
                residence.getInfoPageManager().ShowPagination(commandSender, pageInfo, "res lease list " + claimedResidence.getName());
                return true;
            }
            if (stringArray[0].equals("cost")) {
                if (stringArray.length == 2) {
                    ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                    if (claimedResidence == null || residence.getLeaseManager().isLeased(claimedResidence)) {
                        double d = residence.getLeaseManager().getRenewCostD(claimedResidence);
                        residence.msg((CommandSender)player, lm.Economy_LeaseRenewalCost, stringArray[1], residence.getEconomyManager().format(d));
                    } else {
                        residence.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                    }
                    return true;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByLoc(player.getLocation());
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
                    return true;
                }
                String string = claimedResidence.getName();
                if (residence.getLeaseManager().isLeased(claimedResidence)) {
                    double d = residence.getLeaseManager().getRenewCostD(claimedResidence);
                    residence.msg((CommandSender)player, lm.Economy_LeaseRenewalCost, string, residence.getEconomyManager().format(d));
                } else {
                    residence.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Manage residence leases");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res lease [renew/cost] [residence]", "/res lease cost will show the cost of renewing a residence lease.", "/res lease renew will renew the residence provided you have enough money."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("renew%%cost", "[residence]"));
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("set.Description", "Set the lease time");
        configReader.get("set.Info", Arrays.asList("&eUsage: &6/resadmin lease set [residence] [#days/infinite]", "Sets the lease time to a specified number of days, or infinite."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "set"), Arrays.asList("[residence]"));
        configReader.get("renew.Description", "Renew the lease time");
        configReader.get("renew.Info", Arrays.asList("&eUsage: &6/resadmin lease renew <residence>", "Renews the lease time for current or specified residence."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "renew"), Arrays.asList("[residence]"));
        configReader.get("list.Description", "Show lease list of current residence");
        configReader.get("list.Info", Arrays.asList("&eUsage: &6/resadmin lease list <residence> <page>", "Prints out all subzones lease times"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "list"), Arrays.asList("[residence]"));
        configReader.get("expires.Description", "Lease end date");
        configReader.get("expires.Info", Arrays.asList("&eUsage: &6/resadmin lease expires <residence>", "Shows when expires residence lease time."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "expires"), Arrays.asList("[residence]"));
        configReader.get("cost.Description", "Shows renew cost");
        configReader.get("cost.Info", Arrays.asList("&eUsage: &6/resadmin lease cost <residence>", "Shows how much money you need to renew residence lease."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName(), "cost"), Arrays.asList("[residence]"));
    }
}

