/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class kick
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=2200)
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        Player player = (Player)commandSender;
        if (stringArray.length != 1) {
            return false;
        }
        Player player2 = Bukkit.getPlayer((String)stringArray[0]);
        if (player2 == null || !player.canSee(player2)) {
            residence.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
            return true;
        }
        ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(player);
        PermissionGroup permissionGroup = residencePlayer.getGroup();
        if (!permissionGroup.hasKickAccess() && !bl) {
            residence.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return true;
        }
        ClaimedResidence claimedResidence = residence.getResidenceManager().getByLoc(player2.getLocation());
        if (claimedResidence == null || !claimedResidence.isOwner(player) && !bl) {
            residence.msg((CommandSender)player, lm.Residence_PlayerNotIn, new Object[0]);
            return true;
        }
        if (!claimedResidence.isOwner(player)) {
            return false;
        }
        if (claimedResidence.isRaidInitialized()) {
            residence.msg(commandSender, lm.Raid_cantDo, new Object[0]);
            return true;
        }
        if (claimedResidence.getPlayersInResidence().contains(player2)) {
            if (PermissionManager.ResPerm.command_kick_bypass.hasPermission((CommandSender)player2)) {
                residence.msg(commandSender, lm.Residence_CantKick, new Object[0]);
                return true;
            }
            Location location = residence.getConfigManager().getKickLocation();
            player2.closeInventory();
            if (location != null) {
                player2.teleport(location);
            } else {
                player2.teleport(claimedResidence.getOutsideFreeLoc(player.getLocation(), player));
            }
            residence.msg((CommandSender)player2, lm.Residence_Kicked, new Object[0]);
        }
        return true;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.get("Description", "Kicks player from residence.");
        configReader.get("Info", Arrays.asList("&eUsage: &6/res kick <player>", "You must be the owner or an admin to do this.", "Player should be online."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[playername]"));
    }
}

