/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.utils.Utils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class attack
implements cmd {
    @Override
    @CommandAnnotation(info="Start raid on residence", usage={"&eUsage: &6/res attack [resName]"}, simple=true, priority=3100, regVar={0, 1}, consoleVar={666})
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        Player player = (Player)commandSender;
        if (!ConfigManager.RaidEnabled) {
            residence.msg((CommandSender)player, lm.Raid_NotEnabled, new Object[0]);
            return null;
        }
        ClaimedResidence claimedResidence = null;
        claimedResidence = stringArray.length == 1 ? residence.getResidenceManager().getByName(stringArray[0]) : residence.getResidenceManager().getByLoc(player.getLocation());
        if (claimedResidence == null) {
            residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return null;
        }
        if (!claimedResidence.isTopArea()) {
            residence.msg((CommandSender)player, lm.Raid_attack_noSubzones, new Object[0]);
            return null;
        }
        if (claimedResidence.isOwner(player)) {
            residence.msg((CommandSender)player, lm.Raid_attack_noSelf, new Object[0]);
            return null;
        }
        ResidencePlayer residencePlayer = residence.getPlayerManager().getResidencePlayer(player);
        if (residencePlayer.getJoinedRaid() != null) {
            residence.msg((CommandSender)player, lm.Raid_defend_alreadyInAnother, residencePlayer.getJoinedRaid().getRes().getName());
            return null;
        }
        ResidencePlayer residencePlayer2 = residence.getPlayerManager().getResidencePlayer(claimedResidence.getOwnerUUID());
        if (!residencePlayer2.isOnline()) {
            residence.msg((CommandSender)player, lm.Raid_attack_isOffline, new Object[0]);
            return null;
        }
        if (!residencePlayer2.isOnline()) {
            residence.msg((CommandSender)player, lm.Raid_attack_isOffline, new Object[0]);
            return null;
        }
        if (claimedResidence.getRaid().isPlayerImmune()) {
            residence.msg((CommandSender)player, lm.Raid_attack_playerImmune, Utils.to24hourShort(claimedResidence.getRaid().getPlayerImmunityUntil() - System.currentTimeMillis() + 1000L));
            return null;
        }
        if (claimedResidence.isUnderRaidCooldown() && !claimedResidence.isInPreRaid() && !claimedResidence.isUnderRaid()) {
            residence.msg((CommandSender)player, lm.Raid_attack_cooldown, Utils.to24hourShort(claimedResidence.getRaid().getCooldownEnd() - System.currentTimeMillis() + 1000L));
            return null;
        }
        if (claimedResidence.isUnderRaid() || claimedResidence.isInPreRaid()) {
            if (!claimedResidence.getRaid().isAttacker(player)) {
                claimedResidence.getRaid().addAttacker(player);
            }
            residence.msg((CommandSender)player, lm.Raid_attack_Joined, claimedResidence.getName());
            return null;
        }
        boolean bl2 = claimedResidence.preStartRaid(player);
        if (bl2) {
            claimedResidence.startRaid();
            return true;
        }
        residence.msg(player, "Cant start raid");
        return false;
    }

    @Override
    public void getLocale() {
        LocaleManager.addTabComplete(this, null, "[cresidence]");
    }
}

