/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class area
implements cmd {
    @Override
    @CommandAnnotation(info="Manage physical areas for a residence.", priority=3300, regVar={2, 3}, consoleVar={666})
    public Boolean perform(Residence residence, CommandSender commandSender, String[] stringArray, boolean bl) {
        Player player = (Player)commandSender;
        int n = 1;
        try {
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[stringArray.length - 1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (stringArray[0].toLowerCase()) {
            case "remove": {
                if (stringArray.length != 3) {
                    return false;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                claimedResidence.removeArea(player, stringArray[2], bl);
                return true;
            }
            case "add": {
                if (stringArray.length != 3) {
                    return false;
                }
                if (residence.getWorldEdit() != null && residence.getWorldEditTool().equals((Object)residence.getConfigManager().getSelectionTool())) {
                    residence.getSelectionManager().worldEdit(player);
                }
                if (!residence.getSelectionManager().hasPlacedBoth(player)) {
                    residence.msg((CommandSender)player, lm.Select_Points, new Object[0]);
                    return null;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                if (claimedResidence.addArea(player, residence.getSelectionManager().getSelectionCuboid(player), stringArray[2], bl)) {
                    residence.msg((CommandSender)player, lm.Area_Create, stringArray[2]);
                }
                return true;
            }
            case "replace": {
                if (stringArray.length != 3) {
                    return false;
                }
                if (residence.getWorldEdit() != null && residence.getWorldEditTool().equals((Object)residence.getConfigManager().getSelectionTool())) {
                    residence.getSelectionManager().worldEdit(player);
                }
                if (!residence.getSelectionManager().hasPlacedBoth(player)) {
                    residence.msg((CommandSender)player, lm.Select_Points, new Object[0]);
                    return null;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                claimedResidence.replaceArea(player, residence.getSelectionManager().getSelectionCuboid(player), stringArray[2], bl);
                return true;
            }
            case "list": {
                if (stringArray.length != 2) {
                    return false;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                claimedResidence.printAreaList(player, n);
                return true;
            }
            case "listall": {
                if (stringArray.length != 2) {
                    return false;
                }
                ClaimedResidence claimedResidence = residence.getResidenceManager().getByName(stringArray[1]);
                if (claimedResidence == null) {
                    residence.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                    return null;
                }
                claimedResidence.printAdvancedAreaList(player, n);
                return true;
            }
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader configReader = Residence.getInstance().getLocaleManager().getLocaleConfig();
        configReader.setP(String.valueOf(configReader.getPath()) + "SubCommands.");
        configReader.get("list.Description", "List physical areas in a residence");
        configReader.get("list.Info", Arrays.asList("&eUsage: &6/res area list [residence] <page>"));
        LocaleManager.addTabComplete(this, "list", "[residence]");
        configReader.get("listall.Description", "List coordinates and other Info for areas");
        configReader.get("listall.Info", Arrays.asList("&eUsage: &6/res area listall [residence] <page>"));
        LocaleManager.addTabComplete(this, "listall", "[residence]");
        configReader.get("add.Description", "Add physical areas to a residence");
        configReader.get("add.Info", Arrays.asList("&eUsage: &6/res area add [residence] [areaID]", "You must first select two points first."));
        LocaleManager.addTabComplete(this, "add", "[residence]");
        configReader.get("remove.Description", "Remove physical areas from a residence");
        configReader.get("remove.Info", Arrays.asList("&eUsage: &6/res area remove [residence] [areaID]"));
        LocaleManager.addTabComplete(this, "remove", "[residence]");
        configReader.get("replace.Description", "Replace physical areas in a residence");
        configReader.get("replace.Info", Arrays.asList("&eUsage: &6/res area replace [residence] [areaID]", "You must first select two points first.", "Replacing a area will charge the difference in size if the new area is bigger."));
        LocaleManager.addTabComplete(this, "replace", "[residence]");
    }
}

