/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.chat;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ChatInterface;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Server;

public class ChatManager
implements ChatInterface {
    protected Map<String, ChatChannel> channelmap;
    protected Server server = Residence.getInstance().getServ();

    public ChatManager() {
        this.channelmap = new HashMap<String, ChatChannel>();
    }

    @Override
    public boolean setChannel(String string, String string2) {
        ClaimedResidence claimedResidence = Residence.getInstance().getResidenceManager().getByName(string2);
        if (claimedResidence == null) {
            return false;
        }
        return this.setChannel(string, claimedResidence);
    }

    @Override
    public boolean setChannel(String string, ClaimedResidence claimedResidence) {
        this.removeFromChannel(string);
        if (!this.channelmap.containsKey(claimedResidence.getName())) {
            this.channelmap.put(claimedResidence.getName(), new ChatChannel(claimedResidence.getName(), claimedResidence.getChatPrefix(), claimedResidence.getChannelColor()));
        }
        this.channelmap.get(claimedResidence.getName()).join(string);
        return true;
    }

    @Override
    public boolean removeFromChannel(String string) {
        for (ChatChannel chatChannel : this.channelmap.values()) {
            if (!chatChannel.hasMember(string)) continue;
            chatChannel.leave(string);
            return true;
        }
        return false;
    }

    @Override
    public ChatChannel getChannel(String string) {
        return this.channelmap.get(string);
    }

    @Override
    public ChatChannel getPlayerChannel(String string) {
        for (ChatChannel chatChannel : this.channelmap.values()) {
            if (!chatChannel.hasMember(string)) continue;
            return chatChannel;
        }
        return null;
    }
}

