/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.allNms;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class v1_8Events
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractAtArmoStand(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Player player = playerInteractAtEntityEvent.getPlayer();
        if (Residence.getInstance().isResAdminOn(player)) {
            return;
        }
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        if (!Residence.getInstance().getNms().isArmorStandEntity(entity.getType())) {
            return;
        }
        FlagPermissions flagPermissions = Residence.getInstance().getPermsByLocForPlayer(entity.getLocation(), player);
        if (!flagPermissions.playerHas(player, Flags.container, flagPermissions.playerHas(player, Flags.use, true))) {
            playerInteractAtEntityEvent.setCancelled(true);
            Residence.getInstance().msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockExplodeEvent(BlockExplodeEvent blockExplodeEvent) {
        Location location = blockExplodeEvent.getBlock().getLocation();
        if (Residence.getInstance().isDisabledWorldListener(location.getWorld())) {
            return;
        }
        if (blockExplodeEvent.isCancelled()) {
            return;
        }
        FlagPermissions flagPermissions = Residence.getInstance().getWorldFlags().getPerms(location.getWorld().getName());
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (Block block : blockExplodeEvent.blockList()) {
            FlagPermissions flagPermissions2 = Residence.getInstance().getPermsByLoc(block.getLocation());
            if (flagPermissions2.has(Flags.explode, flagPermissions.has(Flags.explode, true))) continue;
            arrayList.add(block);
        }
        for (Block block : arrayList) {
            blockExplodeEvent.blockList().remove(block);
        }
    }
}

