/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.allNms;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;

public class v1_13Events
implements Listener {
    Residence plugin;

    public v1_13Events(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryFade(BlockFadeEvent blockFadeEvent) {
        if (Version.isCurrentLower(Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(blockFadeEvent.getBlock().getWorld())) {
            return;
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(blockFadeEvent.getBlock());
        if (!cMIMaterial.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockFadeEvent.getNewState().getLocation());
        if (flagPermissions.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) {
            Block block = blockFadeEvent.getBlock();
            try {
                BlockData blockData = block.getBlockData();
                Farmland farmland = (Farmland)blockData;
                farmland.setMoisture(7);
                block.setBlockData((BlockData)farmland);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            blockFadeEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent blockPhysicsEvent) {
        block8: {
            if (Version.isCurrentLower(Version.v1_13_R1)) {
                return;
            }
            if (!Flags.dryup.isGlobalyEnabled()) {
                return;
            }
            if (this.plugin.isDisabledWorldListener(blockPhysicsEvent.getBlock().getWorld())) {
                return;
            }
            try {
                if (!blockPhysicsEvent.getChangedType().toString().equalsIgnoreCase("FARMLAND")) {
                    return;
                }
                FlagPermissions flagPermissions = this.plugin.getPermsByLoc(blockPhysicsEvent.getBlock().getLocation());
                if (!flagPermissions.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) break block8;
                Block block = blockPhysicsEvent.getBlock();
                try {
                    BlockData blockData = block.getBlockData();
                    Farmland farmland = (Farmland)blockData;
                    farmland.setMoisture(7);
                    block.setBlockData((BlockData)farmland);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                blockPhysicsEvent.setCancelled(true);
                return;
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
    }
}

