/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.Placeholders;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Placeholder {
    private Residence plugin;
    Pattern placeholderPatern = Pattern.compile("(%)([^\"^%]*)(%)");

    public Placeholder(Residence residence) {
        this.plugin = residence;
    }

    public List<String> updatePlaceHolders(Player player, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            arrayList.set(n, this.updatePlaceHolders(player, list2.get(n)));
            ++n;
        }
        return arrayList;
    }

    public String updatePlaceHolders(Player player, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("%")) {
            string = this.translateOwnPlaceHolder(player, string);
        }
        if (!this.plugin.isPlaceholderAPIEnabled()) {
            return string;
        }
        if (string.contains("%")) {
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        return string;
    }

    private String translateOwnPlaceHolder(Player player, String string) {
        if (string == null) {
            return null;
        }
        if (string.contains("%")) {
            Matcher matcher = this.placeholderPatern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(2);
                if (!string.contains("%")) break;
                CMIPlaceHolders cMIPlaceHolders = CMIPlaceHolders.getByNameExact(string2);
                String string3 = this.getValue(player, cMIPlaceHolders);
                if (string3 == null) continue;
                string = string.replace(cMIPlaceHolders.getFull(), string3);
            }
        }
        return string;
    }

    public String getValue(Player player, CMIPlaceHolders cMIPlaceHolders) {
        ResidencePlayer residencePlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (cMIPlaceHolders == null) {
            return null;
        }
        if (residencePlayer != null) {
            PermissionGroup permissionGroup = residencePlayer.getGroup();
            switch (cMIPlaceHolders) {
                case residence_user_admin: {
                    return this.variable(Residence.getInstance().getPermissionManager().isResidenceAdmin((CommandSender)player));
                }
                case residence_user_amount: {
                    return String.valueOf(residencePlayer.getResAmount());
                }
                case residence_user_blockcost: {
                    if (Residence.getInstance().getEconomyManager() == null) break;
                    return String.valueOf(permissionGroup.getCostperarea());
                }
                case residence_user_blocksell: {
                    if (Residence.getInstance().getEconomyManager() == null) break;
                    return String.valueOf(permissionGroup.getSellperarea());
                }
                case residence_user_cancreate: {
                    return this.variable(permissionGroup.canCreateResidences());
                }
                case residence_user_group: {
                    return permissionGroup.getGroupName();
                }
                case residence_user_maxew: {
                    return String.valueOf(permissionGroup.getXmin()) + "-" + permissionGroup.getXmax();
                }
                case residence_user_maxns: {
                    return String.valueOf(permissionGroup.getZmin()) + "-" + permissionGroup.getZmax();
                }
                case residence_user_maxrentdays: {
                    return String.valueOf(permissionGroup.getMaxRentDays());
                }
                case residence_user_maxrents: {
                    return String.valueOf(residencePlayer.getMaxRents());
                }
                case residence_user_maxres: {
                    return String.valueOf(residencePlayer.getMaxRes());
                }
                case residence_user_maxsub: {
                    return String.valueOf(residencePlayer.getMaxSubzones());
                }
                case residence_user_maxsubdepth: {
                    return String.valueOf(residencePlayer.getMaxSubzoneDepth());
                }
                case residence_user_maxud: {
                    return String.valueOf(permissionGroup.getYmin()) + "-" + permissionGroup.getYmax();
                }
                case residence_user_current_owner: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "" : claimedResidence.getOwner();
                }
                case residence_user_current_res: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "" : claimedResidence.getName();
                }
                case residence_user_current_bank: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "0" : claimedResidence.getBank().getStoredMoneyFormated();
                }
                case residence_user_current_qsize: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "0" : String.valueOf(claimedResidence.getTotalSize());
                }
                case residence_user_current_ssize: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "0" : String.valueOf(claimedResidence.getXZSize());
                }
                case residence_user_current_forsale: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "" : String.valueOf(claimedResidence.isForSell());
                }
                case residence_user_current_saleprice: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null || !claimedResidence.isForSell() ? "" : String.valueOf(claimedResidence.getSellPrice());
                }
                case residence_user_current_rentprice: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null || !claimedResidence.isForRent() ? "" : String.valueOf(claimedResidence.getRentable().cost);
                }
                case residence_user_current_rentdays: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null || !claimedResidence.isForRent() ? "" : String.valueOf(claimedResidence.getRentable().days);
                }
                case residence_user_current_rentedby: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null || !claimedResidence.isForRent() || claimedResidence.getRentedLand() == null || claimedResidence.getRentedLand().player == null ? "" : claimedResidence.getRentedLand().player;
                }
                case residence_user_current_rentends: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null || !claimedResidence.isForRent() || claimedResidence.getRentedLand() == null || claimedResidence.getRentedLand().player == null ? "" : GetTime.getTime(claimedResidence.getRentedLand().endTime, true);
                }
                case residence_user_current_forrent: {
                    ClaimedResidence claimedResidence = this.plugin.getResidenceManager().getByLoc(residencePlayer.getPlayer().getLocation());
                    return claimedResidence == null ? "" : String.valueOf(claimedResidence.isForRent());
                }
            }
        }
        switch (cMIPlaceHolders) {
            // Empty switch
        }
        return null;
    }

    private String variable(Boolean bl) {
        return bl != false ? this.plugin.getLM().getMessage(lm.General_True, new Object[0]) : this.plugin.getLM().getMessage(lm.General_False, new Object[0]);
    }

    public static enum CMIPlaceHolders {
        residence_user_amount,
        residence_user_group,
        residence_user_admin,
        residence_user_cancreate,
        residence_user_maxres,
        residence_user_maxew,
        residence_user_maxns,
        residence_user_maxud,
        residence_user_maxsub,
        residence_user_maxsubdepth,
        residence_user_maxrents,
        residence_user_maxrentdays,
        residence_user_blockcost,
        residence_user_blocksell,
        residence_user_current_owner,
        residence_user_current_res,
        residence_user_current_bank,
        residence_user_current_qsize,
        residence_user_current_ssize,
        residence_user_current_forsale,
        residence_user_current_saleprice,
        residence_user_current_forrent,
        residence_user_current_rentprice,
        residence_user_current_rentedby,
        residence_user_current_rentdays,
        residence_user_current_rentends;


        public static CMIPlaceHolders getByName(String string) {
            String string2;
            CMIPlaceHolders cMIPlaceHolders;
            string = string.replace("_", "");
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n = cMIPlaceHoldersArray.length;
            int n2 = 0;
            while (n2 < n) {
                cMIPlaceHolders = cMIPlaceHoldersArray[n2];
                string2 = cMIPlaceHolders.name().replace("_", "");
                if (string2.equalsIgnoreCase(string)) {
                    return cMIPlaceHolders;
                }
                ++n2;
            }
            string = "residence" + string;
            cMIPlaceHoldersArray = CMIPlaceHolders.values();
            n = cMIPlaceHoldersArray.length;
            n2 = 0;
            while (n2 < n) {
                cMIPlaceHolders = cMIPlaceHoldersArray[n2];
                string2 = cMIPlaceHolders.name().replace("_", "");
                if (string2.equalsIgnoreCase(string)) {
                    return cMIPlaceHolders;
                }
                ++n2;
            }
            return null;
        }

        public static CMIPlaceHolders getByNameExact(String string) {
            string = string.toLowerCase();
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n = cMIPlaceHoldersArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIPlaceHolders cMIPlaceHolders = cMIPlaceHoldersArray[n2];
                String string2 = cMIPlaceHolders.name();
                if (string2.equals(string)) {
                    return cMIPlaceHolders;
                }
                ++n2;
            }
            return null;
        }

        public String getFull() {
            return "%" + this.name() + "%";
        }
    }
}

