/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.BossBar;

import com.bekvon.bukkit.cmiLib.Version;
import com.bekvon.bukkit.residence.BossBar.BossBarInfo;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBarManager {
    Residence plugin;

    public BossBarManager(Residence residence) {
        this.plugin = residence;
    }

    public synchronized void updateBossBars(ResidencePlayer residencePlayer) {
        if (Version.isCurrentLower(Version.v1_9_R1)) {
            return;
        }
        if (residencePlayer == null) {
            return;
        }
        HashMap<String, BossBarInfo> hashMap = new HashMap<String, BossBarInfo>(residencePlayer.getBossBarInfo());
        for (Map.Entry<String, BossBarInfo> entry : hashMap.entrySet()) {
            this.Show(entry.getValue());
        }
    }

    public synchronized void Show(final BossBarInfo bossBarInfo) {
        Double d;
        Object object;
        if (Version.isCurrentLower(Version.v1_9_R1)) {
            return;
        }
        ResidencePlayer residencePlayer = bossBarInfo.getUser();
        if (residencePlayer == null || !residencePlayer.isOnline()) {
            return;
        }
        bossBarInfo.updateCycle();
        BossBar bossBar = bossBarInfo.getBar();
        String string = bossBarInfo.getTitleOfBar();
        boolean bl = true;
        if (bossBar == null) {
            object = bossBarInfo.getColor();
            if (object == null) {
                switch (residencePlayer.getBossBarInfo().size()) {
                    case 1: {
                        object = BarColor.GREEN;
                        break;
                    }
                    case 2: {
                        object = BarColor.RED;
                        break;
                    }
                    case 3: {
                        object = BarColor.WHITE;
                        break;
                    }
                    case 4: {
                        object = BarColor.YELLOW;
                        break;
                    }
                    case 5: {
                        object = BarColor.PINK;
                        break;
                    }
                    case 6: {
                        object = BarColor.PURPLE;
                        break;
                    }
                    default: {
                        object = BarColor.BLUE;
                    }
                }
            }
            bossBar = Bukkit.createBossBar((String)string, (BarColor)object, (BarStyle)(bossBarInfo.getStyle() != null ? bossBarInfo.getStyle() : BarStyle.SEGMENTED_10), (BarFlag[])new BarFlag[0]);
        } else {
            bossBar.setTitle(string);
            if (bossBarInfo.getStyle() != null) {
                bossBar.setStyle(bossBarInfo.getStyle());
            }
            if (bossBarInfo.getColor() != null) {
                bossBar.setColor(bossBarInfo.getColor());
            }
            bl = false;
        }
        object = bossBarInfo.getPercentage();
        if (object == null) {
            object = 1.0;
        }
        if (bossBarInfo.getAdjustPerc() != null) {
            d = bossBarInfo.getPercentage();
            if (d != null && d <= 0.0 && bossBarInfo.getAdjustPerc() < 0.0) {
                bossBarInfo.cancelAutoScheduler();
                return;
            }
            if (d != null && d >= 1.0 && bossBarInfo.getAdjustPerc() > 0.0) {
                bossBarInfo.cancelAutoScheduler();
                return;
            }
            if (d == null) {
                d = bossBarInfo.getAdjustPerc() > 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0);
            }
            d = d + bossBarInfo.getAdjustPerc();
            bossBarInfo.setPercentage(d);
        } else {
            bossBarInfo.setPercentage((Double)object);
        }
        try {
            bossBar.setProgress(bossBarInfo.getPercentage().doubleValue());
            if (bl) {
                d = residencePlayer.getPlayer();
                if (d == null) {
                    return;
                }
                bossBar.addPlayer((Player)d);
                bossBar.setVisible(true);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            noSuchMethodError.printStackTrace();
        }
        bossBarInfo.setBar(bossBar);
        bossBarInfo.cancelHideScheduler();
        bossBarInfo.cancelAutoScheduler();
        if (bossBarInfo.getAuto() != null && bossBarInfo.getAuto() > 0) {
            bossBarInfo.setAutoId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    BossBarManager.this.Show(bossBarInfo);
                }
            }, (long)bossBarInfo.getAuto().intValue()));
        }
        if (bossBarInfo.getKeepFor() > 0) {
            bossBarInfo.setId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    bossBarInfo.getBar().setVisible(false);
                    bossBarInfo.remove();
                }
            }, (long)bossBarInfo.getKeepFor().intValue()));
        }
    }
}

