/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.BossBar;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;

public class BossBarInfo {
    private ResidencePlayer user;
    private Double percentage = null;
    private Double adjustPerc = null;
    private Integer keepFor = 60;
    private Integer auto = null;
    private BossBar bar;
    private BarColor startingColor = null;
    private BarStyle style = null;
    private Integer autoId = null;
    private Integer id = null;
    private String nameOfBar;
    private String titleOfBar = "Title";
    private List<String> cmds = null;

    public BossBarInfo(ResidencePlayer residencePlayer, String string) {
        this.user = residencePlayer;
        this.nameOfBar = string;
    }

    public BossBarInfo(ResidencePlayer residencePlayer, String string, BossBar bossBar) {
        this.user = residencePlayer;
        this.nameOfBar = string;
        this.bar = bossBar;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public void cancelAutoScheduler() {
        if (this.autoId != null) {
            Bukkit.getScheduler().cancelTask(this.autoId.intValue());
            this.autoId = null;
        }
    }

    public void cancelHideScheduler() {
        if (this.id != null) {
            Bukkit.getScheduler().cancelTask(this.id.intValue());
            this.id = null;
        }
    }

    public void remove() {
        this.cancelAutoScheduler();
        this.cancelHideScheduler();
        if (this.bar != null) {
            this.bar.setVisible(false);
        }
        this.user.removeBossBar(this);
    }

    public ResidencePlayer getUser() {
        return this.user;
    }

    public BossBar getBar() {
        return this.bar;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double d, Double d2) {
        d2 = d2 * 100.0 / d / 100.0;
        this.setPercentage(d2);
    }

    public void setPercentage(Double d) {
        if (d != null) {
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
        }
        this.percentage = d;
    }

    public String getNameOfBar() {
        if (this.nameOfBar == null) {
            this.nameOfBar = "CmiBossbar" + new Random().nextInt(100);
        }
        return this.nameOfBar;
    }

    public void setNameOfBar(String string) {
        this.nameOfBar = string;
    }

    public Integer getKeepFor() {
        return this.keepFor;
    }

    public void setKeepForTicks(Integer n) {
        if (n != null) {
            this.keepFor = n;
        }
    }

    public String getTitleOfBar() {
        if (this.titleOfBar != null && this.titleOfBar.contains("[autoTimeLeft]") && this.percentage != null && this.adjustPerc != null && this.auto != null) {
            double d = this.percentage / (this.adjustPerc < 0.0 ? -this.adjustPerc.doubleValue() : this.adjustPerc);
            Long l = (long)(d * (double)(this.auto < 0 ? -this.auto.intValue() : this.auto));
            Long l2 = l * 50L;
            return this.titleOfBar.replace("[autoTimeLeft]", Utils.to24hourShort(l2 + 1000L));
        }
        return this.titleOfBar == null ? "" : this.titleOfBar;
    }

    public void setTitleOfBar(String string) {
        this.titleOfBar = string == null || string.isEmpty() ? null : CMIChatColor.translate(string);
    }

    public void setBar(BossBar bossBar) {
        this.bar = bossBar;
    }

    public BarColor getColor() {
        return this.startingColor;
    }

    public void setColor(BarColor barColor) {
        this.startingColor = barColor;
    }

    public Double getAdjustPerc() {
        return this.adjustPerc;
    }

    public void setAdjustPerc(Double d) {
        this.adjustPerc = d;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public void setStyle(BarStyle barStyle) {
        this.style = barStyle;
    }

    public void setUser(ResidencePlayer residencePlayer) {
        this.user = residencePlayer;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getAuto() {
        return this.auto;
    }

    public void setAuto(Integer n) {
        this.auto = n;
    }

    public Integer getAutoId() {
        return this.autoId;
    }

    public void setAutoId(Integer n) {
        this.autoId = n;
    }

    public void updateCycle() {
    }
}

