/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.cmiLib.RawMessageFragment;
import com.bekvon.bukkit.cmiLib.RawMessageManager;
import com.bekvon.bukkit.cmiLib.RawMessagePartType;
import com.bekvon.bukkit.cmiLib.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RawMessage {
    List<String> parts = new ArrayList<String>();
    List<String> onlyText = new ArrayList<String>();
    LinkedHashMap<RawMessagePartType, String> temp = new LinkedHashMap();
    RawMessageFragment fragment = new RawMessageFragment();
    RawMessageFragment hoverFragment = new RawMessageFragment();
    private RawMessageFragment frozenFragment = new RawMessageFragment();
    private boolean freezeFormat = false;
    private String combined = "";
    String combinedClean = "";
    private boolean dontBreakLine = false;
    private static final String nl = "\u00a5n";

    public void clear() {
        this.parts = new ArrayList<String>();
        this.onlyText = new ArrayList<String>();
        this.combined = "";
        this.combinedClean = "";
    }

    /*
     * WARNING - void declaration
     */
    private String textIntoJson(String string, boolean bl) {
        String[] stringArray;
        if (string.isEmpty()) {
            return "";
        }
        if (string.equalsIgnoreCase(" ")) {
            return " ";
        }
        string = CMIChatColor.deColorize(string);
        Matcher matcher = CMIChatColor.fullPattern.matcher(string);
        String string2 = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RawMessageFragment rawMessageFragment = bl ? this.hoverFragment : this.fragment;
        String string3 = "";
        while (matcher.find()) {
            Object object;
            string2 = matcher.group();
            stringArray = string.split(string2.replace("#", "\\#").replace("{", "\\{").replace("}", "\\}"), 2);
            string = "";
            int n = 1;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n];
                ++n;
            }
            if (stringArray[0] != null && !stringArray[0].isEmpty()) {
                String string4 = stringArray[0];
                String string5 = string3;
                string3 = string4;
                if (string5.endsWith(" ") && string4.startsWith(" ")) {
                    string4 = string4.substring(1);
                }
                rawMessageFragment.setText(string4);
                arrayList.add(rawMessageFragment);
                rawMessageFragment = new RawMessageFragment(rawMessageFragment);
            }
            if ((object = CMIChatColor.getColor(string2)) == null) continue;
            if (((CMIChatColor)object).isColor()) {
                rawMessageFragment.setLastColor((CMIChatColor)object);
                continue;
            }
            rawMessageFragment.addFormat((CMIChatColor)object);
        }
        if (!string.isEmpty()) {
            if (string3.endsWith(" ") && string.startsWith(" ")) {
                string = string.substring(1);
            }
            stringArray = new RawMessageFragment(rawMessageFragment);
            stringArray.setText(string);
            arrayList.add(stringArray);
        }
        if (bl) {
            this.hoverFragment = rawMessageFragment;
        } else {
            this.fragment = rawMessageFragment;
        }
        stringArray = new StringBuilder();
        for (Object object : arrayList) {
            void object22;
            if (!stringArray.toString().isEmpty()) {
                stringArray.append("},{");
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (CMIChatColor cMIChatColor : ((RawMessageFragment)object).getFormats()) {
                if (!stringBuilder.toString().isEmpty()) {
                    stringBuilder.append(",");
                }
                if (cMIChatColor.equals(CMIChatColor.UNDERLINE)) {
                    stringBuilder.append("\"underlined\":true");
                    continue;
                }
                if (cMIChatColor.equals(CMIChatColor.BOLD)) {
                    stringBuilder.append("\"bold\":true");
                    continue;
                }
                if (cMIChatColor.equals(CMIChatColor.ITALIC)) {
                    stringBuilder.append("\"italic\":true");
                    continue;
                }
                if (cMIChatColor.equals(CMIChatColor.STRIKETHROUGH)) {
                    stringBuilder.append("\"strikethrough\":true");
                    continue;
                }
                if (!cMIChatColor.equals(CMIChatColor.OBFUSCATED)) continue;
                stringBuilder.append("\"obfuscated\":true");
            }
            if (!stringBuilder.toString().isEmpty()) {
                stringArray.append(stringBuilder.toString());
                stringArray.append(",");
            }
            if (((RawMessageFragment)object).getLastColor() != null) {
                if (((RawMessageFragment)object).getLastColor().getHex() != null) {
                    stringArray.append("\"color\":\"#" + ((RawMessageFragment)object).getLastColor().getHex() + "\",");
                } else if (((RawMessageFragment)object).getLastColor().getName() != null) {
                    stringArray.append("\"color\":\"" + ((RawMessageFragment)object).getLastColor().getName().toLowerCase() + "\",");
                }
            }
            String string4 = ((RawMessageFragment)object).getText();
            if (Version.isCurrentLower(Version.v1_16_R1)) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if (((RawMessageFragment)object).getLastColor() != null && ((RawMessageFragment)object).getLastColor().getName() != null) {
                    stringBuilder2.append(((RawMessageFragment)object).getLastColor().getColorCode());
                }
                for (CMIChatColor cMIChatColor : ((RawMessageFragment)object).getFormats()) {
                    if (cMIChatColor.equals(CMIChatColor.UNDERLINE)) {
                        stringBuilder2.append("&n");
                        continue;
                    }
                    if (cMIChatColor.equals(CMIChatColor.BOLD)) {
                        stringBuilder2.append("&l");
                        continue;
                    }
                    if (cMIChatColor.equals(CMIChatColor.ITALIC)) {
                        stringBuilder2.append("&o");
                        continue;
                    }
                    if (cMIChatColor.equals(CMIChatColor.STRIKETHROUGH)) {
                        stringBuilder2.append("&m");
                        continue;
                    }
                    if (!cMIChatColor.equals(CMIChatColor.OBFUSCATED)) continue;
                    stringBuilder2.append("&k");
                }
                String string5 = String.valueOf(stringBuilder2.toString()) + string4;
            }
            stringArray.append("\"text\":\"" + RawMessage.escape((String)object22, bl ? false : this.isDontBreakLine()) + "\"");
        }
        if (stringArray.toString().isEmpty()) {
            return "";
        }
        return "{" + stringArray.toString() + "}";
    }

    @Deprecated
    public RawMessage add(String string, String string2, String string3, String string4, String string5) {
        this.add(string, string2, string3, string4, string5, null);
        return this;
    }

    @Deprecated
    public RawMessage add(String string, String string2, String string3, String string4, String string5, String string6) {
        this.addText(string);
        this.addHover(string2);
        this.addCommand(string3);
        this.addSuggestion(string4);
        this.addUrl(string5);
        this.addInsertion(string6);
        return this;
    }

    @Deprecated
    public RawMessage addUrl(String string, String string2) {
        this.addUrl(string, string2, null);
        return this;
    }

    @Deprecated
    public RawMessage addUrl(String string, String string2, String string3) {
        this.addText(string);
        this.addHover(string3);
        this.addUrl(string2);
        return this;
    }

    @Deprecated
    public RawMessage add(String string) {
        return this.add(string, null, null, null, null);
    }

    @Deprecated
    public RawMessage add(String string, String string2) {
        return this.add(string, string2, null, null, null);
    }

    @Deprecated
    public RawMessage add(String string, List<String> list2) {
        String string2 = "";
        if (list2 != null) {
            for (String string3 : list2) {
                if (!string2.isEmpty()) {
                    string2 = String.valueOf(string2) + "\n";
                }
                string2 = String.valueOf(string2) + string3;
            }
        }
        return this.add(string, string2.isEmpty() ? null : string2, null, null, null);
    }

    @Deprecated
    public RawMessage add(String string, String string2, String string3) {
        return this.add(string, string2, string3, null, null);
    }

    @Deprecated
    public RawMessage add(String string, String string2, String string3, String string4) {
        return this.add(string, string2, string3, string4, null);
    }

    @Deprecated
    public RawMessage addHoverText(List<String> list2) {
        return this.addHover(list2);
    }

    @Deprecated
    public RawMessage addHoverText(String string) {
        return this.addHover(string);
    }

    public RawMessage addItem(String string, ItemStack itemStack, String string2, String string3, String string4) {
        this.addText(string);
        this.addCommand(string2);
        this.addSuggestion(string3);
        this.addInsertion(string4);
        this.addItem(itemStack);
        return this;
    }

    public RawMessage addText(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        if (this.temp.containsKey((Object)RawMessagePartType.Text)) {
            this.build();
        }
        this.onlyText.add(CMIChatColor.translate(string));
        string = this.textIntoJson(string, false);
        String string2 = "";
        string2 = string.isEmpty() ? "\"text\":\"\"" : (string.equalsIgnoreCase(" ") ? "\"text\":\" \"" : "\"text\":\"\",\"extra\":[" + CMIChatColor.translate(string).replace("\uff06", "&") + "]");
        this.temp.put(RawMessagePartType.Text, string2);
        return this;
    }

    public RawMessage addHover(List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list2 != null) {
            for (String string : list2) {
                if (!stringBuilder.toString().isEmpty()) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string);
            }
        }
        return this.addHover(stringBuilder.toString());
    }

    public RawMessage addHover(String string) {
        this.hoverFragment = new RawMessageFragment();
        if (string == null || string.isEmpty()) {
            return this;
        }
        string = this.textIntoJson(string, true);
        String string2 = "";
        string2 = string.isEmpty() ? "\"text\":\"\"" : (string.equalsIgnoreCase(" ") ? "\"text\":\" \"" : "\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + CMIChatColor.translate(string).replace("\uff06", "&") + "]}}");
        this.temp.put(RawMessagePartType.HoverText, string2);
        return this;
    }

    public RawMessage addCommand(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = RawMessage.escape(string, true);
        String string2 = "\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + CMIChatColor.deColorize(string).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickCommand, string2);
        return this;
    }

    public RawMessage addSuggestion(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        string = RawMessage.escape(string, true);
        String string2 = "\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + CMIChatColor.deColorize(string).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickSuggestion, string2);
        return this;
    }

    public RawMessage addInsertion(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        string = RawMessage.escape(string, true);
        String string2 = "\"insertion\":\"" + CMIChatColor.deColorize(string).replace("\uff06", "&") + "\"";
        this.temp.put(RawMessagePartType.ClickInsertion, string2);
        return this;
    }

    public RawMessage addItem(ItemStack itemStack) {
        if (itemStack == null) {
            return this;
        }
        String string = CMIReflections.toJson(itemStack.clone());
        String string2 = "\"hoverEvent\":{\"action\":\"show_item\",\"value\":\"" + RawMessage.escape(string, true) + "\"}";
        this.temp.put(RawMessagePartType.HoverItem, string2);
        return this;
    }

    public RawMessage addUrl(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        if (!string.toLowerCase().startsWith("http://") && !string.toLowerCase().startsWith("https://")) {
            string = "http://" + string;
        }
        String string2 = "\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + CMIChatColor.deColorize(string).replace("\uff06", "&") + "\"}";
        this.temp.put(RawMessagePartType.ClickLink, string2);
        return this;
    }

    public RawMessage build() {
        if (this.temp.isEmpty()) {
            return this;
        }
        if (!this.temp.containsKey((Object)RawMessagePartType.Text)) {
            return this;
        }
        String string = "";
        RawMessagePartType[] rawMessagePartTypeArray = RawMessagePartType.values();
        int n = rawMessagePartTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RawMessagePartType rawMessagePartType = rawMessagePartTypeArray[n2];
            String string2 = this.temp.get((Object)rawMessagePartType);
            if (string2 != null) {
                if (!string.isEmpty()) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + string2;
            }
            ++n2;
        }
        string = "{" + string + "}";
        this.temp.clear();
        this.parts.add(string);
        return this;
    }

    private static String escape(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        RawMessage.escape(string, stringBuffer);
        if (bl) {
            return stringBuffer.toString().replace(nl, "\\\\n");
        }
        return stringBuffer.toString().replace(nl, "\\n");
    }

    private static void escape(String string, StringBuffer stringBuffer) {
        string = string.replace("\n", nl);
        string = string.replace("\\n", nl);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '/': {
                    stringBuffer.append("\\/");
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append("\\u");
                        int n2 = 0;
                        while (n2 < 4 - string2.length()) {
                            stringBuffer.append('0');
                            ++n2;
                        }
                        stringBuffer.append(string2.toUpperCase());
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
    }

    public List<String> softCombine() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (String string2 : this.parts) {
            if (string.isEmpty()) {
                string = "[\"\",";
            } else {
                if (string.length() > 30000) {
                    arrayList.add(String.valueOf(string) + "]");
                    string = "[\"\"," + string2;
                    continue;
                }
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + string2;
        }
        if (!string.isEmpty()) {
            string = String.valueOf(string) + "]";
        }
        arrayList.add(string);
        return arrayList;
    }

    private RawMessage combine() {
        String string = "";
        for (String string2 : this.parts) {
            string = string.isEmpty() ? "[\"\"," : String.valueOf(string) + ",";
            string = String.valueOf(string) + string2;
        }
        if (!string.isEmpty()) {
            string = String.valueOf(string) + "]";
        }
        if (string.isEmpty()) {
            string = "{\"text\":\" \"}";
        }
        this.combined = string;
        return this;
    }

    public RawMessage combineClean() {
        String string = "";
        for (String string2 : this.onlyText) {
            string = String.valueOf(string) + string2.replace("\\\"", "\"");
        }
        this.combinedClean = string;
        return this;
    }

    public RawMessage show(Player player) {
        return this.show(player, true);
    }

    public RawMessage show(Player player, boolean bl) {
        if (player == null) {
            return this;
        }
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        if (!player.isOnline()) {
            return this;
        }
        if (bl) {
            for (String string : this.softCombine()) {
                if (string.isEmpty()) continue;
                RawMessageManager.send(player, string);
            }
        } else {
            RawMessageManager.send(player, this.combined);
        }
        return this;
    }

    public int getFinalLenght() {
        String string = "";
        for (String string2 : this.parts) {
            string = string.isEmpty() ? "[\"\"," : String.valueOf(string) + ",";
            string = String.valueOf(string) + string2;
        }
        if (!string.isEmpty()) {
            string = String.valueOf(string) + "]";
        }
        return string.length();
    }

    public RawMessage show(CommandSender commandSender) {
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        if (commandSender instanceof Player) {
            this.show((Player)commandSender);
        } else {
            commandSender.sendMessage(this.combineClean().combinedClean);
        }
        return this;
    }

    public String getRaw() {
        if (this.combined.isEmpty()) {
            this.build();
            this.combine();
        }
        return this.combined;
    }

    public void setCombined(String string) {
        this.combined = string;
    }

    public String getShortRaw() {
        this.build();
        String string = "";
        for (String string2 : this.parts) {
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + string2;
        }
        return string;
    }

    public boolean isDontBreakLine() {
        return this.dontBreakLine;
    }

    public void setDontBreakLine(boolean bl) {
        this.dontBreakLine = bl;
    }

    public boolean isFormatFrozen() {
        return this.freezeFormat;
    }

    public void freezeFormat() {
        this.frozenFragment = new RawMessageFragment(this.fragment);
        this.freezeFormat = true;
    }

    public void unFreezeFormat() {
        this.fragment = new RawMessageFragment(this.frozenFragment);
        this.freezeFormat = false;
    }
}

