/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.residence.Residence;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigReader
extends YamlConfiguration {
    private HashMap<String, String> comments = new HashMap();
    private HashMap<String, Object> contents = new HashMap();
    YamlConfiguration config;
    private String p = null;
    private File file = null;
    private boolean recordContents = false;
    String[] waitingComment = null;

    public ConfigReader(String string) {
        this(new File(Residence.getInstance().getDataFolder(), string));
    }

    public ConfigReader(File file) {
        this.file = file;
        this.config = this.getyml(file);
    }

    public void load() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException throwable) {
            throwable.printStackTrace();
        }
    }

    public void save(String string) {
        if (string == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.save(new File(string));
    }

    public void save(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        Files.createParentDirs((File)file);
        String string = this.insertComments(this.saveToString());
        try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
            printWriter.write(string);
        }
    }

    private String insertComments(String string) {
        block34: {
            if (this.comments.isEmpty()) break block34;
            String[] stringArray = string.split("[" + System.getProperty("line.separator") + "]");
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            boolean bl3 = true;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block36: {
                    int n4;
                    int n5;
                    String string2;
                    block35: {
                        string2 = stringArray2[n3];
                        if (!bl3) break block35;
                        bl3 = false;
                        if (string2.startsWith("#")) break block36;
                    }
                    boolean bl4 = true;
                    if (string2.contains(": ")) {
                        String string3;
                        n5 = 0;
                        n5 = string2.indexOf(": ");
                        if (n5 < 0) {
                            n5 = string2.length() - 1;
                        }
                        n4 = 0;
                        int n6 = 0;
                        while (n6 < string2.length()) {
                            if (string2.charAt(n6) != ' ') break;
                            ++n4;
                            ++n6;
                        }
                        if ((string3 = string2.substring(n4, n5)).contains(" ")) {
                            bl4 = false;
                        } else if (string3.contains("&")) {
                            bl4 = false;
                        } else if (string3.contains(".")) {
                            bl4 = false;
                        } else if (string3.contains("'")) {
                            bl4 = false;
                        } else if (string3.contains("\"")) {
                            bl4 = false;
                        }
                    }
                    if (string2.contains(": ") && bl4 || string2.length() > 1 && string2.charAt(string2.length() - 1) == ':') {
                        bl = false;
                        bl2 = true;
                        n5 = 0;
                        n5 = string2.indexOf(": ");
                        if (n5 < 0) {
                            n5 = string2.length() - 1;
                        }
                        if (stringBuilder2.toString().isEmpty()) {
                            stringBuilder2 = new StringBuilder(string2.substring(0, n5));
                        } else {
                            n4 = 0;
                            int n7 = 0;
                            while (n7 < string2.length()) {
                                if (string2.charAt(n7) != ' ') break;
                                ++n4;
                                ++n7;
                            }
                            if (n4 / 2 > n) {
                                stringBuilder2.append(".").append(string2.substring(n4, n5));
                                ++n;
                            } else if (n4 / 2 < n) {
                                n7 = n4 / 2;
                                int n8 = 0;
                                while (n8 < n - n7) {
                                    stringBuilder2.replace(stringBuilder2.lastIndexOf("."), stringBuilder2.length(), "");
                                    ++n8;
                                }
                                n8 = stringBuilder2.lastIndexOf(".");
                                if (n8 < 0) {
                                    stringBuilder2 = new StringBuilder();
                                } else {
                                    stringBuilder2.replace(stringBuilder2.lastIndexOf("."), stringBuilder2.length(), "").append(".");
                                }
                                stringBuilder2.append(string2.substring(n4, n5));
                                n = n7;
                            } else {
                                n7 = stringBuilder2.lastIndexOf(".");
                                if (n7 < 0) {
                                    stringBuilder2 = new StringBuilder();
                                } else {
                                    stringBuilder2.replace(stringBuilder2.lastIndexOf("."), stringBuilder2.length(), "").append(".");
                                }
                                stringBuilder2.append(string2.substring(n4, n5));
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                    StringBuilder stringBuilder3 = new StringBuilder(string2);
                    if (bl2) {
                        String string4 = null;
                        if (!bl) {
                            string4 = this.comments.get(stringBuilder2.toString());
                        }
                        if (string4 != null && !string4.isEmpty()) {
                            stringBuilder3.insert(0, System.getProperty("line.separator")).insert(0, string4);
                            string4 = null;
                            bl = true;
                        }
                    }
                    stringBuilder3.append(System.getProperty("line.separator"));
                    stringBuilder.append(stringBuilder3.toString());
                }
                ++n3;
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public void addComment(String string, String ... stringArray) {
        if (this.p != null) {
            string = String.valueOf(this.p) + string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '.') {
                string2 = String.valueOf(string2) + "  ";
            }
            ++n;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray2[n3];
            if (!string3.isEmpty()) {
                string3 = String.valueOf(string2) + "# " + string3;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(System.getProperty("line.separator"));
            }
            stringBuilder.append(string3);
            ++n3;
        }
        this.comments.put(string, stringBuilder.toString());
    }

    public YamlConfiguration getyml(File file) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("UTF-8"));
                yamlConfiguration.load((Reader)inputStreamReader);
                inputStreamReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (IOException | InvalidConfigurationException throwable) {
                throwable.printStackTrace();
                this.saveToBackup();
                throw throwable;
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return yamlConfiguration;
    }

    public void saveToBackup() {
        File file = new File(Residence.getInstance().getDataFolder(), "FileBackups");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss ");
        String string = String.valueOf(simpleDateFormat.format(date)) + this.file.getName();
        Residence.getInstance().consoleMessage("&cFailed to load " + this.file.getName() + "! Backup have been saved into " + Residence.getInstance().getDataFolder().getPath() + File.separator + "FileBackups" + File.separator + string);
        File file2 = new File(Residence.getInstance().getDataFolder(), "FileBackups" + File.separator + string);
        try {
            Files.copy((File)this.file, (File)file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void newLn(StringBuilder stringBuilder) {
        stringBuilder.append(System.lineSeparator());
    }

    private static StringBuilder formStringBuilder(List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list2) {
            stringBuilder.append(string);
            ConfigReader.newLn(stringBuilder);
        }
        return stringBuilder;
    }

    public void header(List<String> list2) {
        this.options().header(ConfigReader.formStringBuilder(list2).toString());
    }

    private void checkWaitingComment(String string) {
        if (this.waitingComment == null) {
            return;
        }
        this.addComment(string, this.waitingComment);
        this.waitingComment = null;
    }

    public YamlConfiguration getC() {
        return this.config;
    }

    public void copyDefaults(boolean bl) {
        this.getC().options().copyDefaults(bl);
    }

    public Boolean get(String string, Boolean bl) {
        string = this.process(string, bl);
        return this.config.getBoolean(string);
    }

    private String process(String string, Object object) {
        if (this.p != null) {
            string = String.valueOf(this.p) + string;
        }
        this.checkWaitingComment(string);
        this.config.addDefault(string, object);
        this.copySetting(string);
        return string;
    }

    public Object get(String string, Location location) {
        string = this.process(string, location);
        return this.config.get(string);
    }

    public int get(String string, int n) {
        string = this.process(string, n);
        return this.config.getInt(string);
    }

    public List<Integer> getIntList(String string, List<Integer> list2) {
        string = this.process(string, list2);
        return this.config.getIntegerList(string);
    }

    private static String convertUnicode(String string) {
        try {
            if (!string.contains("\\u")) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n = 0;
            while (n < string.length()) {
                block12: {
                    int n2;
                    block13: {
                        char c;
                        block14: {
                            n2 = string.charAt(n);
                            if (n2 != 92) break block13;
                            char c2 = c = n == string.length() - 1 ? (char)'\\' : (char)string.charAt(n + 1);
                            if (c < 48 || c > 55) break block14;
                            String string2 = "" + c;
                            if (++n < string.length() - 1 && string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '7') {
                                string2 = String.valueOf(string2) + string.charAt(n + 1);
                                if (++n < string.length() - 1 && string.charAt(n + 1) >= '0' && string.charAt(n + 1) <= '7') {
                                    string2 = String.valueOf(string2) + string.charAt(n + 1);
                                    ++n;
                                }
                            }
                            stringBuilder.append((char)Integer.parseInt(string2, 8));
                            break block12;
                        }
                        switch (c) {
                            case 'u': {
                                if (n >= string.length() - 5) {
                                    n2 = 117;
                                    break;
                                }
                                try {
                                    int n3 = Integer.parseInt("" + string.charAt(n + 2) + string.charAt(n + 3) + string.charAt(n + 4) + string.charAt(n + 5), 16);
                                    stringBuilder.append(Character.toChars(n3));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    stringBuilder.append("\\");
                                    break block12;
                                }
                                n += 5;
                                break block12;
                            }
                            default: {
                                stringBuilder.append("\\");
                                break block12;
                            }
                        }
                        ++n;
                    }
                    stringBuilder.append((char)n2);
                }
                ++n;
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public List<String> get(String string, List<String> list2) {
        string = this.process(string, list2);
        if (this.recordContents) {
            this.contents.put(string, this.config.isList(string) ? this.config.getStringList(string) : list2);
        }
        List list3 = this.config.getStringList(string);
        int n = 0;
        while (n < list3.size()) {
            String string2 = ConfigReader.convertUnicode((String)list3.get(n));
            list3.set(n, string2);
            ++n;
        }
        return list3;
    }

    public String get(String string, String string2) {
        string = this.process(string, string2);
        if (this.recordContents) {
            this.contents.put(string, this.config.isString(string) ? this.config.getString(string) : string2);
        }
        return ConfigReader.convertUnicode(this.config.getString(string));
    }

    public Double get(String string, Double d) {
        string = this.process(string, d);
        return this.config.getDouble(string);
    }

    private synchronized void copySetting(String string) {
        this.set(string, this.config.get(string));
    }

    public void resetP() {
        this.p = null;
    }

    public void setP(String string) {
        this.p = string;
    }

    public String getPath() {
        return this.p;
    }

    public void setRecordContents(boolean bl) {
        this.recordContents = bl;
    }

    public HashMap<String, Object> getContents() {
        return this.contents;
    }
}

