/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.Version;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CMIReflections {
    private static Class<?> CraftServerClass;
    private static Object CraftServer;
    private static Class<?> CraftItemStack;
    private static Class<?> Item;
    private static Class<?> IStack;
    private static Class<?> NBTTagCompound;
    private static Class<?> CraftContainer;
    private static Class<?> CraftContainers;
    private static Class<?> PacketPlayOutOpenWindow;
    private static Class<?> CraftPlayer;
    public static Class<?> nmsChatSerializer;

    static {
        CMIReflections.initialize();
    }

    private static void initialize() {
        try {
            nmsChatSerializer = !Version.isCurrentHigher(Version.v1_8_R2) ? CMIReflections.getMinecraftClass("ChatSerializer") : CMIReflections.getMinecraftClass("IChatBaseComponent$ChatSerializer");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            CraftPlayer = CMIReflections.getBukkitClass("entity.CraftPlayer");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            CraftContainer = CMIReflections.getMinecraftClass("Container");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            CraftContainers = CMIReflections.getMinecraftClass("Containers");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PacketPlayOutOpenWindow = CMIReflections.getMinecraftClass("PacketPlayOutOpenWindow");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            NBTTagCompound = CMIReflections.getMinecraftClass("NBTTagCompound");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            exception.printStackTrace();
        }
        try {
            CraftServerClass = CMIReflections.getBukkitClass("CraftServer");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            exception.printStackTrace();
        }
        try {
            CraftServer = CraftServerClass.cast(Bukkit.getServer());
        }
        catch (IllegalArgumentException | SecurityException runtimeException) {
            runtimeException.printStackTrace();
        }
        try {
            CraftItemStack = CMIReflections.getBukkitClass("inventory.CraftItemStack");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            exception.printStackTrace();
        }
        try {
            Item = CMIReflections.getMinecraftClass("Item");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            exception.printStackTrace();
        }
        try {
            IStack = CMIReflections.getMinecraftClass("ItemStack");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    public static String toJson(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Object object = CMIReflections.asNMSCopy(itemStack);
        try {
            Method method = IStack.getMethod("save", NBTTagCompound);
            Object object2 = method.invoke(object, NBTTagCompound.newInstance());
            return object2.toString();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ItemStack HideFlag(ItemStack itemStack, int n) {
        Object object = CMIReflections.asNMSCopy(itemStack);
        try {
            Method method = object.getClass().getMethod("getTag", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 == null) {
                object2 = NBTTagCompound.newInstance();
            }
            Method method2 = object2.getClass().getMethod("setInt", String.class, Integer.TYPE);
            method2.invoke(object2, "HideFlags", n);
            Method method3 = object.getClass().getMethod("setTag", NBTTagCompound);
            method3.invoke(object, object2);
            return (ItemStack)CMIReflections.asBukkitCopy(object);
        }
        catch (Exception exception) {
            return itemStack;
        }
    }

    private static Integer getActiveContainerId(Object object) {
        try {
            Field field = object.getClass().getField("activeContainer");
            Object obj = CraftContainer.cast(field.get(object));
            Field field2 = obj.getClass().getField("windowId");
            Object object2 = field2.get(obj);
            return (int)((Integer)object2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getContainer(String string) {
        try {
            Field field = CraftContainers.getDeclaredField(string);
            return field.get(CraftContainers);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void updateInventoryTitle(Player player, String string) {
        if (string.length() > 32) {
            string = String.valueOf(string.substring(0, 31)) + "~";
        }
        try {
            if (Version.isCurrentEqualOrHigher(Version.v1_14_R1)) {
                Object object = CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
                Object object2 = CMIReflections.getContainer("GENERIC_9X1");
                switch (player.getOpenInventory().getTopInventory().getSize()) {
                    case 9: {
                        break;
                    }
                    case 18: {
                        object2 = CMIReflections.getContainer("GENERIC_9X2");
                        break;
                    }
                    case 27: {
                        object2 = CMIReflections.getContainer("GENERIC_9X3");
                        break;
                    }
                    case 36: {
                        object2 = CMIReflections.getContainer("GENERIC_9X4");
                        break;
                    }
                    case 45: {
                        object2 = CMIReflections.getContainer("GENERIC_9X5");
                        break;
                    }
                    case 54: {
                        object2 = CMIReflections.getContainer("GENERIC_9X6");
                    }
                }
                Constructor<?> constructor = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, CraftContainers, CMIReflections.getMinecraftClass("IChatBaseComponent"));
                Object obj = constructor.newInstance(CMIReflections.getActiveContainerId(object), object2, CMIReflections.textToIChatBaseComponent("{\"text\": \"" + string + "\"}"));
                CMIReflections.sendPlayerPacket(player, obj);
                Field field = object.getClass().getField("activeContainer");
                Object obj2 = CraftContainer.cast(field.get(object));
                Method method = object.getClass().getMethod("updateInventory", CraftContainer);
                method.invoke(object, obj2);
            } else if (Version.isCurrentEqualOrHigher(Version.v1_8_R2)) {
                Object object = CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
                Constructor<?> constructor = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, String.class, CMIReflections.getMinecraftClass("IChatBaseComponent"), Integer.TYPE);
                Object obj = constructor.newInstance(CMIReflections.getActiveContainerId(object), "minecraft:chest", CMIReflections.textToIChatBaseComponent("{\"text\": \"" + string + "\"}"), player.getOpenInventory().getTopInventory().getSize());
                CMIReflections.sendPlayerPacket(player, obj);
                Field field = object.getClass().getField("activeContainer");
                Object obj3 = CraftContainer.cast(field.get(object));
                Method method = object.getClass().getMethod("updateInventory", CraftContainer);
                method.invoke(object, obj3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static Object textToIChatBaseComponent(String string) {
        try {
            Object object = nmsChatSerializer.getMethod("a", String.class).invoke(null, CMIChatColor.translate(string));
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static Object getPlayerHandle(Player player) {
        Object object = null;
        try {
            object = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    private static Object getPlayerConnection(Player player) {
        Object object = null;
        try {
            Object object2 = CMIReflections.getPlayerHandle(player);
            object = object2.getClass().getField("playerConnection").get(object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object;
    }

    public static Class<?> getClass(String string) {
        try {
            String string2 = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            String string3 = string.replace("{nms}", "net.minecraft.server." + string2).replace("{nm}", "net.minecraft." + string2).replace("{cb}", "org.bukkit.craftbukkit.." + string2);
            return Class.forName(string3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static void sendPlayerPacket(Player player, Object object) {
        Object object2 = CMIReflections.getPlayerConnection(player);
        object2.getClass().getMethod("sendPacket", CMIReflections.getClass("{nms}.Packet")).invoke(object2, object);
    }

    private static Class<?> getBukkitClass(String string) {
        return Class.forName("org.bukkit.craftbukkit." + (Object)((Object)Version.getCurrent()) + "." + string);
    }

    public static Class<?> getMinecraftClass(String string) {
        return Class.forName("net.minecraft.server." + (Object)((Object)Version.getCurrent()) + "." + string);
    }

    public static ItemStack setNbt(ItemStack itemStack, String string, String string2) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object = CMIReflections.asNMSCopy(itemStack);
            if (object == null) {
                return itemStack;
            }
            Method method = object.getClass().getMethod("getTag", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 == null) {
                object2 = NBTTagCompound.newInstance();
            }
            Method method2 = object2.getClass().getMethod("setString", String.class, String.class);
            method2.invoke(object2, string, string2);
            Method method3 = object.getClass().getMethod("setTag", NBTTagCompound);
            method3.invoke(object, object2);
            return (ItemStack)CMIReflections.asBukkitCopy(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getItemMinecraftName(ItemStack itemStack) {
        try {
            Object object = CMIReflections.asNMSCopy(itemStack);
            if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                Object object2 = object.getClass().getMethod("getItem", new Class[0]).invoke(object, new Object[0]);
                Object object3 = object2.getClass().getMethod("getName", new Class[0]).invoke(object2, new Object[0]);
                Class<?> clazz = Class.forName("net.minecraft.server." + (Object)((Object)Version.getCurrent()) + ".LocaleLanguage");
                Object object4 = clazz.getMethod("a", new Class[0]).invoke(clazz, new Object[0]);
                return (String)object4.getClass().getMethod("a", String.class).invoke(object4, (String)object3);
            }
            Field field = Item.getField("REGISTRY");
            Object object5 = field.get(field);
            Method method = object5.getClass().getMethod("b", Object.class);
            method.setAccessible(true);
            Method method2 = object.getClass().getMethod("getItem", new Class[0]);
            Object object6 = method2.invoke(object, new Object[0]);
            Object object7 = method.invoke(object5, object6);
            return object7.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getItemMinecraftNamePath(ItemStack itemStack) {
        try {
            Object object = CMIReflections.asNMSCopy(itemStack);
            Method method = Item.getMethod("getById", Integer.TYPE);
            Object object2 = method.invoke(Item, itemStack.getType().getId());
            Method method2 = Item.getMethod("j", IStack);
            Object object3 = method2.invoke(object2, object);
            return object3.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack itemStack) {
        try {
            Method method = CraftItemStack.getMethod("asNMSCopy", ItemStack.class);
            return method.invoke(CraftItemStack, itemStack);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object asBukkitCopy(Object object) {
        try {
            Method method = CraftItemStack.getMethod("asBukkitCopy", IStack);
            return method.invoke(CraftItemStack, object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getCraftServer() {
        return CraftServer;
    }

    public static Object getNbt(ItemStack itemStack, String string) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object = CMIReflections.getNbt(itemStack);
            if (object == null) {
            }
            Method method = object.getClass().getMethod("getString", String.class);
            Object object2 = method.invoke(object, string);
            return object2;
        }
        finally {
            return null;
        }
    }

    public static Object getNbt(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        try {
            Object object = CMIReflections.asNMSCopy(itemStack);
            Method method = object.getClass().getMethod("getTag", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            return object2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ItemStack getItemInOffHand(Player player) {
        if (Version.getCurrent().isLower(Version.v1_9_R1)) {
            return null;
        }
        return player.getInventory().getItemInOffHand();
    }

    public void setEndermiteActive(Entity entity, boolean bl) {
    }
}

