/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIEntityType;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.ItemManager;
import com.bekvon.bukkit.cmiLib.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CMIItemStack {
    private int id = 0;
    private short data = 0;
    private short durability = 0;
    private int amount = 0;
    private String bukkitName = null;
    private String mojangName = null;
    private CMIMaterial cmiMaterial = null;
    private Material material = null;
    private ItemStack item;

    public CMIItemStack(Material material2) {
        this.material = material2;
        this.cmiMaterial = CMIMaterial.get(material2);
    }

    public CMIItemStack(CMIMaterial cMIMaterial) {
        this.cmiMaterial = cMIMaterial;
        if (cMIMaterial != null) {
            this.material = cMIMaterial.getMaterial();
        }
    }

    public CMIItemStack(ItemStack itemStack) {
        this.setItemStack(itemStack);
    }

    public CMIItemStack clone() {
        CMIItemStack cMIItemStack = new CMIItemStack(this.material);
        cMIItemStack.setId(this.id);
        cMIItemStack.setData(this.data);
        cMIItemStack.setAmount(this.amount);
        cMIItemStack.setDurability(this.durability);
        cMIItemStack.setBukkitName(this.bukkitName);
        cMIItemStack.setMojangName(this.mojangName);
        cMIItemStack.setCMIMaterial(this.cmiMaterial);
        cMIItemStack.setMaterial(this.material);
        cMIItemStack.setItemStack(this.item != null ? this.item.clone() : null);
        return cMIItemStack;
    }

    public int getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public short getData() {
        return this.data;
    }

    public boolean isTool() {
        return this.getMaxDurability() > 0;
    }

    public short getDurability() {
        return this.getItemStack().getDurability();
    }

    public short getMaxDurability() {
        return this.material.getMaxDurability();
    }

    public void setData(short s) {
        this.data = s;
    }

    public CMIItemStack setDisplayName(String string) {
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        if (itemMeta != null) {
            if (string == null) {
                itemMeta.setDisplayName(null);
            } else {
                itemMeta.setDisplayName(CMIChatColor.translate(string));
            }
        }
        this.getItemStack().setItemMeta(itemMeta);
        return this;
    }

    public String getDisplayName() {
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        return itemMeta == null || itemMeta.getDisplayName() == null || itemMeta.getDisplayName().isEmpty() ? this.getRealName() : itemMeta.getDisplayName();
    }

    public CMIItemStack addLore(String string) {
        if (string == null) {
            return this;
        }
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        ArrayList<String> arrayList = itemMeta.getLore();
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(CMIChatColor.translate(string));
        itemMeta.setLore(arrayList);
        this.getItemStack().setItemMeta(itemMeta);
        return this;
    }

    public CMIItemStack clearLore() {
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        ArrayList arrayList = new ArrayList();
        itemMeta.setLore(arrayList);
        this.getItemStack().setItemMeta(itemMeta);
        return this;
    }

    public CMIItemStack setLore(List<String> list2) {
        if (list2 == null || list2.isEmpty()) {
            return this;
        }
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list2) {
            arrayList.add(CMIChatColor.translate(string));
        }
        itemMeta.setLore(arrayList);
        this.getItemStack().setItemMeta(itemMeta);
        return this;
    }

    public CMIItemStack addEnchant(Enchantment enchantment, Integer n) {
        if (enchantment == null) {
            return this;
        }
        if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
            enchantmentStorageMeta.addStoredEnchant(enchantment, n.intValue(), true);
            this.getItemStack().setItemMeta((ItemMeta)enchantmentStorageMeta);
        } else {
            ItemMeta itemMeta = this.getItemStack().getItemMeta();
            itemMeta.addEnchant(enchantment, n.intValue(), true);
            this.getItemStack().setItemMeta(itemMeta);
        }
        return this;
    }

    public CMIItemStack addEnchant(HashMap<Enchantment, Integer> hashMap) {
        if (hashMap == null || hashMap.isEmpty()) {
            return this;
        }
        for (Map.Entry<Enchantment, Integer> entry : hashMap.entrySet()) {
            this.addEnchant(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public CMIItemStack clearEnchants() {
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        itemMeta.getEnchants().clear();
        this.getItemStack().setItemMeta(itemMeta);
        return this;
    }

    public List<String> getLore() {
        ItemMeta itemMeta = this.getItemStack().getItemMeta();
        if (itemMeta != null) {
            ArrayList arrayList = itemMeta.getLore();
            if (arrayList == null) {
                arrayList = new ArrayList();
                itemMeta.setLore(arrayList);
            }
            return itemMeta.getLore() == null ? new ArrayList() : itemMeta.getLore();
        }
        return new ArrayList<String>();
    }

    public String getRealName() {
        return this.getCMIType() == null || this.getCMIType() == CMIMaterial.NONE ? this.getType().name() : this.getCMIType().getName();
    }

    public String getBukkitName() {
        return this.bukkitName == null || this.bukkitName.isEmpty() ? null : this.bukkitName;
    }

    public void setBukkitName(String string) {
        this.bukkitName = string;
    }

    public String getMojangName() {
        return this.mojangName == null || this.mojangName.isEmpty() ? this.getCMIType().getMaterial().name() : this.mojangName;
    }

    public void setMojangName(String string) {
        if (string != null) {
            this.mojangName = string.replace("minecraft:", "");
        }
    }

    public Material getType() {
        if (this.material == null && this.cmiMaterial != null) {
            return this.cmiMaterial.getMaterial();
        }
        return this.material;
    }

    public CMIMaterial getCMIType() {
        return this.cmiMaterial == null ? CMIMaterial.get(this.material) : this.cmiMaterial;
    }

    @Deprecated
    public Material getMaterial() {
        return this.getType();
    }

    public void setMaterial(Material material2) {
        this.cmiMaterial = CMIMaterial.get(material2);
        this.material = material2;
    }

    public void setCMIMaterial(CMIMaterial cMIMaterial) {
        this.cmiMaterial = cMIMaterial;
        this.material = cMIMaterial == null ? null : cMIMaterial.getMaterial();
    }

    public ItemStack getItemStack() {
        if (this.item == null) {
            CMIEntityType cMIEntityType;
            if (this.cmiMaterial.isMonsterEgg()) {
                if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                    this.item = new ItemStack(this.getType());
                    this.item.setAmount(this.getAmount());
                } else {
                    this.item = new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data == 0 ? (short)90 : (short)this.data);
                }
                cMIEntityType = CMIEntityType.getById(this.data);
            } else if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
                this.item = new ItemStack(this.getType());
                this.item.setAmount(this.getAmount());
            } else {
                this.item = new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data);
            }
            if (this.getCMIType().isPotion() || this.item.getType().name().contains("SPLASH_POTION") || this.item.getType().name().contains("TIPPED_ARROW")) {
                cMIEntityType = (PotionMeta)this.item.getItemMeta();
                PotionEffectType potionEffectType = PotionEffectType.getById((int)this.data);
                if (potionEffectType != null) {
                    cMIEntityType.addCustomEffect(new PotionEffect(potionEffectType, 60, 0), true);
                }
                this.item.setItemMeta((ItemMeta)cMIEntityType);
                this.item.setDurability((short)0);
                cMIEntityType = (PotionMeta)this.item.getItemMeta();
                cMIEntityType.setDisplayName(this.getRealName());
                this.item.setItemMeta((ItemMeta)cMIEntityType);
            }
        }
        return this.item;
    }

    public CMIItemStack setItemStack(ItemStack itemStack) {
        ItemStack itemStack2 = this.item = itemStack == null ? null : itemStack;
        if (itemStack != null) {
            this.amount = itemStack.getAmount();
            this.material = itemStack.getType();
            this.cmiMaterial = CMIMaterial.get(this.material);
            if (Version.isCurrentEqualOrLower(Version.v1_13_R2)) {
                this.id = itemStack.getType().getId();
            } else if (this.cmiMaterial != null) {
                this.id = this.cmiMaterial.getId();
            }
            if (this.getType().isBlock() || this.getType().isSolid()) {
                this.data = itemStack.getData().getData();
            }
            if (itemStack.getType().getMaxDurability() - itemStack.getDurability() < 0) {
                this.data = itemStack.getData().getData();
            }
            if (itemStack.getType().getMaxDurability() > 15) {
                this.data = 0;
            }
            if (itemStack.getType() == Material.POTION || itemStack.getType().name().contains("SPLASH_POTION") || itemStack.getType().name().contains("TIPPED_ARROW")) {
                PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
                try {
                    if (potionMeta != null && potionMeta.getBasePotionData() != null && potionMeta.getBasePotionData().getType() != null && potionMeta.getBasePotionData().getType().getEffectType() != null) {
                        this.data = (short)potionMeta.getBasePotionData().getType().getEffectType().getId();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public int getAmount() {
        return this.amount <= 0 ? 1 : this.amount;
    }

    public void setAmount(int n) {
        this.amount = n;
        if (this.item != null) {
            this.item.setAmount(this.amount == 0 ? this.item.getAmount() : this.amount);
        }
    }

    public boolean isSimilar(ItemStack itemStack) {
        return this.isSimilar(ItemManager.getItem(itemStack));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSimilar(CMIItemStack cMIItemStack) {
        PotionMeta potionMeta;
        PotionMeta potionMeta2;
        if (cMIItemStack == null) {
            return false;
        }
        try {
            if ((cMIItemStack.getCMIType().isPotion() || cMIItemStack.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && (this.getCMIType().isPotion() || this.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && this.getType().equals((Object)cMIItemStack.getType())) {
                potionMeta2 = (PotionMeta)cMIItemStack.getItemStack().getItemMeta();
                potionMeta = (PotionMeta)this.getItemStack().getItemMeta();
                try {
                    PotionData potionData;
                    PotionData potionData2;
                    return potionMeta2 != null && potionMeta2.getBasePotionData() != null && (potionData2 = potionMeta2.getBasePotionData()).getType() != null && potionMeta != null && potionMeta.getBasePotionData() != null && (potionData = potionMeta.getBasePotionData()).getType() != null && potionData2.getType().equals((Object)potionData.getType()) && potionData2.isExtended() == potionData.isExtended() && potionData2.isUpgraded() == potionData.isUpgraded();
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta && cMIItemStack.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
                potionMeta2 = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
                potionMeta = (EnchantmentStorageMeta)cMIItemStack.getItemStack().getItemMeta();
                for (Map.Entry entry : potionMeta2.getEnchants().entrySet()) {
                    if (potionMeta.getEnchants().containsKey(entry.getKey()) && potionMeta.getEnchants().get(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
                for (Map.Entry entry : potionMeta2.getStoredEnchants().entrySet()) {
                    if (potionMeta.getStoredEnchants().containsKey(entry.getKey()) && potionMeta.getStoredEnchants().get(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if ((cMIItemStack.getCMIType() == CMIMaterial.SPAWNER || cMIItemStack.getCMIType().isMonsterEgg()) && (this.getCMIType() == CMIMaterial.SPAWNER || this.getCMIType().isMonsterEgg())) {
            return this.cmiMaterial == cMIItemStack.cmiMaterial;
        }
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return this.cmiMaterial == cMIItemStack.cmiMaterial;
        }
        return this.cmiMaterial == cMIItemStack.cmiMaterial && this.getData() == cMIItemStack.getData();
    }

    public void setDurability(short s) {
        this.durability = s;
    }

    public String toOneLiner() {
        PotionMeta potionMeta;
        String string = this.getType().toString();
        if (this.getCMIType().isPotion() || this.getType().name().contains("TIPPED_ARROW")) {
            potionMeta = (PotionMeta)this.item.getItemMeta();
            try {
                if (potionMeta != null && potionMeta.getBasePotionData() != null && potionMeta.getBasePotionData().getType() != null && potionMeta.getBasePotionData().getType().getEffectType() != null) {
                    string = String.valueOf(string) + ":" + potionMeta.getBasePotionData().getType().getEffectType().getName() + "-" + potionMeta.getBasePotionData().isUpgraded() + "-" + potionMeta.getBasePotionData().isExtended();
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        } else if (Version.isCurrentLower(Version.v1_13_R1)) {
            string = String.valueOf(string) + ":" + this.getData();
        }
        if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            potionMeta = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
            String string2 = "";
            for (Map.Entry entry : potionMeta.getStoredEnchants().entrySet()) {
                if (!string2.isEmpty()) {
                    string2 = String.valueOf(string2) + ";";
                }
                string2 = String.valueOf(string2) + ((Enchantment)entry.getKey()).getName() + "x" + entry.getValue();
            }
            for (Map.Entry entry : potionMeta.getEnchants().entrySet()) {
                if (!string2.isEmpty()) {
                    string2 = String.valueOf(string2) + ";";
                }
                string2 = String.valueOf(string2) + ((Enchantment)entry.getKey()).getName() + "x" + entry.getValue();
            }
            if (!string2.isEmpty()) {
                string = String.valueOf(string) + ":" + string2;
            }
        }
        return string;
    }
}

