/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMICustomColors;
import com.bekvon.bukkit.cmiLib.Version;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public class CMIChatColor {
    private static final Map<Character, CMIChatColor> BY_CHAR;
    private static final Map<String, CMIChatColor> BY_NAME;
    private static final LinkedHashMap<String, CMIChatColor> CUSTOM_BY_NAME;
    private static final Map<String, CMIChatColor> CUSTOM_BY_HEX;
    private static final TreeMap<String, CMIChatColor> CUSTOM_BY_RGB;
    public static final String colorReplacerPlaceholder = "\uff06";
    public static final String colorCodePrefix = "{#";
    public static final String colorCodeSuffix = "}";
    public static final String hexColorRegex = "(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})";
    public static final Pattern hexColorRegexPattern;
    public static final Pattern hexColorRegexPatternLast;
    public static final Pattern hexDeColorNamePattern;
    public static final String ColorNameRegex = "(\\{#)([a-zA-Z_]{3,})(\\})";
    public static final Pattern hexColorNamePattern;
    public static final Pattern hexColorNamePatternLast;
    public static final Pattern gradientPattern;
    public static final String hexColorDecolRegex = "(&x)(&[0-9A-Fa-f]){6}";
    public static final Pattern postGradientPattern;
    public static final Pattern fullPattern;
    public static final CMIChatColor BLACK;
    public static final CMIChatColor DARK_BLUE;
    public static final CMIChatColor DARK_GREEN;
    public static final CMIChatColor DARK_AQUA;
    public static final CMIChatColor DARK_RED;
    public static final CMIChatColor DARK_PURPLE;
    public static final CMIChatColor GOLD;
    public static final CMIChatColor GRAY;
    public static final CMIChatColor DARK_GRAY;
    public static final CMIChatColor BLUE;
    public static final CMIChatColor GREEN;
    public static final CMIChatColor AQUA;
    public static final CMIChatColor RED;
    public static final CMIChatColor LIGHT_PURPLE;
    public static final CMIChatColor YELLOW;
    public static final CMIChatColor WHITE;
    public static final CMIChatColor OBFUSCATED;
    public static final CMIChatColor BOLD;
    public static final CMIChatColor STRIKETHROUGH;
    public static final CMIChatColor UNDERLINE;
    public static final CMIChatColor ITALIC;
    public static final CMIChatColor RESET;
    public static final CMIChatColor HEX;
    private char c;
    private boolean color = true;
    private boolean reset = false;
    private Pattern pattern = null;
    private int red;
    private int green;
    private int blue;
    private String hex = null;
    private String name;

    static {
        String string;
        BY_CHAR = new HashMap<Character, CMIChatColor>();
        BY_NAME = new HashMap<String, CMIChatColor>();
        CUSTOM_BY_NAME = new LinkedHashMap();
        CUSTOM_BY_HEX = new HashMap<String, CMIChatColor>();
        CUSTOM_BY_RGB = new TreeMap();
        Object object = CMICustomColors.values();
        int n = ((CMICustomColors[])object).length;
        int n2 = 0;
        while (n2 < n) {
            CMICustomColors cMICustomColors = object[n2];
            CUSTOM_BY_NAME.put(cMICustomColors.name().toLowerCase().replace("_", ""), new CMIChatColor(cMICustomColors.toString(), cMICustomColors.getHex()));
            CUSTOM_BY_HEX.put(cMICustomColors.getHex().toLowerCase(), new CMIChatColor(cMICustomColors.toString(), cMICustomColors.getHex()));
            if (cMICustomColors.getExtra() != null) {
                String[] stringArray = cMICustomColors.getExtra();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    string = stringArray[n4];
                    CUSTOM_BY_NAME.put(string.toLowerCase().replace("_", ""), new CMIChatColor(string.replace(" ", "_"), cMICustomColors.getHex()));
                    ++n4;
                }
            }
            ++n2;
        }
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.1f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    object = Color.getHSBColor(f3, f, f2);
                    string = Integer.toHexString((((Color)object).getRed() << 16) + (((Color)object).getGreen() << 8) + ((Color)object).getBlue() & 0xFFFFFF);
                    while (string.length() < 6) {
                        string = "0" + string;
                    }
                    CMIChatColor.getClosest(string);
                    f3 = (float)((double)f3 + 0.03);
                }
                f2 = (float)((double)f2 + 0.1);
            }
            f = (float)((double)f + 0.1);
        }
        hexColorRegexPattern = Pattern.compile(hexColorRegex);
        hexColorRegexPatternLast = Pattern.compile("(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})(?!.*\\{#)");
        hexDeColorNamePattern = Pattern.compile("(&x)((&[0-9A-Fa-f]){6})");
        hexColorNamePattern = Pattern.compile(ColorNameRegex);
        hexColorNamePatternLast = Pattern.compile("(\\{#)([a-zA-Z_]{3,})(\\})(?!.*\\{#)");
        gradientPattern = Pattern.compile("(\\{(#[^\\{]*?)>\\})(.*?)(\\{(#.*?)<(>?)\\})");
        postGradientPattern = Pattern.compile("((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))(.)((\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\}))");
        fullPattern = Pattern.compile("(&[0123456789abcdefklmnorABCDEFKLMNOR])|(\\{#)([0-9A-Fa-f]{6}|[0-9A-Fa-f]{3})(\\})|(\\{#)([a-zA-Z_]{3,})(\\})");
        BLACK = new CMIChatColor("Black", '0', 0, 0, 0);
        DARK_BLUE = new CMIChatColor("Dark_Blue", '1', 0, 0, 170);
        DARK_GREEN = new CMIChatColor("Dark_Green", '2', 0, 170, 0);
        DARK_AQUA = new CMIChatColor("Dark_Aqua", '3', 0, 170, 170);
        DARK_RED = new CMIChatColor("Dark_Red", '4', 170, 0, 0);
        DARK_PURPLE = new CMIChatColor("Dark_Purple", '5', 170, 0, 170);
        GOLD = new CMIChatColor("Gold", '6', 255, 170, 0);
        GRAY = new CMIChatColor("Gray", '7', 170, 170, 170);
        DARK_GRAY = new CMIChatColor("Dark_Gray", '8', 85, 85, 85);
        BLUE = new CMIChatColor("Blue", '9', 85, 85, 255);
        GREEN = new CMIChatColor("Green", 'a', 85, 255, 85);
        AQUA = new CMIChatColor("Aqua", 'b', 85, 255, 255);
        RED = new CMIChatColor("Red", 'c', 255, 85, 85);
        LIGHT_PURPLE = new CMIChatColor("Light_Purple", 'd', 255, 85, 255);
        YELLOW = new CMIChatColor("Yellow", 'e', 255, 255, 85);
        WHITE = new CMIChatColor("White", 'f', 255, 255, 255);
        OBFUSCATED = new CMIChatColor("Obfuscated", 'k', false);
        BOLD = new CMIChatColor("Bold", 'l', false);
        STRIKETHROUGH = new CMIChatColor("Strikethrough", 'm', false);
        UNDERLINE = new CMIChatColor("Underline", 'n', false);
        ITALIC = new CMIChatColor("Italic", 'o', false);
        RESET = new CMIChatColor("Reset", 'r', false, true);
        HEX = new CMIChatColor("Hex", 'x', false, false);
    }

    private static String charEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '/': {
                    stringBuffer.append("/");
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff') {
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append("\\u");
                        int n2 = 0;
                        while (n2 < 4 - string2.length()) {
                            stringBuffer.append('0');
                            ++n2;
                        }
                        stringBuffer.append(string2.toUpperCase());
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String escape(String string) {
        return string.replace("#", "\\#").replace("{", "\\{").replace(colorCodeSuffix, "\\}");
    }

    public CMIChatColor(String string, char c, int n, int n2, int n3) {
        this(string, c, true, false, n, n2, n3);
    }

    public CMIChatColor(String string) {
        this(null, string);
    }

    public CMIChatColor(String string, String string2) {
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        this.hex = string2;
        this.name = string;
        try {
            this.red = Integer.valueOf(this.hex.substring(0, 2), 16);
            this.green = Integer.valueOf(this.hex.substring(2, 4), 16);
            this.blue = Integer.parseInt(this.hex.substring(4, 6), 16);
        }
        catch (Throwable throwable) {
            this.hex = null;
        }
    }

    public CMIChatColor(String string, char c, Boolean bl) {
        this(string, c, bl, false);
    }

    public CMIChatColor(String string, char c, Boolean bl, Boolean bl2) {
        this(string, c, bl, bl2, -1, -1, -1);
    }

    public CMIChatColor(String string, char c, Boolean bl, Boolean bl2, int n, int n2, int n3) {
        this.name = string;
        this.c = c;
        this.color = bl;
        this.reset = bl2;
        this.pattern = Pattern.compile("(?i)(&[" + c + "])");
        this.red = n;
        this.green = n2;
        this.blue = n3;
        if (Version.isCurrentLower(Version.v1_16_R1) && string.equalsIgnoreCase("Hex")) {
            return;
        }
        BY_CHAR.put(Character.valueOf(c), this);
        BY_NAME.put(this.getName().toLowerCase().replace("_", ""), this);
    }

    public static String processGradient(String string) {
        Matcher matcher = gradientPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            CMIChatColor cMIChatColor = CMIChatColor.getColor(colorCodePrefix + matcher.group(2).replace("#", "") + colorCodeSuffix);
            CMIChatColor cMIChatColor2 = CMIChatColor.getColor(colorCodePrefix + matcher.group(5).replace("#", "") + colorCodeSuffix);
            if (cMIChatColor == null || cMIChatColor2 == null) continue;
            String string3 = matcher.group(3);
            boolean bl = !matcher.group(6).isEmpty();
            String string4 = "";
            string3 = CMIChatColor.stripColor(string3);
            int n = 0;
            while (n < string3.length()) {
                char c = string3.charAt(n);
                int n2 = string3.length();
                n2 = n2 < 2 ? 2 : n2;
                double d = (double)n * 100.0 / (double)(n2 - 1);
                CMIChatColor cMIChatColor3 = CMIChatColor.mixColors(cMIChatColor, cMIChatColor2, d);
                string4 = String.valueOf(string4) + colorCodePrefix + cMIChatColor3.getHex() + colorCodeSuffix;
                string4 = String.valueOf(string4) + String.valueOf(c);
                ++n;
            }
            if (bl) {
                string4 = String.valueOf(string4) + colorCodePrefix + matcher.group(5).replace("#", "") + ">" + colorCodeSuffix;
            }
            string = string.replace(string2, string4);
            if (!bl) continue;
            string = CMIChatColor.processGradient(string);
        }
        return string;
    }

    public static String translate(String string) {
        if (string == null) {
            return null;
        }
        if ((string = CMIChatColor.processGradient(string)).contains(colorCodePrefix)) {
            CharSequence charSequence;
            Object object;
            Matcher matcher = hexColorRegexPattern.matcher(string);
            while (matcher.find()) {
                object = matcher.group();
                charSequence = new StringBuilder("\u00a7x");
                char[] cArray = ((String)object).substring(2, ((String)object).length() - 1).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    ((StringBuilder)charSequence).append('\u00a7').append(c);
                    if (((String)object).substring(2, ((String)object).length() - 1).length() == 3) {
                        ((StringBuilder)charSequence).append('\u00a7').append(c);
                    }
                    ++n2;
                }
                string = string.replace((CharSequence)object, ((StringBuilder)charSequence).toString());
            }
            object = hexColorNamePattern.matcher(string);
            while (((Matcher)object).find()) {
                charSequence = ((Matcher)object).group(2);
                CMIChatColor cMIChatColor = CMIChatColor.getByCustomName(((String)charSequence).toLowerCase().replace("_", ""));
                if (cMIChatColor == null) continue;
                String string2 = cMIChatColor.getHex();
                StringBuilder stringBuilder = new StringBuilder("\u00a7x");
                char[] cArray = string2.toCharArray();
                int n = cArray.length;
                int n3 = 0;
                while (n3 < n) {
                    char c = cArray[n3];
                    stringBuilder.append('\u00a7').append(c);
                    ++n3;
                }
                string = string.replace(((Matcher)object).group(), stringBuilder.toString());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String applyEqualGradient(String string, List<CMIChatColor> list2) {
        if (list2 == null || list2.isEmpty()) {
            return string;
        }
        int n = string.length() / list2.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(list2.get(0).getFormatedHex(">"));
        int n2 = 0;
        while (n2 <= list2.size() - 1) {
            if (n2 > 0 && n > 0) {
                stringBuilder.append(list2.get(n2).getFormatedHex("<>"));
            }
            int n3 = 0;
            while (n3 < n) {
                stringBuilder.append(string.charAt(0));
                string = string.substring(1);
                ++n3;
            }
            ++n2;
        }
        stringBuilder.append(String.valueOf(string) + list2.get(list2.size() - 1).getFormatedHex("<"));
        return stringBuilder.toString();
    }

    @Deprecated
    public static String translateAlternateColorCodes(String string) {
        return CMIChatColor.translate(string);
    }

    public static String colorize(String string) {
        if (string == null) {
            return null;
        }
        return CMIChatColor.translate(string);
    }

    public static String deColorize(String string) {
        if (string == null) {
            return null;
        }
        string = CMIChatColor.translate(string);
        if ((string = string.replace("\u00a7", "&")).contains("&x")) {
            Matcher matcher = hexDeColorNamePattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(2).replace("&", "");
                CMIChatColor cMIChatColor = CUSTOM_BY_HEX.get(string2.toLowerCase());
                string = cMIChatColor != null ? string.replace(matcher.group(), colorCodePrefix + cMIChatColor.getName().toLowerCase().replace("_", "") + colorCodeSuffix) : string.replace(matcher.group(), colorCodePrefix + string2 + colorCodeSuffix);
            }
        }
        return string;
    }

    public static List<String> deColorize(List<String> list2) {
        int n = 0;
        while (n < list2.size()) {
            list2.set(n, CMIChatColor.deColorize(list2.get(n)));
            ++n;
        }
        return list2;
    }

    public static String stripColor(String string) {
        if (string == null) {
            return null;
        }
        string = CMIChatColor.translate(string);
        return ChatColor.stripColor((String)string);
    }

    public static String getLastColors(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = hexColorRegexPatternLast.matcher(string = CMIChatColor.deColorize(string));
        if (matcher.find()) {
            String string2 = matcher.group(0);
            if (string.endsWith(string2)) {
                return string2;
            }
            String[] stringArray = string.split(CMIChatColor.escape(string2), 2);
            if (stringArray == null) {
                return string2;
            }
            String string3 = CMIChatColor.getLastColors(stringArray[1]);
            return string3 == null || string3.isEmpty() ? string2 : string3;
        }
        matcher = hexColorNamePatternLast.matcher(string);
        if (matcher.find()) {
            String string4 = matcher.group();
            if (string.endsWith(string4)) {
                return string4;
            }
            String[] stringArray = string.split(CMIChatColor.escape(string4), 2);
            if (stringArray == null) {
                return string4;
            }
            String string5 = CMIChatColor.getLastColors(stringArray[1]);
            return string5 == null || string5.isEmpty() ? string4 : string5;
        }
        return ChatColor.getLastColors((String)CMIChatColor.translate(string));
    }

    public String getColorCode() {
        if (this.hex != null) {
            return colorCodePrefix + this.hex + colorCodeSuffix;
        }
        return "&" + this.c;
    }

    public String getBukkitColorCode() {
        if (this.hex != null) {
            return CMIChatColor.translate(colorCodePrefix + this.hex + colorCodeSuffix);
        }
        return "\u00a7" + this.c;
    }

    public String toString() {
        return this.getBukkitColorCode();
    }

    public char getChar() {
        return this.c;
    }

    public void setChar(char c) {
        this.c = c;
    }

    public boolean isColor() {
        return this.color;
    }

    public boolean isFormat() {
        return !this.color && !this.reset;
    }

    public boolean isReset() {
        return this.reset;
    }

    public ChatColor getColor() {
        return ChatColor.getByChar((char)this.getChar());
    }

    public static CMIChatColor getColor(String string) {
        if (string == null) {
            return null;
        }
        String string2 = CMIChatColor.deColorize(string);
        if (string2.contains(colorCodePrefix)) {
            Matcher object3 = hexColorRegexPatternLast.matcher(string2);
            if (object3.find()) {
                return new CMIChatColor(object3.group(2));
            }
            Matcher matcher = hexColorNamePatternLast.matcher(string2);
            if (matcher.find()) {
                return CMIChatColor.getByCustomName(matcher.group(2));
            }
        }
        if ((string = CMIChatColor.deColorize(string).replace("&", "")).length() > 1) {
            String string3 = string.toLowerCase().replace("_", "");
            Object object = BY_NAME.get(string3);
            if (object != null) {
                return object;
            }
            object = CUSTOM_BY_NAME.get(string3);
            if (object != null) {
                return object;
            }
        }
        if (string2.length() > 1 && String.valueOf(string2.charAt(string2.length() - 2)).equalsIgnoreCase("&")) {
            string = string.substring(string.length() - 1, string.length());
            for (Map.Entry entry : BY_CHAR.entrySet()) {
                if (!String.valueOf(entry.getKey()).equalsIgnoreCase(string)) continue;
                return (CMIChatColor)entry.getValue();
            }
        }
        return null;
    }

    public static CMIChatColor getRandomColor() {
        ArrayList<CMIChatColor> arrayList = new ArrayList<CMIChatColor>();
        for (Map.Entry<String, CMIChatColor> entry : BY_NAME.entrySet()) {
            if (!entry.getValue().isColor()) continue;
            arrayList.add(entry.getValue());
        }
        Collections.shuffle(arrayList);
        return (CMIChatColor)arrayList.get(0);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public org.bukkit.Color getRGBColor() {
        if (this.blue < 0) {
            return null;
        }
        return org.bukkit.Color.fromRGB((int)this.red, (int)this.green, (int)this.blue);
    }

    public String getHex() {
        return this.hex;
    }

    public String getFormatedHex() {
        return this.getFormatedHex(null);
    }

    public String getFormatedHex(String string) {
        return colorCodePrefix + this.hex + (string == null ? "" : string) + colorCodeSuffix;
    }

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        return this.name.replace("_", "");
    }

    public static CMIChatColor getByCustomName(String string) {
        if (string.equalsIgnoreCase("random")) {
            ArrayList<CMIChatColor> arrayList = new ArrayList<CMIChatColor>(CUSTOM_BY_NAME.values());
            int n = new Random().nextInt(arrayList.size());
            return (CMIChatColor)arrayList.get(n);
        }
        return CUSTOM_BY_NAME.get(string.toLowerCase().replace("_", ""));
    }

    public static CMIChatColor getByHex(String string) {
        if (string.startsWith(colorCodePrefix)) {
            string = string.substring(colorCodePrefix.length());
        }
        if (string.endsWith(colorCodeSuffix)) {
            string = string.substring(0, string.length() - colorCodeSuffix.length());
        }
        return CUSTOM_BY_HEX.get(string.toLowerCase().replace("_", ""));
    }

    public static Map<String, CMIChatColor> getByName() {
        return BY_NAME;
    }

    public static Map<String, CMIChatColor> getByCustomName() {
        return CUSTOM_BY_NAME;
    }

    public static String getHexFromCoord(int n, int n2) {
        int n3 = n < 0 ? 0 : (n = n > 255 ? 255 : n);
        n2 = n2 < 0 ? 0 : (n2 > 255 ? 255 : n2);
        int n4 = (int)(255.0 - (double)(n2 * 255) * (1.0 + Math.sin(6.3 * (double)n)) / 2.0);
        int n5 = (int)(255.0 - (double)(n2 * 255) * (1.0 + Math.cos(6.3 * (double)n)) / 2.0);
        int n6 = (int)(255.0 - (double)(n2 * 255) * (1.0 - Math.sin(6.3 * (double)n)) / 2.0);
        String string = Integer.toHexString((n6 << 16) + (n5 << 8) + n4 & 0xFFFFFF);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return "#" + string;
    }

    public static String getHexRedGreenByPercent(int n, int n2) {
        float f = (float)n * 33.0f / 100.0f / 100.0f;
        Color color = Color.getHSBColor(f, 1.0f, 1.0f);
        String string = Integer.toHexString((color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue() & 0xFFFFFF);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return "#" + string;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public static CMIChatColor getClosest(String string) {
        CMIChatColor cMIChatColor;
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if ((cMIChatColor = CUSTOM_BY_RGB.get(string)) != null) {
            return cMIChatColor;
        }
        Color color = null;
        try {
            color = new Color(Integer.valueOf(string.substring(0, 2), 16), Integer.valueOf(string.substring(2, 4), 16), Integer.valueOf(string.substring(4, 6), 16));
        }
        catch (Throwable throwable) {
            return null;
        }
        double d = Double.MAX_VALUE;
        for (Map.Entry<String, CMIChatColor> entry : CUSTOM_BY_HEX.entrySet()) {
            int n;
            int n2;
            int n3;
            int n4;
            Color color2 = new Color(Integer.valueOf(entry.getValue().hex.substring(0, 2), 16), Integer.valueOf(entry.getValue().hex.substring(2, 4), 16), Integer.valueOf(entry.getValue().hex.substring(4, 6), 16));
            int n5 = color2.getRed();
            int n6 = n5 + (n4 = color.getRed()) >> 1;
            double d2 = Math.sqrt(((512 + n6) * (n3 = n5 - n4) * n3 >> 8) + 4 * (n2 = color2.getGreen() - color.getGreen()) * n2 + ((767 - n6) * (n = color2.getBlue() - color.getBlue()) * n >> 8));
            if (!(d2 < d)) continue;
            cMIChatColor = entry.getValue();
            d = d2;
        }
        if (cMIChatColor != null) {
            CUSTOM_BY_RGB.put(string, cMIChatColor);
            return cMIChatColor;
        }
        CUSTOM_BY_RGB.put(string, null);
        return null;
    }

    public CMIChatColor mixColors(CMIChatColor cMIChatColor, double d) {
        return CMIChatColor.mixColors(this, cMIChatColor, d);
    }

    public static CMIChatColor mixColors(CMIChatColor cMIChatColor, CMIChatColor cMIChatColor2, double d) {
        double d2 = 1.0 - (d /= 100.0);
        int n = (int)((double)cMIChatColor2.getRed() * d + (double)cMIChatColor.getRed() * d2);
        int n2 = (int)((double)cMIChatColor2.getGreen() * d + (double)cMIChatColor.getGreen() * d2);
        int n3 = (int)((double)cMIChatColor2.getBlue() * d + (double)cMIChatColor.getBlue() * d2);
        String string = String.format("#%02x%02x%02x", n, n2, n3);
        return new CMIChatColor(string);
    }
}

