/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.Version;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.material.Banner;
import org.bukkit.material.Bed;
import org.bukkit.material.Comparator;
import org.bukkit.material.Diode;
import org.bukkit.material.Dispenser;
import org.bukkit.material.Door;
import org.bukkit.material.Gate;
import org.bukkit.material.Hopper;
import org.bukkit.material.Lever;
import org.bukkit.material.Observer;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PistonExtensionMaterial;
import org.bukkit.material.Sign;
import org.bukkit.material.Skull;
import org.bukkit.material.Stairs;
import org.bukkit.material.TripwireHook;

public class CMIBlock {
    private Block block;
    private Integer data = null;
    private Object blockd = null;

    public CMIBlock(Block block) {
        this.block = block;
    }

    @Deprecated
    public blockDirection getDirection() {
        return blockDirection.getByDir(this.block.getData()) == null ? blockDirection.none : blockDirection.getByDir(this.block.getData());
    }

    public boolean isWaterlogged() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1) && this.block.getBlockData() instanceof Waterlogged) {
            Waterlogged waterlogged = (Waterlogged)this.block.getBlockData();
            return waterlogged.isWaterlogged();
        }
        CMIMaterial cMIMaterial = CMIMaterial.get(this.block);
        switch (cMIMaterial) {
            case BUBBLE_COLUMN: 
            case KELP: 
            case KELP_PLANT: 
            case SEAGRASS: 
            case TALL_SEAGRASS: 
            case WATER: 
            case LEGACY_STATIONARY_WATER: {
                return true;
            }
        }
        return false;
    }

    public Bisect getBisect() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Bisected)) {
                return null;
            }
            Bisected bisected = (Bisected)blockData;
            switch (bisected.getHalf()) {
                case TOP: {
                    return Bisect.TOP;
                }
                case BOTTOM: {
                    return Bisect.BOTTOM;
                }
            }
        }
        return null;
    }

    public boolean isAttached() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Attachable)) {
                return false;
            }
            Attachable attachable = (Attachable)blockData;
            return attachable.isAttached();
        }
        return false;
    }

    public Axis getAxis() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof Orientable)) {
                return null;
            }
            Orientable orientable = (Orientable)blockData;
            return orientable.getAxis();
        }
        return null;
    }

    public BedPart getBedPart() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockData blockData = this.block.getBlockData();
            if (!(blockData instanceof org.bukkit.block.data.type.Bed)) {
                return null;
            }
            org.bukkit.block.data.type.Bed bed = (org.bukkit.block.data.type.Bed)blockData;
            switch (bed.getPart()) {
                case FOOT: {
                    return BedPart.FOOT;
                }
                case HEAD: {
                    return BedPart.HEAD;
                }
            }
        }
        return null;
    }

    public StairShape getStairShape() {
        CMIMaterial cMIMaterial;
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1) && (cMIMaterial = CMIMaterial.get(this.block)).isStairs()) {
            BlockData blockData = this.block.getBlockData();
            org.bukkit.block.data.type.Stairs stairs = (org.bukkit.block.data.type.Stairs)blockData;
            Stairs.Shape shape = stairs.getShape();
            return StairShape.getByName(shape.toString());
        }
        return null;
    }

    public BlockFace getFacing() {
        Object object;
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            object = this.block.getBlockData();
            if (object instanceof Directional) {
                Directional directional = this.blockd == null ? (Directional)object.clone() : (Directional)this.blockd;
                return directional.getFacing();
            }
            if (object instanceof Rotatable) {
                Rotatable rotatable = this.blockd == null ? (Rotatable)object.clone() : (Rotatable)this.blockd;
                return rotatable.getRotation();
            }
        }
        try {
            object = CMIMaterial.get(this.block);
            switch (CMIBlock.$SWITCH_TABLE$com$bekvon$bukkit$cmiLib$CMIMaterial()[((Enum)object).ordinal()]) {
                case 164: {
                    Comparator comparator = (Comparator)this.block.getState().getData();
                    return comparator.getFacing();
                }
                case 701: {
                    Diode diode = (Diode)this.block.getState().getData();
                    return diode.getFacing();
                }
                case 255: {
                    Dispenser dispenser = (Dispenser)this.block.getState().getData();
                    return dispenser.getFacing();
                }
                case 368: {
                    Hopper hopper = (Hopper)this.block.getState().getData();
                    return hopper.getFacing();
                }
                case 434: {
                    Lever lever = (Lever)this.block.getState().getData();
                    return lever.getFacing();
                }
                case 806: {
                    TripwireHook tripwireHook = (TripwireHook)this.block.getState().getData();
                    return tripwireHook.getFacing();
                }
            }
            if (((CMIMaterial)((Object)object)).isSign()) {
                Sign sign = (Sign)this.block.getState().getData();
                return sign.getFacing();
            }
            if (((CMIMaterial)((Object)object)).isSkull()) {
                Skull skull = (Skull)this.block.getState().getData();
                return skull.getFacing();
            }
            if (((CMIMaterial)((Object)object)).isBed()) {
                Bed bed = (Bed)this.block.getState().getData();
                return bed.getFacing();
            }
            if (((CMIMaterial)((Object)object)).isDoor()) {
                Door door = (Door)this.block.getState().getData();
                return door.getFacing();
            }
            if (((CMIMaterial)((Object)object)).isGate()) {
                Gate gate = (Gate)this.block.getState().getData();
                return gate.getFacing();
            }
            String string = this.block.getType().name();
            if (string.contains("_STAIRS")) {
                Stairs stairs = (Stairs)this.block.getState().getData();
                return stairs.getFacing();
            }
            if (string.contains("BANNER")) {
                Banner banner = (Banner)this.block.getState().getData();
                return banner.getFacing();
            }
            if (string.contains("OBSERVER")) {
                Observer observer = (Observer)this.block.getState().getData();
                return observer.getFacing();
            }
            if (string.contains("PISTON_BASE")) {
                PistonBaseMaterial pistonBaseMaterial = (PistonBaseMaterial)this.block.getState().getData();
                return pistonBaseMaterial.getFacing();
            }
            if (string.contains("PISTON_EXTENSION")) {
                PistonExtensionMaterial pistonExtensionMaterial = (PistonExtensionMaterial)this.block.getState().getData();
                return pistonExtensionMaterial.getFacing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public CMIBlock flip(FlipDirection flipDirection, boolean bl) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            Stairs.Shape shape;
            Directional directional;
            CMIMaterial cMIMaterial = CMIMaterial.get(this.block);
            BlockData blockData = this.block.getBlockData().clone();
            switch (flipDirection) {
                case UP_DOWN: {
                    if (!(blockData instanceof Bisected)) break;
                    Bisected bisected = directional = this.blockd == null || !(this.blockd instanceof Bisected) ? (Bisected)blockData.clone() : (Bisected)this.blockd;
                    if (directional == null) break;
                    switch (directional.getHalf()) {
                        case TOP: {
                            directional.setHalf(Bisected.Half.BOTTOM);
                            break;
                        }
                        case BOTTOM: {
                            directional.setHalf(Bisected.Half.TOP);
                        }
                    }
                    if (this.blockd != null) break;
                    this.blockd = directional;
                }
            }
            if (blockData instanceof Directional) {
                Directional directional2 = directional = this.blockd == null ? (Directional)blockData.clone() : (Directional)this.blockd;
                if (directional != null) {
                    shape = directional.getFacing();
                    block8 : switch (flipDirection) {
                        case NORTH_SOUTH: {
                            if (bl) {
                                switch (CMIBlock.$SWITCH_TABLE$org$bukkit$block$BlockFace()[shape.ordinal()]) {
                                    case 1: {
                                        directional.setFacing(BlockFace.EAST);
                                        break;
                                    }
                                    case 3: {
                                        directional.setFacing(BlockFace.WEST);
                                        break;
                                    }
                                    case 4: {
                                        directional.setFacing(BlockFace.SOUTH);
                                        break;
                                    }
                                    case 2: {
                                        directional.setFacing(BlockFace.NORTH);
                                    }
                                }
                                break;
                            }
                            switch (CMIBlock.$SWITCH_TABLE$org$bukkit$block$BlockFace()[shape.ordinal()]) {
                                case 1: {
                                    directional.setFacing(BlockFace.SOUTH);
                                    break;
                                }
                                case 3: {
                                    directional.setFacing(BlockFace.NORTH);
                                }
                            }
                            break;
                        }
                        case WEST_EAST: {
                            if (bl) {
                                switch (CMIBlock.$SWITCH_TABLE$org$bukkit$block$BlockFace()[shape.ordinal()]) {
                                    case 4: {
                                        directional.setFacing(BlockFace.NORTH);
                                        break;
                                    }
                                    case 2: {
                                        directional.setFacing(BlockFace.SOUTH);
                                        break;
                                    }
                                    case 1: {
                                        directional.setFacing(BlockFace.WEST);
                                        break;
                                    }
                                    case 3: {
                                        directional.setFacing(BlockFace.EAST);
                                    }
                                }
                                break;
                            }
                            switch (CMIBlock.$SWITCH_TABLE$org$bukkit$block$BlockFace()[shape.ordinal()]) {
                                case 4: {
                                    directional.setFacing(BlockFace.EAST);
                                    break;
                                }
                                case 2: {
                                    directional.setFacing(BlockFace.WEST);
                                }
                            }
                            break;
                        }
                        case UP_DOWN: {
                            switch (CMIBlock.$SWITCH_TABLE$org$bukkit$block$BlockFace()[shape.ordinal()]) {
                                case 5: {
                                    directional.setFacing(BlockFace.DOWN);
                                    break block8;
                                }
                                case 6: {
                                    directional.setFacing(BlockFace.UP);
                                }
                            }
                        }
                    }
                    if (this.blockd == null) {
                        this.blockd = directional;
                    }
                }
            }
            if (cMIMaterial.isStairs()) {
                directional = (org.bukkit.block.data.type.Stairs)this.blockd;
                shape = directional.getShape();
                BlockFace blockFace = directional.getFacing();
                block37 : switch (flipDirection) {
                    case NORTH_SOUTH: 
                    case WEST_EAST: {
                        switch (shape) {
                            case INNER_LEFT: {
                                directional.setShape(Stairs.Shape.INNER_RIGHT);
                                break block37;
                            }
                            case INNER_RIGHT: {
                                directional.setShape(Stairs.Shape.INNER_LEFT);
                                break block37;
                            }
                            case OUTER_LEFT: {
                                directional.setShape(Stairs.Shape.OUTER_RIGHT);
                                break block37;
                            }
                            case OUTER_RIGHT: {
                                directional.setShape(Stairs.Shape.OUTER_LEFT);
                            }
                        }
                    }
                }
            }
            if (blockData instanceof Rotatable) {
                directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                switch (directional.getRotation()) {
                    case NORTH: {
                        directional.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case NORTH_EAST: {
                        directional.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        directional.setRotation(BlockFace.WEST_SOUTH_WEST);
                        break;
                    }
                    case EAST: {
                        directional.setRotation(BlockFace.WEST);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        directional.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case SOUTH: {
                        directional.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case SOUTH_WEST: {
                        directional.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        directional.setRotation(BlockFace.EAST_NORTH_EAST);
                        break;
                    }
                    case WEST: {
                        directional.setRotation(BlockFace.EAST);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        directional.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional;
                }
            }
            if (!(cMIMaterial.isWall() || cMIMaterial.isGlassPane() || cMIMaterial.isFence() || cMIMaterial.equals((Object)CMIMaterial.IRON_BARS) || this.blockd != null)) {
                this.blockd = blockData.clone();
            }
            return this;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Material material2 = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        CMIMaterial cMIMaterial = CMIMaterial.get(this.block);
        try {
            switch (flipDirection) {
                case NORTH_SOUTH: {
                    n3 = 1;
                    break;
                }
                case WEST_EAST: {
                    n = 1;
                    break;
                }
                case UP_DOWN: {
                    n2 = 1;
                }
            }
            if (cMIMaterial.isButton()) {
                switch (this.data & 0xFFFFFFF7) {
                    case 1: {
                        this.data = this.data + n;
                        break;
                    }
                    case 2: {
                        this.data = this.data - n;
                        break;
                    }
                    case 3: {
                        this.data = this.data + n3;
                        break;
                    }
                    case 4: {
                        this.data = this.data - n3;
                        break;
                    }
                    case 0: 
                    case 5: {
                        this.data = this.data ^ n2 * 5;
                    }
                }
            } else if (cMIMaterial.isSlab()) {
                this.data = this.data ^ n2 << 3;
            } else if (cMIMaterial.isDoor()) {
                if ((this.data & 8) == 0) {
                    switch (this.data & 3) {
                        case 0: {
                            this.data = this.data + n + n3 * 3;
                            break;
                        }
                        case 1: {
                            this.data = this.data - n + n3;
                            break;
                        }
                        case 2: {
                            this.data = this.data + n - n3;
                            break;
                        }
                        case 3: {
                            this.data = this.data - n - n3 * 3;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (cMIMaterial.isTrapDoor()) {
                switch (this.data & 3) {
                    case 0: 
                    case 1: {
                        this.data = this.data ^ n3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.data = this.data ^ n;
                    }
                }
            } else if (cMIMaterial.isBed()) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ n3 << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ n << 1;
                    }
                }
            } else if (cMIMaterial.isSign()) {
                switch (flipDirection) {
                    case NORTH_SOUTH: {
                        this.data = 16 - this.data & 0xF;
                        break;
                    }
                    case WEST_EAST: {
                        this.data = 8 - this.data & 0xF;
                    }
                }
            }
            block94 : switch (CMIMaterial.get(this.block)) {
                case REDSTONE_TORCH: 
                case TORCH: {
                    if (this.data < 1 || this.data > 4) break;
                    switch (this.data) {
                        case 1: {
                            this.data = this.data + n;
                            break;
                        }
                        case 2: {
                            this.data = this.data - n;
                            break;
                        }
                        case 3: {
                            this.data = this.data + n3;
                            break;
                        }
                        case 4: {
                            this.data = this.data - n3;
                        }
                    }
                    break;
                }
                case LEVER: {
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = this.data + n;
                            break;
                        }
                        case 2: {
                            this.data = this.data - n;
                            break;
                        }
                        case 3: {
                            this.data = this.data + n3;
                            break;
                        }
                        case 4: {
                            this.data = this.data - n3;
                            break;
                        }
                        case 5: 
                        case 7: {
                            this.data = this.data ^ n2 << 1;
                            break;
                        }
                        case 0: 
                        case 6: {
                            this.data = this.data ^ n2 * 6;
                        }
                    }
                    break;
                }
                case RAIL: {
                    switch (this.data) {
                        case 6: {
                            this.data = this.data + n + n3 * 3;
                            break;
                        }
                        case 7: {
                            this.data = this.data - n + n3;
                            break;
                        }
                        case 8: {
                            this.data = this.data + n - n3;
                            break;
                        }
                        case 9: {
                            this.data = this.data - n - n3 * 3;
                        }
                    }
                }
                case ACTIVATOR_RAIL: 
                case DETECTOR_RAIL: 
                case POWERED_RAIL: {
                    switch (this.data & 7) {
                        case 0: 
                        case 1: {
                            this.data = this.data;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.data = this.data ^ n;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ n3;
                        }
                    }
                    break;
                }
                case CHEST: 
                case ENDER_CHEST: 
                case FURNACE: 
                case HOPPER: 
                case LADDER: 
                case TRAPPED_CHEST: 
                case WALL_SIGN: 
                case LEGACY_BURNING_FURNACE: {
                    int n4 = this.data & 8;
                    int n5 = this.data & 0xFFFFFFF7;
                    switch (n5) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ n3 | n4;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ n | n4;
                        }
                    }
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    int n6 = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ n3 | n6;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ n | n6;
                            break;
                        }
                        case 0: 
                        case 1: {
                            this.data = this.data ^ n2 | n6;
                        }
                    }
                    break;
                }
                case JACK_O_LANTERN: 
                case PUMPKIN: {
                    if (this.data > 3) break;
                }
                case COCOA: 
                case COMPARATOR: 
                case REPEATER: 
                case TRIPWIRE_HOOK: 
                case LEGACY_DIODE_BLOCK_OFF: 
                case LEGACY_DIODE_BLOCK_ON: 
                case LEGACY_REDSTONE_COMPARATOR_OFF: 
                case LEGACY_REDSTONE_COMPARATOR_ON: {
                    switch (this.data & 3) {
                        case 0: 
                        case 2: {
                            this.data = this.data ^ n3 << 1;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.data = this.data ^ n << 1;
                        }
                    }
                    break;
                }
                case MOVING_PISTON: 
                case PISTON_HEAD: 
                case STICKY_PISTON: {
                    switch (this.data & 0xFFFFFFF7) {
                        case 0: 
                        case 1: {
                            this.data = this.data ^ n2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.data = this.data ^ n3;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ n;
                        }
                    }
                    break;
                }
                case BROWN_MUSHROOM: 
                case RED_MUSHROOM: {
                    switch (this.data) {
                        case 1: 
                        case 4: 
                        case 7: {
                            this.data = this.data + n * 2;
                            break;
                        }
                        case 3: 
                        case 6: 
                        case 9: {
                            this.data = this.data - n * 2;
                        }
                    }
                    switch (this.data) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.data = this.data + n3 * 6;
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            this.data = this.data - n3 * 6;
                        }
                    }
                    break;
                }
                case VINE: {
                    int n7 = 0;
                    int n8 = 0;
                    switch (flipDirection) {
                        case NORTH_SOUTH: {
                            n7 = 2;
                            n8 = 8;
                            break;
                        }
                        case WEST_EAST: {
                            n7 = 1;
                            n8 = 4;
                            break;
                        }
                        default: {
                            this.data = this.data;
                        }
                    }
                    int n9 = this.data & ~(n7 | n8);
                    if ((this.data & n7) != 0) {
                        n9 |= n8;
                    }
                    if ((this.data & n8) != 0) {
                        n9 |= n7;
                    }
                    this.data = n9;
                    break;
                }
                case LEGACY_SKULL: {
                    switch (this.data) {
                        case 2: 
                        case 3: {
                            this.data = this.data ^ n3;
                            break;
                        }
                        case 4: 
                        case 5: {
                            this.data = this.data ^ n;
                        }
                    }
                    break;
                }
                case ANVIL: {
                    switch (this.data & 3) {
                        case 0: 
                        case 2: {
                            this.data = this.data ^ n3 << 1;
                            break block94;
                        }
                        case 1: 
                        case 3: {
                            this.data = this.data ^ n << 1;
                        }
                    }
                }
            }
            if (cMIMaterial.isFence()) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ n3 << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ n << 1;
                    }
                }
            } else if (cMIMaterial.isStairs()) {
                this.data = this.data ^ n2 << 2;
                switch (this.data) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: {
                        this.data = this.data ^ n;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: {
                        this.data = this.data ^ n3;
                    }
                }
            }
            if (material2.name().contains("TERRACOTTA")) {
                switch (this.data & 3) {
                    case 0: 
                    case 2: {
                        this.data = this.data ^ n3 << 1;
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.data = this.data ^ n << 1;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.data = this.data;
        }
        return this;
    }

    public CMIBlock rotate90Reverse() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            BlockFace blockFace;
            Directional directional;
            CMIMaterial cMIMaterial = CMIMaterial.get(this.block);
            BlockData blockData = this.block.getBlockData();
            if (blockData instanceof Directional) {
                directional = this.blockd == null ? (Directional)blockData.clone() : (Directional)this.blockd;
                blockFace = directional.getFacing();
                switch (directional.getFacing()) {
                    case NORTH: {
                        directional.setFacing(BlockFace.WEST);
                        break;
                    }
                    case EAST: {
                        directional.setFacing(BlockFace.NORTH);
                        break;
                    }
                    case SOUTH: {
                        directional.setFacing(BlockFace.EAST);
                        break;
                    }
                    case WEST: {
                        directional.setFacing(BlockFace.SOUTH);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional.clone();
                }
            }
            if (blockData instanceof Rotatable) {
                directional = this.blockd == null ? (Rotatable)blockData.clone() : (Rotatable)this.blockd;
                blockFace = directional.getRotation();
                switch (blockFace) {
                    case NORTH: {
                        directional.setRotation(BlockFace.WEST);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        directional.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case NORTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case EAST: {
                        directional.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case SOUTH_EAST: {
                        directional.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        directional.setRotation(BlockFace.EAST_NORTH_EAST);
                        break;
                    }
                    case SOUTH: {
                        directional.setRotation(BlockFace.EAST);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        directional.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case SOUTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                        break;
                    }
                    case WEST: {
                        directional.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case NORTH_WEST: {
                        directional.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        directional.setRotation(BlockFace.WEST_SOUTH_WEST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional;
                }
                return this;
            }
            if (this.blockd == null) {
                this.blockd = blockData.clone();
            }
            return this;
        }
        Material material2 = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        CMIMaterial cMIMaterial = CMIMaterial.get(this.block);
        try {
            int n;
            int n2;
            block25 : switch (cMIMaterial) {
                case TORCH: 
                case LEGACY_REDSTONE_TORCH_OFF: 
                case LEGACY_REDSTONE_TORCH_ON: {
                    switch (this.data) {
                        case 1: {
                            this.data = 3;
                            break;
                        }
                        case 2: {
                            this.data = 4;
                            break;
                        }
                        case 3: {
                            this.data = 2;
                            break;
                        }
                        case 4: {
                            this.data = 1;
                        }
                    }
                }
                case RAIL: {
                    switch (this.data) {
                        case 6: {
                            this.data = 7;
                            break;
                        }
                        case 7: {
                            this.data = 8;
                            break;
                        }
                        case 8: {
                            this.data = 9;
                            break;
                        }
                        case 9: {
                            this.data = 6;
                        }
                    }
                }
                case ACTIVATOR_RAIL: 
                case DETECTOR_RAIL: 
                case POWERED_RAIL: {
                    switch (this.data & 7) {
                        case 0: {
                            this.data = 1 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 1: {
                            this.data = this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 2: {
                            this.data = 5 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 3: {
                            this.data = 4 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 4: {
                            this.data = 2 | this.data & 0xFFFFFFF8;
                            break;
                        }
                        case 5: {
                            this.data = 3 | this.data & 0xFFFFFFF8;
                        }
                    }
                    break;
                }
                case OAK_BUTTON: 
                case STONE_BUTTON: {
                    n2 = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = 3 | n2;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n2;
                            break;
                        }
                        case 3: {
                            this.data = 2 | n2;
                            break;
                        }
                        case 4: {
                            this.data = 1 | n2;
                        }
                    }
                    break;
                }
                case LEVER: {
                    n2 = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 1: {
                            this.data = 3 | n2;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n2;
                            break;
                        }
                        case 3: {
                            this.data = 2 | n2;
                            break;
                        }
                        case 4: {
                            this.data = 1 | n2;
                            break;
                        }
                        case 5: {
                            this.data = 6 | n2;
                            break;
                        }
                        case 6: {
                            this.data = 5 | n2;
                            break;
                        }
                        case 7: {
                            this.data = n2;
                            break;
                        }
                        case 0: {
                            this.data = 7 | n2;
                        }
                    }
                    break;
                }
                case IRON_DOOR: 
                case OAK_DOOR: {
                    if ((this.data & 8) != 0) break;
                }
                case COCOA: 
                case TRIPWIRE_HOOK: {
                    n2 = this.data & 0xFFFFFFFC;
                    n = this.data & 3;
                    switch (n) {
                        case 0: {
                            this.data = 1 | n2;
                            break;
                        }
                        case 1: {
                            this.data = 2 | n2;
                            break;
                        }
                        case 2: {
                            this.data = 3 | n2;
                            break;
                        }
                        case 3: {
                            this.data = n2;
                        }
                    }
                    break;
                }
                case LEGACY_SIGN_POST: {
                    this.data = (this.data + 4) % 16;
                    break;
                }
                case CHEST: 
                case ENDER_CHEST: 
                case FURNACE: 
                case HOPPER: 
                case LADDER: 
                case TRAPPED_CHEST: 
                case WALL_SIGN: 
                case LEGACY_BURNING_FURNACE: {
                    n2 = this.data & 8;
                    n = this.data & 0xFFFFFFF7;
                    switch (n) {
                        case 2: {
                            this.data = 5 | n2;
                            break;
                        }
                        case 3: {
                            this.data = 4 | n2;
                            break;
                        }
                        case 4: {
                            this.data = 2 | n2;
                            break;
                        }
                        case 5: {
                            this.data = 3 | n2;
                        }
                    }
                    break;
                }
                case DISPENSER: 
                case DROPPER: {
                    n2 = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 2: {
                            this.data = 5 | n2;
                            break;
                        }
                        case 3: {
                            this.data = 4 | n2;
                            break;
                        }
                        case 4: {
                            this.data = 2 | n2;
                            break;
                        }
                        case 5: {
                            this.data = 3 | n2;
                        }
                    }
                    break;
                }
                case JACK_O_LANTERN: 
                case PUMPKIN: {
                    switch (this.data) {
                        case 0: {
                            this.data = 1;
                            break;
                        }
                        case 1: {
                            this.data = 2;
                            break;
                        }
                        case 2: {
                            this.data = 3;
                            break;
                        }
                        case 3: {
                            this.data = 0;
                        }
                    }
                    break;
                }
                case BIRCH_LOG: 
                case HAY_BLOCK: 
                case JUNGLE_LOG: 
                case OAK_LOG: 
                case SPRUCE_LOG: {
                    if (this.data < 4 || this.data > 11) break;
                    this.data = this.data ^ 0xC;
                    break;
                }
                case LEGACY_DIODE_BLOCK_OFF: 
                case LEGACY_DIODE_BLOCK_ON: 
                case LEGACY_REDSTONE_COMPARATOR_OFF: 
                case LEGACY_REDSTONE_COMPARATOR_ON: {
                    n = this.data & 3;
                    int n3 = this.data - n;
                    switch (n) {
                        case 0: {
                            this.data = 1 | n3;
                            break;
                        }
                        case 1: {
                            this.data = 2 | n3;
                            break;
                        }
                        case 2: {
                            this.data = 3 | n3;
                            break;
                        }
                        case 3: {
                            this.data = n3;
                        }
                    }
                    break;
                }
                case IRON_TRAPDOOR: 
                case OAK_TRAPDOOR: {
                    int n4 = this.data & 0xFFFFFFFC;
                    int n5 = this.data & 3;
                    switch (n5) {
                        case 0: {
                            this.data = 3 | n4;
                            break;
                        }
                        case 1: {
                            this.data = 2 | n4;
                            break;
                        }
                        case 2: {
                            this.data = n4;
                            break;
                        }
                        case 3: {
                            this.data = 1 | n4;
                        }
                    }
                    break;
                }
                case MOVING_PISTON: 
                case PISTON_HEAD: 
                case STICKY_PISTON: {
                    int n6 = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 2: {
                            this.data = 5 | n6;
                            break;
                        }
                        case 3: {
                            this.data = 4 | n6;
                            break;
                        }
                        case 4: {
                            this.data = 2 | n6;
                            break;
                        }
                        case 5: {
                            this.data = 3 | n6;
                        }
                    }
                    break;
                }
                case BROWN_MUSHROOM: 
                case RED_MUSHROOM: {
                    if (this.data >= 10) {
                        this.data = this.data;
                        break;
                    }
                    this.data = this.data * 3 % 10;
                    break;
                }
                case VINE: {
                    this.data = (this.data << 1 | this.data >> 3) & 0xF;
                    break;
                }
                case ANVIL: {
                    int n7 = this.data & 0xFFFFFFFC;
                    switch (this.data & 3) {
                        case 0: {
                            this.data = 3 | n7;
                            break;
                        }
                        case 2: {
                            this.data = 1 | n7;
                            break;
                        }
                        case 1: {
                            this.data = n7;
                            break;
                        }
                        case 3: {
                            this.data = 2 | n7;
                        }
                    }
                    break;
                }
                case LEGACY_SKULL: {
                    switch (this.data) {
                        case 2: {
                            this.data = 5;
                            break block25;
                        }
                        case 3: {
                            this.data = 4;
                            break block25;
                        }
                        case 4: {
                            this.data = 2;
                            break block25;
                        }
                        case 5: {
                            this.data = 3;
                        }
                    }
                }
            }
            if (cMIMaterial.isBed()) {
                this.data = this.data & 0xFFFFFFFC | this.data + 1 & 3;
            } else if (cMIMaterial.isGate()) {
                this.data = this.data + 1 & 3 | this.data & 0xFFFFFFFC;
            } else if (cMIMaterial.isStairs()) {
                switch (this.data) {
                    case 0: {
                        this.data = 2;
                        break;
                    }
                    case 1: {
                        this.data = 3;
                        break;
                    }
                    case 2: {
                        this.data = 1;
                        break;
                    }
                    case 3: {
                        this.data = 0;
                        break;
                    }
                    case 4: {
                        this.data = 6;
                        break;
                    }
                    case 5: {
                        this.data = 7;
                        break;
                    }
                    case 6: {
                        this.data = 5;
                        break;
                    }
                    case 7: {
                        this.data = 4;
                    }
                }
            }
            if (material2.name().contains("TERRACOTTA")) {
                n2 = this.data & 0xFFFFFFFC;
                n = this.data & 3;
                switch (n) {
                    case 0: {
                        this.data = 1 | n2;
                        break;
                    }
                    case 1: {
                        this.data = 2 | n2;
                        break;
                    }
                    case 2: {
                        this.data = 3 | n2;
                        break;
                    }
                    case 3: {
                        this.data = n2;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.data = this.data;
        }
        return this;
    }

    public CMIBlock rotate90() {
        Object object;
        CMIMaterial cMIMaterial;
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            cMIMaterial = CMIMaterial.get(this.block);
            object = this.block.getBlockData().clone();
            if (object instanceof Directional) {
                Directional directional = this.blockd == null ? (Directional)((Directional)object).clone() : (Directional)this.blockd;
                BlockFace blockFace = directional.getFacing();
                switch (blockFace) {
                    case NORTH: {
                        directional.setFacing(BlockFace.EAST);
                        break;
                    }
                    case EAST: {
                        directional.setFacing(BlockFace.SOUTH);
                        break;
                    }
                    case SOUTH: {
                        directional.setFacing(BlockFace.WEST);
                        break;
                    }
                    case WEST: {
                        directional.setFacing(BlockFace.NORTH);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = directional.clone();
                }
                return this;
            }
            if (object instanceof Rotatable) {
                Rotatable rotatable = this.blockd == null ? (Rotatable)object.clone() : (Rotatable)this.blockd;
                BlockFace blockFace = rotatable.getRotation();
                switch (blockFace) {
                    case NORTH: {
                        rotatable.setRotation(BlockFace.EAST);
                        break;
                    }
                    case NORTH_NORTH_EAST: {
                        rotatable.setRotation(BlockFace.EAST_SOUTH_EAST);
                        break;
                    }
                    case NORTH_EAST: {
                        rotatable.setRotation(BlockFace.SOUTH_EAST);
                        break;
                    }
                    case EAST_NORTH_EAST: {
                        rotatable.setRotation(BlockFace.SOUTH_SOUTH_EAST);
                        break;
                    }
                    case EAST: {
                        rotatable.setRotation(BlockFace.SOUTH);
                        break;
                    }
                    case EAST_SOUTH_EAST: {
                        rotatable.setRotation(BlockFace.SOUTH_SOUTH_WEST);
                        break;
                    }
                    case SOUTH_EAST: {
                        rotatable.setRotation(BlockFace.SOUTH_WEST);
                        break;
                    }
                    case SOUTH_SOUTH_EAST: {
                        rotatable.setRotation(BlockFace.WEST_SOUTH_WEST);
                        break;
                    }
                    case SOUTH: {
                        rotatable.setRotation(BlockFace.WEST);
                        break;
                    }
                    case SOUTH_SOUTH_WEST: {
                        rotatable.setRotation(BlockFace.WEST_NORTH_WEST);
                        break;
                    }
                    case SOUTH_WEST: {
                        rotatable.setRotation(BlockFace.NORTH_WEST);
                        break;
                    }
                    case WEST_SOUTH_WEST: {
                        rotatable.setRotation(BlockFace.NORTH_NORTH_WEST);
                        break;
                    }
                    case WEST: {
                        rotatable.setRotation(BlockFace.NORTH);
                        break;
                    }
                    case WEST_NORTH_WEST: {
                        rotatable.setRotation(BlockFace.NORTH_NORTH_EAST);
                        break;
                    }
                    case NORTH_WEST: {
                        rotatable.setRotation(BlockFace.NORTH_EAST);
                        break;
                    }
                    case NORTH_NORTH_WEST: {
                        rotatable.setRotation(BlockFace.EAST_NORTH_EAST);
                    }
                }
                if (this.blockd == null) {
                    this.blockd = rotatable;
                }
            } else {
                if (this.blockd == null) {
                    this.blockd = object.clone();
                }
                return this;
            }
        }
        cMIMaterial = this.block.getType();
        this.data = this.data == null ? this.block.getData() : this.data.intValue();
        object = CMIMaterial.get(this.block);
        try {
            block25 : switch (CMIBlock.$SWITCH_TABLE$com$bekvon$bukkit$cmiLib$CMIMaterial()[((Enum)object).ordinal()]) {
                case 801: 
                case 1096: 
                case 1097: {
                    switch (this.data) {
                        case 3: {
                            this.data = 1;
                            break;
                        }
                        case 4: {
                            this.data = 2;
                            break;
                        }
                        case 2: {
                            this.data = 3;
                            break;
                        }
                        case 1: {
                            this.data = 4;
                        }
                    }
                    break;
                }
                case 673: {
                    switch (this.data) {
                        case 7: {
                            this.data = 6;
                            break;
                        }
                        case 8: {
                            this.data = 7;
                            break;
                        }
                        case 9: {
                            this.data = 8;
                            break;
                        }
                        case 6: {
                            this.data = 9;
                        }
                    }
                }
                case 16: 
                case 239: 
                case 630: {
                    int n = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 1: {
                            this.data = n;
                            break;
                        }
                        case 0: {
                            this.data = 1 | n;
                            break;
                        }
                        case 5: {
                            this.data = 2 | n;
                            break;
                        }
                        case 4: {
                            this.data = 3 | n;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n;
                            break;
                        }
                        case 3: {
                            this.data = 5 | n;
                        }
                    }
                    break;
                }
                case 539: 
                case 769: {
                    int n = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 3: {
                            this.data = 1 | n;
                            break;
                        }
                        case 4: {
                            this.data = 2 | n;
                            break;
                        }
                        case 2: {
                            this.data = 3 | n;
                            break;
                        }
                        case 1: {
                            this.data = 4 | n;
                        }
                    }
                    break;
                }
                case 434: {
                    int n = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 3: {
                            this.data = 1 | n;
                            break;
                        }
                        case 4: {
                            this.data = 2 | n;
                            break;
                        }
                        case 2: {
                            this.data = 3 | n;
                            break;
                        }
                        case 1: {
                            this.data = 4 | n;
                            break;
                        }
                        case 6: {
                            this.data = 5 | n;
                            break;
                        }
                        case 5: {
                            this.data = 6 | n;
                            break;
                        }
                        case 0: {
                            this.data = 7 | n;
                            break;
                        }
                        case 7: {
                            this.data = n;
                        }
                    }
                    break;
                }
                case 389: 
                case 540: {
                    if ((this.data & 8) != 0) break;
                }
                case 157: 
                case 806: {
                    int n = this.data & 0xFFFFFFFC;
                    int n2 = this.data & 3;
                    switch (n2) {
                        case 1: {
                            this.data = n;
                            break;
                        }
                        case 2: {
                            this.data = 1 | n;
                            break;
                        }
                        case 3: {
                            this.data = 2 | n;
                            break;
                        }
                        case 0: {
                            this.data = 3 | n;
                        }
                    }
                    break;
                }
                case 724: {
                    this.data = (this.data + 12) % 16;
                    break;
                }
                case 133: 
                case 277: 
                case 307: 
                case 368: 
                case 421: 
                case 803: 
                case 822: 
                case 1087: {
                    int n = this.data & 8;
                    int n3 = this.data & 0xFFFFFFF7;
                    switch (n3) {
                        case 5: {
                            this.data = 2 | n;
                            break;
                        }
                        case 4: {
                            this.data = 3 | n;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n;
                            break;
                        }
                        case 3: {
                            this.data = 5 | n;
                        }
                    }
                    break;
                }
                case 255: 
                case 264: {
                    int n = this.data & 8;
                    switch (this.data & 0xFFFFFFF7) {
                        case 5: {
                            this.data = 2 | n;
                            break;
                        }
                        case 4: {
                            this.data = 3 | n;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n;
                            break;
                        }
                        case 3: {
                            this.data = 5 | n;
                        }
                    }
                    break;
                }
                case 402: 
                case 642: {
                    switch (this.data) {
                        case 1: {
                            this.data = 0;
                            break;
                        }
                        case 2: {
                            this.data = 1;
                            break;
                        }
                        case 3: {
                            this.data = 2;
                            break;
                        }
                        case 0: {
                            this.data = 3;
                        }
                    }
                    break;
                }
                case 43: 
                case 365: 
                case 410: 
                case 544: 
                case 753: {
                    if (this.data < 4 || this.data > 11) break;
                    this.data = this.data ^ 0xC;
                    break;
                }
                case 1099: 
                case 1100: 
                case 1102: 
                case 1103: {
                    int n = this.data & 3;
                    int n4 = this.data - n;
                    switch (n) {
                        case 1: {
                            this.data = n4;
                            break;
                        }
                        case 2: {
                            this.data = 1 | n4;
                            break;
                        }
                        case 3: {
                            this.data = 2 | n4;
                            break;
                        }
                        case 0: {
                            this.data = 3 | n4;
                        }
                    }
                    break;
                }
                case 400: 
                case 550: {
                    int n = this.data & 0xFFFFFFFC;
                    int n5 = this.data & 3;
                    switch (n5) {
                        case 3: {
                            this.data = n;
                            break;
                        }
                        case 2: {
                            this.data = 1 | n;
                            break;
                        }
                        case 0: {
                            this.data = 2 | n;
                            break;
                        }
                        case 1: {
                            this.data = 3 | n;
                        }
                    }
                }
                case 506: 
                case 594: 
                case 763: {
                    int n = this.data & 0xFFFFFFF8;
                    switch (this.data & 7) {
                        case 5: {
                            this.data = 2 | n;
                            break;
                        }
                        case 4: {
                            this.data = 3 | n;
                            break;
                        }
                        case 2: {
                            this.data = 4 | n;
                            break;
                        }
                        case 3: {
                            this.data = 5 | n;
                        }
                    }
                    break;
                }
                case 103: 
                case 687: {
                    if (this.data >= 10) {
                        this.data = this.data;
                        break;
                    }
                    this.data = this.data * 7 % 10;
                }
                case 820: {
                    this.data = (this.data >> 1 | this.data << 3) & 0xF;
                    break;
                }
                case 20: {
                    int n = this.data & 0xFFFFFFFC;
                    switch (this.data & 3) {
                        case 0: {
                            this.data = 1 | n;
                            break;
                        }
                        case 2: {
                            this.data = 3 | n;
                            break;
                        }
                        case 1: {
                            this.data = 2 | n;
                            break;
                        }
                        case 3: {
                            this.data = n;
                        }
                    }
                    break;
                }
                case 1093: {
                    switch (this.data) {
                        case 2: {
                            this.data = 4;
                            break block25;
                        }
                        case 3: {
                            this.data = 5;
                            break block25;
                        }
                        case 4: {
                            this.data = 3;
                            break block25;
                        }
                        case 5: {
                            this.data = 2;
                        }
                    }
                }
            }
            if (((CMIMaterial)((Object)object)).isBed()) {
                this.data = this.data & 0xFFFFFFFC | this.data - 1 & 3;
            } else if (((CMIMaterial)((Object)object)).isGate()) {
                this.data = this.data + 3 & 3 | this.data & 0xFFFFFFFC;
            } else if (((CMIMaterial)((Object)object)).isStairs()) {
                switch (this.data) {
                    case 2: {
                        this.data = 0;
                        break;
                    }
                    case 3: {
                        this.data = 1;
                        break;
                    }
                    case 1: {
                        this.data = 2;
                        break;
                    }
                    case 0: {
                        this.data = 3;
                        break;
                    }
                    case 6: {
                        this.data = 4;
                        break;
                    }
                    case 7: {
                        this.data = 5;
                        break;
                    }
                    case 5: {
                        this.data = 6;
                        break;
                    }
                    case 4: {
                        this.data = 7;
                    }
                }
            }
            if (cMIMaterial.name().contains("TERRACOTTA")) {
                int n = this.data & 0xFFFFFFFC;
                int n6 = this.data & 3;
                switch (n6) {
                    case 1: {
                        this.data = n;
                        break;
                    }
                    case 2: {
                        this.data = 1 | n;
                        break;
                    }
                    case 3: {
                        this.data = 2 | n;
                        break;
                    }
                    case 0: {
                        this.data = 3 | n;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.data = this.data;
        }
        return this;
    }

    public Object getData() {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            return this.blockd == null ? this.block.getBlockData().clone() : this.blockd;
        }
        if (this.data == null) {
            return this.block.getData();
        }
        return this.data.byteValue();
    }

    public CMIBlock setData(Object object) {
        if (Version.isCurrentEqualOrHigher(Version.v1_13_R1)) {
            if (object != null) {
                BlockData blockData = (BlockData)object;
                this.blockd = blockData.clone();
            } else {
                this.blockd = object;
            }
        } else {
            try {
                this.data = (int)((Integer)object);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this;
    }

    public boolean hasInventory() {
        return this.block.getState() instanceof InventoryHolder;
    }

    public Inventory getInventory() {
        if (this.block.getState() instanceof InventoryHolder) {
            InventoryHolder inventoryHolder = (InventoryHolder)this.block.getState();
            return inventoryHolder.getInventory();
        }
        return null;
    }

    public Block getSecondaryBedBlock() {
        if (this.block == null || !CMIMaterial.isBed(this.block.getType())) {
            return null;
        }
        BlockFace blockFace = this.getFacing();
        BedPart bedPart = this.getBedPart();
        if (blockFace == null || bedPart == null) {
            return null;
        }
        Location location = this.block.getLocation().clone();
        switch (blockFace) {
            case WEST: {
                switch (bedPart) {
                    case FOOT: {
                        return location.add(-1.0, 0.0, 0.0).getBlock();
                    }
                    case HEAD: {
                        return location.add(1.0, 0.0, 0.0).getBlock();
                    }
                }
                break;
            }
            case EAST: {
                switch (bedPart) {
                    case FOOT: {
                        return location.add(1.0, 0.0, 0.0).getBlock();
                    }
                    case HEAD: {
                        return location.add(-1.0, 0.0, 0.0).getBlock();
                    }
                }
                break;
            }
            case NORTH: {
                switch (bedPart) {
                    case FOOT: {
                        return location.add(0.0, 0.0, -1.0).getBlock();
                    }
                    case HEAD: {
                        return location.add(0.0, 0.0, 1.0).getBlock();
                    }
                }
                break;
            }
            case SOUTH: {
                switch (bedPart) {
                    case FOOT: {
                        return location.add(0.0, 0.0, 1.0).getBlock();
                    }
                    case HEAD: {
                        return location.add(0.0, 0.0, -1.0).getBlock();
                    }
                }
            }
        }
        return null;
    }

    public Block getBedFootBlock() {
        if (this.block == null || !CMIMaterial.isBed(this.block.getType())) {
            return null;
        }
        Block block = this.getSecondaryBedBlock();
        Location location = this.block.getLocation();
        if (this.getBedPart() != null) {
            CMIBlock cMIBlock;
            if (this.getBedPart() == BedPart.FOOT) {
                return this.block;
            }
            if (block != null && (cMIBlock = new CMIBlock(block)).getBedPart() != null && cMIBlock.getBedPart() == BedPart.FOOT) {
                return block;
            }
        }
        return null;
    }

    public static enum BedPart {
        HEAD,
        FOOT;

    }

    public static enum Bisect {
        TOP,
        BOTTOM;

    }

    public static enum FlipDirection {
        NORTH_SOUTH,
        WEST_EAST,
        UP_DOWN;

    }

    public static enum StairShape {
        INNER_LEFT,
        INNER_RIGHT,
        OUTER_LEFT,
        OUTER_RIGHT,
        STRAIGHT;


        public static StairShape getByName(String string) {
            StairShape[] stairShapeArray = StairShape.values();
            int n = stairShapeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StairShape stairShape = stairShapeArray[n2];
                if (stairShape.toString().equalsIgnoreCase(string)) {
                    return stairShape;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum blockDirection {
        none(-1),
        upWest(0),
        upEast(1),
        upNorth(2),
        upSouth(3),
        downWest(4),
        downEast(5),
        downNorth(6),
        downSouth(7);

        private int dir;

        private blockDirection(int n2) {
            this.dir = n2;
        }

        public int getDir() {
            return this.dir;
        }

        public static blockDirection getByDir(int n) {
            blockDirection[] blockDirectionArray = blockDirection.values();
            int n2 = blockDirectionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                blockDirection blockDirection2 = blockDirectionArray[n3];
                if (blockDirection2.getDir() == n) {
                    return blockDirection2;
                }
                ++n3;
            }
            return null;
        }
    }
}

